/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QueryActionBase
extends DumbAwareAction
implements Toggleable {
    public void update(@NotNull AnActionEvent e) {
        boolean enabled;
        if (e == null) {
            QueryActionBase.$$$reportNull$$$0(0);
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        FileEditor fileEditor = (FileEditor)e.getData(PlatformDataKeys.FILE_EDITOR);
        JdbcConsole console = this.getConsole(e);
        boolean editorOrStructurePopup = EditorUtil.isRealFileEditor((Editor)editor) || editor == null && fileEditor instanceof TextEditor;
        boolean applicable = editorOrStructurePopup && JdbcConsoleProvider.isSqlAtPlace(file, editor) && (!this.isConsoleRequired() || console != null) && this.isApplicable(console);
        boolean bl = enabled = applicable && this.isEnabled(console);
        if (enabled && console != null && console.isValid()) {
            Editor resultEditor = editor == null ? ((TextEditor)fileEditor).getEditor() : editor;
            TextRange range = ScriptModelUtil.getSelectedStatementsRange(console, resultEditor, this.getExecOption());
            e.getPresentation().setEnabled(range.getLength() > 0);
            e.getPresentation().setVisible(true);
            e.getPresentation().putClientProperty("selected", (Object)(!console.isIdle() ? 1 : 0));
        }
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(applicable || e.isFromActionToolbar());
    }

    protected boolean isApplicable(@Nullable JdbcConsole console) {
        return true;
    }

    protected boolean isEnabled(@Nullable JdbcConsole console) {
        return true;
    }

    @Nullable
    protected JdbcConsole getConsole(AnActionEvent e) {
        return JdbcConsole.findConsole(e);
    }

    protected boolean isConsoleRequired() {
        return true;
    }

    @NotNull
    protected DatabaseSettings.ExecOption getExecOption() {
        DatabaseSettings.ExecOption execOption = DatabaseSettings.getDefaultExecOption();
        if (execOption == null) {
            QueryActionBase.$$$reportNull$$$0(1);
        }
        return execOption;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            QueryActionBase.$$$reportNull$$$0(2);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        DatabaseSettings.ExecOption option = this.getExecOption();
        JdbcConsoleProvider.Info info = (JdbcConsoleProvider.Info)ObjectUtils.chooseNotNull((Object)QueryActionBase.getInfoClassic(e, option), (Object)QueryActionBase.findInfoFromFileStructure(e, option));
        if (info == null) {
            return;
        }
        this.invokeImpl(e, this.getConsole(e), info);
    }

    @Nullable
    public static JdbcConsoleProvider.Info getInfoClassic(@NotNull AnActionEvent e, @NotNull DatabaseSettings.ExecOption execOption) {
        if (e == null) {
            QueryActionBase.$$$reportNull$$$0(3);
        }
        if (execOption == null) {
            QueryActionBase.$$$reportNull$$$0(4);
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        PsiElement elementAt = JdbcConsoleProvider.elementAt(file, null, editor);
        if (elementAt == null) {
            return null;
        }
        return JdbcConsoleProvider.findScriptModel(file, elementAt, editor, execOption);
    }

    @Nullable
    private static JdbcConsoleProvider.Info findInfoFromFileStructure(@NotNull AnActionEvent e, @NotNull DatabaseSettings.ExecOption execOption) {
        Editor editor;
        if (e == null) {
            QueryActionBase.$$$reportNull$$$0(5);
        }
        if (execOption == null) {
            QueryActionBase.$$$reportNull$$$0(6);
        }
        JBIterable elements = JBIterable.of((Object[])((Object[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY)));
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        FileEditor fileEditor = (FileEditor)e.getData(PlatformDataKeys.FILE_EDITOR);
        Editor editor2 = editor = fileEditor instanceof TextEditor ? DataManagerImpl.validateEditor((Editor)((TextEditor)fileEditor).getEditor()) : null;
        if (file == null || elements.isEmpty() || editor == null) {
            return null;
        }
        THashSet set = new THashSet();
        for (PsiElement pe : elements) {
            if (!file.equals(pe.getContainingFile())) {
                return null;
            }
            set.add(pe.getTextRange());
        }
        Project project = file.getProject();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        if (document == null) {
            return null;
        }
        ScriptModel model = QueryActionBase.filterRanges(SqlPsiFacade.getInstance((Project)project).createScriptModel(file), (Set<TextRange>)set);
        return new JdbcConsoleProvider.Info(file, file, (EditorEx)editor, model, execOption, null);
    }

    private static <V> ScriptModel<V> filterRanges(ScriptModel<V> model, final Set<TextRange> set) {
        return model.rawTransform((Function)new Function.Mono<SyntaxTraverser<V>>(){

            public SyntaxTraverser<V> fun(SyntaxTraverser<V> s) {
                return (SyntaxTraverser)s.regard(Conditions.compose((Function)s.api.TO_RANGE, range -> set.contains(range)));
            }
        });
    }

    protected void invokeImpl(@NotNull AnActionEvent e, @Nullable JdbcConsole console, @NotNull JdbcConsoleProvider.Info info) {
        if (e == null) {
            QueryActionBase.$$$reportNull$$$0(7);
        }
        if (info == null) {
            QueryActionBase.$$$reportNull$$$0(8);
        }
        JdbcConsoleProvider.chooseStatements(info, "No query found", false, scriptModel -> this.invokeImpl(console, (ScriptModel<?>)scriptModel, info));
    }

    protected abstract void invokeImpl(@Nullable JdbcConsole var1, @NotNull ScriptModel<?> var2, @NotNull JdbcConsoleProvider.Info var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/QueryActionBase";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execOption";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/QueryActionBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecOption";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInfoClassic";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findInfoFromFileStructure";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invokeImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

