/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.script.PersistenceConsoleProvider;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.icons.AllIcons;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.TreeTraversal;
import icons.DatabaseIcons;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseRunners {
    private DatabaseRunners() {
    }

    @NotNull
    public static PersistenceConsoleProvider.Runner createSessionRunner(@NotNull DatabaseSession session2, @NotNull Runnable runnable, boolean qualify) {
        if (session2 == null) {
            DatabaseRunners.$$$reportNull$$$0(0);
        }
        if (runnable == null) {
            DatabaseRunners.$$$reportNull$$$0(1);
        }
        String title = qualify ? SessionsUtil.qualifiedName(session2) : session2.getTitle();
        String dsId = ((LocalDataSource)session2.getTarget()).getUniqueId();
        PersistenceConsoleProvider.Runner runner = DatabaseRunners.createRunner(title, dsId, session2.getProject(), DatabaseSession.getIcon(session2.isConnected()), runnable);
        if (runner == null) {
            DatabaseRunners.$$$reportNull$$$0(2);
        }
        return runner;
    }

    @NotNull
    public static PersistenceConsoleProvider.Runner createConsoleRunner(@NotNull JdbcConsole console, @NotNull Runnable runnable) {
        if (console == null) {
            DatabaseRunners.$$$reportNull$$$0(3);
        }
        if (runnable == null) {
            DatabaseRunners.$$$reportNull$$$0(4);
        }
        PersistenceConsoleProvider.Runner runner = DatabaseRunners.createRunner(console.getDisplayName(), ((LocalDataSource)console.getTarget()).getUniqueId(), console.getProject(), ((LocalDataSource)console.getTarget()).getIcon(), runnable);
        if (runner == null) {
            DatabaseRunners.$$$reportNull$$$0(5);
        }
        return runner;
    }

    @NotNull
    public static PersistenceConsoleProvider.Runner createDataSourceRunner(@NotNull DbDataSource dataSource, @NotNull Runnable runnable) {
        if (dataSource == null) {
            DatabaseRunners.$$$reportNull$$$0(6);
        }
        if (runnable == null) {
            DatabaseRunners.$$$reportNull$$$0(7);
        }
        MyRunner myRunner = new MyRunner(dataSource.getName(), false, false, dataSource.getIcon(), DatabaseRunners.getRunnerColor(dataSource), runnable);
        if (myRunner == null) {
            DatabaseRunners.$$$reportNull$$$0(8);
        }
        return myRunner;
    }

    public static PersistenceConsoleProvider.Runner createDataSourceRunner(final @NotNull DbDataSource dataSource, final @NotNull String title, final @NotNull Consumer<? super DatabaseSession> consumer2) {
        if (dataSource == null) {
            DatabaseRunners.$$$reportNull$$$0(9);
        }
        if (title == null) {
            DatabaseRunners.$$$reportNull$$$0(10);
        }
        if (consumer2 == null) {
            DatabaseRunners.$$$reportNull$$$0(11);
        }
        final Project project = dataSource.getProject();
        return new MyRunner(dataSource.getName(), false, false, dataSource.getIcon(), DatabaseRunners.getRunnerColor(dataSource), EmptyRunnable.getInstance()){

            @NotNull
            public List<PersistenceConsoleProvider.Runner> getSubRunners() {
                VirtualFile consoleDir = DatabaseEditorHelper.getConsoleRootDir((DasDataSource)dataSource);
                PersistenceConsoleProvider.Runner newRunner = DatabaseRunners.newSessionRunner((Consumer<? super DatabaseSession>)consumer2, title, project, dataSource, consoleDir == null);
                List<DatabaseSession> sessions = DatabaseSessionManager.getSessions(project, DbImplUtil.getLocalDataSource((DasDataSource)dataSource));
                JBIterable perSession = JBIterable.from(sessions).map(s -> DatabaseRunners.createSessionRunner(s, () -> consumer2.consume(s), false));
                List list = (List)JBIterable.of((Object)newRunner).append((Iterable)perSession).addAllTo(new ArrayList());
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/DatabaseRunners$1", "getSubRunners"));
            }
        };
    }

    @NotNull
    public static PersistenceConsoleProvider.Runner createDataSourceConsolesRunner(final @NotNull DbDataSource dataSource, final @NotNull Consumer<? super VirtualFile> consumer2) {
        if (dataSource == null) {
            DatabaseRunners.$$$reportNull$$$0(12);
        }
        if (consumer2 == null) {
            DatabaseRunners.$$$reportNull$$$0(13);
        }
        final Project project = dataSource.getProject();
        MyRunner myRunner = new MyRunner(dataSource.getName(), false, false, dataSource.getIcon(0), DatabaseRunners.getRunnerColor(dataSource), EmptyRunnable.getInstance()){

            @NotNull
            public List<PersistenceConsoleProvider.Runner> getSubRunners() {
                VirtualFile consoleDir = DatabaseEditorHelper.getConsoleRootDir((DasDataSource)dataSource);
                Icon icon = dataSource.getIcon(0);
                Color color = DatabaseRunners.getRunnerColor(dataSource);
                Icon newIcon = LayeredIcon.create((Icon)DatabaseIcons.ConsoleRun, (Icon)AllIcons.Actions.New);
                PersistenceConsoleProvider.Runner newRunner = DatabaseRunners.newPriorityRunner(PriorityAction.Priority.HIGH, "New Console", false, consoleDir == null, newIcon, color, () -> consumer2.consume((Object)DatabaseEditorHelper.createNewConsoleVirtualFile((DasDataSource)dataSource)));
                if (consoleDir == null) {
                    List<PersistenceConsoleProvider.Runner> list = Collections.singletonList(newRunner);
                    if (list == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return list;
                }
                VirtualFile defaultConsoleFile = DatabaseEditorHelper.findExistingConsoleVirtualFile((DasDataSource)dataSource);
                Map allRunningFiles = JBIterable.from(JdbcConsole.getActiveConsoles(project)).toReverseMap(o -> o.getVirtualFile());
                PersistenceConsoleProvider.Runner defRunner = DatabaseRunners.newPriorityRunner(PriorityAction.Priority.HIGH, "console (Default)", allRunningFiles.containsKey(defaultConsoleFile), true, icon, color, () -> consumer2.consume(ObjectUtils.notNull((Object)defaultConsoleFile, () -> (VirtualFile)ObjectUtils.notNull((Object)DatabaseEditorHelper.getConsoleVirtualFile((DasDataSource)dataSource)))));
                DbConsoleRootType rootType = DbConsoleRootType.getInstance();
                JBIterable perFile = FileUtil.fileTraverser((File)VfsUtilCore.virtualToIoFile((VirtualFile)consoleDir)).traverse(TreeTraversal.LEAVES_BFS).take(100).filterMap(file -> LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file)).filter(file -> !file.equals(defaultConsoleFile)).filter(file -> !allRunningFiles.containsKey(file)).map(file -> new MyRunner(StringUtil.trimEnd((String)((String)ObjectUtils.notNull((Object)rootType.substituteName(project, (VirtualFile)file))), (String)(" [" + dataSource.getName() + "]")), false, false, icon, color, () -> consumer2.consume(file)));
                PersistenceConsoleProvider.Runner dir = DatabaseRunners.newPriorityRunner(PriorityAction.Priority.LOW, "Jump to Console Files", false, false, null, color, () -> {
                    PsiManager psiManager = PsiManager.getInstance((Project)project);
                    PsiDirectory psiDirectory = psiManager.findDirectory(consoleDir);
                    if (psiDirectory != null) {
                        psiDirectory.navigate(true);
                    }
                });
                List list = (List)JBIterable.of((Object[])new PersistenceConsoleProvider.Runner[]{defRunner, newRunner}).append((Iterable)perFile).append((Object)dir).addAllTo(new ArrayList());
                if (list == null) {
                    2.$$$reportNull$$$0(1);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/DatabaseRunners$2", "getSubRunners"));
            }
        };
        if (myRunner == null) {
            DatabaseRunners.$$$reportNull$$$0(14);
        }
        return myRunner;
    }

    @NotNull
    public static List<PersistenceConsoleProvider.Runner> createRunners(@Nullable JdbcConsoleProvider.Info info, boolean ignoreForced) {
        if (info == null || info.model.statements().isEmpty()) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                DatabaseRunners.$$$reportNull$$$0(15);
            }
            return list;
        }
        Project project = info.originalFile.getProject();
        JBIterable<DbDataSource> dataSources2 = DbImplUtil.getDataSourcesForExec(info.file, ignoreForced, false);
        if (dataSources2.isEmpty()) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                DatabaseRunners.$$$reportNull$$$0(16);
            }
            return list;
        }
        HashSet<String> allowedIds = new HashSet<String>();
        for (DbDataSource source : dataSources2) {
            allowedIds.add(source.getUniqueId());
        }
        ArrayList<PersistenceConsoleProvider.Runner> result2 = new ArrayList<PersistenceConsoleProvider.Runner>();
        for (DatabaseSession session3 : DatabaseSessionManager.getSessions(project)) {
            if (!allowedIds.contains(((LocalDataSource)session3.getTarget()).getUniqueId())) continue;
            result2.add(DatabaseRunners.createSessionRunner(session3, () -> DatabaseRunners.runInner(session3, info), allowedIds.size() > 1));
        }
        for (DbDataSource dataSource : dataSources2) {
            if (!DbImplUtil.canConnectTo((DbElement)dataSource)) continue;
            result2.add(DatabaseRunners.createDataSourceRunner(dataSource, DatabaseSession.getTitle(project, info.originalFile.getVirtualFile()), (Consumer<? super DatabaseSession>)((Consumer)session2 -> DatabaseRunners.runInner(session2, info))));
        }
        ArrayList<PersistenceConsoleProvider.Runner> arrayList = result2;
        if (arrayList == null) {
            DatabaseRunners.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @NotNull
    public static List<PersistenceConsoleProvider.Runner> getRunners(@NotNull JBIterable<DbDataSource> dataSources2, @NotNull Project project, @Nullable DatabaseSession current, @NotNull String title, @NotNull Consumer<? super DatabaseSession> consumer2) {
        if (dataSources2 == null) {
            DatabaseRunners.$$$reportNull$$$0(18);
        }
        if (project == null) {
            DatabaseRunners.$$$reportNull$$$0(19);
        }
        if (title == null) {
            DatabaseRunners.$$$reportNull$$$0(20);
        }
        if (consumer2 == null) {
            DatabaseRunners.$$$reportNull$$$0(21);
        }
        List<PersistenceConsoleProvider.Runner> list = DatabaseRunners.getRunners(dataSources2, project, current, title, consumer2, true);
        if (list == null) {
            DatabaseRunners.$$$reportNull$$$0(22);
        }
        return list;
    }

    @NotNull
    public static List<PersistenceConsoleProvider.Runner> getRunners(@NotNull JBIterable<DbDataSource> dataSources2, @NotNull Project project, @Nullable DatabaseSession current, @NotNull String title, @NotNull Consumer<? super DatabaseSession> consumer2, boolean allowDetach) {
        if (dataSources2 == null) {
            DatabaseRunners.$$$reportNull$$$0(23);
        }
        if (project == null) {
            DatabaseRunners.$$$reportNull$$$0(24);
        }
        if (title == null) {
            DatabaseRunners.$$$reportNull$$$0(25);
        }
        if (consumer2 == null) {
            DatabaseRunners.$$$reportNull$$$0(26);
        }
        Set allowedIds = dataSources2.map(o -> o.getUniqueId()).toSet();
        ArrayList<PersistenceConsoleProvider.Runner> result2 = new ArrayList<PersistenceConsoleProvider.Runner>();
        if (allowDetach && current != null) {
            result2.add(DatabaseRunners.newPriorityRunner(PriorityAction.Priority.HIGH, "Detach Session", false, false, AllIcons.Actions.Cancel, null, () -> consumer2.consume(null)));
        }
        for (DatabaseSession session2 : DatabaseSessionManager.getSessions(project)) {
            if (session2 == current || !allowedIds.contains(((LocalDataSource)session2.getTarget()).getUniqueId())) continue;
            result2.add(DatabaseRunners.createSessionRunner(session2, () -> consumer2.consume((Object)session2), allowedIds.size() > 1));
        }
        for (DbDataSource dataSource : dataSources2) {
            result2.add(DatabaseRunners.createDataSourceRunner(dataSource, title, consumer2));
        }
        ArrayList<PersistenceConsoleProvider.Runner> arrayList = result2;
        if (arrayList == null) {
            DatabaseRunners.$$$reportNull$$$0(27);
        }
        return arrayList;
    }

    @Nullable
    private static Color getRunnerColor(@NotNull DbDataSource o) {
        if (o == null) {
            DatabaseRunners.$$$reportNull$$$0(28);
        }
        DatabaseColorManager.LocalColors state2 = (DatabaseColorManager.LocalColors)DatabaseColorManager.getLocalColorManager(o.getProject()).getState();
        boolean useColors = state2.useColors && state2.inDatabaseView;
        return useColors ? DatabaseColorManager.getColor((DbElement)o) : null;
    }

    @NotNull
    private static PersistenceConsoleProvider.Runner newSessionRunner(@NotNull Consumer<? super DatabaseSession> consumer2, @NotNull String title, @NotNull Project project, @NotNull DbDataSource dataSource, boolean hasDefault) {
        if (consumer2 == null) {
            DatabaseRunners.$$$reportNull$$$0(29);
        }
        if (title == null) {
            DatabaseRunners.$$$reportNull$$$0(30);
        }
        if (project == null) {
            DatabaseRunners.$$$reportNull$$$0(31);
        }
        if (dataSource == null) {
            DatabaseRunners.$$$reportNull$$$0(32);
        }
        Icon icon = LayeredIcon.create((Icon)DatabaseSession.getIcon(false), (Icon)AllIcons.Actions.New);
        Color color = DatabaseRunners.getRunnerColor(dataSource);
        Runnable runnable = () -> {
            LocalDataSource localDataSource = DbImplUtil.getLocalDataSource((DasDataSource)dataSource);
            DatabaseSession session2 = DatabaseSessionManager.openSession(project, localDataSource, title);
            consumer2.consume((Object)session2);
        };
        PersistenceConsoleProvider.Runner runner = DatabaseRunners.newPriorityRunner(PriorityAction.Priority.HIGH, "New Session", false, hasDefault, icon, color, runnable);
        if (runner == null) {
            DatabaseRunners.$$$reportNull$$$0(33);
        }
        return runner;
    }

    @NotNull
    private static PersistenceConsoleProvider.Runner newPriorityRunner(@NotNull PriorityAction.Priority priority, @NotNull String displayName, boolean running, boolean defaultSubRunner, @Nullable Icon icon, @Nullable Color color, @NotNull Runnable runnable) {
        if (priority == null) {
            DatabaseRunners.$$$reportNull$$$0(34);
        }
        if (displayName == null) {
            DatabaseRunners.$$$reportNull$$$0(35);
        }
        if (runnable == null) {
            DatabaseRunners.$$$reportNull$$$0(36);
        }
        PriorityRunner priorityRunner = new PriorityRunner(displayName, running, defaultSubRunner, icon, color, runnable, priority);
        if (priorityRunner == null) {
            DatabaseRunners.$$$reportNull$$$0(37);
        }
        return priorityRunner;
    }

    private static void runInner(@NotNull DatabaseSession session2, @NotNull JdbcConsoleProvider.Info info) {
        JdbcConsole console;
        PsiFile topPsi;
        VirtualFile virtualFile;
        if (session2 == null) {
            DatabaseRunners.$$$reportNull$$$0(38);
        }
        if (info == null) {
            DatabaseRunners.$$$reportNull$$$0(39);
        }
        if (!session2.isValid()) {
            return;
        }
        if (info.editor instanceof EditorWindow && !((EditorWindow)info.editor).isValid()) {
            return;
        }
        if (info.editor != null && (virtualFile = PsiUtilCore.getVirtualFile((PsiElement)(topPsi = InjectedLanguageManager.getInstance((Project)info.originalFile.getProject()).getTopLevelFile((PsiElement)info.originalFile)))) != null && (console = JdbcConsoleProvider.attachConsole(session2.getProject(), session2, virtualFile)) != null) {
            JdbcConsoleProvider.doRunQueryInConsole(console, info);
        }
    }

    @NotNull
    private static PersistenceConsoleProvider.Runner createRunner(@NotNull String title, @NotNull String dataSourceId, @NotNull Project project, @NotNull Icon icon, @NotNull Runnable runnable) {
        if (title == null) {
            DatabaseRunners.$$$reportNull$$$0(40);
        }
        if (dataSourceId == null) {
            DatabaseRunners.$$$reportNull$$$0(41);
        }
        if (project == null) {
            DatabaseRunners.$$$reportNull$$$0(42);
        }
        if (icon == null) {
            DatabaseRunners.$$$reportNull$$$0(43);
        }
        if (runnable == null) {
            DatabaseRunners.$$$reportNull$$$0(44);
        }
        DbPsiFacade dbPsiFacade = DbPsiFacade.getInstance((Project)project);
        DbDataSource dataSource = (DbDataSource)ObjectUtils.notNull((Object)dbPsiFacade.findDataSource(dataSourceId));
        MyRunner myRunner = new MyRunner(title, true, false, icon, DatabaseRunners.getRunnerColor(dataSource), runnable);
        if (myRunner == null) {
            DatabaseRunners.$$$reportNull$$$0(45);
        }
        return myRunner;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 27: 
            case 33: 
            case 37: 
            case 45: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 27: 
            case 33: 
            case 37: 
            case 45: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 36: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 27: 
            case 33: 
            case 37: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/DatabaseRunners";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 10: 
            case 20: 
            case 25: 
            case 30: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 11: 
            case 13: 
            case 21: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSources";
                break;
            }
            case 19: 
            case 24: 
            case 31: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priority";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSourceId";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/DatabaseRunners";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createSessionRunner";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleRunner";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataSourceRunner";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataSourceConsolesRunner";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createRunners";
                break;
            }
            case 22: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunners";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "newSessionRunner";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "newPriorityRunner";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "createRunner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createSessionRunner";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 27: 
            case 33: 
            case 37: 
            case 45: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleRunner";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createDataSourceRunner";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createDataSourceConsolesRunner";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getRunners";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getRunnerColor";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "newSessionRunner";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "newPriorityRunner";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "runInner";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "createRunner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 27: 
            case 33: 
            case 37: 
            case 45: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class PriorityRunner
    extends MyRunner
    implements PriorityAction {
        private final PriorityAction.Priority myPriority;

        PriorityRunner(@NotNull String displayName, boolean running, boolean defaultSubRunner, @Nullable Icon icon, @Nullable Color color, @NotNull Runnable runnable, @NotNull PriorityAction.Priority priority) {
            if (displayName == null) {
                PriorityRunner.$$$reportNull$$$0(0);
            }
            if (runnable == null) {
                PriorityRunner.$$$reportNull$$$0(1);
            }
            if (priority == null) {
                PriorityRunner.$$$reportNull$$$0(2);
            }
            super(displayName, running, defaultSubRunner, icon, color, runnable);
            this.myPriority = priority;
        }

        @NotNull
        public PriorityAction.Priority getPriority() {
            PriorityAction.Priority priority = this.myPriority;
            if (priority == null) {
                PriorityRunner.$$$reportNull$$$0(3);
            }
            return priority;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "displayName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "priority";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/DatabaseRunners$PriorityRunner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/DatabaseRunners$PriorityRunner";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPriority";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class MyRunner
    extends PersistenceConsoleProvider.Runner {
        final String displayName;
        final boolean running;
        final boolean defaultSubRunner;
        final Icon icon;
        final Color color;
        final Runnable runnable;

        MyRunner(@NotNull String displayName, boolean running, boolean defaultSubRunner, @Nullable Icon icon, @Nullable Color color, @NotNull Runnable runnable) {
            if (displayName == null) {
                MyRunner.$$$reportNull$$$0(0);
            }
            if (runnable == null) {
                MyRunner.$$$reportNull$$$0(1);
            }
            this.displayName = displayName;
            this.running = running;
            this.defaultSubRunner = defaultSubRunner;
            this.icon = icon;
            this.color = color;
            this.runnable = runnable;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Icon getIcon() {
            return this.icon;
        }

        @Nullable
        public Color getColor() {
            return this.color;
        }

        public boolean isAlreadyRunning() {
            return this.running;
        }

        public boolean isDefaultSubRunner() {
            return this.defaultSubRunner;
        }

        public void run() {
            this.runnable.run();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "displayName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "runnable";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/console/DatabaseRunners$MyRunner";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

