/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.CommonBundle;
import com.intellij.database.Dbms;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.util.ErrorHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionId;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.sql.SQLException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.AsyncPromiseKt;
import org.jetbrains.concurrency.Promise;

public class AsyncUtil {
    public static final Executor POOL_EXECUTOR = AsyncUtil.asyncFriendlyExecutor(arg_0 -> ((Application)ApplicationManager.getApplication()).executeOnPooledThread(arg_0));
    public static final Executor EDT_EXECUTOR = AsyncUtil.asyncFriendlyExecutor(UIUtil::invokeLaterIfNeeded);
    public static final Executor NON_EDT_EXECUTOR = command -> {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            POOL_EXECUTOR.execute(command);
        } else {
            command.run();
        }
    };
    private static final Logger LOG = Logger.getInstance(AsyncUtil.class);
    private static final Key<Boolean> ASYNC_FRIENDLY = Key.create((String)"ASYNC_FRIENDLY");
    private static final Key<Object> ASYNC_CALL_TRACE = Key.create((String)"ASYNC_CALL_TRACE");

    public static Executor transactionExecutor(@NotNull Disposable d2, @Nullable TransactionId transactionId) {
        if (d2 == null) {
            AsyncUtil.$$$reportNull$$$0(0);
        }
        return AsyncUtil.asyncFriendlyExecutor(command -> TransactionGuard.getInstance().submitTransaction(d2, transactionId, command));
    }

    public static Executor transactionExecutor(@NotNull Disposable d2) {
        if (d2 == null) {
            AsyncUtil.$$$reportNull$$$0(1);
        }
        return AsyncUtil.transactionExecutor(d2, TransactionGuard.getInstance().getContextTransaction());
    }

    public static Executor asyncFriendlyExecutor(@NotNull Executor e) {
        if (e == null) {
            AsyncUtil.$$$reportNull$$$0(2);
        }
        return task -> {
            ProgressIndicator indicator = AsyncUtil.getAsyncFriendlyIndicator();
            Application application = ApplicationManager.getApplication();
            UserDataHolder dataHolder = application == null || application.isUnitTestMode() ? (UserDataHolder)ObjectUtils.tryCast((Object)indicator, UserDataHolder.class) : null;
            Throwable currentTrace = dataHolder == null ? null : new Throwable();
            ASYNC_CALL_TRACE.set(dataHolder, (Object)currentTrace);
            e.execute(() -> {
                try {
                    AsyncUtil.underProgress(task, indicator);
                }
                finally {
                    if (currentTrace != null && ASYNC_CALL_TRACE.get(dataHolder) == currentTrace) {
                        ASYNC_CALL_TRACE.set(dataHolder, null);
                    }
                }
            });
        };
    }

    @Nullable
    public static Throwable getAsyncCallTrace(@Nullable ProgressIndicator indicator) {
        if (indicator instanceof UserDataHolder) {
            return (Throwable)ObjectUtils.tryCast((Object)ASYNC_CALL_TRACE.get((UserDataHolder)indicator), Throwable.class);
        }
        return null;
    }

    @Nullable
    public static ProgressIndicator getAsyncFriendlyIndicator() {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (AsyncUtil.isAsyncFriendly(indicator)) {
            return indicator;
        }
        LOG.warn("Expected async friendly progress indicator, got " + indicator);
        return new EmptyProgressIndicator();
    }

    @Nullable
    public static Throwable unwrap(@Nullable Throwable e) {
        Throwable first2 = (Throwable)JBIterable.generate((Object)e, o -> o.getCause()).skipWhile(o -> o.getCause() != null && (o instanceof CompletionException || o instanceof ExecutionException || o instanceof com.intellij.execution.ExecutionException && o.getCause() instanceof ProcessCanceledException || o instanceof SQLException && (o.getCause().getClass() == RuntimeException.class || o.getCause().getClass() == SQLException.class) || o.getClass() == RuntimeException.class)).first();
        return first2 instanceof CancellationException ? new ProcessCanceledException() : first2;
    }

    public static void rethrowUnwrapped(@NotNull Exception e) {
        Throwable unwrapped;
        if (e == null) {
            AsyncUtil.$$$reportNull$$$0(3);
        }
        if ((unwrapped = AsyncUtil.unwrap(e)) instanceof CancellationException) {
            throw new ProcessCanceledException(unwrapped);
        }
        ExceptionUtil.rethrowAllAsUnchecked((Throwable)unwrapped);
    }

    public static boolean isAsyncFriendly(@Nullable ProgressIndicator indicator) {
        return indicator == null || indicator instanceof EmptyProgressIndicator || indicator instanceof UserDataHolder && ASYNC_FRIENDLY.get((UserDataHolder)indicator) == Boolean.TRUE;
    }

    public static <T extends ProgressIndicator> T markAsyncFriendly(@Nullable T indicator, boolean friendly) {
        if (indicator instanceof UserDataHolder) {
            ASYNC_FRIENDLY.set((UserDataHolder)indicator, (Object)(friendly ? Boolean.TRUE : null));
        }
        return indicator;
    }

    public static <T> CompletionStage<T> supplyAsync(@NotNull Supplier<? extends CompletionStage<T>> s, @NotNull Executor e) {
        if (s == null) {
            AsyncUtil.$$$reportNull$$$0(4);
        }
        if (e == null) {
            AsyncUtil.$$$reportNull$$$0(5);
        }
        return AsyncUtil.thenComposeAsync(CompletableFuture.completedFuture(null), x -> (CompletionStage)s.get(), e);
    }

    public static <U, T> CompletionStage<T> thenComposeAsync(@NotNull CompletionStage<? extends U> s, @NotNull Function<? super U, ? extends CompletionStage<T>> f, @NotNull Executor e) {
        if (s == null) {
            AsyncUtil.$$$reportNull$$$0(6);
        }
        if (f == null) {
            AsyncUtil.$$$reportNull$$$0(7);
        }
        if (e == null) {
            AsyncUtil.$$$reportNull$$$0(8);
        }
        CompletableFuture result2 = new CompletableFuture();
        AsyncUtil.processWhenComplete(s, result2, r -> e.execute(() -> {
            try {
                AsyncUtil.processWhenComplete((CompletionStage)f.apply((Object)r), result2, result2::complete);
            }
            catch (Throwable th) {
                result2.completeExceptionally(th);
            }
        }));
        return result2;
    }

    private static <T> void processWhenComplete(@NotNull CompletionStage<T> what, @NotNull CompletableFuture<?> where, @NotNull Consumer<? super T> cons) {
        if (what == null) {
            AsyncUtil.$$$reportNull$$$0(9);
        }
        if (where == null) {
            AsyncUtil.$$$reportNull$$$0(10);
        }
        if (cons == null) {
            AsyncUtil.$$$reportNull$$$0(11);
        }
        try {
            what.whenComplete((r, th) -> {
                if (th != null) {
                    where.completeExceptionally((Throwable)th);
                } else {
                    try {
                        cons.consume(r);
                    }
                    catch (Throwable ex) {
                        where.completeExceptionally(ex);
                    }
                }
            });
        }
        catch (Throwable ex) {
            where.completeExceptionally(ex);
        }
    }

    public static <T> T underProgress(@NotNull Computable<T> r, @Nullable ProgressIndicator indicator) {
        if (r == null) {
            AsyncUtil.$$$reportNull$$$0(12);
        }
        Ref res2 = Ref.create();
        AsyncUtil.underProgress(() -> res2.set(r.compute()), indicator);
        return (T)res2.get();
    }

    public static void underProgress(@NotNull Runnable r, @Nullable ProgressIndicator indicator) {
        if (r == null) {
            AsyncUtil.$$$reportNull$$$0(13);
        }
        if (indicator != null) {
            indicator.checkCanceled();
        }
        ProgressManager.getInstance().executeProcessUnderProgress(r, indicator);
    }

    @NotNull
    public static <T> CompletionStage<T> runTask(@NotNull Computable<? extends CompletionStage<T>> r, @NotNull ProgressIndicatorEx indicator) {
        CompletionStage<Object> res2;
        if (r == null) {
            AsyncUtil.$$$reportNull$$$0(14);
        }
        if (indicator == null) {
            AsyncUtil.$$$reportNull$$$0(15);
        }
        indicator.start();
        try {
            res2 = AsyncUtil.underProgress(r, (ProgressIndicator)indicator);
        }
        catch (Throwable th) {
            indicator.stop();
            indicator.processFinish();
            CompletableFuture<T> completableFuture = AsyncUtil.exceptional(th);
            if (completableFuture == null) {
                AsyncUtil.$$$reportNull$$$0(16);
            }
            return completableFuture;
        }
        CompletionStage<Object> completionStage = res2.whenComplete((t, throwable) -> {
            indicator.stop();
            indicator.processFinish();
        });
        if (completionStage == null) {
            AsyncUtil.$$$reportNull$$$0(17);
        }
        return completionStage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Throwable> T withAsyncFriendly(@Nullable ProgressIndicator indicator, @NotNull ThrowableComputable<T, E> computable) throws E {
        boolean wasFriendly;
        if (computable == null) {
            AsyncUtil.$$$reportNull$$$0(18);
        }
        if (!(wasFriendly = AsyncUtil.isAsyncFriendly(indicator))) {
            AsyncUtil.markAsyncFriendly(indicator, true);
        }
        try {
            Object object = computable.compute();
            return (T)object;
        }
        finally {
            if (!wasFriendly) {
                AsyncUtil.markAsyncFriendly(indicator, false);
            }
        }
    }

    public static ProgressIndicatorEx createBackgroundIndicator(@NotNull Project project, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String name2) {
        if (project == null) {
            AsyncUtil.$$$reportNull$$$0(19);
        }
        if (name2 == null) {
            AsyncUtil.$$$reportNull$$$0(20);
        }
        return (ProgressIndicatorEx)AsyncUtil.markAsyncFriendly(new BackgroundableProcessIndicator(project, name2, PerformInBackgroundOption.ALWAYS_BACKGROUND, CommonBundle.getCancelButtonText(), CommonBundle.getCancelButtonText(), true), true);
    }

    public static <T> CompletableFuture<T> cancelled() {
        CompletableFuture res2 = new CompletableFuture();
        res2.cancel(false);
        return res2;
    }

    public static <T> CompletableFuture<T> exceptional(@NotNull Throwable th) {
        if (th == null) {
            AsyncUtil.$$$reportNull$$$0(21);
        }
        CompletableFuture res2 = new CompletableFuture();
        res2.completeExceptionally(th);
        return res2;
    }

    public static boolean isCancellation(@Nullable Throwable e) {
        return JBIterable.generate((Object)e, o -> o.getCause()).find(o -> o instanceof ProcessCanceledException || o instanceof CancellationException) != null;
    }

    public static void addUnhandledError(@NotNull ErrorHandler errorHandler, @Nullable Throwable e, @NotNull String name2, @NotNull Dbms dbms) {
        if (errorHandler == null) {
            AsyncUtil.$$$reportNull$$$0(22);
        }
        if (name2 == null) {
            AsyncUtil.$$$reportNull$$$0(23);
        }
        if (dbms == null) {
            AsyncUtil.$$$reportNull$$$0(24);
        }
        if (e == null || AsyncUtil.isCancellation(e)) {
            return;
        }
        Throwable unwrapped = AsyncUtil.unwrap(e);
        errorHandler.addError(JdbcEngine.getErrorMessage(unwrapped, name2, dbms), unwrapped);
    }

    public static <T> Promise<T> runAsync(@NotNull Supplier<? extends Promise<T>> s, @NotNull Executor e) {
        if (s == null) {
            AsyncUtil.$$$reportNull$$$0(25);
        }
        if (e == null) {
            AsyncUtil.$$$reportNull$$$0(26);
        }
        AsyncPromise res2 = new AsyncPromise();
        e.execute(() -> AsyncPromiseKt.catchError((AsyncPromise)res2, () -> AsyncUtil.lambda$null$14((Supplier)s, res2)));
        return res2;
    }

    private static /* synthetic */ Object lambda$null$14(Supplier s, AsyncPromise res2) {
        ((Promise)s.get()).processed((Promise)res2);
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "d";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 6: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "where";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cons";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/AsyncUtil";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "th";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/AsyncUtil";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "runTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "transactionExecutor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "asyncFriendlyExecutor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "rethrowUnwrapped";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "supplyAsync";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "thenComposeAsync";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processWhenComplete";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "underProgress";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "runTask";
                break;
            }
            case 16: 
            case 17: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "withAsyncFriendly";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createBackgroundIndicator";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "exceptional";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addUnhandledError";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "runAsync";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

