/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.credentialStore.Credentials;
import com.intellij.database.Dbms;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceSslConfiguration;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.SimpleDatabaseConnection;
import com.intellij.database.dataSource.connection.ConnectionRequestor;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.ui.DatabaseAuthPanel;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.RemoteDriver;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.JdbcUtil;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.ui.JBUI;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseConnectionEstablisher {
    private static final Logger LOG = Logger.getInstance(DatabaseConnectionEstablisher.class);
    private static final String USER_KEY = "user";
    private static final String PASSWORD_KEY = "password";
    public static Function<DatabaseAuthPanel, Boolean> ourCredentialsInterceptor = null;
    private final DatabaseConnectionPoint myConnectionPoint;
    private final RemoteDriver myDriver;
    private final Project myProject;
    private final boolean myAskPassword;
    private final AtomicReference<Boolean> myStopProcessRef;
    private final Properties myConnectionProperties;
    private final Map<String, Serializable> myExtraProperties;
    private final ConsoleRunConfiguration myConfiguration;
    private final ConnectionRequestor myRequestor;
    private int myAttemptNo;
    private String myUrl;

    public static void setCredentialsInterceptor(Function<DatabaseAuthPanel, Boolean> di) {
        ourCredentialsInterceptor = di;
    }

    public static CompletionStage<DatabaseConnection> establishConnection(@NotNull DatabaseConnectionPoint connectionPoint, @NotNull ConsoleRunConfiguration runConfiguration, @NotNull ConnectionRequestor requestor, @NotNull Project project, boolean askPassword) {
        if (connectionPoint == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(0);
        }
        if (runConfiguration == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(1);
        }
        if (requestor == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(2);
        }
        if (project == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(3);
        }
        JdbcDriverManager jdbcDriverManager = JdbcDriverManager.getDriverManager(project);
        CompletionStage<Credentials> firstCredentials = DatabaseConnectionEstablisher.getInitialCredentials(runConfiguration.getProject(), runConfiguration.CREDENTIALS, connectionPoint.getDataSource(), askPassword);
        return AsyncUtil.thenComposeAsync(firstCredentials, credentials -> {
            try {
                RemoteDriver driver = (RemoteDriver)RemoteUtil.castToRemoteNotNull((Object)jdbcDriverManager.getDriver(connectionPoint.getDataSource(), runConfiguration), RemoteDriver.class);
                String url = DatabaseConnectionManager.getEffectiveUrl(connectionPoint, jdbcDriverManager);
                if (url == null) {
                    return CompletableFuture.completedFuture(null);
                }
                Runnable releaseDriver = () -> jdbcDriverManager.releaseDriver(connectionPoint.getDataSource(), runConfiguration);
                DatabaseConnectionEstablisher establisher = new DatabaseConnectionEstablisher(project, runConfiguration, driver, connectionPoint, url, releaseDriver, requestor, askPassword);
                return establisher.tryConnect((Credentials)credentials);
            }
            catch (Exception e) {
                return AsyncUtil.exceptional(e);
            }
        }, AsyncUtil.NON_EDT_EXECUTOR);
    }

    DatabaseConnectionEstablisher(@NotNull Project project, @NotNull ConsoleRunConfiguration runConfiguration, @NotNull RemoteDriver driver, @NotNull DatabaseConnectionPoint connectionPoint, @NotNull String url, final @NotNull Runnable releaseDriver, @NotNull ConnectionRequestor requestor, boolean askPassword) {
        if (project == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(4);
        }
        if (runConfiguration == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(5);
        }
        if (driver == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(6);
        }
        if (connectionPoint == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(7);
        }
        if (url == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(8);
        }
        if (releaseDriver == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(9);
        }
        if (requestor == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(10);
        }
        this.myAttemptNo = 0;
        this.myConfiguration = runConfiguration;
        this.myRequestor = requestor;
        this.myStopProcessRef = new AtomicReference<Boolean>(true);
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator instanceof ProgressIndicatorEx) {
            ((ProgressIndicatorEx)indicator).addStateDelegate((ProgressIndicatorEx)new AbstractProgressIndicatorExBase(){

                public void cancel() {
                    if (((Boolean)DatabaseConnectionEstablisher.this.myStopProcessRef.get()).booleanValue()) {
                        releaseDriver.run();
                    }
                }
            });
        }
        this.myConnectionPoint = connectionPoint;
        this.myDriver = driver;
        this.myProject = project;
        this.myConnectionProperties = this.myConnectionPoint.getConnectionProperties();
        this.myExtraProperties = this.setupExtraProperties();
        this.myUrl = url;
        this.myAskPassword = askPassword;
    }

    @NotNull
    private Map<String, Serializable> setupExtraProperties() {
        HashMap<String, Serializable> extra = new HashMap<String, Serializable>();
        DataSourceSslConfiguration ssl = this.myConnectionPoint.getDataSource().getSslCfg();
        if (ssl != null && ssl.myEnabled) {
            JdbcSettings.SSL_MODE.put(extra, (Object)ssl.myMode);
        }
        if (this.myConnectionPoint.getDataSource().isDomainAuthentication()) {
            JdbcSettings.INTEGRATED_SECURITY.put(extra, (Object)true);
        }
        HashMap<String, Serializable> hashMap = extra;
        if (hashMap == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(11);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CompletionStage<DatabaseConnection> tryConnect(@Nullable Credentials credentials) {
        CompletionStage<DatabaseConnection> completionStage;
        String password;
        String userName;
        String string = userName = credentials == null ? null : credentials.getUserName();
        if (StringUtil.isNotEmpty((String)userName)) {
            LOG.info("Connecting as: " + userName);
            this.myConnectionProperties.setProperty(USER_KEY, userName);
        } else {
            LOG.info("No user name provided (may be in url)");
        }
        String string2 = password = credentials == null ? null : credentials.getPasswordAsString();
        if (StringUtil.isNotEmpty((String)password)) {
            this.myConnectionProperties.setProperty(PASSWORD_KEY, password);
        }
        try {
            DatabaseConnection connection2 = this.connect();
            CompletionStage<DatabaseConnection> completionStage2 = connection2 == null ? this.processNullConnection(credentials) : CompletableFuture.completedFuture(connection2);
            completionStage = completionStage2;
        }
        catch (SQLException e) {
            CompletionStage<DatabaseConnection> completionStage3 = this.processConnectionFailure(credentials, e);
            CompletionStage<DatabaseConnection> completionStage4 = completionStage3;
            if (completionStage4 == null) {
                DatabaseConnectionEstablisher.$$$reportNull$$$0(13);
            }
            return completionStage4;
        }
        finally {
            this.myStopProcessRef.set(false);
            ProgressManager.checkCanceled();
        }
        if (completionStage == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(12);
        }
        return completionStage;
    }

    @NotNull
    private CompletionStage<DatabaseConnection> processConnectionFailure(@Nullable Credentials credentials, @NotNull SQLException e) {
        CompletionStage<DatabaseConnection> passwordResolution;
        boolean passIsEmpty;
        if (e == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(14);
        }
        Throwable ex = AsyncUtil.unwrap(e);
        String message2 = JdbcUtil.getLongMessage((Throwable)ex);
        String title = "Connecting to: " + this.myUrl;
        String user = StringUtil.notNullize((String)(credentials == null ? null : credentials.getUserName()), (String)USER_KEY);
        boolean bl = passIsEmpty = credentials == null || StringUtil.isEmpty((String)credentials.getPasswordAsString());
        if (this.myAttemptNo < 20 && DatabaseConnectionEstablisher.mayRequestPassword(message2, user, passIsEmpty && this.myAttemptNo == 0) && (passwordResolution = this.resolvePasswordIssues(title, message2, credentials)) != null) {
            CompletionStage<DatabaseConnection> completionStage = passwordResolution;
            if (completionStage == null) {
                DatabaseConnectionEstablisher.$$$reportNull$$$0(15);
            }
            return completionStage;
        }
        LOG.warn(title);
        LOG.warn(message2);
        CompletableFuture<DatabaseConnection> completableFuture = AsyncUtil.exceptional(e);
        if (completableFuture == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(16);
        }
        return completableFuture;
    }

    @Nullable
    private CompletionStage<DatabaseConnection> resolvePasswordIssues(@NotNull String title, @NotNull String message2, @Nullable Credentials credentials) {
        if (title == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(17);
        }
        if (message2 == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(18);
        }
        if (this.myAttemptNo == 0 && !Comparing.equal((Object)credentials, (Object)this.myConfiguration.CREDENTIALS.getCredentials(this.myConnectionPoint.getDataSource()))) {
            return this.tryReconnectIfWithCredentials(this.myConfiguration.CREDENTIALS.getCredentials(this.myConnectionPoint.getDataSource()), message2, title);
        }
        if (!this.myAskPassword || !this.myConnectionPoint.getDataSource().isAuthRequired()) {
            return null;
        }
        return AsyncUtil.thenComposeAsync(DatabaseConnectionEstablisher.askPasswordAsync(this.myConnectionPoint.getDataSource(), this.myProject, this.myConfiguration.CREDENTIALS, credentials, message2), c2 -> this.tryReconnectIfWithCredentials((Credentials)c2, message2, title), AsyncUtil.NON_EDT_EXECUTOR);
    }

    @NotNull
    private CompletionStage<DatabaseConnection> processNullConnection(@Nullable Credentials credentials) {
        if (this.myAttemptNo == 0 && Dbms.forConnection((RawConnectionConfig)this.myConnectionPoint).isPostgres()) {
            this.myUrl = this.myUrl + "/";
            CompletionStage<DatabaseConnection> completionStage = this.tryReconnect(credentials);
            if (completionStage == null) {
                DatabaseConnectionEstablisher.$$$reportNull$$$0(19);
            }
            return completionStage;
        }
        LOG.warn("Null connection returned for: " + this.myUrl);
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        if (completableFuture == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(20);
        }
        return completableFuture;
    }

    @Nullable
    private DatabaseConnection connect() throws SQLException {
        LOG.info("Connecting to: " + this.myUrl);
        Connection jdbcConnection = null;
        try {
            RemoteConnection connection2 = this.myDriver.connect(this.myUrl, this.myConnectionProperties, this.myExtraProperties);
            jdbcConnection = connection2 == null ? null : (Connection)RemoteUtil.castToLocal((Object)connection2, Connection.class);
        }
        catch (UnmarshalException e) {
            LOG.warn(e.getMessage());
        }
        catch (RemoteException r) {
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)r);
        }
        if (jdbcConnection != null) {
            this.prepareConnection(jdbcConnection);
        }
        return jdbcConnection == null ? null : new SimpleDatabaseConnection(this.myConnectionPoint, jdbcConnection, this.myConfiguration, this.myRequestor, this.myProject);
    }

    private void prepareConnection(@NotNull Connection jdbcConnection) {
        if (jdbcConnection == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(21);
        }
        Dbms dbms = this.myConnectionPoint.getDataSource().getDbms();
        if (this.myConnectionPoint.isReadOnly() && DbImplUtil.supportsReadOnlyChangeOnTheFly(dbms)) {
            DbImplUtil.tryToSetReadOnly(jdbcConnection, true, dbms);
        }
        if (!DatabaseDriver.OPTION_SEND_APP_INFO.get(this.myConnectionPoint.getDatabaseDriver()).booleanValue()) {
            return;
        }
        if (StringUtil.isEmpty((String)DatabaseConnectionEstablisher.getClientInfo(jdbcConnection))) {
            DatabaseConnectionEstablisher.setClientInfo(jdbcConnection, DatabaseConnectionEstablisher.getApplicationName());
        }
    }

    private static void setClientInfo(@NotNull Connection jdbcConnection, String name2) {
        if (jdbcConnection == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(22);
        }
        try {
            jdbcConnection.setClientInfo("ApplicationName", name2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @NotNull
    private static String getApplicationName() {
        String name2;
        Application app = ApplicationManager.getApplication();
        String string = name2 = app == null || app.isUnitTestMode() ? null : ApplicationInfoEx.getInstanceEx().getFullApplicationName();
        if (name2 == null) {
            name2 = "DG Tests";
        }
        String string2 = name2;
        if (string2 == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(23);
        }
        return string2;
    }

    @Nullable
    private static String getClientInfo(@NotNull Connection jdbcConnection) {
        if (jdbcConnection == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(24);
        }
        String existing = null;
        try {
            existing = jdbcConnection.getClientInfo("ApplicationName");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return existing;
    }

    private CompletionStage<DatabaseConnection> tryReconnect(Credentials credentials) {
        ++this.myAttemptNo;
        this.myStopProcessRef.set(false);
        ProgressManager.checkCanceled();
        return this.tryConnect(credentials);
    }

    private CompletionStage<DatabaseConnection> tryReconnectIfWithCredentials(Credentials credentials, String message2, String title) {
        if (credentials == null) {
            LOG.warn(title);
            LOG.warn(message2);
            return AsyncUtil.cancelled();
        }
        return this.tryReconnect(credentials);
    }

    private static CompletionStage<Credentials> askPasswordAsync(@NotNull LocalDataSource dataSource, Project project, DatabaseCredentials databaseCredentials, Credentials credentials, String message2) {
        if (dataSource == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(25);
        }
        String prompt = "The specified database user/password combination is rejected";
        prompt = prompt + (message2.isEmpty() ? "." : ":<br>" + message2);
        String userNameDef = StringUtil.notNullize((String)(credentials == null ? null : credentials.getUserName()), (String)StringUtil.notNullize((String)dataSource.getUsername()));
        return DatabaseConnectionEstablisher.askCredentialsWhenFailed(project, databaseCredentials, dataSource, "<html>" + prompt + "</html>", true, userNameDef);
    }

    private static boolean mayRequestPassword(@NotNull String message2, @Nullable String user, boolean askIfUncertain) {
        if (message2 == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(26);
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return false;
        }
        if (message2.contains("ORA-28001:")) {
            return true;
        }
        if (message2.contains("ORA-12705:")) {
            return false;
        }
        if (askIfUncertain) {
            return true;
        }
        String userPart = StringUtil.isNotEmpty((String)user) ? "|" + StringUtil.escapeToRegexp((String)user) : "";
        String regex = "(?i)\\b(access|denied|password|user" + userPart + ")\\b";
        return Pattern.compile(regex).matcher(message2).find();
    }

    public static CompletionStage<Credentials> getInitialCredentials(@NotNull Project project, @NotNull DatabaseCredentials dc, @NotNull LocalDataSource dataSource, boolean askPassword) {
        boolean canAskPassword;
        if (project == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(27);
        }
        if (dc == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(28);
        }
        if (dataSource == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(29);
        }
        boolean bl = canAskPassword = askPassword && DbImplUtil.isAuthRequired(dataSource);
        if (!dataSource.getPasswordStorage().isPersisted() && dataSource.isConfiguredByUrl()) {
            JdbcUrlParser parsed = JdbcUrlParserUtil.parsed(dataSource);
            boolean hardcoded = parsed != null && parsed.isValid() && parsed.getParameter(PASSWORD_KEY) != null;
            canAskPassword &= !hardcoded;
        }
        return DatabaseCredentials.getInitialCredentialsImpl(dataSource.getPasswordStorage(), canAskPassword, () -> dc.strict().getCredentialsAsync(dataSource), th -> th == null ? DatabaseConnectionEstablisher.askNoCredentials(project, dc, dataSource) : DatabaseConnectionEstablisher.askCredentialsWhenFailed(project, dc, dataSource, th.getMessage(), true, dataSource.getUsername()), c2 -> c2 == null || c2.getPassword() == null);
    }

    public static CompletionStage<Credentials> askNoCredentials(@NotNull Project project, @NotNull DatabaseCredentials dc, @NotNull LocalDataSource dataSource) {
        if (project == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(30);
        }
        if (dc == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(31);
        }
        if (dataSource == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(32);
        }
        return DatabaseConnectionEstablisher.askCredentialsWhenFailed(project, dc, dataSource, "<html>Please provide database credentials.</html>", false, dataSource.getUsername());
    }

    @NotNull
    public static CompletionStage<Credentials> askCredentialsWhenFailed(@NotNull Project project, @NotNull DatabaseCredentials dc, @NotNull LocalDataSource dataSource, @Nullable String message2, boolean error2, String userNameDef) {
        if (project == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(33);
        }
        if (dc == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(34);
        }
        if (dataSource == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(35);
        }
        if (!dataSource.isAuthRequired()) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                DatabaseConnectionEstablisher.$$$reportNull$$$0(36);
            }
            return completableFuture;
        }
        if (project.isDefault()) {
            CompletableFuture<Credentials> completableFuture = AsyncUtil.cancelled();
            if (completableFuture == null) {
                DatabaseConnectionEstablisher.$$$reportNull$$$0(37);
            }
            return completableFuture;
        }
        Credentials c1 = dc.getCredentials(dataSource);
        CompletableFuture<Credentials> completableFuture = DatabaseCredentials.showCredentialsDialog(() -> {
            boolean ok;
            Credentials c2 = dc.getCredentials(dataSource);
            if (!Comparing.equal((Object)c1, (Object)c2)) {
                return c2;
            }
            DatabaseAuthPanel auth = new DatabaseAuthPanel(dataSource, dc, true);
            auth.reset(dataSource, false);
            auth.setUser(StringUtil.notNullize((String)userNameDef));
            if (c1 == null || c1.getPassword() == null) {
                auth.setPassword("");
            }
            if (ourCredentialsInterceptor == null) {
                auth.getComponent().setBorder((Border)JBUI.Borders.emptyTop((int)12));
                DialogBuilder builder = DatabaseCredentials.prepareDialog(project, (error2 ? MessageType.ERROR : MessageType.WARNING).getDefaultIcon(), auth.getComponent(), "Connecting to '" + dataSource.getName() + "'...", StringUtil.notNullize((String)message2));
                builder.setPreferredFocusComponent(auth.getPreferredFocusedComponent());
                ok = builder.show() == 0;
            } else {
                ok = (Boolean)ourCredentialsInterceptor.fun((Object)auth);
            }
            if (!ok) {
                throw new ProcessCanceledException();
            }
            auth.save(dataSource, true);
            return new Credentials(auth.getUserName(), auth.getPassword());
        });
        if (completableFuture == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(38);
        }
        return completableFuture;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 23: 
            case 36: 
            case 37: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 23: 
            case 36: 
            case 37: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionPoint";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 3: 
            case 4: 
            case 27: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "releaseDriver";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 23: 
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DatabaseConnectionEstablisher";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 18: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 21: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdbcConnection";
                break;
            }
            case 25: 
            case 29: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 28: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DatabaseConnectionEstablisher";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "setupExtraProperties";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "tryConnect";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "processConnectionFailure";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "processNullConnection";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationName";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "askCredentialsWhenFailed";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "establishConnection";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 23: 
            case 36: 
            case 37: 
            case 38: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processConnectionFailure";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "resolvePasswordIssues";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "prepareConnection";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setClientInfo";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getClientInfo";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "askPasswordAsync";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "mayRequestPassword";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getInitialCredentials";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "askNoCredentials";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "askCredentialsWhenFailed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 23: 
            case 36: 
            case 37: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

