/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.actions.DatabaseViewActions;
import com.intellij.database.actions.ImportAction;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dbimport.DatabaseInputType;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DbImplUtil;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDEventImpl;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbElementDnDTarget
implements DnDTarget {
    private final DbElement myConsumerElement;

    public DbElementDnDTarget(@NotNull DbElement consumerElement) {
        if (consumerElement == null) {
            DbElementDnDTarget.$$$reportNull$$$0(0);
        }
        this.myConsumerElement = consumerElement;
    }

    public void drop(DnDEvent event) {
        if (!this.dropDbElement(event)) {
            this.dropFile(event);
        }
    }

    public boolean equals(Object obj2) {
        return this.getClass() == obj2.getClass() && Objects.equals(this.myConsumerElement, ((DbElementDnDTarget)obj2).myConsumerElement);
    }

    public int hashCode() {
        return Objects.hash(this.myConsumerElement);
    }

    @NotNull
    protected final DbElement getElement() {
        DbElement dbElement = this.myConsumerElement;
        if (dbElement == null) {
            DbElementDnDTarget.$$$reportNull$$$0(1);
        }
        return dbElement;
    }

    private boolean dropDbElement(@NotNull DnDEvent event) {
        DbTable table;
        if (event == null) {
            DbElementDnDTarget.$$$reportNull$$$0(2);
        }
        if ((table = this.getDbTable(event)) == null) {
            return false;
        }
        DbDataSource source = table.getDataSource();
        LocalDataSource delegate = (LocalDataSource)ObjectUtils.tryCast((Object)source.getDelegate(), LocalDataSource.class);
        if (delegate == null) {
            return true;
        }
        DatabaseInputType type = new DatabaseInputType(delegate, source, (DasTable)table, table.getProject());
        ImportAction.showDialog(this.myConsumerElement.getProject(), this.myConsumerElement, table.getName(), type);
        return true;
    }

    private void dropFile(DnDEvent event) {
        List object = FileCopyPasteUtil.getVirtualFileListFromAttachedObject((Object)event.getAttachedObject());
        if (object.size() != 1) {
            return;
        }
        VirtualFile file = (VirtualFile)ContainerUtil.getFirstItem((List)object);
        ImportAction.showDialog(this.myConsumerElement.getProject(), this.myConsumerElement, (VirtualFile)ObjectUtils.assertNotNull((Object)file));
    }

    public boolean update(DnDEvent event) {
        return ImportUtil.canBeConsumer(this.myConsumerElement) && (this.updateDbElements(event) || this.updateFiles(event));
    }

    public void cleanUpOnLeave() {
    }

    public void updateDraggedImage(Image image, Point dropPoint, Point imageOffset) {
    }

    @Nullable
    private DbTable getDbTable(@NotNull DnDEvent event) {
        Object[] objects2;
        if (event == null) {
            DbElementDnDTarget.$$$reportNull$$$0(3);
        }
        if ((objects2 = DbElementDnDTarget.getObjects(event)) == null || objects2.length != 1) {
            return null;
        }
        DbTable table = (DbTable)ObjectUtils.tryCast((Object)ArrayUtil.getFirstElement((Object[])objects2), DbTable.class);
        return table == null || table == this.myConsumerElement || !ImportUtil.canBeProducer((DbElement)table) ? null : table;
    }

    @Nullable
    protected static Object[] getObjects(@NotNull DnDEvent event) {
        if (event == null) {
            DbElementDnDTarget.$$$reportNull$$$0(4);
        }
        try {
            Object object = event.getTransferData(DnDEventImpl.ourDataFlavor);
            return (Object[])ObjectUtils.tryCast((Object)object, Object[].class);
        }
        catch (UnsupportedFlavorException | IOException exception) {
            return null;
        }
    }

    protected boolean updateDbElements(DnDEvent event) {
        return this.getDbTable(event) != null;
    }

    protected boolean updateFiles(DnDEvent event) {
        List object = FileCopyPasteUtil.getVirtualFileListFromAttachedObject((Object)event.getAttachedObject());
        return object.size() == 1 && !((VirtualFile)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem((List)object))).isDirectory();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumerElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/DbElementDnDTarget";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/DbElementDnDTarget";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "dropDbElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDbTable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getObjects";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class FamilyGroupDnDTarget
    extends NamespaceDnDTarget {
        private final ObjectKind myKind;

        public FamilyGroupDnDTarget(@NotNull DbNamespaceImpl namespace, @NotNull ObjectKind kind) {
            if (namespace == null) {
                FamilyGroupDnDTarget.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                FamilyGroupDnDTarget.$$$reportNull$$$0(1);
            }
            super(namespace);
            this.myKind = kind;
        }

        @Override
        public boolean update(DnDEvent event) {
            return super.update(event) && this.myKind == ObjectKind.TABLE;
        }

        @Override
        public boolean equals(Object obj2) {
            if (!(obj2 instanceof FamilyGroupDnDTarget)) {
                return false;
            }
            FamilyGroupDnDTarget anotherTarget = (FamilyGroupDnDTarget)obj2;
            return Objects.equals(this.myKind, anotherTarget.myKind) && Objects.equals(this.getElement(), anotherTarget.getElement());
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.myKind, this.getElement());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "namespace";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "kind";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dbimport/DbElementDnDTarget$FamilyGroupDnDTarget";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class NamespaceDnDTarget
    extends DbElementDnDTarget {
        private final DbNamespaceImpl myNamespace;

        public NamespaceDnDTarget(@NotNull DbNamespaceImpl namespace) {
            if (namespace == null) {
                NamespaceDnDTarget.$$$reportNull$$$0(0);
            }
            super(namespace);
            this.myNamespace = namespace;
        }

        @Override
        public boolean update(DnDEvent event) {
            return super.update(event) && this.myNamespace.getKind() == ObjectKind.SCHEMA;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/database/dbimport/DbElementDnDTarget$NamespaceDnDTarget", "<init>"));
        }
    }

    public static class DataSourceDnDTarget
    extends DbElementDnDTarget {
        private final DbDataSource myDataSource;

        public DataSourceDnDTarget(@NotNull DbDataSource dataSource) {
            if (dataSource == null) {
                DataSourceDnDTarget.$$$reportNull$$$0(0);
            }
            super((DbElement)dataSource);
            this.myDataSource = dataSource;
        }

        @Override
        public void drop(DnDEvent event) {
            List<DbDataSource> dataSources2 = DataSourceDnDTarget.getDataSources(event);
            if (dataSources2.isEmpty()) {
                super.drop(event);
                return;
            }
            dataSources2.add(this.myDataSource);
            Project project = this.myDataSource.getProject();
            String name2 = DatabaseViewActions.MoveToGroup.askForGroupName(project, null);
            if (!StringUtil.isEmptyOrSpaces((String)name2)) {
                DatabaseViewActions.MoveToGroup.assignGroup(project, name2, dataSources2);
            }
        }

        @Override
        public boolean update(DnDEvent event) {
            List<DbDataSource> dataSources2 = DataSourceDnDTarget.getDataSources(event);
            return !dataSources2.isEmpty() && !dataSources2.contains(this.myDataSource) || super.update(event) && DbImplUtil.getTopSingleNamespace((DasObject)this.myDataSource) != null;
        }

        @NotNull
        private static List<DbDataSource> getDataSources(@NotNull DnDEvent event) {
            Object[] objects2;
            if (event == null) {
                DataSourceDnDTarget.$$$reportNull$$$0(1);
            }
            if ((objects2 = DbElementDnDTarget.getObjects(event)) == null) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    DataSourceDnDTarget.$$$reportNull$$$0(2);
                }
                return list;
            }
            ArrayList<DbDataSource> dataSources2 = new ArrayList<DbDataSource>();
            for (Object object : objects2) {
                if (!(object instanceof DbDataSource)) {
                    List list = ContainerUtil.emptyList();
                    if (list == null) {
                        DataSourceDnDTarget.$$$reportNull$$$0(3);
                    }
                    return list;
                }
                dataSources2.add((DbDataSource)object);
            }
            ArrayList<DbDataSource> arrayList = dataSources2;
            if (arrayList == null) {
                DataSourceDnDTarget.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/DbElementDnDTarget$DataSourceDnDTarget";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/DbElementDnDTarget$DataSourceDnDTarget";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataSources";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getDataSources";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DbTableDnDTarget
    extends DbElementDnDTarget {
        private final DbTable myTable;

        public DbTableDnDTarget(@NotNull DbTable table) {
            if (table == null) {
                DbTableDnDTarget.$$$reportNull$$$0(0);
            }
            super((DbElement)table);
            this.myTable = table;
        }

        @Override
        public boolean update(DnDEvent event) {
            return super.update(event) && this.myTable.getKind() == ObjectKind.TABLE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/DbElementDnDTarget$DbTableDnDTarget", "<init>"));
        }
    }
}

