/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diagram;

import com.intellij.database.diagram.DbDiagramDataModel;
import com.intellij.database.diagram.DbDiagramElementManager;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.diagram.AbstractDiagramNodeContentManager;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramElementsProvider;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNodeContentManager;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.DiagramRelationshipManager;
import com.intellij.diagram.DiagramVfsResolver;
import com.intellij.diagram.DiagramVisibilityManager;
import com.intellij.diagram.EmptyDiagramVisibilityManager;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.diagram.extras.providers.DiagramDnDProvider;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import icons.DatabaseIcons;
import java.util.List;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbDiagramProvider
extends DiagramProvider<DbElement>
implements DumbAware {
    public static final String ID = "DATABASE";
    private static final DiagramCategory COLUMNS = new DiagramCategory("Columns", DatabaseIcons.Col, true);
    private static final DiagramCategory ID_COLUMNS = new DiagramCategory("Key columns", DatabaseIcons.ColGoldKey, true);
    private static final DiagramCategory[] CATEGORIES = new DiagramCategory[]{ID_COLUMNS, COLUMNS};
    private final EmptyDiagramVisibilityManager myVisibilityManager = new EmptyDiagramVisibilityManager();
    private final DbDiagramElementManager myElementManager = new DbDiagramElementManager();
    private final DiagramNodeContentManager myCategoryManager = new AbstractDiagramNodeContentManager(){

        public DiagramCategory[] getContentCategories() {
            return CATEGORIES;
        }

        public boolean isInCategory(Object element2, DiagramCategory category, DiagramState presentation) {
            if (COLUMNS.equals((Object)category)) {
                return element2 instanceof DbColumn && !DasUtil.isPrimary((DasColumn)((DbColumn)element2));
            }
            if (ID_COLUMNS.equals((Object)category)) {
                return element2 instanceof DbColumn && DasUtil.isPrimary((DasColumn)((DbColumn)element2));
            }
            return false;
        }
    };
    private final DiagramVfsResolver<DbElement> myVfsResolver = new DiagramVfsResolver<DbElement>(){

        public String getQualifiedName(DbElement element2) {
            return element2.getDataSource().getUniqueId() + (element2 instanceof DbDataSource ? "" : "." + element2.getKind().name() + ":" + QNameUtil.getQualifiedName(element2));
        }

        public DbElement resolveElementByFQN(String fqn, Project project) {
            int idx = fqn.indexOf(46);
            DbDataSource dataSource = DbPsiFacade.getInstance((Project)project).findDataSource(idx == -1 ? fqn : fqn.substring(0, idx));
            if (dataSource == null || idx == -1) {
                return dataSource;
            }
            String typedQName = fqn.substring(idx + 1);
            String qname = typedQName.substring(typedQName.indexOf(58) + 1);
            for (DasObject object : QNameUtil.findByQName(dataSource.getModel(), qname, (Function<? super DasObject, String>)DasUtil.TO_NAME)) {
                if (!typedQName.startsWith(object.getKind().name() + ":")) continue;
                return DbImplUtil.findElement(dataSource, object);
            }
            return null;
        }
    };
    private final DiagramRelationshipManager<DbElement> myRelationshipManager = new DiagramRelationshipManager<DbElement>(){

        @Nullable
        public DiagramRelationshipInfo getDependencyInfo(DbElement e1, DbElement e2, DiagramCategory category) {
            return null;
        }

        public DiagramCategory[] getContentCategories() {
            return DiagramCategory.EMPTY_ARRAY;
        }
    };
    private final DiagramExtras<DbElement> myExtras = new DiagramExtras<DbElement>(){
        private final DiagramDnDProvider<DbElement> DND_PROVIDER = new DiagramDnDProvider<DbElement>(){

            public boolean isAcceptedForDnD(Object o, Project project) {
                return DbDiagramElementManager.isAcceptedAsNodeImpl(o);
            }

            public DbElement[] wrapToModelObject(Object o, Project project) {
                return new DbElement[]{(DbElement)o};
            }
        };

        public DiagramElementsProvider<DbElement>[] getElementsProviders() {
            return DiagramElementsProvider.EMPTY_ARRAY;
        }

        public DiagramDnDProvider<DbElement> getDnDProvider() {
            return this.DND_PROVIDER;
        }

        @Nullable
        public Object getData(@NotNull String dataId, List<DiagramNode<DbElement>> nodes2, DiagramBuilder builder) {
            if (dataId == null) {
                4.$$$reportNull$$$0(0);
            }
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                return "reference.persistencediagram";
            }
            return super.getData(dataId, nodes2, builder);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/database/diagram/DbDiagramProvider$4", "getData"));
        }
    };

    public DbDiagramProvider() {
        this.myElementManager.setUmlProvider(this);
    }

    @Pattern(value="[a-zA-Z0-9_-]*")
    public String getID() {
        return ID;
    }

    public DiagramVisibilityManager createVisibilityManager() {
        return this.myVisibilityManager;
    }

    public DiagramNodeContentManager getNodeContentManager() {
        return this.myCategoryManager;
    }

    public DiagramElementManager<DbElement> getElementManager() {
        return this.myElementManager;
    }

    public DiagramVfsResolver<DbElement> getVfsResolver() {
        return this.myVfsResolver;
    }

    public DiagramRelationshipManager<DbElement> getRelationshipManager() {
        return this.myRelationshipManager;
    }

    public DiagramDataModel<DbElement> createDataModel(@NotNull Project project, @Nullable DbElement element2, @Nullable VirtualFile file, DiagramPresentationModel presentationModel) {
        if (project == null) {
            DbDiagramProvider.$$$reportNull$$$0(0);
        }
        return new DbDiagramDataModel(project, element2, this);
    }

    @NotNull
    public DiagramExtras<DbElement> getExtras() {
        DiagramExtras<DbElement> diagramExtras = this.myExtras;
        if (diagramExtras == null) {
            DbDiagramProvider.$$$reportNull$$$0(1);
        }
        return diagramExtras;
    }

    public String getActionName(boolean isPopup) {
        return "Visualisation";
    }

    public String getPresentableName() {
        return "Database Schema Diagram";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/diagram/DbDiagramProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/diagram/DbDiagramProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtras";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDataModel";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

