/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.base.BaseDmlGenerator;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.script.generator.dml.CountAll;
import com.intellij.database.script.generator.dml.DasColumns;
import com.intellij.database.script.generator.dml.DmlGenerator;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.OrderBy;
import com.intellij.database.script.generator.dml.QueryColumns;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.script.generator.dml.WhereClause;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlOrderByClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSelectOption;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlWithQueryExpression;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.TIntArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 F2\u00020\u0001:\u0001FB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0004J\"\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\r\u001a\u00020\u0013H\u0002J(\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0014H\u0014J(\u0010\u0015\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\nH\u0014J:\u0010\u0019\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u0018H\u0014J \u0010\"\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\u001fH\u0004J\u001a\u0010%\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0014J4\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001f0'2\u0006\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0002J'\u0010,\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010+\u001a\u00020-2\u0006\u0010.\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010/J\u0018\u00100\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00101\u001a\u00020\u001fH\u0004J\u0012\u00102\u001a\u0004\u0018\u00010-2\u0006\u0010)\u001a\u00020*H\u0002J\u0018\u00103\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00104\u001a\u000205H\u0016J\u0012\u00106\u001a\u0002072\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0014J \u00108\u001a\u00020\n2\u0006\u00109\u001a\u00020:2\u0006\u0010+\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020;H\u0002J \u0010<\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00101\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u0018H\u0004J\u0018\u0010=\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00104\u001a\u00020>H\u0014J \u0010?\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010@\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001fH\u0004J,\u0010A\u001a\u0004\u0018\u00010B2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010+\u001a\u0004\u0018\u00010\n2\u0006\u00109\u001a\u00020:2\u0006\u00104\u001a\u000205H\u0016J,\u0010C\u001a\u0004\u0018\u00010D2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010+\u001a\u0004\u0018\u00010\n2\u0006\u00109\u001a\u00020:2\u0006\u00104\u001a\u00020>H\u0002J\u0014\u0010E\u001a\u00020\f*\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006G"}, d2={"Lcom/intellij/database/dialects/base/BaseDmlGenerator;", "Lcom/intellij/database/script/generator/dml/DmlGenerator;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "getDbms", "()Lcom/intellij/database/Dbms;", "appendColumnList", "", "alias", "", "builder", "Lcom/intellij/database/util/DdlBuilder;", "columns", "", "Lcom/intellij/database/model/DasColumn;", "appendColumns", "table", "Lcom/intellij/database/model/DasTable;", "Lcom/intellij/database/script/generator/dml/QueryColumns;", "", "appendFromTable", "dasTable", "insertNewLines", "", "appendLimit", "dialect", "Lcom/intellij/database/dialects/DatabaseDialectEx;", "system", "Lcom/intellij/database/model/DasDataSource;", "limit", "", "offset", "atBeginning", "appendNumericProperty", "property", "value", "appendRowId", "appendWrappedQueryTail", "Lkotlin/Pair;", "head", "e", "Lcom/intellij/sql/psi/SqlResultSetExpression;", "query", "buildOptimizedCountQuery", "Lcom/intellij/sql/psi/SqlQueryExpression;", "queryText", "(Lcom/intellij/database/util/DdlBuilder;Lcom/intellij/sql/psi/SqlQueryExpression;Ljava/lang/String;)Ljava/lang/Integer;", "fetchFirst", "rows", "findQuery", "generate", "task", "Lcom/intellij/database/script/generator/dml/DmlTask;", "getPlaceForLimit", "Lcom/intellij/database/dialects/base/BaseDmlGenerator$Companion$LimitPlace;", "removeOrderByClause", "project", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "rowNumLimit", "select", "Lcom/intellij/database/script/generator/dml/SelectTask;", "top", "topWord", "wrap", "Lcom/intellij/database/script/generator/dml/DmlGenerator$Companion$Result;", "wrapInSelect", "Lcom/intellij/database/script/generator/dml/DmlGenerator$Companion$WrapQueryResult;", "space", "Companion", "intellij.database.dialects.base"})
public abstract class BaseDmlGenerator
implements DmlGenerator {
    @NotNull
    private final Dbms dbms;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DmlTask task) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        DmlTask dmlTask = task;
        if (!(dmlTask instanceof SelectTask)) {
            throw (Throwable)new UnsupportedOperationException("Task is not supported " + task);
        }
        return this.select(builder, (SelectTask)task);
    }

    @Override
    @Nullable
    public DmlGenerator.Companion.Result wrap(@NotNull DdlBuilder builder, @Nullable String query, @NotNull Project project, @NotNull DmlTask task) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        DmlTask dmlTask = task;
        if (!(dmlTask instanceof SelectTask)) {
            throw (Throwable)new UnsupportedOperationException("Task is not supported " + task);
        }
        return this.wrapInSelect(builder, query, project, (SelectTask)task);
    }

    @NotNull
    protected Companion.LimitPlace getPlaceForLimit(@Nullable DasDataSource system) {
        return Companion.LimitPlace.END;
    }

    @NotNull
    protected DdlBuilder select(@NotNull DdlBuilder builder, @NotNull SelectTask task) {
        Object it2;
        boolean bl;
        boolean bl2;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        DatabaseDialectEx databaseDialectEx = DbImplUtil.getDatabaseDialect(this.dbms);
        Intrinsics.checkExpressionValueIsNotNull((Object)databaseDialectEx, (String)"getDatabaseDialect(dbms)");
        DatabaseDialectEx dialect = databaseDialectEx;
        boolean limited = !DbImplUtil.isPageSizeUnlimited(task.getLimit()) || task.getOffset() > 0;
        Companion.LimitPlace limitPlace = this.getPlaceForLimit(task.getSystem());
        if (limited) {
            Companion.LimitPlace.BOTH.appendLimit(builder, this, dialect, limitPlace, task.getSystem(), task.getLimit(), task.getOffset(), true);
        }
        builder.keyword("SELECT").space();
        if (limited) {
            Companion.LimitPlace.BEGIN.appendLimit(builder, this, dialect, limitPlace, task.getSystem(), task.getLimit(), task.getOffset(), true);
        }
        this.appendColumns(builder, task.getTable(), task.getColumns());
        if (dialect.hasRowId(task.getSystem()) && task.getAppendRowId()) {
            this.appendRowId(builder, task.getSystem());
        }
        DasTable dasTable = task.getTable();
        if (dasTable == null) {
            Intrinsics.throwNpe();
        }
        boolean bl3 = task.getInsertNewLines();
        String string = task.getAlias();
        if (string == null) {
            string = "t";
        }
        this.appendFromTable(builder, dasTable, bl3, string);
        WhereClause whereClause = task.getWhereClause();
        if (whereClause != null) {
            object = whereClause;
            bl2 = false;
            bl = false;
            it2 = object;
            boolean bl4 = false;
            this.space(builder, task.getInsertNewLines());
            ((WhereClause)it2).produce(builder, task, this.dbms);
        }
        OrderBy orderBy = task.getOrderBy();
        if (orderBy != null) {
            object = orderBy;
            bl2 = false;
            bl = false;
            it2 = object;
            boolean bl5 = false;
            this.space(builder, task.getInsertNewLines());
            ((OrderBy)it2).produce(builder, task, this.dbms);
        }
        if (limited) {
            Companion.LimitPlace.BOTH.appendLimit(builder, this, dialect, limitPlace, task.getSystem(), task.getLimit(), task.getOffset(), false);
            Companion.LimitPlace.END.appendLimit(builder, this, dialect, limitPlace, task.getSystem(), task.getLimit(), task.getOffset(), false);
        }
        return builder;
    }

    @NotNull
    protected DdlBuilder appendRowId(@NotNull DdlBuilder builder, @Nullable DasDataSource system) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        return builder;
    }

    protected void appendFromTable(@NotNull DdlBuilder builder, @NotNull DasTable dasTable, boolean insertNewLines, @NotNull String alias) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)dasTable, (String)"dasTable");
        Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
        if (insertNewLines) {
            builder.newLine();
        } else {
            builder.space();
        }
        builder.keyword("FROM").space().qualifiedRef((DasObject)dasTable).space().alias(alias);
    }

    private final void appendColumns(DdlBuilder builder, DasTable table, QueryColumns columns) {
        QueryColumns queryColumns = columns;
        if (queryColumns instanceof DasColumns) {
            this.appendColumns(builder, table, ((DasColumns)columns).getColumns());
        } else if (queryColumns instanceof CountAll) {
            Intrinsics.checkExpressionValueIsNotNull((Object)builder.keyword("COUNT").symbol("(").symbol("*").symbol(")"), (String)"builder.keyword(\"COUNT\")\u2026).symbol(\"*\").symbol(\")\")");
        }
    }

    protected void appendColumns(@NotNull DdlBuilder builder, @Nullable DasTable table, @NotNull List<? extends DasColumn> columns) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull(columns, (String)"columns");
        if (columns.isEmpty()) {
            Intrinsics.checkExpressionValueIsNotNull((Object)builder.alias("t").symbol(".").symbol("*"), (String)"builder.alias(DialectUti\u2026).symbol(\".\").symbol(\"*\")");
        } else {
            this.appendColumnList("t", builder, (Iterable<? extends DasColumn>)columns);
        }
    }

    protected final void appendColumnList(@Nullable String alias, @NotNull DdlBuilder builder, @NotNull Iterable<? extends DasColumn> columns) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull(columns, (String)"columns");
        DialectUtils.appendCommaSeparated(builder, ContainerUtil.map(columns, (Function)new Function<T, V>(alias){
            final /* synthetic */ String $alias;

            @NotNull
            public final Consumer<DdlBuilder> fun(DasColumn column2) {
                return (Consumer)new Consumer<DdlBuilder>(this, column2){
                    final /* synthetic */ appendColumnList.1 this$0;
                    final /* synthetic */ DasColumn $column;

                    public final void consume(@NotNull DdlBuilder b2) {
                        Intrinsics.checkParameterIsNotNull((Object)b2, (String)"b");
                        if (this.this$0.$alias != null) {
                            b2.alias(this.this$0.$alias).symbol(".");
                        }
                        b2.columnRef((DasObject)this.$column);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$column = dasColumn;
                    }
                };
            }
            {
                this.$alias = string;
            }
        }));
    }

    private final DmlGenerator.Companion.WrapQueryResult wrapInSelect(DdlBuilder builder, String query, Project project, SelectTask task) {
        Integer offset;
        Integer n;
        SqlQueryExpression queryExpression;
        if (query == null) {
            return null;
        }
        String string = StringUtil.trimEnd((String)query, (String)";");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.trimEnd(query, \";\")");
        String queryText = string;
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect(this.dbms);
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlLanguageDialect, (String)"DbSqlUtil.getSqlDialect(dbms)");
        SqlLanguageDialect dialect = sqlLanguageDialect;
        if (task.getColumns() instanceof CountAll) {
            queryText = this.removeOrderByClause(project, queryText, dialect);
        }
        SqlResultSetExpression sqlResultSetExpression = DbSqlUtil.parseQuery(project, dialect, queryText, null);
        if (sqlResultSetExpression == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlResultSetExpression, (String)"DbSqlUtil.parseQuery(pro\u2026ext, null) ?: return null");
        SqlResultSetExpression e = sqlResultSetExpression;
        SqlQueryExpression sqlQueryExpression = queryExpression = this.findQuery(e);
        if (sqlQueryExpression != null) {
            SqlQueryExpression sqlQueryExpression2 = sqlQueryExpression;
            boolean bl = false;
            boolean bl2 = false;
            SqlQueryExpression it2 = sqlQueryExpression2;
            boolean bl3 = false;
            n = this.buildOptimizedCountQuery(builder, it2, queryText);
        } else {
            n = offset = null;
        }
        if (queryExpression == null || offset == null) {
            builder.keyword("SELECT").space();
            this.appendColumns(builder, task.getTable(), task.getColumns());
            builder.space().keyword("FROM").space().symbol("(");
            int currentHeadLength = builder.length();
            String string2 = task.getAlias();
            if (string2 == null) {
                string2 = "t";
            }
            offset = currentHeadLength + ((Number)this.appendWrappedQueryTail(builder, e, queryText, string2).getSecond()).intValue();
        }
        return new DmlGenerator.Companion.WrapQueryResult(builder, offset);
    }

    private final Integer buildOptimizedCountQuery(DdlBuilder builder, SqlQueryExpression query, String queryText) {
        SqlSelectClause sqlSelectClause = query.getSelectClause();
        if (sqlSelectClause == null) {
            return null;
        }
        SqlSelectClause selectClause = sqlSelectClause;
        Iterator iterator = selectClause.getOptions().iterator();
        while (iterator.hasNext()) {
            SqlSelectOption option;
            SqlSelectOption sqlSelectOption = option = (SqlSelectOption)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlSelectOption, (String)"option");
            if (!StringUtil.startsWithIgnoreCase((String)sqlSelectOption.getOptionName(), (String)"DISTINCT") && option.getClause() == null) continue;
            return null;
        }
        SqlTableExpression tableExp = query.getTableExpression();
        if (tableExp == null || tableExp.getHavingClause() != null || tableExp.getGroupByClause() != null) {
            return null;
        }
        List list = selectClause.getExpressions();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"selectClause.expressions");
        List expressions2 = list;
        for (SqlExpression e : expressions2) {
            JBIterable jBIterable = ((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)e)).preOrderDfsTraversal().filter(SqlFunctionCallExpression.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"SyntaxTraverser.psiTrave\u2026llExpression::class.java)");
            if (jBIterable.isEmpty()) continue;
            return null;
        }
        SqlExpression firstExpression = (SqlExpression)ContainerUtil.getFirstItem((List)expressions2);
        SqlExpression lastExpression = (SqlExpression)ContainerUtil.getLastItem((List)expressions2);
        if (firstExpression == null || lastExpression == null) {
            return null;
        }
        TextRange textRange = firstExpression.getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"firstExpression.textRange");
        int expressionsStartOffset = textRange.getStartOffset();
        TextRange textRange2 = lastExpression.getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"lastExpression.textRange");
        int expressionsEndOffset = textRange2.getEndOffset();
        String string = queryText;
        int n = 0;
        DdlBuilder ddlBuilder = builder.clear();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, expressionsStartOffset);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string4 = string3;
        string = queryText;
        ddlBuilder = ddlBuilder.plain(string4).keyword("COUNT").symbol("(").symbol("*").symbol(")");
        n = 0;
        String string5 = string;
        if (string5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.substring(expressionsEndOffset);
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
        string4 = string6;
        ddlBuilder.plain(string4);
        return builder.length() - queryText.length();
    }

    private final String removeOrderByClause(Project project, String query, SqlLanguageDialect dialect) {
        SqlResultSetExpression sqlResultSetExpression = DbSqlUtil.parseQuery(project, dialect, query, null);
        if (sqlResultSetExpression == null) {
            return query;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlResultSetExpression, (String)"DbSqlUtil.parseQuery(pro\u2026ry, null) ?: return query");
        SqlResultSetExpression e = sqlResultSetExpression;
        SqlQueryExpression queryExpression = this.findQuery(e);
        SqlOrderByClause sqlOrderByClause = (SqlOrderByClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)queryExpression), SqlOrderByClause.class);
        if (sqlOrderByClause == null) {
            return query;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlOrderByClause, (String)"PsiTreeUtil.getChildOfTy\u2026ass.java) ?: return query");
        SqlOrderByClause clause = sqlOrderByClause;
        StringBuilder stringBuilder = new StringBuilder();
        String string = query;
        int n = 0;
        TextRange textRange = clause.getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"clause.textRange");
        int n2 = textRange.getStartOffset();
        StringBuilder stringBuilder2 = stringBuilder;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string4 = string3;
        StringBuilder stringBuilder3 = stringBuilder2.append(string4);
        string = query;
        TextRange textRange2 = clause.getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"clause.textRange");
        n = textRange2.getEndOffset();
        stringBuilder2 = stringBuilder3;
        n2 = 0;
        String string5 = string;
        if (string5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
        string4 = string6;
        String queryText = stringBuilder2.append(string4).toString();
        String string7 = StringUtil.trimEnd((String)queryText, (String)" ");
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"StringUtil.trimEnd(queryText, \" \")");
        return string7;
    }

    private final SqlQueryExpression findQuery(SqlResultSetExpression e) {
        SqlQueryExpression sqlQueryExpression;
        SqlResultSetExpression sqlResultSetExpression = e;
        if (sqlResultSetExpression instanceof SqlWithQueryExpression) {
            SqlExpression sqlExpression = ((SqlWithQueryExpression)e).getExpression();
            if (!(sqlExpression instanceof SqlQueryExpression)) {
                sqlExpression = null;
            }
            sqlQueryExpression = (SqlQueryExpression)sqlExpression;
        } else {
            sqlQueryExpression = sqlResultSetExpression instanceof SqlQueryExpression ? (SqlQueryExpression)e : null;
        }
        return sqlQueryExpression;
    }

    private final DdlBuilder space(@NotNull DdlBuilder $this$space, boolean insertNewLines) {
        DdlBuilder ddlBuilder;
        if (insertNewLines) {
            DdlBuilder ddlBuilder2 = $this$space.newLine();
            ddlBuilder = ddlBuilder2;
            Intrinsics.checkExpressionValueIsNotNull((Object)ddlBuilder2, (String)"this.newLine()");
        } else {
            DdlBuilder ddlBuilder3 = $this$space.space();
            ddlBuilder = ddlBuilder3;
            Intrinsics.checkExpressionValueIsNotNull((Object)ddlBuilder3, (String)"this.space()");
        }
        return ddlBuilder;
    }

    private final Pair<DdlBuilder, Integer> appendWrappedQueryTail(DdlBuilder head, SqlResultSetExpression e, String query, String alias) {
        DatabaseDialectEx databaseDialectEx = head.getDialect();
        Intrinsics.checkExpressionValueIsNotNull((Object)databaseDialectEx, (String)"head.dialect");
        Dbms dbms = databaseDialectEx.getDbms();
        Intrinsics.checkExpressionValueIsNotNull((Object)dbms, (String)"head.dialect.dbms");
        boolean needSelectTargetAliases = dbms.isMicrosoft();
        int placeholdersOffset = 0;
        if (needSelectTargetAliases) {
            String string;
            DdlBuilder ddlBuilder;
            TIntArrayList endOffsets = new TIntArrayList();
            Iterator iterator = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)e)).filter(SqlSelectClause.class).iterator();
            while (iterator.hasNext()) {
                SqlSelectClause selectClause;
                SqlSelectClause sqlSelectClause = selectClause = (SqlSelectClause)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)sqlSelectClause, (String)"selectClause");
                for (SqlExpression expression : sqlSelectClause.getExpressions()) {
                    if (expression instanceof SqlAsExpression || expression instanceof SqlReferenceExpression) continue;
                    SqlExpression sqlExpression = expression;
                    Intrinsics.checkExpressionValueIsNotNull((Object)sqlExpression, (String)"expression");
                    TextRange textRange = sqlExpression.getTextRange();
                    Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"expression.textRange");
                    endOffsets.add(textRange.getEndOffset());
                }
            }
            endOffsets.sort();
            int prevIdx = 0;
            int count2 = 0;
            int len = endOffsets.size();
            for (int i2 = 0; i2 < len; ++i2) {
                int offset = endOffsets.get(i2);
                String string2 = query;
                ddlBuilder = head;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string3.substring(prevIdx, offset), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                ddlBuilder.plain(string);
                String name2 = "_" + ++count2;
                placeholdersOffset += name2.length();
                head.space().columnRef(name2);
                prevIdx = offset;
            }
            String string4 = e.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"e.text");
            String string5 = string4;
            ddlBuilder = head;
            boolean bl = false;
            String string6 = string5;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.substring(prevIdx);
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
            string = string7;
            ddlBuilder.plain(string);
        } else {
            head.plain(query);
        }
        return new Pair((Object)head.symbol(")").space().alias(alias), (Object)placeholdersOffset);
    }

    @NotNull
    protected DdlBuilder appendLimit(@NotNull DdlBuilder builder, @NotNull DatabaseDialectEx dialect, @Nullable DasDataSource system, int limit, int offset, boolean atBeginning) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)dialect, (String)"dialect");
        DdlBuilder b2 = builder;
        if (!DbImplUtil.isPageSizeUnlimited(limit)) {
            b2 = this.appendNumericProperty(builder, "LIMIT", limit);
        }
        if (offset != 0 && dialect.supportsOffset()) {
            b2 = this.appendNumericProperty(builder, "OFFSET", offset);
        }
        return b2;
    }

    @NotNull
    protected final DdlBuilder top(@NotNull DdlBuilder builder, @NotNull String topWord, int limit) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)topWord, (String)"topWord");
        DdlBuilder ddlBuilder = builder.keyword(topWord).space().literal(String.valueOf(limit)).space();
        Intrinsics.checkExpressionValueIsNotNull((Object)ddlBuilder, (String)"builder.keyword(topWord)\u2026limit.toString()).space()");
        return ddlBuilder;
    }

    @NotNull
    protected final DdlBuilder appendNumericProperty(@NotNull DdlBuilder builder, @NotNull String property, int value) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        DdlBuilder ddlBuilder = builder.newLine().keyword(property).space().literal(String.valueOf(value));
        Intrinsics.checkExpressionValueIsNotNull((Object)ddlBuilder, (String)"builder.newLine().keywor\u2026literal(value.toString())");
        return ddlBuilder;
    }

    @NotNull
    protected final DdlBuilder fetchFirst(@NotNull DdlBuilder builder, int rows) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        DdlBuilder ddlBuilder = builder.newLine().keywords("FETCH", "FIRST").space().literal(String.valueOf(rows)).space().keywords("ROWS", "ONLY");
        Intrinsics.checkExpressionValueIsNotNull((Object)ddlBuilder, (String)"builder.newLine().keywor\u2026.keywords(\"ROWS\", \"ONLY\")");
        return ddlBuilder;
    }

    @NotNull
    protected final DdlBuilder rowNumLimit(@NotNull DdlBuilder builder, int rows, boolean atBeginning) {
        DdlBuilder ddlBuilder;
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        if (atBeginning) {
            DdlBuilder ddlBuilder2 = builder.keyword("SELECT").space().symbol("*").space().keyword("FROM").space().symbol("(").indent("    ").newLine();
            ddlBuilder = ddlBuilder2;
            Intrinsics.checkExpressionValueIsNotNull((Object)ddlBuilder2, (String)"builder.keyword(\"SELECT\"\u2026.indent(\"    \").newLine()");
        } else {
            DdlBuilder ddlBuilder3 = builder.indent(null).newLine().symbol(")").space().keyword("WHERE").space().keyword("ROWNUM").space().symbol("<=").space().literal(String.valueOf(rows));
            ddlBuilder = ddlBuilder3;
            Intrinsics.checkExpressionValueIsNotNull((Object)ddlBuilder3, (String)"builder.indent(null).new\u2026.literal(rows.toString())");
        }
        return ddlBuilder;
    }

    @NotNull
    public final Dbms getDbms() {
        return this.dbms;
    }

    public BaseDmlGenerator(@NotNull Dbms dbms) {
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        this.dbms = dbms;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/dialects/base/BaseDmlGenerator$Companion;", "", "()V", "LimitPlace", "intellij.database.dialects.base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JH\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00002\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dialects/base/BaseDmlGenerator$Companion$LimitPlace;", "", "(Ljava/lang/String;I)V", "appendLimit", "Lcom/intellij/database/util/DdlBuilder;", "builder", "generator", "Lcom/intellij/database/dialects/base/BaseDmlGenerator;", "dialect", "Lcom/intellij/database/dialects/DatabaseDialectEx;", "place", "system", "Lcom/intellij/database/model/DasDataSource;", "limit", "", "offset", "atBeginning", "", "BEGIN", "END", "BOTH", "intellij.database.dialects.base"})
        public static final class LimitPlace
        extends Enum<LimitPlace> {
            public static final /* enum */ LimitPlace BEGIN;
            public static final /* enum */ LimitPlace END;
            public static final /* enum */ LimitPlace BOTH;
            private static final /* synthetic */ LimitPlace[] $VALUES;

            static {
                LimitPlace[] limitPlaceArray = new LimitPlace[3];
                LimitPlace[] limitPlaceArray2 = limitPlaceArray;
                limitPlaceArray[0] = BEGIN = new LimitPlace();
                limitPlaceArray[1] = END = new LimitPlace();
                limitPlaceArray[2] = BOTH = new LimitPlace();
                $VALUES = limitPlaceArray;
            }

            @NotNull
            public final DdlBuilder appendLimit(@NotNull DdlBuilder builder, @NotNull BaseDmlGenerator generator, @NotNull DatabaseDialectEx dialect, @NotNull LimitPlace place, @Nullable DasDataSource system, int limit, int offset, boolean atBeginning) {
                Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
                Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
                Intrinsics.checkParameterIsNotNull((Object)dialect, (String)"dialect");
                Intrinsics.checkParameterIsNotNull((Object)((Object)place), (String)"place");
                return place == this ? generator.appendLimit(builder, dialect, system, limit, offset, atBeginning) : builder;
            }

            public static LimitPlace[] values() {
                return (LimitPlace[])$VALUES.clone();
            }

            public static LimitPlace valueOf(String string) {
                return Enum.valueOf(LimitPlace.class, string);
            }
        }
    }
}

