/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.introspector;

import com.google.common.collect.ImmutableSet;
import com.intellij.database.dialects.mssql.generator.MsNamingService;
import com.intellij.database.dialects.mssql.model.MsCustomType;
import com.intellij.database.dialects.mssql.model.MsKey;
import com.intellij.database.dialects.mssql.model.MsSchemaObject;
import com.intellij.database.dialects.mssql.model.MsTable;
import com.intellij.database.dialects.mssql.model.MsTableType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.basic.BasicColumniation;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.DataTypeFactory;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u0088\u0001\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0012\u0010\u0013\u001a\u00020\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000bH\u0002\u001a\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0001H\u0002\u001a*\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0001H\u0002\u001a7\u0010\u001f\u001a\u0002H \"\b\b\u0000\u0010 *\u00020!2\u000e\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u0002H 0#2\u0006\u0010$\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010%\u001a\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010\u000e\u001a\u00020\u0001H\u0002\u001a\u001c\u0010)\u001a\u0004\u0018\u00010**\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000b0-H\u0002\u001a \u0010.\u001a\u00020/*\u0002002\b\u00101\u001a\u0004\u0018\u0001022\b\u00103\u001a\u0004\u0018\u000102H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"2\u0010\t\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u000b0\u000b \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"ALIAS_TYPE_KIND", "", "FULLTEXT_INDEX_POSITION", "", "MUFFLED_WORDS", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "SURROGATE_NAME_PATTERN", "TABLE_TYPE_KIND", "VARIABLE_TYPES", "Lcom/google/common/collect/ImmutableSet;", "", "canCheckOutdated", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "catalogPrefix", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "detectSurrogateName", "name", "makeCascadeRule", "Lcom/intellij/database/model/properties/CascadeRule;", "code", "makeDataType", "Lcom/intellij/database/model/DataType;", "type_name", "max_length", "", "precision", "scale", "renewType", "T", "Lcom/intellij/database/dialects/mssql/model/MsCustomType;", "family", "Lcom/intellij/database/model/families/ModNamingFamily;", "typeId", "(Lcom/intellij/database/model/families/ModNamingFamily;ILjava/lang/String;)Lcom/intellij/database/dialects/mssql/model/MsCustomType;", "unpackEvents", "", "Lcom/intellij/database/model/TrigEvent;", "findKeyByColumns", "Lcom/intellij/database/dialects/mssql/model/MsKey;", "Lcom/intellij/database/dialects/mssql/model/MsTable;", "names", "", "setCreatedAndModifiedTimestamps", "", "Lcom/intellij/database/dialects/mssql/model/MsSchemaObject;", "createdTimestamp", "Ljava/util/Date;", "modifiedTimestamp", "intellij.database.dialects.mssql"})
public final class MsIntrospectorKt {
    private static final Pattern MUFFLED_WORDS = Pattern.compile("\\(\\d+(\\.\\d+)?\\)", 2);
    private static final byte ALIAS_TYPE_KIND = 1;
    private static final byte TABLE_TYPE_KIND = 2;
    private static final Pattern SURROGATE_NAME_PATTERN = Pattern.compile("^\\s*\\w{2}\\S{2,18}__[\\dA-F]{8,16}\\s*$", 2);
    private static final ImmutableSet<String> VARIABLE_TYPES = ImmutableSet.of((Object)"decimal", (Object)"numeric", (Object)"varbinary", (Object)"varchar", (Object)"binary", (Object)"char", (Object[])new String[]{"nvarchar", "nchar", "time", "datetime2", "datetimeoffset"});
    private static final short FULLTEXT_INDEX_POSITION = Short.MAX_VALUE;

    private static final <T extends MsCustomType> T renewType(ModNamingFamily<? extends T> family, int typeId, String name2) {
        MsCustomType type = null;
        type = (MsCustomType)family.find(new Predicate<T>(typeId){
            final /* synthetic */ int $typeId;

            public final boolean test(T it2) {
                T t = it2;
                Intrinsics.checkExpressionValueIsNotNull(t, (String)"it");
                return t.getTypeId() == this.$typeId;
            }
            {
                this.$typeId = n;
            }
        });
        if (type != null) {
            type.setName(name2);
            type.resetSyncPending();
            return (T)type;
        }
        type = (MsCustomType)family.get(name2);
        if (type != null && type.getTypeId() == 0) {
            type.setTypeId(typeId);
            type.resetSyncPending();
            return (T)type;
        }
        type = (MsCustomType)family.createNewOne();
        type.setTypeId(typeId);
        type.setName(name2);
        return (T)type;
    }

    private static final MsKey findKeyByColumns(@NotNull MsTable $this$findKeyByColumns, List<String> names) {
        Object v1;
        block1: {
            Family family = $this$findKeyByColumns.getKeys();
            Intrinsics.checkExpressionValueIsNotNull((Object)family, (String)"this.keys");
            Iterable $this$firstOrNull$iv = family;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                MsKey it2 = (MsKey)element$iv;
                boolean bl = false;
                if (!BasicColumniation.areColNames(it2, names)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private static final Set<TrigEvent> unpackEvents(byte e) {
        byte $this$and$iv;
        EnumSet<TrigEvent> events = EnumSet.noneOf(TrigEvent.class);
        byte by = e;
        byte that$iv = 1;
        boolean $i$f$and = false;
        byte $this$toUnsignedInt$iv$iv = $this$and$iv;
        boolean $i$f$toUnsignedInt = false;
        int n = Byte.toUnsignedInt($this$toUnsignedInt$iv$iv);
        $this$toUnsignedInt$iv$iv = that$iv;
        int n2 = n;
        $i$f$toUnsignedInt = false;
        int n3 = Byte.toUnsignedInt($this$toUnsignedInt$iv$iv);
        if ((byte)(n2 & n3) != 0) {
            events.add(TrigEvent.INSERT);
        }
        $this$and$iv = e;
        that$iv = 2;
        $i$f$and = false;
        $this$toUnsignedInt$iv$iv = $this$and$iv;
        $i$f$toUnsignedInt = false;
        int n4 = Byte.toUnsignedInt($this$toUnsignedInt$iv$iv);
        $this$toUnsignedInt$iv$iv = that$iv;
        n2 = n4;
        $i$f$toUnsignedInt = false;
        n3 = Byte.toUnsignedInt($this$toUnsignedInt$iv$iv);
        if ((byte)(n2 & n3) != 0) {
            events.add(TrigEvent.UPDATE);
        }
        $this$and$iv = e;
        that$iv = 4;
        $i$f$and = false;
        $this$toUnsignedInt$iv$iv = $this$and$iv;
        $i$f$toUnsignedInt = false;
        int n5 = Byte.toUnsignedInt($this$toUnsignedInt$iv$iv);
        $this$toUnsignedInt$iv$iv = that$iv;
        n2 = n5;
        $i$f$toUnsignedInt = false;
        n3 = Byte.toUnsignedInt($this$toUnsignedInt$iv$iv);
        if ((byte)(n2 & n3) != 0) {
            events.add(TrigEvent.DELETE);
        }
        EnumSet<TrigEvent> enumSet = events;
        Intrinsics.checkExpressionValueIsNotNull(enumSet, (String)"events");
        return enumSet;
    }

    private static final void setCreatedAndModifiedTimestamps(@NotNull MsSchemaObject $this$setCreatedAndModifiedTimestamps, Date createdTimestamp, Date modifiedTimestamp) {
        $this$setCreatedAndModifiedTimestamps.setCreatedTimestamp(createdTimestamp);
        $this$setCreatedAndModifiedTimestamps.setModifiedTimestamp(modifiedTimestamp);
    }

    private static final String catalogPrefix(BasicDatabase database) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = database.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"database.name");
        return stringBuilder.append(MsNamingService.INSTANCE.nameToScript(string, false)).append(".sys").toString();
    }

    private static final boolean detectSurrogateName(String name2) {
        if (name2 == null) {
            return false;
        }
        return SURROGATE_NAME_PATTERN.matcher(name2).matches();
    }

    private static final DataType makeDataType(String type_name, int max_length, int precision, byte scale) {
        DataType dt = null;
        if (type_name != null) {
            if (VARIABLE_TYPES.contains((Object)type_name)) {
                if (Intrinsics.areEqual((Object)type_name, (Object)"time") || Intrinsics.areEqual((Object)type_name, (Object)"datetime2") || Intrinsics.areEqual((Object)type_name, (Object)"datetimeoffset")) {
                    int size = scale >= 0 && scale <= 6 ? (int)scale : -1;
                    LengthUnit units = size >= 0 ? LengthUnit.DIGIT : null;
                    DataType dataType = DataTypeFactory.of(null, type_name, size, 0, units, null, false, false);
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataTypeFactory.of(null,\u2026nits, null, false, false)");
                    dt = dataType;
                } else if (precision > 0) {
                    DataType dataType = DataTypeFactory.of(null, type_name, precision, scale, null, null, false, false);
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataTypeFactory.of(null,\u2026null, null, false, false)");
                    dt = dataType;
                } else if (Intrinsics.areEqual((Object)type_name, (Object)"char") || Intrinsics.areEqual((Object)type_name, (Object)"nchar") || Intrinsics.areEqual((Object)type_name, (Object)"varchar") || Intrinsics.areEqual((Object)type_name, (Object)"nvarchar") || Intrinsics.areEqual((Object)type_name, (Object)"varbinary")) {
                    boolean national;
                    boolean bl = national = type_name.charAt(0) == 'n';
                    int length = max_length == -1 ? Integer.MAX_VALUE : (national ? max_length >> 1 : max_length);
                    DataType dataType = DataTypeFactory.of(null, type_name, length, 0, LengthUnit.CHAR, null, false, false);
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataTypeFactory.of(null,\u2026CHAR, null, false, false)");
                    dt = dataType;
                } else if (max_length > 0) {
                    DataType dataType = DataTypeFactory.of(null, type_name, max_length, scale, null, null, false, false);
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataTypeFactory.of(null,\u2026null, null, false, false)");
                    dt = dataType;
                } else {
                    DataType dataType = DataTypeFactory.of(type_name);
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataTypeFactory.of(type_name)");
                    dt = dataType;
                }
            } else {
                DataType dataType = DataTypeFactory.of(type_name);
                Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataTypeFactory.of(type_name)");
                dt = dataType;
            }
        } else {
            DataType dataType = DataType.UNKNOWN;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataType.UNKNOWN");
            dt = dataType;
        }
        return dt;
    }

    private static final CascadeRule makeCascadeRule(byte code) {
        CascadeRule cascadeRule;
        switch (code) {
            case 1: {
                cascadeRule = CascadeRule.cascade;
                break;
            }
            case 2: {
                cascadeRule = CascadeRule.set_null;
                break;
            }
            case 3: {
                cascadeRule = CascadeRule.set_default;
                break;
            }
            default: {
                cascadeRule = CascadeRule.no_action;
            }
        }
        return cascadeRule;
    }

    private static final boolean canCheckOutdated(BasicElement e) {
        return e == null || e instanceof MsSchemaObject && !(e instanceof MsTableType) && ((MsSchemaObject)e).getModifiedTimestamp() != null;
    }

    static {
        FULLTEXT_INDEX_POSITION = Short.MAX_VALUE;
    }

    public static final /* synthetic */ boolean access$canCheckOutdated(BasicElement e) {
        return MsIntrospectorKt.canCheckOutdated(e);
    }

    public static final /* synthetic */ MsCustomType access$renewType(ModNamingFamily family, int typeId, String name2) {
        return MsIntrospectorKt.renewType(family, typeId, name2);
    }

    public static final /* synthetic */ DataType access$makeDataType(String type_name, int max_length, int precision, byte scale) {
        return MsIntrospectorKt.makeDataType(type_name, max_length, precision, scale);
    }

    public static final /* synthetic */ void access$setCreatedAndModifiedTimestamps(MsSchemaObject $this$access_u24setCreatedAndModifiedTimestamps, Date createdTimestamp, Date modifiedTimestamp) {
        MsIntrospectorKt.setCreatedAndModifiedTimestamps($this$access_u24setCreatedAndModifiedTimestamps, createdTimestamp, modifiedTimestamp);
    }

    public static final /* synthetic */ boolean access$detectSurrogateName(String name2) {
        return MsIntrospectorKt.detectSurrogateName(name2);
    }

    public static final /* synthetic */ short access$getFULLTEXT_INDEX_POSITION$p() {
        return FULLTEXT_INDEX_POSITION;
    }

    public static final /* synthetic */ CascadeRule access$makeCascadeRule(byte code) {
        return MsIntrospectorKt.makeCascadeRule(code);
    }

    public static final /* synthetic */ MsKey access$findKeyByColumns(MsTable $this$access_u24findKeyByColumns, List names) {
        return MsIntrospectorKt.findKeyByColumns($this$access_u24findKeyByColumns, names);
    }

    public static final /* synthetic */ Set access$unpackEvents(byte e) {
        return MsIntrospectorKt.unpackEvents(e);
    }

    public static final /* synthetic */ String access$catalogPrefix(BasicDatabase database) {
        return MsIntrospectorKt.catalogPrefix(database);
    }
}

