/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysql;

import com.intellij.database.DatabaseMessages;
import com.intellij.database.dialects.mysqlbase.MysqlBaseErrorHandler;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class MysqlErrorHandler
extends MysqlBaseErrorHandler {
    private static final Pattern UNRECOGNIZED_TIME_ZONE = Pattern.compile("The server time zone value '.*' is unrecognized");

    @Override
    @NotNull
    public String getErrorMessage(@NotNull String dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
        String message2;
        if (dataSource == null) {
            MysqlErrorHandler.$$$reportNull$$$0(0);
        }
        if (original == null) {
            MysqlErrorHandler.$$$reportNull$$$0(1);
        }
        if (cause == null) {
            MysqlErrorHandler.$$$reportNull$$$0(2);
        }
        if ((message2 = cause.getMessage()) == null || !UNRECOGNIZED_TIME_ZONE.matcher(message2).find()) {
            String string = super.getErrorMessage(dataSource, original, cause);
            if (string == null) {
                MysqlErrorHandler.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = DatabaseMessages.message((String)"error.message.mysql.invalid.timezone", (Object[])new Object[0]);
        if (string == null) {
            MysqlErrorHandler.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mysql/MysqlErrorHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mysql/MysqlErrorHandler";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

