/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysqlbase;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.OperandType;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.data.types.PredicatesUtilKt;
import com.intellij.database.data.types.domain.LikeOpType;
import com.intellij.database.data.types.domain.OperationKt;
import com.intellij.database.dialects.mysqlbase.MysqlBasePredicatesHelper$WhenMappings;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseIndex;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseLikeColumn;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseLikeTable;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.families.Family;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.TypeNameColumnDescriptor;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J>\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u001e\u0010\u001a\u001a\u00020\r2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u001c\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0002JD\u0010!\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00130\u001c2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002Jg\u0010#\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u001c0$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001c2\u0010\u0010&\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110'2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00130\u001c2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016\u00a2\u0006\u0002\u0010(J>\u0010)\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J>\u0010+\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u001a\u0010,\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/database/dialects/mysqlbase/MysqlBasePredicatesHelper;", "Lcom/intellij/database/data/types/PredicatesHelper;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "getDbms", "()Lcom/intellij/database/Dbms;", "formatTypes", "", "Lcom/intellij/database/data/types/LogicalType;", "geometryTypes", "", "equalsOrLike", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "column", "Lcom/intellij/database/model/DasColumn;", "value", "", "type", "Lcom/intellij/database/data/types/OperandType;", "likeType", "Lcom/intellij/database/data/types/domain/LikeOpType;", "matchCase", "", "version", "Lcom/intellij/database/util/Version;", "ftsPredicate", "ftsGroup", "", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseLikeColumn;", "getFtsGroups", "table", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseLikeTable;", "getPredicateProducer", "types", "getPredicateProducers", "", "columns", "values", "", "(Ljava/util/List;[Ljava/lang/Object;Ljava/util/List;Lcom/intellij/database/data/types/domain/LikeOpType;ZLcom/intellij/database/util/Version;)Ljava/util/Map;", "likePredicate", "canCastToText", "otherPredicate", "shouldCastToChar", "intellij.database.dialects.mysqlbase"})
public class MysqlBasePredicatesHelper
implements PredicatesHelper {
    private final Set<String> geometryTypes;
    private final Set<LogicalType> formatTypes;
    @NotNull
    private final Dbms dbms;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<DasColumn, List<PredicatesHelper.PredicateProducer>> getPredicateProducers(@NotNull List<? extends DasColumn> columns, @NotNull Object[] values2, @NotNull List<? extends OperandType> types, @NotNull LikeOpType likeType, boolean matchCase, @Nullable Version version) {
        DasColumn c2;
        Intrinsics.checkParameterIsNotNull(columns, (String)"columns");
        Intrinsics.checkParameterIsNotNull((Object)values2, (String)"values");
        Intrinsics.checkParameterIsNotNull(types, (String)"types");
        Intrinsics.checkParameterIsNotNull((Object)((Object)likeType), (String)"likeType");
        if (columns.isEmpty()) {
            return MapsKt.emptyMap();
        }
        boolean bl = false;
        Map colsToValue = new LinkedHashMap();
        Iterable $this$forEachIndexed$iv = columns;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void c3;
            int n = index$iv++;
            boolean bl2 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            DasColumn dasColumn = (DasColumn)item$iv;
            int i2 = n2;
            boolean bl3 = false;
            colsToValue.put(c3, values2[i2]);
        }
        Object object = DbImplUtil.unwrap((DasObject)((DasColumn)CollectionsKt.first(columns)).getTable());
        if (!(object instanceof MysqlBaseLikeTable)) {
            object = null;
        }
        MysqlBaseLikeTable mysqlBaseLikeTable = (MysqlBaseLikeTable)object;
        if (mysqlBaseLikeTable == null) {
            return MapsKt.emptyMap();
        }
        MysqlBaseLikeTable table = mysqlBaseLikeTable;
        List<List<MysqlBaseLikeColumn>> ftsGroups = this.getFtsGroups(table);
        boolean bl4 = false;
        Map predicates = new LinkedHashMap();
        for (List list : ftsGroups) {
            String value;
            boolean bl2;
            block16: {
                Collection collection = list;
                boolean bl6 = false;
                if (!(!collection.isEmpty())) continue;
                Iterable $this$all$iv = list;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        MysqlBaseLikeColumn it2 = (MysqlBaseLikeColumn)element$iv;
                        boolean bl7 = false;
                        if (colsToValue.containsKey(it2)) continue;
                        bl2 = false;
                        break block16;
                    }
                    bl2 = true;
                }
            }
            if (!bl2) continue;
            Object v2 = colsToValue.get(CollectionsKt.first((List)list));
            if (!(v2 instanceof String)) {
                v2 = null;
            }
            if ((String)v2 == null) {
                continue;
            }
            PredicatesHelper.PredicateProducer predicate = this.ftsPredicate(list, value);
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object2;
                c2 = (MysqlBaseLikeColumn)element$iv;
                boolean bl8 = false;
                Map $this$getOrPut$iv = predicates;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(c2);
                if (value$iv == null) {
                    boolean bl9 = false;
                    boolean bl10 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(c2, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                ((List)object2).add(predicate);
            }
        }
        Iterable iterable = columns;
        boolean $i$f$forEachIndexed2 = false;
        int index$iv2 = 0;
        for (Object item$iv : iterable) {
            PredicatesHelper.PredicateProducer predicate;
            void c3;
            int n = index$iv2++;
            boolean bl11 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n3 = n;
            c2 = (DasColumn)item$iv;
            int i3 = n3;
            boolean bl12 = false;
            if (predicates.containsKey(c3) || (predicate = this.getPredicateProducer((DasColumn)c3, values2[i3], types, likeType, matchCase, version)) == null) continue;
            predicates.put(c3, CollectionsKt.mutableListOf((Object[])new PredicatesHelper.PredicateProducer[]{predicate}));
        }
        return predicates;
    }

    private final PredicatesHelper.PredicateProducer getPredicateProducer(DasColumn column2, Object value, List<? extends OperandType> types, LikeOpType likeType, boolean matchCase, Version version) {
        for (OperandType operandType : types) {
            PredicatesHelper.PredicateProducer predicate;
            PredicatesHelper.PredicateProducer predicateProducer;
            switch (MysqlBasePredicatesHelper$WhenMappings.$EnumSwitchMapping$0[operandType.ordinal()]) {
                case 1: {
                    predicateProducer = null;
                    break;
                }
                case 2: {
                    predicateProducer = PredicatesUtilKt.defaultEqualsPredicate(column2, value, operandType, this.dbms, version);
                    break;
                }
                case 3: {
                    if (PredicatesUtilKt.getRequiredFormat(column2, this.dbms, version, this.formatTypes) != null) {
                        predicateProducer = null;
                        break;
                    }
                    predicateProducer = this.equalsOrLike(column2, value, operandType, likeType, matchCase, version);
                    break;
                }
                case 4: {
                    predicateProducer = this.otherPredicate(column2, value, operandType, likeType, matchCase, version);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            if ((predicate = predicateProducer) == null) continue;
            return predicate;
        }
        return null;
    }

    private final PredicatesHelper.PredicateProducer equalsOrLike(DasColumn column2, Object value, OperandType type, LikeOpType likeType, boolean matchCase, Version version) {
        PredicatesHelper.PredicateProducer predicateProducer;
        if (likeType == LikeOpType.MATCHES) {
            predicateProducer = PredicatesUtilKt.defaultEqualsPredicate(column2, value, type, this.dbms, version);
            if (predicateProducer == null) {
                predicateProducer = this.likePredicate(column2, value, likeType, matchCase, type != OperandType.TEXT, version);
            }
        } else {
            predicateProducer = this.likePredicate(column2, value, likeType, matchCase, type != OperandType.TEXT, version);
            if (predicateProducer == null) {
                predicateProducer = PredicatesUtilKt.defaultEqualsPredicate(column2, value, type, this.dbms, version);
            }
        }
        return predicateProducer;
    }

    private final PredicatesHelper.PredicateProducer otherPredicate(DasColumn column2, Object value, OperandType type, LikeOpType likeType, boolean matchCase, Version version) {
        Formatter format;
        if (value instanceof String && (format = PredicatesUtilKt.getRequiredFormat(column2, this.dbms, version, this.formatTypes)) != null) {
            try {
                if (format.parse((String)value) != null) {
                    return PredicatesUtilKt.defaultEqualsPredicate(column2, value, type, this.dbms, version);
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return this.likePredicate(column2, value, likeType, matchCase, type != OperandType.TEXT, version);
        }
        return this.equalsOrLike(column2, value, type, likeType, matchCase, version);
    }

    private final PredicatesHelper.PredicateProducer ftsPredicate(List<? extends MysqlBaseLikeColumn> ftsGroup, String value) {
        String query = "AGAINST (" + DbImplUtil.StringLiteralDecorator.MATCHES.decorate(value, this.dbms) + " IN NATURAL LANGUAGE MODE)";
        return new PredicatesHelper.PredicateProducer(ftsGroup, query){
            final /* synthetic */ List $ftsGroup;
            final /* synthetic */ String $query;

            public final void produce(@NotNull DdlBuilder builder) {
                Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
                builder.keyword("MATCH").space().symbol("(");
                boolean first2 = true;
                for (MysqlBaseLikeColumn column2 : this.$ftsGroup) {
                    if (first2) {
                        first2 = false;
                    } else {
                        Intrinsics.checkExpressionValueIsNotNull((Object)builder.symbol(",").space(), (String)"builder.symbol(\",\").space()");
                    }
                    builder.identifier(column2);
                }
                builder.symbol(")").space().plain(this.$query);
            }
            {
                this.$ftsGroup = list;
                this.$query = string;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final List<List<MysqlBaseLikeColumn>> getFtsGroups(MysqlBaseLikeTable table) {
        void $this$mapTo$iv$iv;
        MysqlBaseIndex it2;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Family family = table.getIndices();
        Intrinsics.checkExpressionValueIsNotNull((Object)family, (String)"table.indices");
        Iterable $this$filterIsInstance$iv = family;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof MysqlBaseIndex)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it2 = (MysqlBaseIndex)element$iv$iv;
            boolean bl = false;
            if (!StringUtil.equalsIgnoreCase((CharSequence)it2.getType(), (CharSequence)"fulltext")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$filterIsInstanceTo$iv$iv2;
            it2 = (MysqlBaseIndex)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            List<? extends BasicLikeColumn> list = it2.getCols();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"it.cols");
            Iterable $this$filterIsInstance$iv2 = list;
            boolean $i$f$filterIsInstance2 = false;
            Iterable iterable2 = $this$filterIsInstance$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo2 = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
                if (!(element$iv$iv instanceof MysqlBaseLikeColumn)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List list2 = (List)destination$iv$iv2;
            collection.add(list2);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Unable to fully structure code
     */
    private final PredicatesHelper.PredicateProducer likePredicate(DasColumn column, Object value, LikeOpType likeType, boolean matchCase, boolean canCastToText, Version version) {
        if (!(value instanceof String)) {
            return null;
        }
        v0 = typeSupportsOperation = PredicatesUtilKt.supportsOperation(OperationKt.LIKE_OPERATION, column, this.dbms, version) != false && PredicatesUtilKt.supportsOperation(OperationKt.EQUALS_TO_NUMBER_OPERATION, column, this.dbms, version) == false;
        if (!typeSupportsOperation && !canCastToText) {
            return null;
        }
        if (typeSupportsOperation) ** GOTO lbl-1000
        v1 = DomainRegistry.getDomain(this.dbms, version, new TypeNameColumnDescriptor(column.getDataType().typeName), true);
        if (v1 != null && (v1 = v1.simpleName()) != null) {
            var9_8 = v1;
            var10_10 = false;
            var11_12 = false;
            it = var9_8;
            $i$a$-let-MysqlBasePredicatesHelper$likePredicate$isGeometry$1 = false;
            v2 = this.geometryTypes.contains(it);
        } else {
            v2 = false;
        }
        if (v2) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = false;
        }
        isGeometry = v3;
        shouldCastToChar = isGeometry == false && this.shouldCastToChar(column, version) != false;
        likeWord = matchCase != false || DbImplUtil.getJdbcHelper(this.dbms).supportsIlike() == false ? "LIKE" : "ILIKE";
        v4 = likeType.getDecorator().decorate(StringUtil.notNullize((String)((String)value)), this.dbms);
        Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"likeType.decorator.decor\u2026.notNullize(value), dbms)");
        literal = v4;
        return new PredicatesHelper.PredicateProducer(isGeometry, column, shouldCastToChar, likeWord, literal){
            final /* synthetic */ boolean $isGeometry;
            final /* synthetic */ DasColumn $column;
            final /* synthetic */ boolean $shouldCastToChar;
            final /* synthetic */ String $likeWord;
            final /* synthetic */ String $literal;

            public final void produce(@NotNull DdlBuilder builder) {
                Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
                if (this.$isGeometry) {
                    builder.identifier("ST_AsText").symbol("(").identifier((DasObject)this.$column).symbol(")");
                } else if (this.$shouldCastToChar) {
                    builder.identifier("CAST").symbol("(").identifier((DasObject)this.$column).space().keyword("AS").space().type("CHAR").symbol(")");
                } else {
                    builder.identifier((DasObject)this.$column);
                }
                builder.space().keyword(this.$likeWord).space().literal(this.$literal);
            }
            {
                this.$isGeometry = bl;
                this.$column = dasColumn;
                this.$shouldCastToChar = bl2;
                this.$likeWord = string;
                this.$literal = string2;
            }
        };
    }

    protected boolean shouldCastToChar(@NotNull DasColumn column2, @Nullable Version version) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        return false;
    }

    @NotNull
    public final Dbms getDbms() {
        return this.dbms;
    }

    public MysqlBasePredicatesHelper(@NotNull Dbms dbms) {
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        this.dbms = dbms;
        this.geometryTypes = SetsKt.setOf((Object[])new String[]{"geometry", "point", "polygon", "linestring"});
        this.formatTypes = SetsKt.setOf((Object[])new LogicalType[]{LogicalType.TIMESTAMP, LogicalType.DATE});
    }
}

