/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.debugger.SimpleExecutionStack;
import com.intellij.database.debugger.SqlDebugController;
import com.intellij.database.debugger.SqlDebugProcess;
import com.intellij.database.debugger.SqlProgramPosition;
import com.intellij.database.debugger.SqlProgramSource;
import com.intellij.database.debugger.SqlProgramSourceKt;
import com.intellij.database.dialects.oracle.debugger.DebugCommand;
import com.intellij.database.dialects.oracle.debugger.OracleConnectionHelperKt;
import com.intellij.database.dialects.oracle.debugger.OracleDebugController$WhenMappings;
import com.intellij.database.dialects.oracle.debugger.OracleDebugController$sam$java_lang_Runnable$0;
import com.intellij.database.dialects.oracle.debugger.OracleDebuggingSession;
import com.intellij.database.dialects.oracle.debugger.OracleExecutingSession;
import com.intellij.database.dialects.oracle.debugger.OraclePosition;
import com.intellij.database.dialects.oracle.debugger.OracleProgramPosition;
import com.intellij.database.dialects.oracle.debugger.OracleProgramSources;
import com.intellij.database.dialects.oracle.debugger.OracleProgramStackFrame;
import com.intellij.database.dialects.oracle.debugger.OracleScriptPosition;
import com.intellij.database.dialects.oracle.debugger.OracleScriptStackFrame;
import com.intellij.database.dialects.oracle.debugger.OracleStackFrame;
import com.intellij.database.dialects.oracle.debugger.OracleUnknownPosition;
import com.intellij.database.dialects.oracle.debugger.OracleUnknownStackFrame;
import com.intellij.database.dialects.oracle.debugger.PauseCommand;
import com.intellij.database.dialects.oracle.debugger.ProcessState;
import com.intellij.database.dialects.oracle.debugger.ResumeCommand;
import com.intellij.database.dialects.oracle.debugger.StepIntoCommand;
import com.intellij.database.dialects.oracle.debugger.StepOutCommand;
import com.intellij.database.dialects.oracle.debugger.StepOverCommand;
import com.intellij.database.dialects.oracle.debugger.StopCommand;
import com.intellij.database.util.GuardedRef;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XSuspendContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0003KLMB'\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020 H\u0016J\b\u0010\"\u001a\u00020 H\u0016J\u001e\u0010#\u001a\u00020 2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0016\u0010'\u001a\u00020 2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020 0)H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010,\u001a\u00020 2\u0006\u0010-\u001a\u00020\rH\u0016J\u000e\u0010.\u001a\u00020 2\u0006\u0010/\u001a\u000200J\b\u00101\u001a\u00020 H\u0002J\b\u00102\u001a\u00020 H\u0002J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u00020&H\u0002J\u0010\u00106\u001a\u0002042\u0006\u00105\u001a\u000207H\u0002J\u0010\u00108\u001a\u0002092\u0006\u00105\u001a\u00020:H\u0002J\u0010\u0010;\u001a\u00020<2\u0006\u00105\u001a\u00020&H\u0002J\u001e\u0010=\u001a\u00020 2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010>\u001a\u00020\rH\u0002J\u0016\u0010?\u001a\u00020@2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0002J\b\u0010A\u001a\u00020 H\u0002J\b\u0010B\u001a\u00020 H\u0002J\u0018\u0010C\u001a\u00020 2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020GH\u0002J\u0018\u0010H\u001a\u00020 2\u0006\u0010I\u001a\u00020\u001a2\u0006\u0010J\u001a\u00020\u001aH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OracleDebugController;", "Lcom/intellij/database/debugger/SqlDebugController;", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "scriptVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "scriptFirstLineNr", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;Lcom/intellij/openapi/vfs/VirtualFile;I)V", "debuggingConnectionRef", "Lcom/intellij/database/util/GuardedRef;", "Lcom/intellij/database/dataSource/DatabaseConnection;", "debuggingSession", "Lcom/intellij/database/dialects/oracle/debugger/OracleDebuggingSession;", "debuggingThread", "Ljava/lang/Thread;", "executingIsActive", "", "executingSession", "Lcom/intellij/database/dialects/oracle/debugger/OracleExecutingSession;", "initialized", "sources", "Lcom/intellij/database/dialects/oracle/debugger/OracleProgramSources;", "state", "Lcom/intellij/database/dialects/oracle/debugger/ProcessState;", "getState", "()Lcom/intellij/database/dialects/oracle/debugger/ProcessState;", "xSession", "Lcom/intellij/xdebugger/XDebugSession;", "close", "", "debugBegin", "debugEnd", "doUpdateUI", "stack", "", "Lcom/intellij/database/dialects/oracle/debugger/OraclePosition;", "inUI", "what", "Lkotlin/Function0;", "initLocal", "Lcom/intellij/xdebugger/XDebugProcess;", "initRemote", "executingConnection", "issueCommand", "command", "Lcom/intellij/database/dialects/oracle/debugger/DebugCommand;", "kickOffFinishing", "kickOffMainLoop", "makeFrame", "Lcom/intellij/database/dialects/oracle/debugger/OracleStackFrame;", "position", "makeFrameForProgram", "Lcom/intellij/database/dialects/oracle/debugger/OracleProgramPosition;", "makeFrameForScript", "Lcom/intellij/database/dialects/oracle/debugger/OracleScriptStackFrame;", "Lcom/intellij/database/dialects/oracle/debugger/OracleScriptPosition;", "makeFrameForUnknownPosition", "Lcom/intellij/database/dialects/oracle/debugger/OracleUnknownStackFrame;", "notifyUpdateUI", "obtainDebuggingConnection", "obtainSuspendContext", "Lcom/intellij/xdebugger/frame/XSuspendContext;", "performFinishing", "performMainLoop", "print", "s", "", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "stateTransition", "oldState", "newState", "EmptySuspendedContext", "OracleDebugProcess", "SuspendedContext", "intellij.database.dialects.oracle"})
public final class OracleDebugController
extends SqlDebugController {
    private final Project project;
    private final LocalDataSource dataSource;
    private final VirtualFile scriptVirtualFile;
    private final int scriptFirstLineNr;
    private XDebugSession xSession;
    private OracleExecutingSession executingSession;
    private OracleDebuggingSession debuggingSession;
    private Thread debuggingThread;
    private boolean initialized;
    private GuardedRef<DatabaseConnection> debuggingConnectionRef;
    private boolean executingIsActive;
    private final OracleProgramSources sources;

    private final ProcessState getState() {
        ProcessState processState;
        if (this.debuggingSession != null) {
            OracleDebuggingSession oracleDebuggingSession = this.debuggingSession;
            if (oracleDebuggingSession == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
            }
            processState = oracleDebuggingSession.getState();
        } else {
            processState = ProcessState.STATE_ASLEEP;
        }
        return processState;
    }

    @Override
    @NotNull
    public XDebugProcess initLocal(@NotNull XDebugSession xSession) {
        Intrinsics.checkParameterIsNotNull((Object)xSession, (String)"xSession");
        this.xSession = xSession;
        return new OracleDebugProcess(xSession);
    }

    @Override
    public void initRemote(@NotNull DatabaseConnection executingConnection) {
        Intrinsics.checkParameterIsNotNull((Object)executingConnection, (String)"executingConnection");
        if (this.initialized) {
            return;
        }
        OracleExecutingSession oracleExecutingSession = this.executingSession = new OracleExecutingSession(executingConnection);
        if (oracleExecutingSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executingSession");
        }
        oracleExecutingSession.setTraceConsumer((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
            final /* synthetic */ OracleDebugController this$0;

            public final void invoke(@NotNull String s) {
                Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                String string = s + '\n';
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.LOG_VERBOSE_OUTPUT;
                Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.LOG_VERBOSE_OUTPUT");
                OracleDebugController.access$print(this.this$0, string, consoleViewContentType);
            }
            {
                this.this$0 = oracleDebugController;
                super(1);
            }
        }));
        OracleExecutingSession oracleExecutingSession2 = this.executingSession;
        if (oracleExecutingSession2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executingSession");
        }
        oracleExecutingSession2.initRemote();
        OracleExecutingSession oracleExecutingSession3 = this.executingSession;
        if (oracleExecutingSession3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executingSession");
        }
        oracleExecutingSession3.makeSessionDebuggable();
        DatabaseConnection debuggingConnection = this.obtainDebuggingConnection();
        OracleExecutingSession oracleExecutingSession4 = this.executingSession;
        if (oracleExecutingSession4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executingSession");
        }
        OracleDebuggingSession oracleDebuggingSession = this.debuggingSession = new OracleDebuggingSession(debuggingConnection, oracleExecutingSession4);
        if (oracleDebuggingSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
        }
        oracleDebuggingSession.setDbmsOutputConsumer((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
            final /* synthetic */ OracleDebugController this$0;

            public final void invoke(@NotNull String s) {
                Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                String string = s + '\n';
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
                Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.NORMAL_OUTPUT");
                OracleDebugController.access$print(this.this$0, string, consoleViewContentType);
            }
            {
                this.this$0 = oracleDebugController;
                super(1);
            }
        }));
        OracleDebuggingSession oracleDebuggingSession2 = this.debuggingSession;
        if (oracleDebuggingSession2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
        }
        oracleDebuggingSession2.setTraceConsumer((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
            final /* synthetic */ OracleDebugController this$0;

            public final void invoke(@NotNull String s) {
                Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.LOG_DEBUG_OUTPUT;
                Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.LOG_DEBUG_OUTPUT");
                OracleDebugController.access$print(this.this$0, s, consoleViewContentType);
            }
            {
                this.this$0 = oracleDebugController;
                super(1);
            }
        }));
        OracleDebuggingSession oracleDebuggingSession3 = this.debuggingSession;
        if (oracleDebuggingSession3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
        }
        oracleDebuggingSession3.initRemote();
        OracleDebuggingSession oracleDebuggingSession4 = this.debuggingSession;
        if (oracleDebuggingSession4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
        }
        oracleDebuggingSession4.setOnStateTransition$intellij_database_dialects_oracle((Function2<? super ProcessState, ? super ProcessState, Unit>)((Function2)new Function2<ProcessState, ProcessState, Unit>(this){

            public final void invoke(@NotNull ProcessState p1, @NotNull ProcessState p2) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)p1), (String)"p1");
                Intrinsics.checkParameterIsNotNull((Object)((Object)p2), (String)"p2");
                OracleDebugController.access$stateTransition((OracleDebugController)this.receiver, p1, p2);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(OracleDebugController.class);
            }

            public final String getName() {
                return "stateTransition";
            }

            public final String getSignature() {
                return "stateTransition(Lcom/intellij/database/dialects/oracle/debugger/ProcessState;Lcom/intellij/database/dialects/oracle/debugger/ProcessState;)V";
            }
        }));
        OracleDebuggingSession oracleDebuggingSession5 = this.debuggingSession;
        if (oracleDebuggingSession5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
        }
        oracleDebuggingSession5.setOnEventInfo$intellij_database_dialects_oracle((Function2<? super List<? extends OraclePosition>, ? super ProcessState, Unit>)((Function2)new Function2<List<? extends OraclePosition>, ProcessState, Unit>(this){

            public final void invoke(@NotNull List<? extends OraclePosition> p1, @NotNull ProcessState p2) {
                Intrinsics.checkParameterIsNotNull(p1, (String)"p1");
                Intrinsics.checkParameterIsNotNull((Object)((Object)p2), (String)"p2");
                OracleDebugController.access$notifyUpdateUI((OracleDebugController)this.receiver, p1, p2);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(OracleDebugController.class);
            }

            public final String getName() {
                return "notifyUpdateUI";
            }

            public final String getSignature() {
                return "notifyUpdateUI(Ljava/util/List;Lcom/intellij/database/dialects/oracle/debugger/ProcessState;)V";
            }
        }));
        OracleDebuggingSession oracleDebuggingSession6 = this.debuggingSession;
        if (oracleDebuggingSession6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
        }
        this.initialized = oracleDebuggingSession6.getAttached();
    }

    private final DatabaseConnection obtainDebuggingConnection() {
        GuardedRef<DatabaseConnection> connectionRef = OracleConnectionHelperKt.obtainGuardedConnection(this.project, this.dataSource, DGDepartment.DEBUGGER);
        this.debuggingConnectionRef = connectionRef;
        DatabaseConnection databaseConnection = connectionRef.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)databaseConnection, (String)"connectionRef.get()");
        return databaseConnection;
    }

    @Override
    public void debugBegin() {
        if (!this.initialized) {
            throw (Throwable)new IllegalStateException("OracleDebugController is not initialized");
        }
        if (this.xSession == null) {
            throw (Throwable)new IllegalStateException("An XDebugSession instance was not assigned");
        }
        this.inUI((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ OracleDebugController this$0;

            public final void invoke() {
                OracleDebugController.access$getXSession$p(this.this$0).getConsoleView();
            }
            {
                this.this$0 = oracleDebugController;
                super(0);
            }
        }));
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.SYSTEM_OUTPUT;
        Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.SYSTEM_OUTPUT");
        this.print("Starting Debugger\u2026", consoleViewContentType);
        this.kickOffMainLoop();
        OracleExecutingSession oracleExecutingSession = this.executingSession;
        if (oracleExecutingSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executingSession");
        }
        oracleExecutingSession.turnDebugON(false);
        this.executingIsActive = true;
    }

    @Override
    public void debugEnd() {
        this.executingIsActive = false;
        this.kickOffFinishing();
        if (this.initialized) {
            OracleExecutingSession oracleExecutingSession = this.executingSession;
            if (oracleExecutingSession == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"executingSession");
            }
            oracleExecutingSession.turnDebugOFF();
        }
        if (this.xSession != null) {
            XDebugSession xDebugSession = this.xSession;
            if (xDebugSession == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"xSession");
            }
            xDebugSession.stop();
        }
        if (this.debuggingThread != null) {
            Thread thread = this.debuggingThread;
            if (thread == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingThread");
            }
            thread.join();
        }
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.SYSTEM_OUTPUT;
        Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.SYSTEM_OUTPUT");
        this.print("Debugger is stopped.", consoleViewContentType);
    }

    @Override
    public void close() {
        GuardedRef<DatabaseConnection> connectionRef;
        if (this.debuggingThread != null) {
            Thread thread = this.debuggingThread;
            if (thread == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingThread");
            }
            if (thread.isAlive()) {
                this.issueCommand(StopCommand.INSTANCE);
                Thread thread2 = this.debuggingThread;
                if (thread2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingThread");
                }
                thread2.join(5000L);
                Thread thread3 = this.debuggingThread;
                if (thread3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingThread");
                }
                if (thread3.isAlive()) {
                    throw (Throwable)new RuntimeException("Failed to stop the debugging process (current state: " + (Object)((Object)this.getState()) + ')');
                }
            }
        }
        this.initialized = false;
        if (this.debuggingSession != null) {
            OracleDebuggingSession oracleDebuggingSession = this.debuggingSession;
            if (oracleDebuggingSession == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
            }
            oracleDebuggingSession.close();
        }
        if (this.executingSession != null) {
            OracleExecutingSession oracleExecutingSession = this.executingSession;
            if (oracleExecutingSession == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"executingSession");
            }
            oracleExecutingSession.close();
        }
        if ((connectionRef = this.debuggingConnectionRef) != null) {
            connectionRef.close();
            this.debuggingConnectionRef = null;
        }
    }

    private final void kickOffMainLoop() {
        OracleDebuggingSession oracleDebuggingSession = this.debuggingSession;
        if (oracleDebuggingSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
        }
        boolean bl = !oracleDebuggingSession.getProcessIsActive();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            StringBuilder stringBuilder = new StringBuilder().append("Attempting start debugging when already is active (state: ");
            OracleDebuggingSession oracleDebuggingSession2 = this.debuggingSession;
            if (oracleDebuggingSession2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
            }
            String string = stringBuilder.append((Object)oracleDebuggingSession2.getState()).append(')').toString();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Function0 function0 = (Function0)new Function0<Unit>(this){

            public final void invoke() {
                OracleDebugController.access$performMainLoop((OracleDebugController)this.receiver);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(OracleDebugController.class);
            }

            public final String getName() {
                return "performMainLoop";
            }

            public final String getSignature() {
                return "performMainLoop()V";
            }
        };
        Thread thread = this.debuggingThread = new Thread((Runnable)new OracleDebugController$sam$java_lang_Runnable$0(function0), "Oracle Debugging");
        if (thread == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingThread");
        }
        thread.start();
        Thread.sleep(10L);
    }

    private final void performMainLoop() {
        OracleDebuggingSession oracleDebuggingSession = this.debuggingSession;
        if (oracleDebuggingSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
        }
        oracleDebuggingSession.performMainLoop();
    }

    private final void kickOffFinishing() {
        OracleDebuggingSession oracleDebuggingSession = this.debuggingSession;
        if (oracleDebuggingSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
        }
        boolean bl = !oracleDebuggingSession.getProcessIsActive();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            StringBuilder stringBuilder = new StringBuilder().append("Attempting to start finishing when debugging is active (state: ");
            OracleDebuggingSession oracleDebuggingSession2 = this.debuggingSession;
            if (oracleDebuggingSession2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
            }
            String string = stringBuilder.append((Object)oracleDebuggingSession2.getState()).append(')').toString();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Function0 function0 = (Function0)new Function0<Unit>(this){

            public final void invoke() {
                OracleDebugController.access$performFinishing((OracleDebugController)this.receiver);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(OracleDebugController.class);
            }

            public final String getName() {
                return "performFinishing";
            }

            public final String getSignature() {
                return "performFinishing()V";
            }
        };
        Thread thread = this.debuggingThread = new Thread((Runnable)new OracleDebugController$sam$java_lang_Runnable$0(function0), "Oracle Debugging (finishing)");
        if (thread == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingThread");
        }
        thread.start();
        Thread.sleep(10L);
    }

    private final void performFinishing() {
        OracleDebuggingSession oracleDebuggingSession = this.debuggingSession;
        if (oracleDebuggingSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
        }
        oracleDebuggingSession.performFinishLoop();
    }

    public final void issueCommand(@NotNull DebugCommand command) {
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        OracleDebuggingSession oracleDebuggingSession = this.debuggingSession;
        if (oracleDebuggingSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
        }
        oracleDebuggingSession.issueCommand(command);
    }

    private final void inUI(Function0<Unit> what) {
        Application application = ApplicationManager.getApplication();
        Object object = what;
        if (object != null) {
            Function0<Unit> function0 = object;
            object = new OracleDebugController$sam$java_lang_Runnable$0(function0);
        }
        application.invokeLater((Runnable)object);
    }

    private final void print(String s, ConsoleViewContentType contentType) {
        this.inUI((Function0<Unit>)((Function0)new Function0<Unit>(this, s, contentType){
            final /* synthetic */ OracleDebugController this$0;
            final /* synthetic */ String $s;
            final /* synthetic */ ConsoleViewContentType $contentType;

            public final void invoke() {
                OracleDebugController.access$getXSession$p(this.this$0).getConsoleView().print(this.$s + '\n', this.$contentType);
            }
            {
                this.this$0 = oracleDebugController;
                this.$s = string;
                this.$contentType = consoleViewContentType;
                super(0);
            }
        }));
    }

    private final void stateTransition(ProcessState oldState, ProcessState newState) {
    }

    private final void notifyUpdateUI(List<? extends OraclePosition> stack, ProcessState state2) {
        this.inUI((Function0<Unit>)((Function0)new Function0<Unit>(this, stack, state2){
            final /* synthetic */ OracleDebugController this$0;
            final /* synthetic */ List $stack;
            final /* synthetic */ ProcessState $state;

            public final void invoke() {
                OracleDebugController.access$doUpdateUI(this.this$0, this.$stack, this.$state);
            }
            {
                this.this$0 = oracleDebugController;
                this.$stack = list;
                this.$state = processState;
                super(0);
            }
        }));
    }

    private final void doUpdateUI(List<? extends OraclePosition> stack, ProcessState state2) {
        switch (OracleDebugController$WhenMappings.$EnumSwitchMapping$0[state2.ordinal()]) {
            case 1: {
                XDebugSession xDebugSession = this.xSession;
                if (xDebugSession == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"xSession");
                }
                xDebugSession.sessionResumed();
                XDebugSession xDebugSession2 = this.xSession;
                if (xDebugSession2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"xSession");
                }
                xDebugSession2.setPauseActionSupported(true);
                break;
            }
            case 2: {
                XSuspendContext suspendContext = this.obtainSuspendContext(stack);
                XDebugSession xDebugSession = this.xSession;
                if (xDebugSession == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"xSession");
                }
                xDebugSession.positionReached(suspendContext);
                if (!(Intrinsics.areEqual((Object)suspendContext, (Object)((Object)EmptySuspendedContext.INSTANCE)) ^ true)) break;
                XDebugSession xDebugSession3 = this.xSession;
                if (xDebugSession3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"xSession");
                }
                xDebugSession3.showExecutionPoint();
                break;
            }
            case 3: {
                XDebugSession xDebugSession = this.xSession;
                if (xDebugSession == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"xSession");
                }
                xDebugSession.sessionResumed();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final XSuspendContext obtainSuspendContext(List<? extends OraclePosition> stack) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = stack;
        OracleDebugController oracleDebugController = this;
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p1;
            OraclePosition oraclePosition = (OraclePosition)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            OracleStackFrame oracleStackFrame = oracleDebugController.makeFrame((OraclePosition)p1);
            collection.add(oracleStackFrame);
        }
        List frames = (List)destination$iv$iv;
        return new SuspendedContext(frames);
    }

    private final OracleStackFrame makeFrame(OraclePosition position) {
        OracleStackFrame oracleStackFrame;
        OraclePosition oraclePosition = position;
        if (oraclePosition instanceof OracleScriptPosition) {
            oracleStackFrame = this.makeFrameForScript((OracleScriptPosition)position);
        } else if (oraclePosition instanceof OracleProgramPosition) {
            oracleStackFrame = this.makeFrameForProgram((OracleProgramPosition)position);
        } else if (oraclePosition instanceof OracleUnknownPosition) {
            oracleStackFrame = this.makeFrameForUnknownPosition(position);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return oracleStackFrame;
    }

    private final OracleScriptStackFrame makeFrameForScript(OracleScriptPosition position) {
        XSourcePosition xPosition = SqlProgramSourceKt.createVirtualFilePosition(this.scriptVirtualFile, this.scriptFirstLineNr + position.getLineNr() - 1);
        return new OracleScriptStackFrame(position, xPosition);
    }

    private final OracleStackFrame makeFrameForProgram(OracleProgramPosition position) {
        SqlProgramSource source = this.sources.getProgramSource(position.getProgram());
        SqlProgramPosition programPosition = source != null ? new SqlProgramPosition(source, position.getLineNr() - 1) : null;
        return programPosition != null ? (OracleStackFrame)new OracleProgramStackFrame(position, programPosition) : (OracleStackFrame)this.makeFrameForUnknownPosition(position);
    }

    private final OracleUnknownStackFrame makeFrameForUnknownPosition(OraclePosition position) {
        return new OracleUnknownStackFrame(position);
    }

    public OracleDebugController(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull VirtualFile scriptVirtualFile, int scriptFirstLineNr) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        Intrinsics.checkParameterIsNotNull((Object)scriptVirtualFile, (String)"scriptVirtualFile");
        this.project = project;
        this.dataSource = dataSource;
        this.scriptVirtualFile = scriptVirtualFile;
        this.scriptFirstLineNr = scriptFirstLineNr;
        this.sources = new OracleProgramSources(project, dataSource);
    }

    public static final /* synthetic */ OracleDebuggingSession access$getDebuggingSession$p(OracleDebugController $this) {
        OracleDebuggingSession oracleDebuggingSession = $this.debuggingSession;
        if (oracleDebuggingSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
        }
        return oracleDebuggingSession;
    }

    public static final /* synthetic */ void access$setDebuggingSession$p(OracleDebugController $this, OracleDebuggingSession oracleDebuggingSession) {
        $this.debuggingSession = oracleDebuggingSession;
    }

    public static final /* synthetic */ void access$print(OracleDebugController $this, String s, ConsoleViewContentType contentType) {
        $this.print(s, contentType);
    }

    public static final /* synthetic */ void access$stateTransition(OracleDebugController $this, ProcessState oldState, ProcessState newState) {
        $this.stateTransition(oldState, newState);
    }

    public static final /* synthetic */ void access$notifyUpdateUI(OracleDebugController $this, List stack, ProcessState state2) {
        $this.notifyUpdateUI(stack, state2);
    }

    public static final /* synthetic */ XDebugSession access$getXSession$p(OracleDebugController $this) {
        XDebugSession xDebugSession = $this.xSession;
        if (xDebugSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"xSession");
        }
        return xDebugSession;
    }

    public static final /* synthetic */ void access$setXSession$p(OracleDebugController $this, XDebugSession xDebugSession) {
        $this.xSession = xDebugSession;
    }

    public static final /* synthetic */ Thread access$getDebuggingThread$p(OracleDebugController $this) {
        Thread thread = $this.debuggingThread;
        if (thread == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingThread");
        }
        return thread;
    }

    public static final /* synthetic */ void access$setDebuggingThread$p(OracleDebugController $this, Thread thread) {
        $this.debuggingThread = thread;
    }

    public static final /* synthetic */ OracleExecutingSession access$getExecutingSession$p(OracleDebugController $this) {
        OracleExecutingSession oracleExecutingSession = $this.executingSession;
        if (oracleExecutingSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executingSession");
        }
        return oracleExecutingSession;
    }

    public static final /* synthetic */ void access$setExecutingSession$p(OracleDebugController $this, OracleExecutingSession oracleExecutingSession) {
        $this.executingSession = oracleExecutingSession;
    }

    public static final /* synthetic */ void access$performMainLoop(OracleDebugController $this) {
        $this.performMainLoop();
    }

    public static final /* synthetic */ void access$performFinishing(OracleDebugController $this) {
        $this.performFinishing();
    }

    public static final /* synthetic */ void access$doUpdateUI(OracleDebugController $this, List stack, ProcessState state2) {
        $this.doUpdateUI(stack, state2);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u001a\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\f\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\r\u001a\u00020\u0006H\u0016J\u0012\u0010\u000e\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\u000f\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\u0010\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\u0011\u001a\u00020\u0006H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OracleDebugController$OracleDebugProcess;", "Lcom/intellij/database/debugger/SqlDebugProcess;", "xSession", "Lcom/intellij/xdebugger/XDebugSession;", "(Lcom/intellij/database/dialects/oracle/debugger/OracleDebugController;Lcom/intellij/xdebugger/XDebugSession;)V", "resume", "", "context", "Lcom/intellij/xdebugger/frame/XSuspendContext;", "runToPosition", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "startForceStepInto", "startPausing", "startStepInto", "startStepOut", "startStepOver", "stop", "intellij.database.dialects.oracle"})
    public final class OracleDebugProcess
    extends SqlDebugProcess {
        public void startStepInto(@Nullable XSuspendContext context) {
            if (OracleDebugController.this.getState() == ProcessState.STATE_RELAXING) {
                OracleDebugController.this.issueCommand(StepIntoCommand.INSTANCE);
            }
        }

        public void startForceStepInto(@Nullable XSuspendContext context) {
            if (OracleDebugController.this.getState() == ProcessState.STATE_RELAXING) {
                OracleDebugController.this.issueCommand(StepIntoCommand.INSTANCE);
            }
        }

        public void startStepOver(@Nullable XSuspendContext context) {
            if (OracleDebugController.this.getState() == ProcessState.STATE_RELAXING) {
                OracleDebugController.this.issueCommand(StepOverCommand.INSTANCE);
            }
        }

        public void startStepOut(@Nullable XSuspendContext context) {
            if (OracleDebugController.this.getState() == ProcessState.STATE_RELAXING) {
                OracleDebugController.this.issueCommand(StepOutCommand.INSTANCE);
            }
        }

        public void runToPosition(@NotNull XSourcePosition position, @Nullable XSuspendContext context) {
            Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        }

        public void startPausing() {
            if (OracleDebugController.this.getState() == ProcessState.STATE_RUNNING || OracleDebugController.this.getState() == ProcessState.STATE_STARTING_UP) {
                OracleDebugController.this.issueCommand(PauseCommand.INSTANCE);
            }
        }

        public void resume(@Nullable XSuspendContext context) {
            if (OracleDebugController.this.getState() == ProcessState.STATE_RELAXING) {
                OracleDebugController.this.issueCommand(ResumeCommand.INSTANCE);
            }
        }

        @Override
        public void stop() {
            if (OracleDebugController.this.getState().compareTo((Enum)ProcessState.STATE_ASLEEP) > 0 && OracleDebugController.this.getState().compareTo((Enum)ProcessState.STATE_COMPLETING) < 0) {
                OracleDebugController.this.issueCommand(StopCommand.INSTANCE);
            }
        }

        public OracleDebugProcess(XDebugSession xSession) {
            Intrinsics.checkParameterIsNotNull((Object)xSession, (String)"xSession");
            super(xSession);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\u0007H\u0016J\u0013\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u0016\u00a2\u0006\u0002\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OracleDebugController$SuspendedContext;", "Lcom/intellij/xdebugger/frame/XSuspendContext;", "frames", "", "Lcom/intellij/database/dialects/oracle/debugger/OracleStackFrame;", "(Ljava/util/List;)V", "stack", "Lcom/intellij/database/debugger/SimpleExecutionStack;", "getActiveExecutionStack", "getExecutionStacks", "", "()[Lcom/intellij/database/debugger/SimpleExecutionStack;", "intellij.database.dialects.oracle"})
    private static final class SuspendedContext
    extends XSuspendContext {
        private final SimpleExecutionStack stack;

        @NotNull
        public SimpleExecutionStack getActiveExecutionStack() {
            return this.stack;
        }

        @NotNull
        public SimpleExecutionStack[] getExecutionStacks() {
            return new SimpleExecutionStack[]{this.stack};
        }

        public SuspendedContext(@NotNull List<? extends OracleStackFrame> frames) {
            Intrinsics.checkParameterIsNotNull(frames, (String)"frames");
            this.stack = new SimpleExecutionStack(frames);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OracleDebugController$EmptySuspendedContext;", "Lcom/intellij/xdebugger/frame/XSuspendContext;", "()V", "intellij.database.dialects.oracle"})
    private static final class EmptySuspendedContext
    extends XSuspendContext {
        public static final EmptySuspendedContext INSTANCE;

        private EmptySuspendedContext() {
        }

        static {
            EmptySuspendedContext emptySuspendedContext;
            INSTANCE = emptySuspendedContext = new EmptySuspendedContext();
        }
    }
}

