/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.debugger.SqlProgramSource;
import com.intellij.database.dialects.oracle.debugger.OracleNamespace;
import com.intellij.database.dialects.oracle.debugger.OracleProgram;
import com.intellij.database.dialects.oracle.debugger.OracleProgramSources$WhenMappings;
import com.intellij.database.dialects.oracle.model.OraBody;
import com.intellij.database.dialects.oracle.model.OraModel;
import com.intellij.database.dialects.oracle.model.OraObjectType;
import com.intellij.database.dialects.oracle.model.OraPackage;
import com.intellij.database.dialects.oracle.model.OraRoot;
import com.intellij.database.dialects.oracle.model.OraSchema;
import com.intellij.database.dialects.oracle.model.OraSingleRoutine;
import com.intellij.database.dialects.oracle.model.OraSourceAware;
import com.intellij.database.dialects.oracle.model.OraTrigger;
import com.intellij.database.model.DasModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.SLRUCache;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0015\u001a\u00020\u000bJ\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J\"\u0010\u001e\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001cH\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\u001a2\u0006\u0010#\u001a\u00020\u001cH\u0002J\u001a\u0010$\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001a\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006'"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OracleProgramSources;", "", "project", "Lcom/intellij/openapi/project/Project;", "ds", "Lcom/intellij/database/dataSource/LocalDataSource;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;)V", "getDs", "()Lcom/intellij/database/dataSource/LocalDataSource;", "programCache", "Lcom/intellij/util/containers/SLRUCache;", "Lcom/intellij/database/dialects/oracle/debugger/OracleProgram;", "Ljava/util/Optional;", "Lcom/intellij/database/debugger/SqlProgramSource;", "getProject", "()Lcom/intellij/openapi/project/Project;", "findAssociatedVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "modelElement", "Lcom/intellij/database/dialects/oracle/model/OraSourceAware;", "findProgramSource", "program", "getProgramSource", "resolveBodyObject", "Lcom/intellij/database/dialects/oracle/model/OraBody;", "schema", "Lcom/intellij/database/dialects/oracle/model/OraSchema;", "name", "", "resolveModelElement", "resolveModelProgramObject", "namespace", "Lcom/intellij/database/dialects/oracle/debugger/OracleNamespace;", "programName", "resolveModelSchemaObject", "schemaName", "resolveTopLevelProgramObject", "resolveTriggerObject", "Lcom/intellij/database/dialects/oracle/model/OraTrigger;", "intellij.database.dialects.oracle"})
public final class OracleProgramSources {
    private final SLRUCache<OracleProgram, Optional<SqlProgramSource>> programCache;
    @NotNull
    private final Project project;
    @NotNull
    private final LocalDataSource ds;

    @Nullable
    public final SqlProgramSource getProgramSource(@NotNull OracleProgram program) {
        Intrinsics.checkParameterIsNotNull((Object)program, (String)"program");
        return ((Optional)this.programCache.get((Object)program)).orElse(null);
    }

    private final Optional<SqlProgramSource> findProgramSource(OracleProgram program) {
        OraSourceAware oraSourceAware = this.resolveModelElement(program);
        if (oraSourceAware == null) {
            Optional<SqlProgramSource> optional = Optional.empty();
            Intrinsics.checkExpressionValueIsNotNull(optional, (String)"Optional.empty()");
            return optional;
        }
        OraSourceAware modelElement = oraSourceAware;
        VirtualFile virtualFile = this.findAssociatedVirtualFile(modelElement);
        if (virtualFile == null) {
            Optional<SqlProgramSource> optional = Optional.empty();
            Intrinsics.checkExpressionValueIsNotNull(optional, (String)"Optional.empty()");
            return optional;
        }
        VirtualFile virtualFile2 = virtualFile;
        Optional<SqlProgramSource> optional = Optional.of(new SqlProgramSource(modelElement, virtualFile2));
        Intrinsics.checkExpressionValueIsNotNull(optional, (String)"Optional.of(SqlProgramSo\u2026delElement, virtualFile))");
        return optional;
    }

    private final OraSourceAware resolveModelElement(OracleProgram program) {
        OraSchema oraSchema = this.resolveModelSchemaObject(program.getSchemaName());
        if (oraSchema == null) {
            return null;
        }
        OraSchema schema = oraSchema;
        return this.resolveModelProgramObject(schema, program.getNamespace(), program.getProgramName());
    }

    private final OraSchema resolveModelSchemaObject(String schemaName) {
        String string = schemaName;
        if (string == null) {
            return null;
        }
        String theSchemaName = string;
        DasModel dasModel = this.ds.getModel();
        if (!(dasModel instanceof OraModel)) {
            dasModel = null;
        }
        OraModel oraModel = (OraModel)dasModel;
        if (oraModel == null) {
            return null;
        }
        OraModel model = oraModel;
        OraRoot oraRoot = model.getRoot();
        Intrinsics.checkExpressionValueIsNotNull((Object)oraRoot, (String)"model.root");
        OraRoot database = oraRoot;
        return (OraSchema)database.getSchemas().get(theSchemaName);
    }

    private final OraSourceAware resolveModelProgramObject(OraSchema schema, OracleNamespace namespace, String programName) {
        OraSourceAware oraSourceAware;
        switch (OracleProgramSources$WhenMappings.$EnumSwitchMapping$0[namespace.ordinal()]) {
            case 1: 
            case 2: {
                oraSourceAware = null;
                break;
            }
            case 3: {
                oraSourceAware = this.resolveTopLevelProgramObject(schema, programName);
                break;
            }
            case 4: {
                oraSourceAware = this.resolveBodyObject(schema, programName);
                break;
            }
            case 5: {
                oraSourceAware = this.resolveTriggerObject(schema, programName);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return oraSourceAware;
    }

    private final OraSourceAware resolveTopLevelProgramObject(OraSchema schema, String name2) {
        OraSingleRoutine routine = (OraSingleRoutine)schema.getRoutines().get(name2);
        if (routine != null) {
            return routine;
        }
        OraPackage oraPackage = (OraPackage)schema.getPackages().get(name2);
        if (oraPackage != null) {
            return oraPackage;
        }
        return null;
    }

    private final OraBody resolveBodyObject(OraSchema schema, String name2) {
        OraPackage oraPackage = (OraPackage)schema.getPackages().get(name2);
        if (oraPackage != null) {
            return (OraBody)oraPackage.getBodies().get();
        }
        OraObjectType type = (OraObjectType)schema.getObjectTypes().get(name2);
        if (type != null) {
            return (OraBody)type.getBodies().get();
        }
        return null;
    }

    private final OraTrigger resolveTriggerObject(OraSchema schema, String name2) {
        return null;
    }

    private final VirtualFile findAssociatedVirtualFile(OraSourceAware modelElement) {
        return DbSrcUtils.findDbSrcFile(this.project, this.ds, modelElement, null, false);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final LocalDataSource getDs() {
        return this.ds;
    }

    public OracleProgramSources(@NotNull Project project, @NotNull LocalDataSource ds) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)ds, (String)"ds");
        this.project = project;
        this.ds = ds;
        this.programCache = (SLRUCache)new SLRUCache<OracleProgram, Optional<SqlProgramSource>>(this, 7, 7){
            final /* synthetic */ OracleProgramSources this$0;

            @NotNull
            public Optional<SqlProgramSource> createValue(@NotNull OracleProgram key2) {
                Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
                return OracleProgramSources.access$findProgramSource(this.this$0, key2);
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2);
            }
        };
    }

    public static final /* synthetic */ Optional access$findProgramSource(OracleProgramSources $this, OracleProgram program) {
        return $this.findProgramSource(program);
    }
}

