/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TransferHolder<T> {
    @Nullable
    private T datum = null;

    public synchronized void offer(@NotNull T datum) {
        if (datum == null) {
            TransferHolder.$$$reportNull$$$0(0);
        }
        this.datum = datum;
        this.notifyAll();
    }

    @Nullable
    public synchronized T take(long timeout) throws InterruptedException {
        long t0 = System.currentTimeMillis();
        long tR = t0 + timeout;
        T d2 = this.datum;
        try {
            if (d2 != null || timeout == 0L) {
                T t = d2;
                return t;
            }
            while (true) {
                long toWait;
                if ((toWait = tR - System.currentTimeMillis()) <= 0L) {
                    T t = null;
                    return t;
                }
                this.wait(toWait);
                d2 = this.datum;
                if (d2 == null) continue;
                T t = d2;
                return t;
            }
        }
        finally {
            this.datum = null;
        }
    }

    private synchronized T peekDatum() {
        return this.datum;
    }

    public String toString() {
        T d2 = this.peekDatum();
        return d2 != null ? d2.toString() : "null";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "datum", "com/intellij/database/dialects/oracle/debugger/TransferHolder", "offer"));
    }
}

