/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase;

import com.google.common.collect.Iterables;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.PgDialectHelper;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.Version;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.JBIterable;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PgDialectBase
extends AbstractDatabaseDialect {
    private static final int FRACTIONAL_SECONDS_PRECISION_MAX = 6;

    protected PgDialectBase(@NotNull TypeHelper typeHelper, @NotNull Casing casing) {
        if (typeHelper == null) {
            PgDialectBase.$$$reportNull$$$0(0);
        }
        if (casing == null) {
            PgDialectBase.$$$reportNull$$$0(1);
        }
        super(typeHelper, casing);
    }

    @Override
    public String getBinaryLiteralString(@NotNull byte[] binaryData) {
        if (binaryData == null) {
            PgDialectBase.$$$reportNull$$$0(2);
        }
        return "E'\\\\x" + DialectUtils.toHexString(binaryData) + "'";
    }

    @Override
    @NotNull
    public String getTypeName(@NotNull DataType dataType) {
        if (dataType == null) {
            PgDialectBase.$$$reportNull$$$0(3);
        }
        if (dataType.jdbcType == 0) {
            String string = dataType.getSpecification();
            if (string == null) {
                PgDialectBase.$$$reportNull$$$0(4);
            }
            return string;
        }
        String typeName = dataType.typeName;
        int jdbcType = dataType.jdbcType;
        if (jdbcType == -7 && "bool".equals(typeName)) {
            if ("bool" == null) {
                PgDialectBase.$$$reportNull$$$0(5);
            }
            return "bool";
        }
        if (jdbcType == -5 && "oid".equals(typeName)) {
            if ("oid" == null) {
                PgDialectBase.$$$reportNull$$$0(6);
            }
            return "oid";
        }
        if (jdbcType == 93 || jdbcType == 92) {
            int fractionalSecondsPrecision = dataType.getScale();
            String string = JdbcUtil.getJdbcTypeName((DataType)dataType, (boolean)false) + (fractionalSecondsPrecision != 6 ? "(" + fractionalSecondsPrecision + ")" : "");
            if (string == null) {
                PgDialectBase.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (jdbcType == 2) {
            String string = "numeric" + (dataType.getLength() == 131089 ? "" : "(" + dataType.getPrecision() + (dataType.getScale() == 0 ? "" : ", " + dataType.getScale()) + ")");
            if (string == null) {
                PgDialectBase.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = super.getTypeName(dataType);
        if (string == null) {
            PgDialectBase.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropProcedure(@NotNull DdlBuilder builder, @NotNull DasRoutine procedure) {
        if (builder == null) {
            PgDialectBase.$$$reportNull$$$0(10);
        }
        if (procedure == null) {
            PgDialectBase.$$$reportNull$$$0(11);
        }
        String type = procedure.getRoutineKind().name();
        builder.keyword("DROP").space().keyword(type);
        builder.space();
        builder.qualifiedRef((DasObject)procedure).symbol("(");
        boolean first2 = true;
        for (DasArgument arg : DasUtil.getParameters((DasRoutine)procedure)) {
            ArgumentDirection direction = arg.getArgumentDirection();
            if (direction != ArgumentDirection.IN && direction != ArgumentDirection.INOUT) continue;
            if (first2) {
                first2 = false;
            } else {
                builder.symbol(",").space();
            }
            builder.type((DasTypedObject)arg);
        }
        builder.symbol(")");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            PgDialectBase.$$$reportNull$$$0(12);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    @Override
    public DdlBuilder sqlCreateView(@NotNull DdlBuilder builder, @NotNull DasTable view2, @NotNull String definition) {
        if (builder == null) {
            PgDialectBase.$$$reportNull$$$0(13);
        }
        if (view2 == null) {
            PgDialectBase.$$$reportNull$$$0(14);
        }
        if (definition == null) {
            PgDialectBase.$$$reportNull$$$0(15);
        }
        builder.keywords("CREATE", "OR", "REPLACE", "VIEW").space().qualifiedRef((DasObject)view2).space().keyword("AS").space().plain(definition);
        return builder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropView(@NotNull DdlBuilder builder, @NotNull DasTable view2, boolean cascade) {
        if (builder == null) {
            PgDialectBase.$$$reportNull$$$0(16);
        }
        if (view2 == null) {
            PgDialectBase.$$$reportNull$$$0(17);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropViewSQL(builder, view2, cascade);
        if (ddlBuilder == null) {
            PgDialectBase.$$$reportNull$$$0(18);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull DatabaseConnection connection2) throws Exception {
        if (table == null) {
            PgDialectBase.$$$reportNull$$$0(19);
        }
        if (connection2 == null) {
            PgDialectBase.$$$reportNull$$$0(20);
        }
        String string = PgDialectHelper.getTableDefinition(table, connection2);
        if (string == null) {
            PgDialectBase.$$$reportNull$$$0(21);
        }
        return string;
    }

    @Override
    public boolean supportsTableInfo() {
        return true;
    }

    @Override
    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element2, @NotNull DatabaseConnection connection2) throws Exception {
        if (element2 == null) {
            PgDialectBase.$$$reportNull$$$0(22);
        }
        if (connection2 == null) {
            PgDialectBase.$$$reportNull$$$0(23);
        }
        Dbms dbms = connection2.getDbms();
        Map<String, Object> map2 = DbImplUtil.resultRowAsMap(connection2, String.format("SELECT CAST(reltuples as INT) as rows FROM pg_catalog.pg_class C\n  LEFT JOIN pg_catalog.pg_namespace N ON (N.oid = C.relnamespace)\nWHERE (relkind = 'r' OR relkind = 'v') AND nspname LIKE '%s' ESCAPE '#' AND relname LIKE '%s' ESCAPE '#'", DbImplUtil.escapeSql(DasUtil.getSchema((DasObject)element2), true, dbms), DbImplUtil.escapeSql(element2.getName(), true, dbms)), new String[0]);
        if (map2 == null) {
            PgDialectBase.$$$reportNull$$$0(24);
        }
        return map2;
    }

    @Override
    public boolean supportsSearchPath() {
        return true;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnection connection2) throws SQLException {
        if (system == null) {
            PgDialectBase.$$$reportNull$$$0(25);
        }
        if (connection2 == null) {
            PgDialectBase.$$$reportNull$$$0(26);
        }
        Map<String, Object> map2 = DbImplUtil.resultRowAsMap(connection2, "select current_database() as a, current_schemas(false) as b", new String[0]);
        String db = String.valueOf(map2.get("a"));
        Object[] schemas2 = (Object[])ObjectUtils.tryCast((Object)map2.get("b"), Object[].class);
        if (StringUtil.isEmpty((String)db) || schemas2 == null || schemas2.length == 0) {
            return null;
        }
        ObjectPath dbPath = ObjectPath.create((String)db, (ObjectKind)ObjectKind.DATABASE);
        return SearchPath.of((List)JBIterable.of((Object[])schemas2).filter(String.class).transform(s -> dbPath.append(s, ObjectKind.SCHEMA)).toList());
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            PgDialectBase.$$$reportNull$$$0(27);
        }
        if (path.getCurrent().kind != ObjectKind.SCHEMA) {
            return null;
        }
        DdlBuilder builder = new DdlBuilder().plain("set search_path = ").quoteIdentifiers(true);
        boolean first2 = true;
        for (ObjectPath e : path.elements) {
            if (!first2) {
                builder.plain(", ");
            }
            first2 = false;
            builder.identifier(e.getName());
        }
        return builder.getStatement();
    }

    @Override
    public boolean supportsTableDefinition() {
        return true;
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    @Override
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element2) {
        if (element2 == null) {
            PgDialectBase.$$$reportNull$$$0(28);
        }
        return Pair.create((Object)("select view_definition from information_schema.views where table_schema = '" + DasUtil.getSchema((DasObject)element2) + "' and table_name = '" + element2.getName() + "'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
    }

    public boolean supportsProcedureDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element2) {
        if (element2 == null) {
            PgDialectBase.$$$reportNull$$$0(29);
        }
        Pair pair = Pair.create((Object)("select routine_definition from information_schema.routines where routine_schema = '" + DasUtil.getSchema((DasObject)element2) + "' and routine_name = '" + element2.getName() + "'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            PgDialectBase.$$$reportNull$$$0(30);
        }
        return pair;
    }

    @Override
    @NotNull
    public String tryToLoadProcedureDefinition(@NotNull DasRoutine proc, @NotNull DatabaseConnection connection2) throws Exception {
        Version curVersion;
        DdlBuilder builder;
        block6: {
            String string;
            if (proc == null) {
                PgDialectBase.$$$reportNull$$$0(31);
            }
            if (connection2 == null) {
                PgDialectBase.$$$reportNull$$$0(32);
            }
            Dbms dbms = connection2.getDbms();
            DatabaseMetaData md = (DatabaseMetaData)ObjectUtils.assertNotNull((Object)connection2.getMetaData());
            builder = new DdlBuilder().withDialect(this).qualifyReferences(true);
            curVersion = Version.of((int[])new int[]{md.getDatabaseMajorVersion(), md.getDatabaseMinorVersion()});
            try {
                if (!curVersion.isOrGreater(new int[]{8, 4})) break block6;
                string = DbImplUtil.concatStringResults(connection2, dbms, "SELECT pg_get_functiondef(p.oid) FROM pg_proc p JOIN pg_namespace n ON n.oid=pronamespace WHERE proname = " + PgDialectHelper.str(proc.getName()) + " AND nspname = " + PgDialectHelper.str(DasUtil.getSchema((DasObject)proc)), 0, DbImplUtil.ConcatenationProps.LINES);
            }
            catch (Exception e) {
                Logger.getInstance(this.getClass()).info((Throwable)e);
            }
            if (string == null) {
                PgDialectBase.$$$reportNull$$$0(33);
            }
            return string;
        }
        boolean isPre81 = Version.of((int[])new int[]{8, 0}).isOrGreater(curVersion);
        int limit = Math.max(10, Iterables.size((Iterable)proc.getArguments())) + 5;
        String s = "SELECT proname, proisagg, prosecdef, proisstrict, proretset, provolatile, pronargs, prosrc, probin,\n       lanname, \n" + PgDialectHelper.typeArg("tr", "rettype", "prorettype", isPre81) + ",\n" + PgDialectHelper.select(limit, isPre81) + "\n       " + (isPre81 ? "null dummy" : "proargmodes, pg_catalog.pg_get_expr(proargdefaults, 0) as proargdefaults") + "\n  FROM pg_proc\n  JOIN pg_namespace nsp ON nsp.oid=pronamespace\n  JOIN pg_language l ON l.oid=prolang\n" + PgDialectHelper.joinType("tr", "prorettype", isPre81) + "\n" + PgDialectHelper.join(limit, isPre81) + "  WHERE proname = " + PgDialectHelper.str(proc.getName()) + " AND nsp.nspname = " + PgDialectHelper.str(DasUtil.getSchema((DasObject)proc)) + "\n";
        SmartStatements.poweredBy(connection2).simple().noisy().execute(s, (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.results((ThrowableConsumer<ResultSet, Exception>)((ThrowableConsumer)rs -> {
            while (rs.next()) {
                builder.keywords("CREATE", "OR", "REPLACE", "FUNCTION").space().qualifiedRef((DasObject)proc).symbol("(");
                PgDialectHelper.SignatureBuilder signatureBuilder = new PgDialectHelper.SignatureBuilder(isPre81, (ResultSet)rs);
                signatureBuilder.buildArguments(builder);
                builder.symbol(")").newLine().space(2).keyword("RETURNS").space();
                signatureBuilder.buildReturn(builder);
                String language = rs.getString("lanname");
                String src = ((String)ObjectUtils.notNull((Object)rs.getString("prosrc"), (Object)"")).trim();
                if ("c".equals(language)) {
                    builder.newLine().keyword("AS").newLine().symbol("'").plain(rs.getString("probin")).symbol("'").symbol(",").space().symbol("'").plain(src).symbol("'");
                } else {
                    builder.newLine().keyword("AS").newLine().plain("$BODY$").newLine().plain(src).newLine().plain("$BODY$").newLine().keyword("LANGUAGE").space().plain(language).space();
                }
                String provolatile = rs.getString("provolatile");
                if ("v".equals(provolatile)) {
                    builder.keyword("VOLATILE");
                } else if ("i".equals(provolatile)) {
                    builder.keyword("IMMUTABLE");
                } else {
                    builder.keyword("STABLE");
                }
                if (rs.getBoolean("proisstrict")) {
                    builder.space().keyword("STRICT");
                }
                if (rs.getBoolean("prosecdef")) {
                    builder.space().keyword("SECURITY DEFINER");
                }
                builder.newStatement();
            }
        })));
        String string = builder.getStatement();
        if (string == null) {
            PgDialectBase.$$$reportNull$$$0(34);
        }
        return string;
    }

    @Override
    public boolean supportsSequenceDefinition() {
        return true;
    }

    @Override
    public boolean supportsQualifiedAsteriskInCalls() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefinePrototype(@NotNull DdlBuilder builder, @NotNull DasRoutine routine, boolean longMode, boolean withReturn) {
        if (builder == null) {
            PgDialectBase.$$$reportNull$$$0(35);
        }
        if (routine == null) {
            PgDialectBase.$$$reportNull$$$0(36);
        }
        JBIterable parameters = DasUtil.getParameters((DasRoutine)routine);
        boolean returnsTypeExplicit = false;
        String returnsTypeSpec = null;
        DasArgument returnArg = routine.getReturnArgument();
        if (returnArg != null) {
            returnsTypeExplicit = true;
            returnsTypeSpec = returnArg.getDataType().getSpecification();
        }
        int outs2 = 0;
        for (DasArgument parameter : parameters) {
            if (!parameter.getArgumentDirection().isOut()) continue;
            ++outs2;
        }
        builder.symbol("(");
        boolean first2 = true;
        for (DasArgument parameter : parameters) {
            if (first2) {
                first2 = false;
            } else {
                builder.symbol(",").space();
            }
            ArgumentDirection argumentDirection = parameter.getArgumentDirection();
            if (longMode || !argumentDirection.isIn()) {
                if (StringUtil.isNotEmpty((String)parameter.getName())) {
                    builder.identifier((DasObject)parameter, parameter.getName()).space();
                }
                if (argumentDirection.isOut()) {
                    if (argumentDirection.isIn()) {
                        builder.keyword("in").space();
                    }
                    builder.keyword("out").space();
                }
            }
            builder.type((DasTypedObject)parameter);
        }
        builder.symbol(")");
        if (!returnsTypeExplicit) {
            if (outs2 == 1) {
                for (DasArgument parameter : parameters) {
                    if (!parameter.getArgumentDirection().isOut()) continue;
                    returnsTypeSpec = parameter.getDataType().getSpecification();
                }
            } else {
                returnsTypeSpec = "record";
            }
        }
        if (returnsTypeExplicit && withReturn && StringUtil.isNotEmpty((String)returnsTypeSpec)) {
            if (longMode) {
                builder.space().keyword("returns").space();
            } else {
                builder.plain(": ");
            }
            builder.type(returnsTypeSpec);
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            PgDialectBase.$$$reportNull$$$0(37);
        }
        return ddlBuilder;
    }

    @Override
    public int getJavaTypeForNativeType(@NotNull String nativeColumnTypeName) {
        if (nativeColumnTypeName == null) {
            PgDialectBase.$$$reportNull$$$0(38);
        }
        if ("character_data".equalsIgnoreCase(nativeColumnTypeName)) {
            return 1;
        }
        if ("cardinal_number".equalsIgnoreCase(nativeColumnTypeName)) {
            return 4;
        }
        if ("xml".equalsIgnoreCase(nativeColumnTypeName)) {
            return 12;
        }
        return super.getJavaTypeForNativeType(nativeColumnTypeName);
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    public boolean supportsLoadDatabaseList() {
        return true;
    }

    @Override
    @NotNull
    public List<String> tryToLoadDatabaseList(@NotNull DatabaseConnection connection2) throws SQLException {
        if (connection2 == null) {
            PgDialectBase.$$$reportNull$$$0(39);
        }
        List<String> list = DbImplUtil.executeAndGetResult(connection2, "SELECT datname as name FROM pg_database WHERE datistemplate = false", DbImplUtil.RS_AS_STRING_LIST);
        if (list == null) {
            PgDialectBase.$$$reportNull$$$0(40);
        }
        return list;
    }

    @Override
    @Nullable
    public String sqlResetSearchPath() {
        return "set search_path to default";
    }

    @Override
    public boolean supportsOffset() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 18: 
            case 21: 
            case 24: 
            case 30: 
            case 33: 
            case 34: 
            case 37: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 18: 
            case 21: 
            case 24: 
            case 30: 
            case 33: 
            case 34: 
            case 37: 
            case 40: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeHelper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casing";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 18: 
            case 21: 
            case 24: 
            case 30: 
            case 33: 
            case 34: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/postgresbase/PgDialectBase";
                break;
            }
            case 10: 
            case 13: 
            case 16: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "procedure";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 20: 
            case 23: 
            case 26: 
            case 32: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 22: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proc";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeColumnTypeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/postgresbase/PgDialectBase";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropProcedure";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropView";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableDefinition";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableInfo";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadProcedureDefinition";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefinePrototype";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadDatabaseList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryLiteralString";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 18: 
            case 21: 
            case 24: 
            case 30: 
            case 33: 
            case 34: 
            case 37: 
            case 40: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropProcedure";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateView";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropView";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableDefinition";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadProcedureDefinition";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefinePrototype";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getJavaTypeForNativeType";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadDatabaseList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 18: 
            case 21: 
            case 24: 
            case 30: 
            case 33: 
            case 34: 
            case 37: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

