/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.fulltextsearch;

import com.intellij.database.data.types.OperandType;
import com.intellij.database.data.types.domain.LikeOpType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FullTextSearchOptions {
    public static final int DEFAULT_MAX_NUM_OF_FETCHED_ROWS = 10;
    public static final Location DEFAULT_LOCATION = Location.CONTAINS;
    public static final SearchScope DEFAULT_SEARCH_SCOPE = SearchScope.ALL_COLUMNS;
    public static final boolean DEFAULT_MATCH_CASE = false;
    private final String myText;
    private final boolean myMatchCase;
    private final SearchScope mySearchScope;
    private final Location myLocation;
    private final int myMaxNumOfFetchedRows;

    public FullTextSearchOptions(@NotNull String text2, boolean matchCase, @NotNull SearchScope searchScope, @NotNull Location location, int maxNumOfFetchedRows) {
        if (text2 == null) {
            FullTextSearchOptions.$$$reportNull$$$0(0);
        }
        if (searchScope == null) {
            FullTextSearchOptions.$$$reportNull$$$0(1);
        }
        if (location == null) {
            FullTextSearchOptions.$$$reportNull$$$0(2);
        }
        this.myText = text2;
        this.myMatchCase = matchCase;
        this.mySearchScope = searchScope;
        this.myLocation = location;
        this.myMaxNumOfFetchedRows = maxNumOfFetchedRows;
    }

    public String getText() {
        return this.myText;
    }

    public int getMaxNumOfFetchedRows() {
        return this.myMaxNumOfFetchedRows;
    }

    @NotNull
    public Location getLocation() {
        Location location = this.myLocation;
        if (location == null) {
            FullTextSearchOptions.$$$reportNull$$$0(3);
        }
        return location;
    }

    @NotNull
    public SearchScope getSearchScope() {
        SearchScope searchScope = this.mySearchScope;
        if (searchScope == null) {
            FullTextSearchOptions.$$$reportNull$$$0(4);
        }
        return searchScope;
    }

    public boolean isMatchCase() {
        return this.myMatchCase;
    }

    public String toString() {
        return String.format("%s(text: %s, maxNumOfFetchedRows: %d, target: %s, location: %s, match-case: %b)", new Object[]{FullTextSearchOptions.class.getSimpleName(), this.myText, this.myMaxNumOfFetchedRows, this.mySearchScope, this.myLocation, this.myMatchCase});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/fulltextsearch/FullTextSearchOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/fulltextsearch/FullTextSearchOptions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Location {
        CONTAINS("Contains", LikeOpType.CONTAINS),
        STARTS_WITH("Starts with", LikeOpType.STARTS_WITH),
        ENDS_WITH("Ends with", LikeOpType.ENDS_WITH),
        MATCHES("Matches", LikeOpType.MATCHES),
        LIKE_PATTERN("LIKE pattern", LikeOpType.CUSTOM_LIKE_PATTERN);

        private final String myName;
        private final LikeOpType myType;

        private Location(String name2, LikeOpType type) {
            if (name2 == null) {
                Location.$$$reportNull$$$0(0);
            }
            if (type == null) {
                Location.$$$reportNull$$$0(1);
            }
            this.myName = name2;
            this.myType = type;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                Location.$$$reportNull$$$0(2);
            }
            return string;
        }

        public LikeOpType getLikeOpType() {
            return this.myType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/fulltextsearch/FullTextSearchOptions$Location";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/fulltextsearch/FullTextSearchOptions$Location";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum SearchScope {
        TEXT_COLUMNS("Text columns", Arrays.asList(OperandType.INDEXED_TEXT, OperandType.TEXT)),
        INDEXED_COLUMNS("Only columns with full-text search indexes", Collections.singletonList(OperandType.INDEXED_TEXT)),
        NUMERIC_COLUMNS("Numeric columns", Collections.singletonList(OperandType.NUMBER)),
        ALL_COLUMNS("All columns", Arrays.asList(OperandType.INDEXED_TEXT, OperandType.NUMBER, OperandType.OTHER, OperandType.TEXT));

        private final String myName;
        private final List<OperandType> myTypes;

        private SearchScope(String name2, List<OperandType> types) {
            if (name2 == null) {
                SearchScope.$$$reportNull$$$0(0);
            }
            this.myName = name2;
            this.myTypes = types;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                SearchScope.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public List<OperandType> getTypes() {
            List<OperandType> list = this.myTypes;
            if (list == null) {
                SearchScope.$$$reportNull$$$0(2);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/fulltextsearch/FullTextSearchOptions$SearchScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/fulltextsearch/FullTextSearchOptions$SearchScope";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

