/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.serialization.converters;

import com.intellij.database.Dbms;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.serialization.Converter;
import com.intellij.database.model.serialization.ModelElementMem;
import com.intellij.database.model.serialization.ModelMem;
import com.intellij.database.model.serialization.MutableNameAndValue;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/model/serialization/converters/Converter_4_1;", "Lcom/intellij/database/model/serialization/Converter;", "()V", "adjustCascadeRules", "", "node", "Lcom/intellij/database/model/serialization/ModelElementMem;", "action", "", "adjustCascadeRulesPostgres", "meaningful", "", "convertMem", "modelMem", "Lcom/intellij/database/model/serialization/ModelMem;", "guessPostgresRulesAreMeaningful", "propertyIsCascadeRule", "property", "Lcom/intellij/database/model/serialization/MutableNameAndValue;", "intellij.database.impl"})
public final class Converter_4_1
implements Converter {
    @Override
    public void convertMem(@NotNull ModelMem modelMem) {
        Intrinsics.checkParameterIsNotNull((Object)modelMem, (String)"modelMem");
        boolean isPostgres = Intrinsics.areEqual((Object)modelMem.getDbms(), (Object)Dbms.POSTGRES);
        boolean postgresRulesAreMeaningful = isPostgres ? this.guessPostgresRulesAreMeaningful(modelMem) : false;
        for (ModelElementMem node : modelMem.getNodes()) {
            if (!Intrinsics.areEqual((Object)node.getKind(), (Object)"foreign-key")) continue;
            if (isPostgres) {
                this.adjustCascadeRulesPostgres(node, "update", postgresRulesAreMeaningful);
                this.adjustCascadeRulesPostgres(node, "delete", postgresRulesAreMeaningful);
                continue;
            }
            this.adjustCascadeRules(node, "update");
            this.adjustCascadeRules(node, "delete");
        }
    }

    private final boolean guessPostgresRulesAreMeaningful(ModelMem modelMem) {
        for (ModelElementMem node : modelMem.getNodes()) {
            if (!Intrinsics.areEqual((Object)node.getKind(), (Object)"foreign-key")) continue;
            for (MutableNameAndValue property : node.getProperties()) {
                String v2;
                if (!this.propertyIsCascadeRule(property, "update") && !this.propertyIsCascadeRule(property, "delete")) continue;
                String string = property.getValue();
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string2.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
                if (!(Intrinsics.areEqual((Object)v2, (Object)"restrict") ^ true)) continue;
                return true;
            }
        }
        return false;
    }

    private final void adjustCascadeRules(ModelElementMem node, String action2) {
        for (MutableNameAndValue property : node.getProperties()) {
            if (!this.propertyIsCascadeRule(property, action2) || !Intrinsics.areEqual((Object)property.getValue(), (Object)"update") && !Intrinsics.areEqual((Object)property.getValue(), (Object)"delete")) continue;
            property.setValue("cascade");
        }
    }

    private final void adjustCascadeRulesPostgres(ModelElementMem node, String action2, boolean meaningful) {
        boolean found = false;
        for (MutableNameAndValue property : node.getProperties()) {
            if (!this.propertyIsCascadeRule(property, action2)) continue;
            if (Intrinsics.areEqual((Object)property.getValue(), (Object)"update") || Intrinsics.areEqual((Object)property.getValue(), (Object)"delete")) {
                property.setValue("cascade");
            }
            if (Intrinsics.areEqual((Object)property.getValue(), (Object)"restrict") && !meaningful) {
                property.setValue("no_action");
            }
            found = true;
        }
        if (!found && meaningful) {
            node.getProperties().add(new MutableNameAndValue("On" + StringsKt.capitalize((String)action2), "restrict"));
        }
    }

    private final boolean propertyIsCascadeRule(MutableNameAndValue property, String action2) {
        String string = property.getName();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String n = string3;
        return Intrinsics.areEqual((Object)n, (Object)("on-" + action2)) || Intrinsics.areEqual((Object)n, (Object)("on" + action2));
    }

    @Override
    public void convertModel(@NotNull BasicModModel model) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Converter.DefaultImpls.convertModel(this, model);
    }
}

