/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.model.ClusterType;
import com.intellij.database.model.DasCluster;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasPositioned;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.icons.AllIcons;
import com.intellij.ide.presentation.PresentationProvider;
import com.intellij.ide.util.treeView.WeighedItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.IconDeferrer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TObjectIntHashMap;
import icons.DatabaseIcons;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbPresentation {
    public static final Comparator<String> NAMES_COMPARATOR = (s1, s2) -> StringUtil.compare((String)s1, (String)s2, (boolean)true);
    public static final String UNNAMED = "<unnamed>";
    private static final Map<ObjectKind, Icon> ourIcons = ContainerUtil.newConcurrentMap();
    private static final TObjectIntHashMap<ObjectKind> KIND_WEIGHTS;

    @Nullable
    public static Icon getIcon(@Nullable ObjectKind kind) {
        return ourIcons.get(kind);
    }

    @Nullable
    public static Icon getIcon(@NotNull DasObject c2) {
        if (c2 == null) {
            DbPresentation.$$$reportNull$$$0(0);
        }
        ObjectKind kind = c2.getKind();
        if (c2 instanceof PsiElement && !((PsiElement)c2).isValid()) {
            return DbPresentation.getIcon(kind);
        }
        if (kind == ObjectKind.COLUMN && c2 instanceof DasColumn) {
            return DbPresentation.getColumnIcon((DasColumn)c2);
        }
        if (kind == ObjectKind.KEY && c2 instanceof DasTableKey) {
            return ((DasTableKey)c2).isPrimary() ? DatabaseIcons.GoldKey : DatabaseIcons.GoldKeyAlt;
        }
        if (kind == ObjectKind.FOREIGN_KEY && c2 instanceof DasForeignKey) {
            DasForeignKey.RuleAction r1 = ((DasForeignKey)c2).getUpdateRule();
            DasForeignKey.RuleAction r2 = ((DasForeignKey)c2).getDeleteRule();
            return r1 != null && r1 != DasForeignKey.RuleAction.NO_ACTION || r2 != null && r2 != DasForeignKey.RuleAction.NO_ACTION ? DatabaseIcons.BlueKeyTrigger : DatabaseIcons.BlueKey;
        }
        if (kind == ObjectKind.INDEX && c2 instanceof DasIndex) {
            DasIndex index2 = (DasIndex)c2;
            return index2.isUnique() ? (index2.isFunctionBased() ? DatabaseIcons.IndexUniqueFun : DatabaseIcons.IndexUnique) : (index2.isFunctionBased() ? DatabaseIcons.IndexFun : DatabaseIcons.Index);
        }
        if (kind != ObjectKind.SCRIPT && kind != ObjectKind.AGGREGATE && kind != ObjectKind.MACRO && c2 instanceof DasRoutine) {
            DasRoutine.Kind k = ((DasRoutine)c2).getRoutineKind();
            return k == DasRoutine.Kind.PROCEDURE ? DatabaseIcons.Procedure : (k == DasRoutine.Kind.FUNCTION ? DatabaseIcons.Function : DatabaseIcons.Routine);
        }
        if (kind == ObjectKind.CLUSTER && c2 instanceof DasCluster) {
            ClusterType clusterType = ((DasCluster)c2).getClusterType();
            return clusterType == ClusterType.INDEX ? DatabaseIcons.IndexCluster : (clusterType == ClusterType.HASH ? DatabaseIcons.HashCluster : DatabaseIcons.UnspecifiedCluster);
        }
        BasicElement element2 = (BasicElement)ObjectUtils.tryCast((Object)DbImplUtil.unwrap(c2), BasicElement.class);
        if (element2 != null) {
            return DbImplUtil.getModelHelper(element2).getIcon(element2);
        }
        return DbPresentation.getIcon(kind);
    }

    static Icon getColumnIcon(@NotNull DasColumn c2) {
        DasTable table;
        if (c2 == null) {
            DbPresentation.$$$reportNull$$$0(1);
        }
        Set attrs = (table = c2.getTable()) == null ? Collections.emptySet() : table.getColumnAttrs(c2);
        boolean pinned = c2.isNotNull();
        boolean inIndex = attrs.contains(DasColumn.Attribute.INDEX);
        boolean pk = attrs.contains(DasColumn.Attribute.PRIMARY_KEY);
        boolean fk = attrs.contains(DasColumn.Attribute.FOREIGN_KEY);
        if (pk && fk) {
            if (pinned) {
                return inIndex ? DatabaseIcons.ColGoldBlueKeyDotIndex : DatabaseIcons.ColGoldBlueKeyDot;
            }
            return inIndex ? DatabaseIcons.ColGoldBlueKeyIndex : DatabaseIcons.ColGoldBlueKey;
        }
        if (pk) {
            if (pinned) {
                return inIndex ? DatabaseIcons.ColGoldKeyDotIndex : DatabaseIcons.ColGoldKeyDot;
            }
            return inIndex ? DatabaseIcons.ColGoldKeyIndex : DatabaseIcons.ColGoldKey;
        }
        if (fk) {
            if (pinned) {
                return inIndex ? DatabaseIcons.ColBlueKeyDotIndex : DatabaseIcons.ColBlueKeyDot;
            }
            return inIndex ? DatabaseIcons.ColBlueKeyIndex : DatabaseIcons.ColBlueKey;
        }
        if (pinned) {
            return inIndex ? DatabaseIcons.ColDotIndex : DatabaseIcons.ColDot;
        }
        return inIndex ? DatabaseIcons.ColIndex : DatabaseIcons.Col;
    }

    @NotNull
    public static String getPresentableName(@NotNull DasObject o, boolean unnamed) {
        if (o == null) {
            DbPresentation.$$$reportNull$$$0(2);
        }
        DasObject d2 = o instanceof DbElement ? ((DbElement)o).getDelegate() : o;
        String name2 = d2 instanceof BasicNode ? ((BasicNode)d2).getDisplayName() : o.getName();
        String string = StringUtil.isEmpty((String)name2) && unnamed ? UNNAMED : name2;
        if (string == null) {
            DbPresentation.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static boolean isUnnamed(@NotNull DasObject o) {
        if (o == null) {
            DbPresentation.$$$reportNull$$$0(4);
        }
        if (StringUtil.isNotEmpty((String)o.getName())) {
            return false;
        }
        if (o.getKind() != ObjectKind.ROUTINE) {
            return true;
        }
        DasObject parent2 = o.getDasParent();
        return parent2 == null || parent2.getKind() != ObjectKind.PACKAGE;
    }

    @NotNull
    public static String getPresentableName(@NotNull ObjectKind o, @NotNull DatabaseDialect dialect) {
        if (o == null) {
            DbPresentation.$$$reportNull$$$0(5);
        }
        if (dialect == null) {
            DbPresentation.$$$reportNull$$$0(6);
        }
        String name2 = dialect.getNameForKind(o);
        String string = StringUtil.toLowerCase((String)name2);
        if (string == null) {
            DbPresentation.$$$reportNull$$$0(7);
        }
        return string;
    }

    public static int getWeight(@NotNull ObjectKind kind, int groupCount) {
        int w;
        if (kind == null) {
            DbPresentation.$$$reportNull$$$0(8);
        }
        return (w = KIND_WEIGHTS.get((Object)kind)) != 0 ? w : 1000000 + kind.getOrder() * 1000 + groupCount;
    }

    public static int getWeight(@NotNull Object o, boolean sortPositioned) {
        int weight;
        BasicElement element2;
        Dbms dbms;
        int weight2;
        if (o == null) {
            DbPresentation.$$$reportNull$$$0(9);
        }
        if (o instanceof BasicElement && (weight2 = DatabaseStructure.Provider.forDbms(dbms = DbImplUtil.getDbms(element2 = (BasicElement)o)).getWeight(element2)) != -1) {
            return weight2;
        }
        ObjectKind kind = o instanceof DasObject ? ((DasObject)o).getKind() : ObjectKind.NONE;
        int n = weight = o instanceof WeighedItem ? ((WeighedItem)o).getWeight() : KIND_WEIGHTS.get((Object)kind);
        if (kind == ObjectKind.KEY && o instanceof DasTableKey && ((DasTableKey)o).isPrimary()) {
            --weight;
        }
        if (!sortPositioned && o instanceof DasPositioned) {
            return weight + ((DasPositioned)o).getPosition();
        }
        return weight;
    }

    @NotNull
    private static TObjectIntHashMap<ObjectKind> buildWeights(ObjectKind ... kinds) {
        TObjectIntHashMap res2 = new TObjectIntHashMap();
        for (int i2 = 0; i2 < kinds.length; ++i2) {
            res2.put((Object)kinds[i2], 1000 * (i2 + 1));
        }
        res2.compact();
        TObjectIntHashMap tObjectIntHashMap = res2;
        if (tObjectIntHashMap == null) {
            DbPresentation.$$$reportNull$$$0(10);
        }
        return tObjectIntHashMap;
    }

    public static String arrowToColumns(@Nullable String schemaName, @Nullable String tableName, @NotNull MultiRef<? extends DasTypedObject> columnsRef) {
        if (columnsRef == null) {
            DbPresentation.$$$reportNull$$$0(11);
        }
        String prefix = schemaName != null ? schemaName + "." : "";
        return StringUtil.isEmpty((String)tableName) ? "" : DbPresentation.arrow() + " " + prefix + tableName + " " + DbPresentation.multiRef(columnsRef);
    }

    @NotNull
    public static String multiRef(@NotNull MultiRef<? extends DasTypedObject> ref) {
        if (ref == null) {
            DbPresentation.$$$reportNull$$$0(12);
        }
        String string = ref.size() == 0 ? "" : "(" + StringUtil.join((Iterable)JBIterable.from((Iterable)ref.names()).filter(n -> n != null), (String)", ") + ")";
        if (string == null) {
            DbPresentation.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public static String arrow() {
        String string = ApplicationManager.getApplication().isUnitTestMode() ? "->" : UIUtil.rightArrow();
        if (string == null) {
            DbPresentation.$$$reportNull$$$0(14);
        }
        return string;
    }

    static {
        ourIcons.put(ObjectKind.DATABASE, DatabaseIcons.Database);
        ourIcons.put(ObjectKind.SCHEMA, DatabaseIcons.Schema);
        ourIcons.put(ObjectKind.SEQUENCE, DatabaseIcons.Sequence);
        ourIcons.put(ObjectKind.CLUSTER, DatabaseIcons.UnspecifiedCluster);
        ourIcons.put(ObjectKind.TABLE, DatabaseIcons.Table);
        ourIcons.put(ObjectKind.COLUMN, DatabaseIcons.Col);
        ourIcons.put(ObjectKind.INDEX, DatabaseIcons.Index);
        ourIcons.put(ObjectKind.KEY, DatabaseIcons.GoldKeyAlt);
        ourIcons.put(ObjectKind.FOREIGN_KEY, DatabaseIcons.BlueKey);
        ourIcons.put(ObjectKind.MAT_LOG, DatabaseIcons.MaterializedLog);
        ourIcons.put(ObjectKind.MAT_VIEW, DatabaseIcons.MaterializedView);
        ourIcons.put(ObjectKind.VIEW, DatabaseIcons.View);
        ourIcons.put(ObjectKind.CHECK, DatabaseIcons.CheckConstraint);
        ourIcons.put(ObjectKind.DEFAULT, DatabaseIcons.DefaultConstraint);
        ourIcons.put(ObjectKind.RULE, DatabaseIcons.Rule);
        ourIcons.put(ObjectKind.TRIGGER, DatabaseIcons.Trigger);
        ourIcons.put(ObjectKind.PACKAGE, DatabaseIcons.Package);
        ourIcons.put(ObjectKind.ALIAS_TYPE, AllIcons.Nodes.Type);
        ourIcons.put(ObjectKind.TABLE_TYPE, AllIcons.Nodes.Type);
        ourIcons.put(ObjectKind.OBJECT_TYPE, AllIcons.Nodes.Type);
        ourIcons.put(ObjectKind.OBJECT_ATTRIBUTE, AllIcons.Nodes.ObjectTypeAttribute);
        ourIcons.put(ObjectKind.COLLECTION_TYPE, DatabaseIcons.CollectionType);
        ourIcons.put(ObjectKind.BODY, DatabaseIcons.Body);
        ourIcons.put(ObjectKind.ROUTINE, DatabaseIcons.Routine);
        ourIcons.put(ObjectKind.ARGUMENT, DatabaseIcons.Argument);
        ourIcons.put(ObjectKind.OPERATOR, DatabaseIcons.Operator);
        ourIcons.put(ObjectKind.VARIABLE, AllIcons.Nodes.Variable);
        ourIcons.put(ObjectKind.SYNONYM, DatabaseIcons.Synonym);
        ourIcons.put(ObjectKind.VIRTUAL_TABLE, DatabaseIcons.Table);
        ourIcons.put(ObjectKind.SCRIPT, DatabaseIcons.Scripting_script);
        ourIcons.put(ObjectKind.COLLATION, DatabaseIcons.Collation);
        ourIcons.put(ObjectKind.CONNECTION, DatabaseIcons.Connector);
        ourIcons.put(ObjectKind.USER, AllIcons.General.User);
        ourIcons.put(ObjectKind.ROLE, DatabaseIcons.Role);
        ourIcons.put(ObjectKind.FOREIGN_DATA_WRAPPER, DatabaseIcons.Foreign_datawrapper);
        ourIcons.put(ObjectKind.FOREIGN_TABLE, DatabaseIcons.Foreign_table);
        ourIcons.put(ObjectKind.SERVER, DatabaseIcons.Foreign_server);
        ourIcons.put(ObjectKind.USER_MAPPING, DatabaseIcons.User_mapping);
        ourIcons.put(ObjectKind.DB_LINK, DatabaseIcons.DatabaseLink);
        ourIcons.put(ObjectKind.EXTERNAL_SCHEMA, DatabaseIcons.External_schema_object);
        ourIcons.put(ObjectKind.SCHEDULED_EVENT, DatabaseIcons.ScheduledEvent);
        ourIcons.put(ObjectKind.ACCESS_METHOD, DatabaseIcons.Access_method);
        ourIcons.put(ObjectKind.AGGREGATE, DatabaseIcons.Aggregate);
        ourIcons.put(ObjectKind.EXCEPTION, AllIcons.Nodes.ExceptionClass);
        ourIcons.put(ObjectKind.EXTENSION, DatabaseIcons.Extension);
        ourIcons.put(ObjectKind.TABLESPACE, DatabaseIcons.Tablespace);
        ourIcons.put(ObjectKind.MACRO, DatabaseIcons.Macro);
        ourIcons.put(ObjectKind.PROJECTION, DatabaseIcons.Projection);
        ourIcons.put(ObjectKind.DATA_FILE, DatabaseIcons.DataFile);
        ourIcons.put(ObjectKind.PARTITION, DatabaseIcons.Partition);
        ourIcons.put(ObjectKind.METHOD, AllIcons.Nodes.Method);
        ourIcons.put(ObjectKind.WAREHOUSE, DatabaseIcons.Warehouse);
        ourIcons.put(ObjectKind.FORMAT, DatabaseIcons.FileFormat);
        ourIcons.put(ObjectKind.INDEX_EXTENSION, DatabaseIcons.IndexFun);
        ourIcons.put(ObjectKind.INDEX_SEARCH_METHOD, DatabaseIcons.Access_method);
        ourIcons.put(ObjectKind.CONSTANT, DatabaseIcons.Constant);
        KIND_WEIGHTS = DbPresentation.buildWeights(ObjectKind.DATABASE, ObjectKind.DB_LINK, ObjectKind.SCHEMA, ObjectKind.EXTERNAL_SCHEMA, ObjectKind.TABLE, ObjectKind.FOREIGN_TABLE, ObjectKind.VIRTUAL_TABLE, ObjectKind.MAT_VIEW, ObjectKind.VIEW, ObjectKind.CLUSTER, ObjectKind.BODY, ObjectKind.ROUTINE, ObjectKind.AGGREGATE, ObjectKind.PACKAGE, ObjectKind.OPERATOR, ObjectKind.SEQUENCE, ObjectKind.ALIAS_TYPE, ObjectKind.OBJECT_TYPE, ObjectKind.TABLE_TYPE, ObjectKind.COLLECTION_TYPE, ObjectKind.COLLATION, ObjectKind.SYNONYM, ObjectKind.EXCEPTION, ObjectKind.VARIABLE, ObjectKind.OBJECT_ATTRIBUTE, ObjectKind.COLUMN, ObjectKind.KEY, ObjectKind.FOREIGN_KEY, ObjectKind.INDEX, ObjectKind.CHECK, ObjectKind.DEFAULT, ObjectKind.RULE, ObjectKind.TRIGGER, ObjectKind.PARTITION);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/DbPresentation";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnsRef";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/DbPresentation";
                break;
            }
            case 3: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "buildWeights";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "multiRef";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "arrow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getColumnIcon";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableName";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 13: 
            case 14: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isUnnamed";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getWeight";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "arrowToColumns";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "multiRef";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Provider
    extends PresentationProvider<DasObject> {
        @Nullable
        public String getName(@Nullable DasObject object) {
            return object == null ? null : DbPresentation.getPresentableName(object, true);
        }

        @Nullable
        public Icon getIcon(@Nullable DasObject object) {
            if (object == null) {
                return null;
            }
            Icon baseIcon = DbPresentation.getIcon(object.getKind());
            return IconDeferrer.getInstance().defer(baseIcon, (Object)object, DbPresentation::getIcon);
        }

        @Nullable
        public String getTypeName(DasObject object) {
            if (object == null) {
                return null;
            }
            DatabaseDialect dialect = DbImplUtil.guessDatabaseDialect(object);
            return DbPresentation.getPresentableName(object.getKind(), (DatabaseDialect)ObjectUtils.notNull((Object)dialect, (Object)DatabaseDialects.getGenericDialect()));
        }
    }
}

