/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridLoader;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.run.actions.ChangePageSizeActionGroup;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import org.jetbrains.annotations.NotNull;

public class ChangePageSizeAction
extends DumbAwareAction {
    private final int myPageSize;

    public ChangePageSizeAction(int pageSize) {
        super(pageSize == -1 ? "All" : ChangePageSizeActionGroup.format(pageSize), pageSize == -1 ? "Snow all rows" : "Change page size to " + ChangePageSizeActionGroup.format(pageSize), null);
        this.myPageSize = pageSize;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ChangePageSizeAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabledAndVisible(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataGrid grid;
        if (e == null) {
            ChangePageSizeAction.$$$reportNull$$$0(1);
        }
        if ((grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) == null) {
            return;
        }
        ChangePageSizeAction.setPageSize(this.myPageSize, grid);
    }

    static void setPageSize(int pageSize, @NotNull DataGrid grid) {
        if (grid == null) {
            ChangePageSizeAction.$$$reportNull$$$0(2);
        }
        GridPagingModel pageModel = grid.getDataHookup().getPageModel();
        pageModel.setPageSize(pageSize);
        GridLoader<DataConsumer.Row, DataConsumer.Column> loader = grid.getDataHookup().getLoader();
        GridRequestSource<DataConsumer.Row, DataConsumer.Column> source = GridRequestSource.create(grid, null);
        if (DbImplUtil.isPageSizeUnlimited(pageSize)) {
            loader.load(source, 0);
        } else {
            loader.reloadCurrentPage(source);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/actions/ChangePageSizeAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setPageSize";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

