/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.grid.editors.GridCellEditor;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorsUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.ThreeStateCheckBox;
import java.awt.Color;
import java.util.EventObject;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultBooleanEditorFactory
implements GridCellEditorFactory {
    @Override
    public int getSuitability(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        if (grid == null) {
            DefaultBooleanEditorFactory.$$$reportNull$$$0(0);
        }
        if (row == null) {
            DefaultBooleanEditorFactory.$$$reportNull$$$0(1);
        }
        if (column2 == null) {
            DefaultBooleanEditorFactory.$$$reportNull$$$0(2);
        }
        return GridCellEditorsUtil.isBooleanCell(grid, row, column2) ? 2 : 0;
    }

    @Override
    @NotNull
    public GridCellEditor createEditor(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2, @Nullable Object object, EventObject initiator) {
        if (grid == null) {
            DefaultBooleanEditorFactory.$$$reportNull$$$0(3);
        }
        if (row == null) {
            DefaultBooleanEditorFactory.$$$reportNull$$$0(4);
        }
        if (column2 == null) {
            DefaultBooleanEditorFactory.$$$reportNull$$$0(5);
        }
        ReservedCellValue nullValue = DataGridUtil.getDefaultNullValue(grid, column2);
        BooleanCellEditor booleanCellEditor = new BooleanCellEditor(grid, object, nullValue);
        if (booleanCellEditor == null) {
            DefaultBooleanEditorFactory.$$$reportNull$$$0(6);
        }
        return booleanCellEditor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSuitability";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class BooleanCellEditor
    extends GridCellEditor.Adapter {
        private final ReservedCellValue myNullValue;
        private final ThreeStateCheckBox myComponent;

        private BooleanCellEditor(final @NotNull DataGrid grid, @Nullable Object value, @Nullable ReservedCellValue nullValue) {
            if (grid == null) {
                BooleanCellEditor.$$$reportNull$$$0(0);
            }
            this.myNullValue = nullValue;
            this.myComponent = new ThreeStateCheckBox(){

                public Color getBackground() {
                    Color background = super.getBackground();
                    return background != null ? new JBColor(background.darker(), background.brighter()) : null;
                }
            };
            this.myComponent.setHorizontalAlignment(0);
            this.myComponent.setThirdStateEnabled(this.myNullValue != null);
            this.myComponent.setState(BooleanCellEditor.getCheckboxState(value, nullValue));
            this.myComponent.setRequestFocusEnabled(true);
            this.myComponent.addItemListener(e -> this.fireEditing(this.getValue()));
            new DumbAwareAction("Stop Editing"){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    grid.stopEditing();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory$BooleanCellEditor$2", "actionPerformed"));
                }
            }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"ENTER"}), (JComponent)this.myComponent, (Disposable)this);
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            ThreeStateCheckBox threeStateCheckBox = this.myComponent;
            if (threeStateCheckBox == null) {
                BooleanCellEditor.$$$reportNull$$$0(1);
            }
            return threeStateCheckBox;
        }

        @Override
        @Nullable
        public Object getValue() {
            ThreeStateCheckBox.State state2 = this.myComponent.getState();
            switch (state2) {
                case NOT_SELECTED: {
                    return Boolean.FALSE;
                }
                case SELECTED: {
                    return Boolean.TRUE;
                }
            }
            return this.myNullValue;
        }

        @Override
        public boolean isColumnSpanAllowed() {
            return false;
        }

        @NotNull
        private static ThreeStateCheckBox.State getCheckboxState(Object value, ReservedCellValue nullValue) {
            Boolean result2;
            Boolean booleanValue = ObjectFormatter.getBooleanValue(value);
            Boolean bl = result2 = booleanValue == null && nullValue == null ? Boolean.FALSE : booleanValue;
            ThreeStateCheckBox.State state2 = Boolean.TRUE.equals(result2) ? ThreeStateCheckBox.State.SELECTED : (Boolean.FALSE.equals(result2) ? ThreeStateCheckBox.State.NOT_SELECTED : ThreeStateCheckBox.State.DONT_CARE);
            if (state2 == null) {
                BooleanCellEditor.$$$reportNull$$$0(2);
            }
            return state2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory$BooleanCellEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory$BooleanCellEditor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCheckboxState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

