/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DatabaseMessages;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.view.DatabaseView;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectInDatabaseView
implements SelectInTarget,
DumbAware {
    public static final String DATABASE = DatabaseMessages.message((String)"select.in.database.view", (Object[])new Object[0]);
    public static final ExtensionPointName<Extension> EXTENSION_POINT_NAME = ExtensionPointName.create((String)"com.intellij.database.selectInProvider");

    public String toString() {
        return DATABASE;
    }

    @Nullable
    public static DbElement askProviders(@NotNull SelectInContext context) {
        Pair<PsiElement, Factory<PsiElement>> p2;
        if (context == null) {
            SelectInDatabaseView.$$$reportNull$$$0(0);
        }
        return (p2 = SelectInDatabaseView.askProvidersInner(context)) == null ? null : (DbElement)ObjectUtils.tryCast((Object)p2.first, DbElement.class);
    }

    @Nullable
    private static Pair<PsiElement, Factory<PsiElement>> askProvidersInner(@NotNull SelectInContext context) {
        if (context == null) {
            SelectInDatabaseView.$$$reportNull$$$0(1);
        }
        for (Extension provider : (Extension[])EXTENSION_POINT_NAME.getExtensions()) {
            PsiElement target2 = provider.findTarget(context);
            if (target2 == PsiUtilCore.NULL_PSI_ELEMENT) {
                return Pair.create(null, () -> provider.tryCreateTarget(context));
            }
            if (target2 == null) continue;
            return Pair.create((Object)target2, null);
        }
        return null;
    }

    public boolean canSelect(@NotNull SelectInContext context) {
        VirtualFile file;
        if (context == null) {
            SelectInDatabaseView.$$$reportNull$$$0(2);
        }
        return !(file = context.getVirtualFile()).isDirectory() && SelectInDatabaseView.askProvidersInner(context) != null;
    }

    public void selectIn(@NotNull SelectInContext context, boolean requestFocus) {
        Pair<PsiElement, Factory<PsiElement>> p2;
        if (context == null) {
            SelectInDatabaseView.$$$reportNull$$$0(3);
        }
        if ((p2 = SelectInDatabaseView.askProvidersInner(context)) == null) {
            return;
        }
        if (p2.first != null) {
            DatabaseView.select((PsiElement)p2.first, requestFocus);
        } else {
            PsiElement target2 = (PsiElement)((Factory)p2.second).create();
            if (target2 != null) {
                DataSourceUiUtil.promiseFacadeUpdate(DbPsiFacade.getInstance((Project)context.getProject()), null).onProcessed(o -> DatabaseView.select(target2, requestFocus));
            }
        }
    }

    public String getToolWindowId() {
        return ToolWindowId.DATABASE_VIEW;
    }

    public String getMinorViewId() {
        return null;
    }

    public float getWeight() {
        return 4.5f;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "context";
        objectArray2[1] = "com/intellij/database/view/SelectInDatabaseView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "askProviders";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "askProvidersInner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "canSelect";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "selectIn";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Extension {
        @Nullable
        public PsiElement findTarget(@NotNull SelectInContext var1);

        @Nullable
        default public PsiElement tryCreateTarget(@NotNull SelectInContext context) {
            if (context == null) {
                Extension.$$$reportNull$$$0(0);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/SelectInDatabaseView$Extension", "tryCreateTarget"));
        }
    }
}

