/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.introduce.inplace.InplaceVariableIntroducer;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlVariableDefinition;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import com.intellij.sql.refactoring.SqlIntroduceHandlerBase;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlIntroduceVariableHandler
extends SqlIntroduceHandlerBase<SqlExtractVariableHelper> {
    public SqlIntroduceVariableHandler() {
        super("Introduce Variable");
    }

    private static void performInplaceIntroduce(@NotNull Editor editor, @NotNull SqlExpression expression, boolean replaceAll) {
        if (editor == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(0);
        }
        if (expression == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(1);
        }
        List<PsiElement> occurrences = replaceAll ? SqlIntroduceVariableHandler.getOccurrences(expression) : Collections.singletonList(expression);
        SqlExtractVariableHelper helper = SqlImplUtil.getSqlDialectSafe((PsiElement)expression).getExtractVariableHelper();
        if (helper == null) {
            return;
        }
        PsiElement declaration = SqlIntroduceVariableHandler.performElement(editor, expression, occurrences, helper);
        if (declaration != null && declaration.isValid()) {
            PsiNamedElement target2 = (PsiNamedElement)SqlImplUtil.sqlTraverser().filter(SqlVariableDefinition.class).first();
            if (target2 == null || !target2.isValid()) {
                return;
            }
            editor.getCaretModel().moveToOffset(target2.getTextRange().getStartOffset());
            SqlTypeElement type = helper.getTypeElement((PsiElement)target2);
            SqlInplaceVariableIntroducer introducer = new SqlInplaceVariableIntroducer(expression.getProject(), editor, target2, type, occurrences);
            introducer.performInplaceRefactoring(new LinkedHashSet());
        }
    }

    @Nullable
    private static PsiElement performElement(@NotNull Editor editor, @NotNull SqlExpression expression, @NotNull List<PsiElement> occurrences, @NotNull SqlExtractVariableHelper helper) {
        if (editor == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(2);
        }
        if (expression == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(3);
        }
        if (occurrences == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(4);
        }
        if (helper == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(5);
        }
        Project project = expression.getProject();
        String name2 = "new_var";
        String type = "int";
        PsiElement initializer = helper.createInitializerDeclaration(project, "new_var", expression.getText());
        PsiElement declaration = helper.createDeclaration(project, "new_var", type);
        PsiElement anchor = helper.findInitializerAnchor(occurrences);
        PsiElement block = helper.findTopmostBlock((PsiElement)expression);
        if (declaration == null || initializer == null || anchor == null || block == null) {
            SqlIntroduceVariableHandler.showCannotPerformError(project, editor);
            return null;
        }
        SqlLanguageDialectEx language = SqlImplUtil.getSqlDialectSafe((PsiElement)expression);
        PsiFile file = expression.getContainingFile();
        return (PsiElement)WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{file}).withName("Extract variable").compute(() -> {
            PsiDocumentManager dm = PsiDocumentManager.getInstance((Project)project);
            Document document = dm.getDocument(file);
            if (document == null) {
                return null;
            }
            dm.commitDocument(document);
            PsiElement createdDeclaration = helper.addDeclaration(declaration, block);
            SqlIntroduceVariableHandler.addInitializer(project, anchor, initializer, language);
            SqlExpression newExpression = SqlPsiElementFactory.createExpressionFromText("new_var", language, project, null);
            if (newExpression != null) {
                for (PsiElement occurrence : occurrences) {
                    occurrence.replace((PsiElement)newExpression);
                }
            }
            if (createdDeclaration != null) {
                createdDeclaration = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)createdDeclaration);
            }
            return createdDeclaration;
        });
    }

    private static void addInitializer(Project project, PsiElement anchor, PsiElement initializer, @NotNull SqlLanguageDialect language) {
        PsiElement createdInitializer;
        if (language == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(6);
        }
        if ((createdInitializer = anchor.getParent().addBefore(initializer, anchor)) != null) {
            PsiElement semi = SqlPsiElementFactory.createLeafFromText(project, language, ";");
            PsiElement newLineNode = SqlPsiElementFactory.newLine(project);
            PsiElement parent2 = createdInitializer.getParent();
            PsiElement psiElement = parent2.addAfter(semi, createdInitializer);
            parent2.addAfter(newLineNode, psiElement);
        }
    }

    private static void showCannotPerformError(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(8);
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"Cannot perform refactoring", (String)"Cannot Perform Refactoring", (String)"refactoring.extractMethod");
    }

    @Nullable
    public static PsiElement getTopmostScope(@Nullable PsiElement element2) {
        return PsiTreeUtil.getParentOfType((PsiElement)element2, SqlBlockStatementImpl.class);
    }

    @NotNull
    static List<PsiElement> getOccurrences(@NotNull SqlExpression expression) {
        PsiElement scope;
        if (expression == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(9);
        }
        List list = (scope = SqlIntroduceVariableHandler.getTopmostScope((PsiElement)expression)) == null ? Collections.emptyList() : ((SyntaxTraverser)SqlImplUtil.sqlTraverser(scope).filter(element2 -> PsiEquivalenceUtil.areElementsEquivalent((PsiElement)element2, (PsiElement)expression))).toList();
        if (list == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Override
    @Nullable
    protected SqlExtractVariableHelper getHelper(@NotNull SqlLanguageDialectEx dialect) {
        if (dialect == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(11);
        }
        return dialect.getExtractVariableHelper();
    }

    @Override
    protected void invoke(@NotNull Project project, final @NotNull Editor editor, final @NotNull SqlExpression expression) {
        if (project == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(12);
        }
        if (editor == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(13);
        }
        if (expression == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(14);
        }
        if (!editor.getSettings().isVariableInplaceRenameEnabled()) {
            return;
        }
        OccurrencesChooser.simpleChooser((Editor)editor).showChooser((Object)expression, SqlIntroduceVariableHandler.getOccurrences(expression), (Pass)new Pass<OccurrencesChooser.ReplaceChoice>(){

            public void pass(OccurrencesChooser.ReplaceChoice replaceChoice) {
                SqlIntroduceVariableHandler.performInplaceIntroduce(editor, expression, replaceChoice == OccurrencesChooser.ReplaceChoice.ALL);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrences";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/SqlIntroduceVariableHandler";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/SqlIntroduceVariableHandler";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOccurrences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "performInplaceIntroduce";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addInitializer";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showCannotPerformError";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getOccurrences";
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getHelper";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SqlInplaceVariableIntroducer
    extends InplaceVariableIntroducer<PsiElement> {
        @NotNull
        private final PsiElement myTarget;
        @Nullable
        private final SqlTypeElement myTypeElement;

        SqlInplaceVariableIntroducer(@NotNull Project project, @NotNull Editor editor, @NotNull PsiNamedElement target2, @Nullable SqlTypeElement typeElement, @NotNull List<PsiElement> occurrences) {
            if (project == null) {
                SqlInplaceVariableIntroducer.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                SqlInplaceVariableIntroducer.$$$reportNull$$$0(1);
            }
            if (target2 == null) {
                SqlInplaceVariableIntroducer.$$$reportNull$$$0(2);
            }
            if (occurrences == null) {
                SqlInplaceVariableIntroducer.$$$reportNull$$$0(3);
            }
            super(target2, editor, project, "Introduce Variable", occurrences.toArray(PsiElement.EMPTY_ARRAY), null);
            this.myTarget = target2;
            this.myTypeElement = typeElement;
        }

        protected PsiElement checkLocalScope() {
            return this.myTarget.getContainingFile();
        }

        protected void addAdditionalVariables(@NotNull TemplateBuilderImpl builder) {
            if (builder == null) {
                SqlInplaceVariableIntroducer.$$$reportNull$$$0(4);
            }
            if (this.myTypeElement != null) {
                builder.replaceElement((PsiElement)this.myTypeElement, this.myTypeElement.getText());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "occurrences";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/sql/SqlIntroduceVariableHandler$SqlInplaceVariableIntroducer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addAdditionalVariables";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

