/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.exasol;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.base.TokenClasses;
import com.intellij.sql.dialects.exasol.ExaLexer;
import com.intellij.sql.dialects.exasol.ExaTokens;
import com.intellij.sql.dialects.exasol.ExaTypes;
import com.intellij.sql.dialects.exasol.refactoring.ExaExtractFunctionHelper;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExaDialect
extends SqlLanguageDialectEx {
    public static final ExaDialect INSTANCE = new ExaDialect();

    public ExaDialect() {
        super("Exasol");
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.EXASOL;
        if (dbms == null) {
            ExaDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    @Override
    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    @Override
    @NotNull
    public SqlLanguageDialectEx.BuiltinFunctions getSupportedFunctions() {
        SqlLanguageDialectEx.BuiltinFunctions builtinFunctions = LazyData.ourFunctionMap;
        if (builtinFunctions == null) {
            ExaDialect.$$$reportNull$$$0(1);
        }
        return builtinFunctions;
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set<String> set = LazyData.ourKeywords;
        if (set == null) {
            ExaDialect.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Set<String> getReservedKeywords() {
        Set<String> set = LazyData.ourReservedKeywords;
        if (set == null) {
            ExaDialect.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            ExaDialect.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Override
    @Nullable
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            ExaDialect.$$$reportNull$$$0(5);
        }
        switch (cat) {
            case INTEGER: {
                return "DECIMAL";
            }
            case REAL: {
                return "DECIMAL";
            }
            case STRING: {
                return "VARCHAR";
            }
            case BOOLEAN: {
                return "BOOLEAN";
            }
            case DATE_TIME: {
                return "TIMESTAMP";
            }
            case DATE: {
                return "DATE";
            }
            case TIME: {
                return "TIMESTAMP";
            }
            case TIMESTAMP: {
                return "TIMESTAMP";
            }
            case INTERVAL: {
                return "INTERVAL";
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getNormalizedTypeName(@NotNull String name2) {
        if (name2 == null) {
            ExaDialect.$$$reportNull$$$0(6);
        }
        if ("BIGINT".equals(name2 = super.getNormalizedTypeName(name2))) {
            if ("DECIMAL" == null) {
                ExaDialect.$$$reportNull$$$0(7);
            }
            return "DECIMAL";
        }
        if ("BOOL".equals(name2)) {
            if ("BOOLEAN" == null) {
                ExaDialect.$$$reportNull$$$0(8);
            }
            return "BOOLEAN";
        }
        if ("CHAR VARYING".equals(name2)) {
            if ("VARCHAR" == null) {
                ExaDialect.$$$reportNull$$$0(9);
            }
            return "VARCHAR";
        }
        if ("CHARACTER".equals(name2)) {
            if ("CHAR" == null) {
                ExaDialect.$$$reportNull$$$0(10);
            }
            return "CHAR";
        }
        if ("CHARACTER LARGE OBJECT".equals(name2)) {
            if ("VARCHAR" == null) {
                ExaDialect.$$$reportNull$$$0(11);
            }
            return "VARCHAR";
        }
        if ("CHARACTER VARYING".equals(name2)) {
            if ("VARCHAR" == null) {
                ExaDialect.$$$reportNull$$$0(12);
            }
            return "VARCHAR";
        }
        if ("CLOB".equals(name2)) {
            if ("VARCHAR" == null) {
                ExaDialect.$$$reportNull$$$0(13);
            }
            return "VARCHAR";
        }
        if ("DEC".equals(name2)) {
            if ("DECIMAL" == null) {
                ExaDialect.$$$reportNull$$$0(14);
            }
            return "DECIMAL";
        }
        if ("DOUBLE".equals(name2)) {
            if ("DOUBLE PRECISION" == null) {
                ExaDialect.$$$reportNull$$$0(15);
            }
            return "DOUBLE PRECISION";
        }
        if ("FLOAT".equals(name2)) {
            if ("DOUBLE PRECISION" == null) {
                ExaDialect.$$$reportNull$$$0(16);
            }
            return "DOUBLE PRECISION";
        }
        if ("INT".equals(name2)) {
            if ("DECIMAL" == null) {
                ExaDialect.$$$reportNull$$$0(17);
            }
            return "DECIMAL";
        }
        if ("INTEGER".equals(name2)) {
            if ("DECIMAL" == null) {
                ExaDialect.$$$reportNull$$$0(18);
            }
            return "DECIMAL";
        }
        if ("LONG VARCHAR".equals(name2)) {
            if ("VARCHAR" == null) {
                ExaDialect.$$$reportNull$$$0(19);
            }
            return "VARCHAR";
        }
        if ("NCHAR".equals(name2)) {
            if ("CHAR" == null) {
                ExaDialect.$$$reportNull$$$0(20);
            }
            return "CHAR";
        }
        if ("NUMBER".equals(name2)) {
            if ("DECIMAL" == null) {
                ExaDialect.$$$reportNull$$$0(21);
            }
            return "DECIMAL";
        }
        if ("NUMERIC".equals(name2)) {
            if ("DECIMAL" == null) {
                ExaDialect.$$$reportNull$$$0(22);
            }
            return "DECIMAL";
        }
        if ("NVARCHAR".equals(name2)) {
            if ("VARCHAR" == null) {
                ExaDialect.$$$reportNull$$$0(23);
            }
            return "VARCHAR";
        }
        if ("NVARCHAR2".equals(name2)) {
            if ("VARCHAR" == null) {
                ExaDialect.$$$reportNull$$$0(24);
            }
            return "VARCHAR";
        }
        if ("REAL".equals(name2)) {
            if ("DOUBLE PRECISION" == null) {
                ExaDialect.$$$reportNull$$$0(25);
            }
            return "DOUBLE PRECISION";
        }
        if ("SHORTINT".equals(name2)) {
            if ("DECIMAL" == null) {
                ExaDialect.$$$reportNull$$$0(26);
            }
            return "DECIMAL";
        }
        if ("SMALLINT".equals(name2)) {
            if ("DECIMAL" == null) {
                ExaDialect.$$$reportNull$$$0(27);
            }
            return "DECIMAL";
        }
        if ("TINYINT".equals(name2)) {
            if ("DECIMAL" == null) {
                ExaDialect.$$$reportNull$$$0(28);
            }
            return "DECIMAL";
        }
        if ("VARCHAR2".equals(name2)) {
            if ("VARCHAR" == null) {
                ExaDialect.$$$reportNull$$$0(29);
            }
            return "VARCHAR";
        }
        String string = name2;
        if (string == null) {
            ExaDialect.$$$reportNull$$$0(30);
        }
        return string;
    }

    @Override
    @NotNull
    public SqlType.Category getTypeCategoryByName(@NotNull String typeName) {
        if (typeName == null) {
            ExaDialect.$$$reportNull$$$0(31);
        }
        if ("DECIMAL".equals(typeName)) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                ExaDialect.$$$reportNull$$$0(32);
            }
            return category;
        }
        if ("NUMERIC".equals(typeName)) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                ExaDialect.$$$reportNull$$$0(33);
            }
            return category;
        }
        SqlType.Category category = super.getTypeCategoryByName(typeName);
        if (category == null) {
            ExaDialect.$$$reportNull$$$0(34);
        }
        return category;
    }

    @Override
    @NotNull
    protected TreePattern getBaseImports(@Nullable DbDataSource dataSource, @Nullable ObjectName[] dsNames) {
        ObjectName exaDb = ObjectName.quoted((String)"EXA_DB");
        DasNamespace namespace = ExaDialect.getDefaultNamespace(dataSource, exaDb);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtil.createObjectPattern(dsNames, (DasObject)namespace, new TreePatternNode.Group[0]);
            if (treePattern == null) {
                ExaDialect.$$$reportNull$$$0(35);
            }
            return treePattern;
        }
        TreePattern treePattern = new TreePattern(SqlImportUtil.createDataSources(dsNames, SqlImportUtil.createNodeIfNotNull(exaDb, ObjectKind.DATABASE, new TreePatternNode.Group[0])));
        if (treePattern == null) {
            ExaDialect.$$$reportNull$$$0(36);
        }
        return treePattern;
    }

    @Override
    protected boolean canBeWithoutCurrentSchema() {
        return true;
    }

    @Override
    public boolean isValidRawToken(@NotNull IElementType type, @NotNull CharSequence text2) {
        if (type == null) {
            ExaDialect.$$$reportNull$$$0(37);
        }
        if (text2 == null) {
            ExaDialect.$$$reportNull$$$0(38);
        }
        return ExaLexer.isValidRawToken(text2);
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement element2, boolean resolve, @NotNull SqlScopeProcessor processor) {
        if (element2 == null) {
            ExaDialect.$$$reportNull$$$0(39);
        }
        if (processor == null) {
            ExaDialect.$$$reportNull$$$0(40);
        }
        if (!ExaDialect.processReservedEntitiesWithTypeDual(name2, element2, resolve, processor)) {
            return false;
        }
        return super.processReservedEntitiesWithType(name2, element2, resolve, processor);
    }

    @Override
    @Nullable
    public ProblemDescriptor checkIdentifierText(SqlIdentifier o, InspectionManager manager, boolean onTheFly) {
        if (PsiUtilCore.getElementType((PsiElement)o.getFirstChild()) == ExaTypes.EXA_LOCAL) {
            return null;
        }
        return super.checkIdentifierText(o, manager, onTheFly);
    }

    public boolean isResolveTargetAccepted(@Nullable PsiElement element2, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            ExaDialect.$$$reportNull$$$0(41);
        }
        if (!strict) {
            if (expectedTypes.contains(ObjectKind.ROUTINE) && type == ObjectKind.SCRIPT) {
                return true;
            }
            if (expectedTypes.contains(ObjectKind.SCHEMA) && type == ObjectKind.EXTERNAL_SCHEMA) {
                return true;
            }
        }
        return super.isResolveTargetAccepted(element2, type, expectedTypes, place, strict, isCompletion);
    }

    @Override
    @Nullable
    public SqlExtractFunctionHelper getExtractFunctionHelper() {
        return ExaExtractFunctionHelper.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 31: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 31: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/exasol/ExaDialect";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFunctions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedKeywords";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 5: 
            case 6: 
            case 31: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/exasol/ExaDialect";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeName";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeCategoryByName";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeName";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCategoryByName";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isValidRawToken";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 31: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class LazyData {
        static final TokenClasses ourClasses = new TokenClasses(ExaTokens.class);
        static final SqlLanguageDialectEx.BuiltinFunctions ourFunctionMap = new SqlLanguageDialectEx.BuiltinFunctionsMap(SqlFunctionsUtil.loadFunctionDefinition(INSTANCE));
        static final NullableFunction<String, IElementType> ourReservedTokens;
        static Set<String> ourKeywords;
        static Set<String> ourReservedKeywords;
        static final Set<IElementType> ourSupportedOperators;
        static final TokenSet ourClosingTokens;

        LazyData() {
        }

        static {
            SqlLexer.initTokens(ourFunctionMap, ourClasses);
            ourReservedTokens = SqlTokenRegistry.getTokenProvider((Class)LazyData.ourClasses.reserved);
            ourKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.all);
            ourReservedKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.reserved);
            ourSupportedOperators = ContainerUtil.newTroveSet((Object[])new IElementType[]{SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_NEQ2, SqlTokens.SQL_OP_NEQ3, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQ, SqlTokens.SQL_OP_GT, SqlTokens.SQL_OP_CONCAT, SqlTokens.SQL_AND, SqlTokens.SQL_NOT, SqlTokens.SQL_OR, SqlTokens.SQL_IS, SqlTokens.SQL_LIKE, SqlTokens.SQL_IN, SqlTokens.SQL_INTERVAL, SqlTokens.SQL_SECOND, SqlTokens.SQL_MINUTE, SqlTokens.SQL_HOUR, SqlTokens.SQL_DAY, SqlTokens.SQL_MONTH, SqlTokens.SQL_YEAR});
            ourClosingTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{SqlTokens.STATEMENT_SEPARATORS, TokenSet.create((IElementType[])new IElementType[]{SqlTokens.SQL_OP_DIV})});
        }
    }
}

