/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.model.DataType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.oracle.OraDialect;
import com.intellij.sql.dialects.oraplus.OraPlusDialect;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlTypeElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SqlDeprecateTypeInspection
extends SqlInspectionBase {
    @Override
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, final boolean onTheFly) {
        if (dialect == null) {
            SqlDeprecateTypeInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SqlDeprecateTypeInspection.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            SqlDeprecateTypeInspection.$$$reportNull$$$0(2);
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2){

            public void visitSqlTypeElement(SqlTypeElement o) {
                DataType dataType = o.getDataType();
                if ((this.myDialect == OraDialect.INSTANCE || this.myDialect == OraPlusDialect.INSTANCE) && StringUtil.equalsIgnoreCase((CharSequence)dataType.getSpecification(), (CharSequence)"long")) {
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)o, "The 'long' type is deprecated. Use LOB columns (CLOB, NCLOB, BLOB) instead.", (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "dialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/dialects/oracle/inspections/SqlDeprecateTypeInspection";
        objectArray[2] = "createAnnotationVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

