/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres;

import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.postgres.PgDialect;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlFunctionCallExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PgDialectBase
extends SqlLanguageDialectEx {
    @Override
    protected void addTypes(Map<String, SqlFunctionDefinition.Type> myTypes) {
        super.addTypes(myTypes);
        SqlFunctionDefinition.addSimpleType(myTypes, "dpn", "double precision", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "bigint", "bigint", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "numeric", "numeric", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "dp", "double precision", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "bytea", "bytea", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "name", "name", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "oid", "oid", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "gobject", "geometric object", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "circle", "circle", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "path", "path", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "box", "box", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "polygon", "polygon", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "lseg", "lseg", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "point", "point", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "line", "line", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "cidr", "cidr", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "inet", "inet", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "macaddr", "macaddr", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "tsvector", "tsvector", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "tsquery", "tsquery", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "trigger", "trigger", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "range", "range", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "txid_snapshot", "txid_snapshot", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "void", "void", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "record", "record", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "enum", "enum", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "xml", "xml", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "float4", "float4", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "int2vector", "int2vector", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "json", "json", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "jsonb", "jsonb", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "regclass", "regclass", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "regdictionary", "regdictionary", (SqlLanguageDialectEx)this);
    }

    public PgDialectBase(@NotNull String id) {
        if (id == null) {
            PgDialectBase.$$$reportNull$$$0(0);
        }
        super(id);
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement element2, boolean resolve, @NotNull SqlScopeProcessor processor) {
        SqlFunctionDefinition definition;
        SqlReferenceExpression ref;
        if (element2 == null) {
            PgDialectBase.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            PgDialectBase.$$$reportNull$$$0(2);
        }
        SqlExpression qualifier = (ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)element2, SqlReferenceExpression.class)) == null ? null : ref.getQualifierExpression();
        boolean isFunctionCall = element2.getParent() instanceof SqlFunctionCallExpression;
        SqlFunctionDefinition sqlFunctionDefinition = definition = name2 == null || qualifier == null || isFunctionCall ? null : this.getSupportedFunctions().get(name2);
        if (definition != null) {
            for (SqlFunctionDefinition.Prototype prototype : definition.getPrototypes()) {
                SqlType type;
                if (prototype.getParams().length != 1 || processor.executeTarget((DasObject)definition, (PsiElement)ref, type = SqlFunctionCallExpressionImpl.createBuiltinFunctionReturnType(prototype, ref, (PsiElement)qualifier, (PsiElement)ref), null, ResolveState.initial())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @Nullable
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            PgDialectBase.$$$reportNull$$$0(3);
        }
        switch (cat) {
            case INTEGER: {
                return "integer";
            }
            case REAL: {
                return "numeric";
            }
            case STRING: {
                return "text";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case DATE_TIME: {
                return "date";
            }
            case DATE: {
                return "date";
            }
            case TIME: {
                return "time";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case INTERVAL: {
                return "interval";
            }
            case BYTES: {
                return "bytea";
            }
            case ARRAY: {
                return "anyarray";
            }
            case TABLE: {
                return "anyarray";
            }
            case RECORD: {
                return "record";
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getNormalizedTypeName(@NotNull String name2) {
        if (name2 == null) {
            PgDialectBase.$$$reportNull$$$0(4);
        }
        if ((name2 = super.getNormalizedTypeName(name2)).endsWith("[]")) {
            String string = this.getNormalizedTypeName(name2.substring(0, name2.length() - 2)) + "[]";
            if (string == null) {
                PgDialectBase.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (name2.equals("int8")) {
            if ("bigint" == null) {
                PgDialectBase.$$$reportNull$$$0(6);
            }
            return "bigint";
        }
        if (name2.equals("serial8")) {
            if ("bigserial" == null) {
                PgDialectBase.$$$reportNull$$$0(7);
            }
            return "bigserial";
        }
        if (name2.equals("bool")) {
            if ("boolean" == null) {
                PgDialectBase.$$$reportNull$$$0(8);
            }
            return "boolean";
        }
        if (name2.equals("character varying")) {
            if ("varchar" == null) {
                PgDialectBase.$$$reportNull$$$0(9);
            }
            return "varchar";
        }
        if (name2.equals("float8")) {
            if ("double precision" == null) {
                PgDialectBase.$$$reportNull$$$0(10);
            }
            return "double precision";
        }
        if (name2.equals("int4")) {
            if ("integer" == null) {
                PgDialectBase.$$$reportNull$$$0(11);
            }
            return "integer";
        }
        if (name2.equals("int")) {
            if ("integer" == null) {
                PgDialectBase.$$$reportNull$$$0(12);
            }
            return "integer";
        }
        if (name2.equals("decimal")) {
            if ("numeric" == null) {
                PgDialectBase.$$$reportNull$$$0(13);
            }
            return "numeric";
        }
        if (name2.equals("float4")) {
            if ("real" == null) {
                PgDialectBase.$$$reportNull$$$0(14);
            }
            return "real";
        }
        if (name2.equals("int2")) {
            if ("smallint" == null) {
                PgDialectBase.$$$reportNull$$$0(15);
            }
            return "smallint";
        }
        if (name2.equals("serial4")) {
            if ("serial" == null) {
                PgDialectBase.$$$reportNull$$$0(16);
            }
            return "serial";
        }
        if (name2.equals("serial2")) {
            if ("smallserial" == null) {
                PgDialectBase.$$$reportNull$$$0(17);
            }
            return "smallserial";
        }
        String string = name2;
        if (string == null) {
            PgDialectBase.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Override
    @NotNull
    public DataType normalizeType(@NotNull DataType type) {
        if (type == null) {
            PgDialectBase.$$$reportNull$$$0(19);
        }
        if ("without time zone".equalsIgnoreCase(type.suffix)) {
            DataType dataType = DataTypeFactory.of(type.schemaName, this.getNormalizedTypeName(type.typeName), type.size, type.scale, type.sizeUnit, null, type.sizeUnitExplicit, type.custom, type.jdbcType);
            if (dataType == null) {
                PgDialectBase.$$$reportNull$$$0(20);
            }
            return dataType;
        }
        DataType dataType = super.normalizeType(type);
        if (dataType == null) {
            PgDialectBase.$$$reportNull$$$0(21);
        }
        return dataType;
    }

    @Override
    @NotNull
    public SqlType.Category getTypeCategoryByName(@NotNull String typeName) {
        if (typeName == null) {
            PgDialectBase.$$$reportNull$$$0(22);
        }
        if (typeName.equals("record")) {
            SqlType.Category category = SqlType.Category.RECORD;
            if (category == null) {
                PgDialectBase.$$$reportNull$$$0(23);
            }
            return category;
        }
        if (typeName.equals("setof")) {
            SqlType.Category category = SqlType.Category.SETOF;
            if (category == null) {
                PgDialectBase.$$$reportNull$$$0(24);
            }
            return category;
        }
        if (typeName.endsWith("[]")) {
            SqlType.Category category = SqlType.Category.ARRAY;
            if (category == null) {
                PgDialectBase.$$$reportNull$$$0(25);
            }
            return category;
        }
        SqlType.Category category = super.getTypeCategoryByName(typeName);
        if (category == null) {
            PgDialectBase.$$$reportNull$$$0(26);
        }
        return category;
    }

    @Override
    public boolean processUnqualifiedResolve(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state2, @NotNull PsiReference ref) {
        if (processor == null) {
            PgDialectBase.$$$reportNull$$$0(27);
        }
        if (state2 == null) {
            PgDialectBase.$$$reportNull$$$0(28);
        }
        if (ref == null) {
            PgDialectBase.$$$reportNull$$$0(29);
        }
        PsiElement place = ref.getElement();
        if (processor.isExpected(ObjectKind.ROUTINE)) {
            List exprs;
            SqlFunctionCallExpression callExpression = (SqlFunctionCallExpression)ObjectUtils.tryCast((Object)place.getParent(), SqlFunctionCallExpression.class);
            SqlExpressionList params = callExpression == null ? null : callExpression.getParameterList();
            List list = exprs = params == null ? Collections.emptyList() : params.getExpressionList();
            if (exprs.size() == 1) {
                SqlTableType type = (SqlTableType)ObjectUtils.tryCast((Object)((SqlExpression)exprs.get(0)).getSqlType(), SqlTableType.class);
                if (type == null) {
                    return true;
                }
                Set<ObjectKind> expected = processor.getInitialExpectedTypes();
                processor.handleEvent(SqlScopeProcessor.EXPECTED_TYPE, Collections.singleton(ObjectKind.COLUMN));
                boolean res2 = SqlImplUtil.processDeclarationsInType(type, (PsiScopeProcessor)processor, state2, place);
                processor.handleEvent(SqlScopeProcessor.EXPECTED_TYPE, expected);
                if (!res2) {
                    return false;
                }
            }
        }
        return super.processUnqualifiedResolve(processor, state2, ref);
    }

    @Override
    public boolean processQualifiedResolve(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state2, @NotNull PsiReference ref, @NotNull SqlExpression qualifier) {
        if (processor == null) {
            PgDialectBase.$$$reportNull$$$0(30);
        }
        if (state2 == null) {
            PgDialectBase.$$$reportNull$$$0(31);
        }
        if (ref == null) {
            PgDialectBase.$$$reportNull$$$0(32);
        }
        if (qualifier == null) {
            PgDialectBase.$$$reportNull$$$0(33);
        }
        if (!processor.isExpected(ObjectKind.COLUMN)) {
            return true;
        }
        if (processor.referenceName == null && qualifier.getSqlType() == SqlType.UNKNOWN) {
            return true;
        }
        if (qualifier.getSqlType().getCategory() == SqlType.Category.RECORD) {
            return processor.executeTarget(null, ref.getElement(), (SqlType)SqlType.UNKNOWN, false, state2);
        }
        SqlScopeProcessor filteringProcessor = PgDialectBase.filterSingleArgumentRoutines(processor);
        SqlReferenceImpl refImpl = (SqlReferenceImpl)ObjectUtils.tryCast((Object)ref, SqlReferenceImpl.class);
        if (refImpl != null && !refImpl.processUnqualifiedResolveVariants(filteringProcessor, ResolveState.initial())) {
            return false;
        }
        return super.processQualifiedResolve(processor, state2, ref, qualifier);
    }

    @Override
    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type) {
        if (type == ObjectKind.COLUMN) {
            result2.add((ObjectKind)ObjectKind.COLUMN);
        }
        return super.getParentDbTypes(result2, type);
    }

    public boolean isResolveTargetAccepted(@Nullable PsiElement element2, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            PgDialectBase.$$$reportNull$$$0(34);
        }
        if (strict) {
            return false;
        }
        if (type == ObjectKind.COLUMN && expectedTypes.contains(ObjectKind.VARIABLE)) {
            return true;
        }
        if (type == ObjectKind.AGGREGATE && expectedTypes.contains(ObjectKind.ROUTINE)) {
            return true;
        }
        if (ModelConsts.TABLE_OR_VIEW_KINDS.contains(type) && expectedTypes.contains(ObjectKind.OBJECT_TYPE)) {
            return true;
        }
        if (expectedTypes.contains(ObjectKind.COLUMN) && type == ObjectKind.ROUTINE) {
            if (place instanceof SqlReferenceExpression) {
                return ((SqlReferenceExpression)place).getQualifierExpression() != null;
            }
            return true;
        }
        return super.isResolveTargetAccepted(element2, type, expectedTypes, place, strict, isCompletion);
    }

    @NotNull
    private static SqlScopeProcessor filterSingleArgumentRoutines(final SqlScopeProcessor sqlProcessor) {
        SqlScopeProcessor processor = new SqlScopeProcessor(sqlProcessor.referenceName, sqlProcessor.dialect, sqlProcessor.dataSources, sqlProcessor.place){

            @Override
            public boolean isResultEmpty() {
                return sqlProcessor.isResultEmpty();
            }

            @Override
            public boolean executeTarget(@Nullable DasObject target2, @NotNull PsiElement element2, @Nullable SqlType sqlType, @Nullable Boolean forcedCaseSens, @NotNull ResolveState state2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return !SqlFunctionsUtil.isSingleArgumentRoutine(target2) || sqlProcessor.executeTarget(target2, element2, sqlType, forcedCaseSens, state2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/dialects/postgres/PgDialectBase$1";
                objectArray[2] = "executeTarget";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        processor.handleEvent(SqlScopeProcessor.EXPECTED_TYPE, Collections.singleton(ObjectKind.ROUTINE));
        SqlScopeProcessor sqlScopeProcessor = processor;
        if (sqlScopeProcessor == null) {
            PgDialectBase.$$$reportNull$$$0(35);
        }
        return sqlScopeProcessor;
    }

    @Override
    @NotNull
    public TreePattern forcedContextPattern(@Nullable DbDataSource dataSource, @Nullable SearchPath searchPath) {
        Couple<ObjectName> scAndDb = PgDialectBase.getScAndDb(dataSource);
        TreePatternNode.Group[] schemas2 = SqlImportUtil.optAr(TreePatternUtils.create((ObjectName)scAndDb.first, ObjectKind.SCHEMA, new TreePatternNode.Group[0]));
        TreePattern treePattern = this.applyImplicitImports(SqlImportUtil.getRealDsNames(dataSource), SqlDialectImplUtil.forcedContextExpandedToSchemas(dataSource, this.getDbms(), searchPath, schemas2, SqlImportUtil.optAr(TreePatternUtils.create((ObjectName)scAndDb.second, ObjectKind.DATABASE, schemas2))));
        if (treePattern == null) {
            PgDialectBase.$$$reportNull$$$0(36);
        }
        return treePattern;
    }

    @Override
    public boolean isValidRawToken(@NotNull IElementType type, @NotNull CharSequence text2) {
        if (type == null) {
            PgDialectBase.$$$reportNull$$$0(37);
        }
        if (text2 == null) {
            PgDialectBase.$$$reportNull$$$0(38);
        }
        return SqlLexer.isValidRawCopyToken(text2);
    }

    private static Couple<ObjectName> getScAndDb(@Nullable DbDataSource dataSource) {
        ObjectName dbName = PgDialectBase.getDbName(dataSource);
        ObjectName scName = null;
        DasNamespace namespace = PgDialectBase.getDefaultNamespace(dataSource, dbName);
        if (namespace != null) {
            DasObject parent2;
            if (namespace.getKind() == ObjectKind.SCHEMA) {
                scName = ObjectName.quoted((String)namespace.getName());
            }
            if ((parent2 = namespace.getDasParent()) != null && parent2.getKind() == ObjectKind.DATABASE) {
                dbName = ObjectName.quoted((String)parent2.getName());
            }
        }
        if (scName == null) {
            scName = PgDialect.LazyData.PUBLIC_NAME;
        }
        return Couple.of((Object)scName, (Object)dbName);
    }

    @Nullable
    protected static ObjectName getDbName(@Nullable DbDataSource dataSource) {
        RawConnectionConfig config = SqlImportUtil.getConnectionConfig(dataSource);
        return ObjectName.plain((String)((String)ObjectUtils.chooseNotNull((Object)SqlDialectImplUtil.getDatabaseName(config), (Object)SqlDialectImplUtil.getUserName(config))));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 35: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 35: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/postgres/PgDialectBase";
                break;
            }
            case 19: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/postgres/PgDialectBase";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeName";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeType";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeCategoryByName";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "filterSingleArgumentRoutines";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "forcedContextPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeName";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 35: 
            case 36: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "normalizeType";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCategoryByName";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processUnqualifiedResolve";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processQualifiedResolve";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isValidRawToken";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 35: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

