/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.snowflake;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dataFlow.DFABuildingVisitor;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.base.TokenClasses;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.snowflake.SFlakeElementTypes;
import com.intellij.sql.dialects.snowflake.SFlakeTokens;
import com.intellij.sql.dialects.snowflake.dataFlow.SFlakeDFABuildingVisitor;
import com.intellij.sql.dialects.snowflake.refactoring.SFlakeExtractFunctionHelper;
import com.intellij.sql.editor.SqlCloseBlockProcessor;
import com.intellij.sql.editor.SqlEnterHandlerImpl;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SFlakeDialect
extends SqlLanguageDialectEx {
    public static final SFlakeDialect INSTANCE = new SFlakeDialect();

    public SFlakeDialect() {
        super("Snowflake");
    }

    @Override
    protected void addTypes(Map<String, SqlFunctionDefinition.Type> myTypes) {
        super.addTypes(myTypes);
        SqlFunctionDefinition.addSimpleType(myTypes, "variant", "variant", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "object", "object", (SqlLanguageDialectEx)this);
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.SNOWFLAKE;
        if (dbms == null) {
            SFlakeDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    @Override
    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type) {
        T types = super.getParentDbTypes(result2, type);
        if (type == SFlakeElementTypes.Kinds.SHARE) {
            types.add((ObjectKind)SFlakeElementTypes.Kinds.ACCOUNT);
        }
        return types;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    @Override
    @NotNull
    public SqlLanguageDialectEx.BuiltinFunctions getSupportedFunctions() {
        SqlLanguageDialectEx.BuiltinFunctions builtinFunctions = LazyData.ourFunctionMap;
        if (builtinFunctions == null) {
            SFlakeDialect.$$$reportNull$$$0(1);
        }
        return builtinFunctions;
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set<String> set = LazyData.ourKeywords;
        if (set == null) {
            SFlakeDialect.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Set<String> getReservedKeywords() {
        Set<String> set = LazyData.ourReservedKeywords;
        if (set == null) {
            SFlakeDialect.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            SFlakeDialect.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Override
    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    @Override
    public boolean shouldWrap(SqlDefinition o, ObjectKind kind) {
        return kind == SFlakeElementTypes.Kinds.ACCOUNT || super.shouldWrap(o, kind);
    }

    @Override
    @NotNull
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            SFlakeDialect.$$$reportNull$$$0(5);
        }
        switch (cat) {
            case INTEGER: {
                if ("integer" == null) {
                    SFlakeDialect.$$$reportNull$$$0(6);
                }
                return "integer";
            }
            case BOOLEAN: {
                if ("boolean" == null) {
                    SFlakeDialect.$$$reportNull$$$0(7);
                }
                return "boolean";
            }
            case REAL: {
                if ("float" == null) {
                    SFlakeDialect.$$$reportNull$$$0(8);
                }
                return "float";
            }
            case STRING: {
                if ("varchar" == null) {
                    SFlakeDialect.$$$reportNull$$$0(9);
                }
                return "varchar";
            }
            case BYTES: {
                if ("binary" == null) {
                    SFlakeDialect.$$$reportNull$$$0(10);
                }
                return "binary";
            }
            case ARRAY: {
                if ("array" == null) {
                    SFlakeDialect.$$$reportNull$$$0(11);
                }
                return "array";
            }
            case DATE_TIME: 
            case TIMESTAMP: {
                if ("timestamp" == null) {
                    SFlakeDialect.$$$reportNull$$$0(12);
                }
                return "timestamp";
            }
            case DATE: {
                if ("date" == null) {
                    SFlakeDialect.$$$reportNull$$$0(13);
                }
                return "date";
            }
            case TIME: {
                if ("time" == null) {
                    SFlakeDialect.$$$reportNull$$$0(14);
                }
                return "time";
            }
            case COLLECTION: {
                if ("array" == null) {
                    SFlakeDialect.$$$reportNull$$$0(15);
                }
                return "array";
            }
            case RECORD: {
                if ("object" == null) {
                    SFlakeDialect.$$$reportNull$$$0(16);
                }
                return "object";
            }
        }
        if ("variant" == null) {
            SFlakeDialect.$$$reportNull$$$0(17);
        }
        return "variant";
    }

    @Override
    @NotNull
    public SqlType.Category getTypeCategoryByName(@NotNull String typeName) {
        if (typeName == null) {
            SFlakeDialect.$$$reportNull$$$0(18);
        }
        if (StringUtil.containsIgnoreCase((String)typeName, (String)"string")) {
            SqlType.Category category = SqlType.Category.STRING;
            if (category == null) {
                SFlakeDialect.$$$reportNull$$$0(19);
            }
            return category;
        }
        if (StringUtil.containsIgnoreCase((String)typeName, (String)"bit")) {
            SqlType.Category category = SqlType.Category.BYTES;
            if (category == null) {
                SFlakeDialect.$$$reportNull$$$0(20);
            }
            return category;
        }
        if (StringUtil.containsIgnoreCase((String)typeName, (String)"dec")) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                SFlakeDialect.$$$reportNull$$$0(21);
            }
            return category;
        }
        if (StringUtil.containsIgnoreCase((String)typeName, (String)"numeric")) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                SFlakeDialect.$$$reportNull$$$0(22);
            }
            return category;
        }
        if (StringUtil.containsIgnoreCase((String)typeName, (String)"timestamp")) {
            SqlType.Category category = SqlType.Category.TIMESTAMP;
            if (category == null) {
                SFlakeDialect.$$$reportNull$$$0(23);
            }
            return category;
        }
        if (StringUtil.containsIgnoreCase((String)typeName, (String)"array")) {
            SqlType.Category category = SqlType.Category.ARRAY;
            if (category == null) {
                SFlakeDialect.$$$reportNull$$$0(24);
            }
            return category;
        }
        if (StringUtil.containsIgnoreCase((String)typeName, (String)"object")) {
            SqlType.Category category = SqlType.Category.RECORD;
            if (category == null) {
                SFlakeDialect.$$$reportNull$$$0(25);
            }
            return category;
        }
        SqlType.Category category = super.getTypeCategoryByName(typeName);
        if (category == null) {
            SFlakeDialect.$$$reportNull$$$0(26);
        }
        return category;
    }

    @Override
    @NotNull
    public String getNormalizedTypeName(@NotNull String name2) {
        if (name2 == null) {
            SFlakeDialect.$$$reportNull$$$0(27);
        }
        String string = super.getNormalizedTypeName(this.getDefaultTypeName(this.getTypeCategoryByName(name2)));
        if (string == null) {
            SFlakeDialect.$$$reportNull$$$0(28);
        }
        return string;
    }

    @Override
    @NotNull
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource, @Nullable ObjectName[] dsNames) {
        JdbcUrlParser params = SqlDialectImplUtil.getParsed(SqlImportUtil.getConnectionConfig(dataSource));
        ObjectName dbName = params == null ? null : ObjectName.plain((String)StringUtil.nullize((String)params.getParameter("database")));
        ObjectName scName = (ObjectName)ObjectUtils.chooseNotNull(params == null ? null : ObjectName.plain((String)StringUtil.nullize((String)params.getParameter("schema"))), (Object)LazyData.PUBLIC_NAME);
        DasNamespace curDb = SFlakeDialect.getDefaultTopNamespace(dataSource, dbName);
        DasNamespace curSc = SFlakeDialect.getDefaultSubNamespace(curDb, scName);
        if (curSc != null) {
            TreePattern treePattern = SqlDialectImplUtil.createObjectPattern(dsNames, (DasObject)curSc, new TreePatternNode.Group[0]);
            if (treePattern == null) {
                SFlakeDialect.$$$reportNull$$$0(29);
            }
            return treePattern;
        }
        if (curDb != null) {
            TreePattern treePattern = SqlDialectImplUtil.createObjectPattern(dsNames, (DasObject)curDb, TreePatternUtils.create(scName, ObjectKind.SCHEMA, new TreePatternNode.Group[0]));
            if (treePattern == null) {
                SFlakeDialect.$$$reportNull$$$0(30);
            }
            return treePattern;
        }
        TreePattern treePattern = new TreePattern(SqlImportUtil.createDataSources(dsNames, SqlImportUtil.optAr(SqlImportUtil.createPositiveDatabase(dataSource == null, dbName, TreePatternUtils.create(scName, ObjectKind.SCHEMA, new TreePatternNode.Group[0])))));
        if (treePattern == null) {
            SFlakeDialect.$$$reportNull$$$0(31);
        }
        return treePattern;
    }

    @Override
    @NotNull
    public TreePattern applyImplicitImports(@Nullable ObjectName[] dsNames, @NotNull TreePattern pattern) {
        if (pattern == null) {
            SFlakeDialect.$$$reportNull$$$0(32);
        }
        TreePattern treePattern = SqlImportUtil.addObjectsByPath(pattern, dsNames, Collections.singletonList(LazyData.PUBLIC_NAME), false, SqlImportUtil.DATA_SOURCE, ObjectKind.DATABASE, ObjectKind.SCHEMA);
        if (treePattern == null) {
            SFlakeDialect.$$$reportNull$$$0(33);
        }
        return treePattern;
    }

    @Override
    protected TreePattern createRefPattern(@NotNull TreePattern prev, @NotNull SqlReferenceExpression ref) {
        TreePattern dbPattern;
        ObjectKind refKind;
        if (prev == null) {
            SFlakeDialect.$$$reportNull$$$0(34);
        }
        if (ref == null) {
            SFlakeDialect.$$$reportNull$$$0(35);
        }
        boolean isDb = (refKind = ref.getReferenceElementType().getTargetKind()) == ObjectKind.DATABASE;
        boolean isSc = refKind == ObjectKind.SCHEMA || refKind == SqlDbElementType.ANY && ref.getQualifierExpression() != null;
        TreePattern scPattern = isDb ? null : SqlImportUtil.createRefPattern(ref, ObjectKind.SCHEMA, this.getDbms());
        TreePattern treePattern = dbPattern = isSc ? null : this.createDbRefPattern(prev, ref);
        if (isSc) {
            return scPattern;
        }
        if (isDb) {
            return dbPattern;
        }
        return TreePatternUtils.union(dbPattern, scPattern);
    }

    @Nullable
    private TreePattern createDbRefPattern(@NotNull TreePattern prev, @NotNull SqlReferenceExpression ref) {
        if (prev == null) {
            SFlakeDialect.$$$reportNull$$$0(36);
        }
        if (ref == null) {
            SFlakeDialect.$$$reportNull$$$0(37);
        }
        return SqlDialectImplUtil.refPatternExpandedToSchema(prev, ref, this);
    }

    @Override
    @Nullable
    public EnterHandlerDelegate getEnterHandler() {
        return LazyData.ENTER_HANDLER;
    }

    @Override
    @NotNull
    public DFABuildingVisitor createDFAVisitor() {
        SFlakeDFABuildingVisitor sFlakeDFABuildingVisitor = new SFlakeDFABuildingVisitor(this);
        if (sFlakeDFABuildingVisitor == null) {
            SFlakeDialect.$$$reportNull$$$0(38);
        }
        return sFlakeDFABuildingVisitor;
    }

    @Override
    @Nullable
    public SqlExtractFunctionHelper getExtractFunctionHelper() {
        return SFlakeExtractFunctionHelper.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 18: 
            case 27: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 18: 
            case 27: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/snowflake/SFlakeDialect";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prev";
                break;
            }
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFunctions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedKeywords";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 5: 
            case 18: 
            case 27: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/snowflake/SFlakeDialect";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTypeName";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeCategoryByName";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeName";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "applyImplicitImports";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "createDFAVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCategoryByName";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeName";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "applyImplicitImports";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createRefPattern";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createDbRefPattern";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 18: 
            case 27: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class LazyData {
        static final TokenClasses ourClasses = new TokenClasses(SFlakeTokens.class);
        static final SqlLanguageDialectEx.BuiltinFunctions ourFunctionMap = new SqlLanguageDialectEx.BuiltinFunctionsMap(SqlFunctionsUtil.loadFunctionDefinition(INSTANCE));
        static final NullableFunction<String, IElementType> ourReservedTokens;
        static Set<String> ourKeywords;
        static Set<String> ourReservedKeywords;
        static final Set<IElementType> ourSupportedOperators;
        static final TokenSet ourClosingTokens;
        static final ObjectName PUBLIC_NAME;
        private static final EnterHandlerDelegate ENTER_HANDLER;

        LazyData() {
        }

        static {
            SqlLexer.initTokens(ourFunctionMap, ourClasses);
            ourReservedTokens = SqlTokenRegistry.getTokenProvider((Class)LazyData.ourClasses.reserved);
            ourKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.all);
            ourReservedKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.reserved);
            ourSupportedOperators = ContainerUtil.newTroveSet((Object[])new IElementType[]{SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQ, SqlTokens.SQL_OP_GT, SqlTokens.SQL_OP_CONCAT, SqlTokens.SQL_AND, SqlTokens.SQL_NOT, SqlTokens.SQL_OR, SqlTokens.SQL_IS, SqlTokens.SQL_LIKE, SqlTokens.SQL_COLLATE, SqlTokens.SQL_IN, SqlTokens.SQL_OP_INVERT, SqlTokens.SQL_OP_BITWISE_AND, SqlTokens.SQL_OP_BITWISE_OR, SqlTokens.SQL_OP_LEFT_SHIFT, SqlTokens.SQL_OP_RIGHT_SHIFT, SqlTokens.SQL_OP_MODULO, SqlTokens.SQL_OP_NEQ2, SqlTokens.SQL_OP_EQEQ});
            ourClosingTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{SqlTokens.STATEMENT_SEPARATORS, TokenSet.create((IElementType[])new IElementType[]{SqlTokens.SQL_OP_DIV})});
            PUBLIC_NAME = ObjectName.quoted((String)"PUBLIC");
            ENTER_HANDLER = new SqlEnterHandlerImpl(new SqlCloseBlockProcessor[0]);
        }
    }
}

