/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.CodeInsightAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.CompleteMacro;
import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.lang.InjectableLanguage;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlGenerateGroup
extends ActionGroup
implements DumbAware {
    private static final AnAction[] ACTIONS = new AnAction[]{new OraclePackage(), new OraclePackageBody(), new Function(), new Procedure(), new Block(), new Trigger(), new View(), new MaterializedView(), new Schema(), new Database()};

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        if (ACTIONS == null) {
            SqlGenerateGroup.$$$reportNull$$$0(0);
        }
        return ACTIONS;
    }

    private static boolean onTopLevel(@Nullable PsiElement element2) {
        return SyntaxTraverser.psiApi().parents((Object)element2).skip(1).filter(SqlStatement.class).isEmpty();
    }

    @NotNull
    private static Pair<String, Expression> constantNodeKeyValuePair(@NotNull String key2, @NotNull String value) {
        if (key2 == null) {
            SqlGenerateGroup.$$$reportNull$$$0(1);
        }
        if (value == null) {
            SqlGenerateGroup.$$$reportNull$$$0(2);
        }
        Pair pair = Pair.create((Object)key2, (Object)new ConstantNode(value));
        if (pair == null) {
            SqlGenerateGroup.$$$reportNull$$$0(3);
        }
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/editor/SqlGenerateGroup";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/editor/SqlGenerateGroup";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "constantNodeKeyValuePair";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "constantNodeKeyValuePair";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyResult
    extends TextResult {
        private final Result myDelegate;

        private MyResult(@NotNull Result delegate, @NotNull String text2) {
            if (delegate == null) {
                MyResult.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                MyResult.$$$reportNull$$$0(1);
            }
            super(text2);
            this.myDelegate = delegate;
        }

        public void handleFocused(PsiFile psiFile, Document document, int segmentStart, int segmentEnd) {
            this.myDelegate.handleFocused(psiFile, document, segmentStart, segmentEnd);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/editor/SqlGenerateGroup$MyResult";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyNode
    extends MacroCallNode {
        private final String myValue;

        MyNode(@NotNull Macro macro, @NotNull String value) {
            if (macro == null) {
                MyNode.$$$reportNull$$$0(0);
            }
            if (value == null) {
                MyNode.$$$reportNull$$$0(1);
            }
            super(macro);
            this.myValue = value;
        }

        public Result calculateQuickResult(ExpressionContext context) {
            Result delegate = super.calculateQuickResult(context);
            return delegate == null ? null : new MyResult(delegate, this.myValue);
        }

        public Result calculateResult(ExpressionContext context) {
            Result delegate = super.calculateResult(context);
            return delegate == null ? null : new MyResult(delegate, this.myValue);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "macro";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "value";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/editor/SqlGenerateGroup$MyNode";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class OraclePackageBody
    extends Oracle {
        @Override
        @NotNull
        protected String getTemplateText(@NotNull SqlLanguageDialect language, @NotNull String delimiter) {
            if (language == null) {
                OraclePackageBody.$$$reportNull$$$0(0);
            }
            if (delimiter == null) {
                OraclePackageBody.$$$reportNull$$$0(1);
            }
            if ("CREATE OR REPLACE PACKAGE BODY $name$ AS\n  $END$\nEND $name$;\n/" == null) {
                OraclePackageBody.$$$reportNull$$$0(2);
            }
            return "CREATE OR REPLACE PACKAGE BODY $name$ AS\n  $END$\nEND $name$;\n/";
        }

        @Override
        @NotNull
        protected Map<String, Expression> getVariables(@NotNull SqlLanguageDialect dialect) {
            if (dialect == null) {
                OraclePackageBody.$$$reportNull$$$0(3);
            }
            LinkedHashMap linkedHashMap = ContainerUtil.newLinkedHashMap((Pair)SqlGenerateGroup.constantNodeKeyValuePair("name", "new_package"), (Pair[])new Pair[0]);
            if (linkedHashMap == null) {
                OraclePackageBody.$$$reportNull$$$0(4);
            }
            return linkedHashMap;
        }

        @Override
        @NotNull
        String getText(@Nullable DatabaseDialect dialect) {
            if ("Package body" == null) {
                OraclePackageBody.$$$reportNull$$$0(5);
            }
            return "Package body";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delimiter";
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/editor/SqlGenerateGroup$OraclePackageBody";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialect";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/editor/SqlGenerateGroup$OraclePackageBody";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTemplateText";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariables";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getTemplateText";
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getVariables";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class OraclePackage
    extends Oracle {
        @Override
        @NotNull
        protected String getTemplateText(@NotNull SqlLanguageDialect language, @NotNull String delimiter) {
            if (language == null) {
                OraclePackage.$$$reportNull$$$0(0);
            }
            if (delimiter == null) {
                OraclePackage.$$$reportNull$$$0(1);
            }
            if ("CREATE OR REPLACE PACKAGE $name$ AS\n  $END$ \nEND $name$;\n/" == null) {
                OraclePackage.$$$reportNull$$$0(2);
            }
            return "CREATE OR REPLACE PACKAGE $name$ AS\n  $END$ \nEND $name$;\n/";
        }

        @Override
        @NotNull
        protected Map<String, Expression> getVariables(@NotNull SqlLanguageDialect dialect) {
            if (dialect == null) {
                OraclePackage.$$$reportNull$$$0(3);
            }
            LinkedHashMap linkedHashMap = ContainerUtil.newLinkedHashMap((Pair)SqlGenerateGroup.constantNodeKeyValuePair("name", "new_package"), (Pair[])new Pair[0]);
            if (linkedHashMap == null) {
                OraclePackage.$$$reportNull$$$0(4);
            }
            return linkedHashMap;
        }

        @Override
        @NotNull
        String getText(@Nullable DatabaseDialect dialect) {
            if ("Package" == null) {
                OraclePackage.$$$reportNull$$$0(5);
            }
            return "Package";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delimiter";
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/editor/SqlGenerateGroup$OraclePackage";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialect";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/editor/SqlGenerateGroup$OraclePackage";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTemplateText";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariables";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getTemplateText";
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getVariables";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static abstract class Oracle
    extends GenerateActionBase {
        Oracle() {
        }

        @Override
        protected boolean isSqlDialectSupported(@NotNull SqlLanguageDialect dialect) {
            if (dialect == null) {
                Oracle.$$$reportNull$$$0(0);
            }
            return dialect.getDbms().isOracle();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/editor/SqlGenerateGroup$Oracle", "isSqlDialectSupported"));
        }
    }

    public static class Block
    extends GenerateActionBase {
        @Override
        protected String getTemplateText(@NotNull SqlLanguageDialect dialect, @NotNull String delimiter) {
            Dbms dbms;
            if (dialect == null) {
                Block.$$$reportNull$$$0(0);
            }
            if (delimiter == null) {
                Block.$$$reportNull$$$0(1);
            }
            if ((dbms = dialect.getDbms()).isOracle() || dbms.isDb2() || dbms.isMicrosoft() || dbms.isSybase() || dbms.isPostgres() && dialect instanceof InjectableLanguage) {
                return "BEGIN\n  $END$\nEND" + delimiter;
            }
            return null;
        }

        @Override
        @NotNull
        protected Map<String, Expression> getVariables(@NotNull SqlLanguageDialect dialect) {
            if (dialect == null) {
                Block.$$$reportNull$$$0(2);
            }
            HashMap<String, Expression> hashMap = new HashMap<String, Expression>();
            if (hashMap == null) {
                Block.$$$reportNull$$$0(3);
            }
            return hashMap;
        }

        @Override
        @NotNull
        String getText(@Nullable DatabaseDialect dialect) {
            if ("Block" == null) {
                Block.$$$reportNull$$$0(4);
            }
            return "Block";
        }

        @Override
        protected boolean isInContext(@Nullable PsiElement element2) {
            return super.isInContext(element2) || !SyntaxTraverser.psiApi().parents((Object)element2).filter(SqlBlockStatementImpl.class).isEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialect";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delimiter";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/editor/SqlGenerateGroup$Block";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/editor/SqlGenerateGroup$Block";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariables";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getTemplateText";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getVariables";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Procedure
    extends GenerateActionBase {
        @Override
        protected String getTemplateText(@NotNull SqlLanguageDialect language, @NotNull String delimiter) {
            Dbms dbms;
            if (language == null) {
                Procedure.$$$reportNull$$$0(0);
            }
            if (delimiter == null) {
                Procedure.$$$reportNull$$$0(1);
            }
            if ((dbms = language.getDbms()).isOracle()) {
                return "CREATE OR REPLACE PROCEDURE $name$() AS\nBEGIN\n  $END$\nEND;\n/";
            }
            if (dbms.isMysql() || dbms.isDb2()) {
                return "CREATE PROCEDURE $name$()\nBEGIN\n  $END$\nEND" + delimiter;
            }
            if (dbms.isMicrosoft()) {
                return "CREATE PROCEDURE $name$ AS\nBEGIN\n  $END$\nEND\nGO";
            }
            if (dbms.isSybase()) {
                return "CREATE PROCEDURE $name$() AS\n  $END$\nGO";
            }
            if (dbms == Dbms.POSTGRES) {
                return "CREATE OR REPLACE PROCEDURE $name$()\nAS $$$$\nBEGIN\n  $END$\nEND;\n$$$$ LANGUAGE 'plpgsql';";
            }
            return null;
        }

        @Override
        @NotNull
        protected Map<String, Expression> getVariables(@NotNull SqlLanguageDialect dialect) {
            if (dialect == null) {
                Procedure.$$$reportNull$$$0(2);
            }
            LinkedHashMap linkedHashMap = ContainerUtil.newLinkedHashMap((Pair)SqlGenerateGroup.constantNodeKeyValuePair("name", "name"), (Pair[])new Pair[0]);
            if (linkedHashMap == null) {
                Procedure.$$$reportNull$$$0(3);
            }
            return linkedHashMap;
        }

        @Override
        @NotNull
        String getText(@Nullable DatabaseDialect dialect) {
            if ("Procedure" == null) {
                Procedure.$$$reportNull$$$0(4);
            }
            return "Procedure";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delimiter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialect";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/editor/SqlGenerateGroup$Procedure";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/editor/SqlGenerateGroup$Procedure";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariables";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getTemplateText";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getVariables";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Function
    extends GenerateActionBase {
        @Override
        @Nullable
        protected String getTemplateText(@NotNull SqlLanguageDialect language, @NotNull String delimiter) {
            Dbms dbms;
            if (language == null) {
                Function.$$$reportNull$$$0(0);
            }
            if (delimiter == null) {
                Function.$$$reportNull$$$0(1);
            }
            if ((dbms = language.getDbms()).isOracle()) {
                return "CREATE OR REPLACE FUNCTION $name$() RETURN $type$ AS\nBEGIN\n  $END$\nEND;\n/";
            }
            if (dbms.isPostgres()) {
                return "CREATE OR REPLACE FUNCTION $name$()\nRETURNS $type$ AS $$$$\nBEGIN\n  $END$\nEND;\n$$$$ LANGUAGE 'plpgsql';";
            }
            if (dbms.isMysql() || dbms.isDb2()) {
                return "CREATE FUNCTION $name$() RETURNS $type$\nBEGIN\n  $END$\nEND" + delimiter;
            }
            if (dbms.isMicrosoft()) {
                return "CREATE FUNCTION $name$() RETURNS $type$\nBEGIN\n  $END$\nEND\nGO";
            }
            if (dbms.isSybase()) {
                return "CREATE FUNCTION $name$() RETURNS $type$ AS \n  $END$\nGO";
            }
            if (dbms.isCassandra()) {
                return "CREATE OR REPLACE FUNCTION $name$()\nRETURNS NULL ON NULL INPUT\nRETURNS $type$\nLANGUAGE java\nAS $$$$ $END$ $$$$";
            }
            if (dbms.isHive() || dbms.isSpark()) {
                return "CREATE FUNCTION $name$ AS '$END$'";
            }
            return null;
        }

        @Override
        @NotNull
        protected Map<String, Expression> getVariables(@NotNull SqlLanguageDialect dialect) {
            if (dialect == null) {
                Function.$$$reportNull$$$0(2);
            }
            LinkedHashMap map2 = ContainerUtil.newLinkedHashMap((Pair)SqlGenerateGroup.constantNodeKeyValuePair("name", "name"), (Pair[])new Pair[0]);
            Dbms id = dialect.getDbms();
            if (!id.isHive() && !id.isSpark()) {
                map2.put("type", new ConstantNode("int"));
            }
            LinkedHashMap linkedHashMap = map2;
            if (linkedHashMap == null) {
                Function.$$$reportNull$$$0(3);
            }
            return linkedHashMap;
        }

        @Override
        @NotNull
        String getText(@Nullable DatabaseDialect dialect) {
            if ("Function" == null) {
                Function.$$$reportNull$$$0(4);
            }
            return "Function";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delimiter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialect";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/editor/SqlGenerateGroup$Function";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/editor/SqlGenerateGroup$Function";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariables";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getTemplateText";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getVariables";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Schema
    extends GenerateActionBase {
        @Override
        @Nullable
        protected String getTemplateText(@NotNull SqlLanguageDialect language, @NotNull String delimiter) {
            Dbms id;
            if (language == null) {
                Schema.$$$reportNull$$$0(0);
            }
            if (delimiter == null) {
                Schema.$$$reportNull$$$0(1);
            }
            if ((id = language.getDbms()).isOracle()) {
                return "CREATE SCHEMA AUTHORIZATION $schema_name$$END$;";
            }
            if (id.isPostgres() || id.isDb2() || id.isHsqldb() || id.isH2() || id.isDerby() || id.isMysql() || id.isTransactSql() || id.isHive() || id.isSpark()) {
                return "CREATE SCHEMA $schema_name$$END$;";
            }
            if (id.isCassandra()) {
                return "CREATE KEYSPACE $schema_name$$END$ WITH REPLICATION = {'class': 'SimpleStrategy', 'replication_factor': 1};";
            }
            return null;
        }

        @Override
        @NotNull
        Map<String, Expression> getVariables(@NotNull SqlLanguageDialect dialect) {
            if (dialect == null) {
                Schema.$$$reportNull$$$0(2);
            }
            LinkedHashMap<String, Expression> map2 = new LinkedHashMap<String, Expression>();
            if (dialect.getDbms().isCassandra()) {
                map2.put("schema_name", (Expression)new ConstantNode("keyspace_name"));
            } else {
                map2.put("schema_name", (Expression)new ConstantNode("schema_name"));
            }
            LinkedHashMap<String, Expression> linkedHashMap = map2;
            if (linkedHashMap == null) {
                Schema.$$$reportNull$$$0(3);
            }
            return linkedHashMap;
        }

        @Override
        @NotNull
        String getText(@Nullable DatabaseDialect dialect) {
            if (dialect == null) {
                if ("Schema" == null) {
                    Schema.$$$reportNull$$$0(4);
                }
                return "Schema";
            }
            String kindName = dialect.getNameForKind(ObjectKind.SCHEMA);
            String string = StringUtil.capitalize((String)StringUtil.toLowerCase((String)kindName));
            if (string == null) {
                Schema.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delimiter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialect";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/editor/SqlGenerateGroup$Schema";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/editor/SqlGenerateGroup$Schema";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariables";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getTemplateText";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getVariables";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Database
    extends GenerateActionBase {
        @Override
        @Nullable
        protected String getTemplateText(@NotNull SqlLanguageDialect language, @NotNull String delimiter) {
            Dbms id;
            if (language == null) {
                Database.$$$reportNull$$$0(0);
            }
            if (delimiter == null) {
                Database.$$$reportNull$$$0(1);
            }
            if ((id = language.getDbms()).isPostgres() || id.isDb2() || id.isTransactSql()) {
                return "CREATE DATABASE $database_name$$END$;";
            }
            return null;
        }

        @Override
        @NotNull
        Map<String, Expression> getVariables(@NotNull SqlLanguageDialect dialect) {
            if (dialect == null) {
                Database.$$$reportNull$$$0(2);
            }
            Map<String, ConstantNode> map2 = Collections.singletonMap("database_name", new ConstantNode("database_name"));
            if (map2 == null) {
                Database.$$$reportNull$$$0(3);
            }
            return map2;
        }

        @Override
        @NotNull
        String getText(@Nullable DatabaseDialect dialect) {
            if ("Database" == null) {
                Database.$$$reportNull$$$0(4);
            }
            return "Database";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delimiter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialect";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/editor/SqlGenerateGroup$Database";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/editor/SqlGenerateGroup$Database";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariables";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getTemplateText";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getVariables";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class MaterializedView
    extends View {
        @Override
        @Nullable
        protected String getTemplateText(@NotNull SqlLanguageDialect language, @NotNull String delimiter) {
            Dbms id;
            if (language == null) {
                MaterializedView.$$$reportNull$$$0(0);
            }
            if (delimiter == null) {
                MaterializedView.$$$reportNull$$$0(1);
            }
            if ((id = language.getDbms()).isCassandra()) {
                return "CREATE MATERIALIZED VIEW $view_name$ AS $END$;";
            }
            return null;
        }

        @Override
        @NotNull
        String getText(@Nullable DatabaseDialect dialect) {
            if ("Materialized View" == null) {
                MaterializedView.$$$reportNull$$$0(2);
            }
            return "Materialized View";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delimiter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/editor/SqlGenerateGroup$MaterializedView";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/editor/SqlGenerateGroup$MaterializedView";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getTemplateText";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class View
    extends GenerateActionBase {
        @Override
        @Nullable
        protected String getTemplateText(@NotNull SqlLanguageDialect language, @NotNull String delimiter) {
            Dbms id;
            if (language == null) {
                View.$$$reportNull$$$0(0);
            }
            if (delimiter == null) {
                View.$$$reportNull$$$0(1);
            }
            if ((id = language.getDbms()).isCassandra()) {
                return null;
            }
            return "CREATE VIEW $view_name$ AS $END$;";
        }

        @Override
        @NotNull
        Map<String, Expression> getVariables(@NotNull SqlLanguageDialect dialect) {
            if (dialect == null) {
                View.$$$reportNull$$$0(2);
            }
            LinkedHashMap<String, Expression> map2 = new LinkedHashMap<String, Expression>();
            map2.put("view_name", (Expression)new ConstantNode("view_name"));
            LinkedHashMap<String, Expression> linkedHashMap = map2;
            if (linkedHashMap == null) {
                View.$$$reportNull$$$0(3);
            }
            return linkedHashMap;
        }

        @Override
        @NotNull
        String getText(@Nullable DatabaseDialect dialect) {
            if ("View" == null) {
                View.$$$reportNull$$$0(4);
            }
            return "View";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delimiter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialect";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/editor/SqlGenerateGroup$View";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/editor/SqlGenerateGroup$View";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariables";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getTemplateText";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getVariables";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Trigger
    extends GenerateActionBase {
        @Override
        @Nullable
        protected String getTemplateText(@NotNull SqlLanguageDialect language, @NotNull String delimiter) {
            Dbms id;
            if (language == null) {
                Trigger.$$$reportNull$$$0(0);
            }
            if (delimiter == null) {
                Trigger.$$$reportNull$$$0(1);
            }
            if ((id = language.getDbms()).isOracle()) {
                return "CREATE TRIGGER $trigger_name$\n  $type$ $event$ ON $object_name$\n  BEGIN\n    $END$\n  END;";
            }
            if (id.isPostgres()) {
                return "CREATE TRIGGER $trigger_name$\n  $type$ $event$ ON $object_name$\n  EXECUTE PROCEDURE $call$($END$);";
            }
            if (id.isMysql()) {
                return "CREATE TRIGGER $trigger_name$\n  $type$ $event$ ON $object_name$\n  FOR EACH ROW\n  BEGIN\n    $END$\n  END;\n";
            }
            if (id.isDb2()) {
                return "CREATE TRIGGER $trigger_name$\n  $type$ $event$ ON $object_name$\n  FOR EACH $each_clause$\n  BEGIN ATOMIC\n    $END$\n  END;\n";
            }
            if (id.isDerby()) {
                return "CREATE TRIGGER $trigger_name$\n  $type$ $event$ ON $object_name$\n  FOR EACH $each_clause$\n  $END$";
            }
            if (id.isTransactSql()) {
                return "CREATE TRIGGER $trigger_name$\n  ON $object_name$\n  $type$ $event$\n  AS $call$;\n";
            }
            if (id.isHsqldb()) {
                return "CREATE TRIGGER $trigger_name$ $type$ $event$\n  ON $object_name$\n  BEGIN ATOMIC\n    $END$\n  END;\n";
            }
            if (id.isH2()) {
                return "CREATE TRIGGER $trigger_name$ $type$ $event$\n  ON $object_name$\n  CALL $call$;\n";
            }
            if (id.isSqlite()) {
                return "CREATE TRIGGER $trigger_name$ $type$ $event$\n  ON $object_name$\n  BEGIN\n    $END$\n  END;\n";
            }
            if (id.isCassandra()) {
                return "CREATE TRIGGER $trigger_name$ ON $object_name$ USING '$END$'";
            }
            if (id.isHive()) {
                return "CREATE TRIGGER $resource_plan_name$.$trigger_name$ WHEN $expression$ DO $action$$END$";
            }
            return null;
        }

        @Override
        @NotNull
        Map<String, Expression> getVariables(@NotNull SqlLanguageDialect dialect) {
            if (dialect == null) {
                Trigger.$$$reportNull$$$0(2);
            }
            LinkedHashMap<String, Expression> map2 = new LinkedHashMap<String, Expression>();
            Dbms id = dialect.getDbms();
            if (id.isCassandra()) {
                Trigger.putTriggerName(map2);
                Trigger.putObjectName(map2, id);
                LinkedHashMap<String, Expression> linkedHashMap = map2;
                if (linkedHashMap == null) {
                    Trigger.$$$reportNull$$$0(3);
                }
                return linkedHashMap;
            }
            if (id.isHive()) {
                map2.put("resource_plan_name", (Expression)new ConstantNode("resource_plan_name"));
                Trigger.putTriggerName(map2);
                map2.put("expression", (Expression)new ConstantNode("expression"));
                map2.put("action", (Expression)new ConstantNode("kill"));
            }
            boolean isTransactSql = id.isTransactSql();
            Trigger.putTriggerName(map2);
            if (isTransactSql) {
                Trigger.putObjectName(map2, id);
            }
            map2.put("type", (Expression)new ConstantNode(isTransactSql ? "FOR" : (id.isDerby() ? "AFTER" : "BEFORE")));
            map2.put("event", (Expression)new ConstantNode("INSERT"));
            if (!isTransactSql) {
                Trigger.putObjectName(map2, id);
            }
            if (id.isDb2() || id.isDerby()) {
                map2.put("each_clause", (Expression)new ConstantNode("ROW"));
            }
            Trigger.putCall(map2, id);
            LinkedHashMap<String, Expression> linkedHashMap = map2;
            if (linkedHashMap == null) {
                Trigger.$$$reportNull$$$0(4);
            }
            return linkedHashMap;
        }

        @Override
        @NotNull
        String getText(@Nullable DatabaseDialect dialect) {
            if ("Trigger" == null) {
                Trigger.$$$reportNull$$$0(5);
            }
            return "Trigger";
        }

        private static void putObjectName(@NotNull Map<String, Expression> map2, @NotNull Dbms id) {
            if (map2 == null) {
                Trigger.$$$reportNull$$$0(6);
            }
            if (id == null) {
                Trigger.$$$reportNull$$$0(7);
            }
            MyNode node = new MyNode((Macro)new CompleteMacro(), id.isOracle() ? "object_name" : "table_name");
            map2.put("object_name", (Expression)node);
        }

        private static void putTriggerName(@NotNull Map<String, Expression> map2) {
            if (map2 == null) {
                Trigger.$$$reportNull$$$0(8);
            }
            map2.put("trigger_name", (Expression)new ConstantNode("trigger_name"));
        }

        private static void putCall(@NotNull Map<String, Expression> map2, @NotNull Dbms id) {
            if (map2 == null) {
                Trigger.$$$reportNull$$$0(9);
            }
            if (id == null) {
                Trigger.$$$reportNull$$$0(10);
            }
            if (!(id.isPostgres() || id.isH2() || id.isTransactSql())) {
                return;
            }
            map2.put("call", (Expression)(id.isPostgres() ? new MyNode((Macro)new CompleteMacro(), "procedure_name") : new ConstantNode(id.isH2() ? "triggeredClassName" : "statements")));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delimiter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialect";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/editor/SqlGenerateGroup$Trigger";
                    break;
                }
                case 6: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 7: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/editor/SqlGenerateGroup$Trigger";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariables";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getTemplateText";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getVariables";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "putObjectName";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "putTriggerName";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "putCall";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class GenerateActionBase
    extends CodeInsightAction
    implements CodeInsightActionHandler {
        private GenerateActionBase() {
        }

        public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
            int targetOffset;
            PsiFile targetFile;
            String delimiter;
            int offset;
            PsiElement elementAt;
            SqlLanguageDialect dialect;
            String text2;
            if (project == null) {
                GenerateActionBase.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                GenerateActionBase.$$$reportNull$$$0(1);
            }
            if (file == null) {
                GenerateActionBase.$$$reportNull$$$0(2);
            }
            if ((text2 = this.getTemplateText(dialect = GenerateActionBase.getDialectAt(file, elementAt = GenerateActionBase.findElementAt(file, offset = editor.getCaretModel().getOffset())), delimiter = this.getDelimiter(targetFile = elementAt == null ? file : elementAt.getContainingFile(), targetOffset = elementAt == null ? offset : elementAt.getTextOffset()))) == null) {
                return;
            }
            TemplateManager templateManager = TemplateManager.getInstance((Project)project);
            Template template = templateManager.createTemplate("", "", text2);
            Map<String, Expression> vars = this.getVariables(dialect);
            for (Map.Entry<String, Expression> var : vars.entrySet()) {
                template.addVariable(var.getKey(), var.getValue(), true);
            }
            template.setToReformat(true);
            templateManager.startTemplate(editor, template);
        }

        @Nullable
        protected abstract String getTemplateText(@NotNull SqlLanguageDialect var1, @NotNull String var2);

        @NotNull
        abstract Map<String, Expression> getVariables(@NotNull SqlLanguageDialect var1);

        @NotNull
        protected CodeInsightActionHandler getHandler() {
            GenerateActionBase generateActionBase = this;
            if (generateActionBase == null) {
                GenerateActionBase.$$$reportNull$$$0(3);
            }
            return generateActionBase;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                GenerateActionBase.$$$reportNull$$$0(4);
            }
            super.update(e);
            PsiElement elementAt = null;
            SqlLanguageDialect dialect = null;
            PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            if (file instanceof SqlFile && editor != null) {
                int offset = editor.getCaretModel().getOffset();
                elementAt = GenerateActionBase.findElementAt(file, offset);
                dialect = GenerateActionBase.getDialectAt(file, elementAt);
            }
            boolean available = this.isAvailable(dialect, elementAt);
            Presentation presentation = e.getPresentation();
            if (!available) {
                presentation.setEnabledAndVisible(false);
                return;
            }
            DatabaseDialectEx databaseDialect = dialect == null ? null : DbImplUtil.getDatabaseDialect(dialect.getDbms());
            presentation.setText(this.getText(databaseDialect));
            presentation.setDescription(this.getDescription(databaseDialect));
        }

        protected boolean isAvailable(@Nullable SqlLanguageDialect dialect, @Nullable PsiElement elementAt) {
            if (dialect == null || !this.isSqlDialectSupported(dialect)) {
                return false;
            }
            return this.isInContext(elementAt);
        }

        @NotNull
        private static SqlLanguageDialect getDialectAt(PsiFile file, PsiElement elementAt) {
            SqlLanguageDialectEx dialect = null;
            if (elementAt != null) {
                PsiElement o;
                IElementType elementType;
                Iterator iterator = SyntaxTraverser.psiApi().parents((Object)elementAt).iterator();
                while (iterator.hasNext() && (dialect = (SqlLanguageDialect)ObjectUtils.tryCast((Object)(elementType = PsiUtilCore.getElementType((PsiElement)(o = (PsiElement)iterator.next()))).getLanguage(), SqlLanguageDialect.class)) == null) {
                }
            }
            if (dialect == null) {
                dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)(elementAt != null ? elementAt : file));
            }
            SqlLanguageDialectEx sqlLanguageDialectEx = dialect;
            if (sqlLanguageDialectEx == null) {
                GenerateActionBase.$$$reportNull$$$0(5);
            }
            return sqlLanguageDialectEx;
        }

        @Nullable
        private static PsiElement findElementAt(@NotNull PsiFile file, int offset) {
            PsiElement e1;
            if (file == null) {
                GenerateActionBase.$$$reportNull$$$0(6);
            }
            return (e1 = InjectedLanguageManager.getInstance((Project)file.getProject()).findInjectedElementAt(file, offset)) != null ? e1 : file.findElementAt(offset);
        }

        protected boolean isInContext(@Nullable PsiElement element2) {
            return SqlGenerateGroup.onTopLevel(element2);
        }

        @NotNull
        abstract String getText(@Nullable DatabaseDialect var1);

        @NotNull
        protected String getDescription(@Nullable DatabaseDialect dialect) {
            String string = "Creates " + StringUtil.toLowerCase((String)this.getText(dialect));
            if (string == null) {
                GenerateActionBase.$$$reportNull$$$0(7);
            }
            return string;
        }

        protected boolean isSqlDialectSupported(@NotNull SqlLanguageDialect dialect) {
            if (dialect == null) {
                GenerateActionBase.$$$reportNull$$$0(8);
            }
            return this.getTemplateText(dialect, "") != null;
        }

        @NotNull
        protected String getDelimiter(@NotNull PsiFile file, int offset) {
            String delim;
            if (file == null) {
                GenerateActionBase.$$$reportNull$$$0(9);
            }
            String string = DbSqlUtil.delimiterNeedsSpacing(delim = DbSqlUtil.getDelimiterAt(file, offset).replace("$", "$$")) ? " " + delim : delim;
            if (string == null) {
                GenerateActionBase.$$$reportNull$$$0(10);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/editor/SqlGenerateGroup$GenerateActionBase";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialect";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/editor/SqlGenerateGroup$GenerateActionBase";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHandler";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDialectAt";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDelimiter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 10: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "findElementAt";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "isSqlDialectSupported";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getDelimiter";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

