/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.lang.ASTNode;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.FlowPattern;
import com.intellij.sql.formatter.model.FlowPatternKt;
import com.intellij.sql.formatter.model.NodeMatcher;
import com.intellij.sql.formatter.model.RowPattern;
import com.intellij.sql.formatter.model.SqlBlock;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001BA\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0010\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r\u00a2\u0006\u0002\u0010\u000eJ \u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lcom/intellij/sql/formatter/model/RowPattern;", "Lcom/intellij/sql/formatter/model/FlowPattern;", "applicableState", "", "resultState", "matchers", "", "Lcom/intellij/sql/formatter/model/NodeMatcher;", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "producer", "Lkotlin/Function0;", "Lcom/intellij/sql/formatter/model/SqlBlock;", "Lcom/intellij/sql/formatter/model/SqlBlockProducer;", "(Ljava/lang/Byte;Ljava/lang/Byte;Ljava/util/List;Lcom/intellij/sql/formatter/model/BlockRole;Lkotlin/jvm/functions/Function0;)V", "getRole", "()Lcom/intellij/sql/formatter/model/BlockRole;", "process", "Lkotlin/ranges/IntRange;", "nodes", "Lcom/intellij/lang/ASTNode;", "since", "", "toString", "", "intellij.database.sql.impl"})
public final class RowPattern
extends FlowPattern {
    private final List<NodeMatcher> matchers;
    @NotNull
    private final BlockRole role;

    @Override
    @Nullable
    public IntRange process(@NotNull List<? extends ASTNode> nodes2, int since) {
        Intrinsics.checkParameterIsNotNull(nodes2, (String)"nodes");
        int rowLength = FlowPatternKt.access$parseRow(nodes2, since, this.matchers);
        return rowLength > 0 ? RangesKt.until((int)since, (int)(since + rowLength)) : null;
    }

    @NotNull
    public String toString() {
        return "[ROW: " + CollectionsKt.joinToString$default((Iterable)this.matchers, null, null, null, (int)0, null, (Function1)toString.1.INSTANCE, (int)31, null) + ']';
    }

    @Override
    @NotNull
    public BlockRole getRole() {
        return this.role;
    }

    public RowPattern(@Nullable Byte applicableState, @Nullable Byte resultState, @NotNull List<? extends NodeMatcher> matchers, @NotNull BlockRole role, @NotNull Function0<? extends SqlBlock> producer) {
        Intrinsics.checkParameterIsNotNull(matchers, (String)"matchers");
        Intrinsics.checkParameterIsNotNull((Object)((Object)role), (String)"role");
        Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
        super(applicableState, resultState, producer, null);
        this.matchers = matchers;
        this.role = role;
    }
}

