/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.SqlUtilFun;
import com.intellij.sql.formatter.model.AdjacentBlocks;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlExpressionBlock;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFunKt;
import com.intellij.sql.formatter.model.SqlLeafBlock;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlOperatorExpression;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0014J\u001f\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0010\u00a2\u0006\u0002\b\u000fJ\u0015\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0010\u00a2\u0006\u0002\b\u0014J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u0014J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\tH\u0014J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\rH\u0002J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/sql/formatter/model/SqlBinaryExpressionBlock;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "Lcom/intellij/sql/formatter/model/SqlExpressionBlock;", "()V", "operationText", "", "operationType", "Lcom/intellij/psi/tree/IElementType;", "configureFormattingAttributes", "", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "decideSpacing$intellij_database_sql_impl", "determineRole", "Lcom/intellij/sql/formatter/model/BlockRole;", "node", "Lcom/intellij/lang/ASTNode;", "determineRole$intellij_database_sql_impl", "getDebugNameSuffix", "getNewLineIndent", "blocks", "Lcom/intellij/sql/formatter/model/AdjacentBlocks;", "prepareForNode", "whetherBlockIsSymbol", "", "block", "whetherToFlatten", "intellij.database.sql.impl"})
public final class SqlBinaryExpressionBlock
extends SqlNodeBlock
implements SqlExpressionBlock {
    private IElementType operationType;
    private String operationText;

    @Override
    protected void prepareForNode() {
        super.prepareForNode();
        PsiElement psiElement = this.getNode().getPsi();
        if (!(psiElement instanceof SqlOperatorExpression)) {
            psiElement = null;
        }
        SqlOperatorExpression sqlOperatorExpression = (SqlOperatorExpression)psiElement;
        PsiElement operatorSignElement = sqlOperatorExpression != null ? sqlOperatorExpression.getOpSignElement() : null;
        this.operationType = SqlUtilFun.getType(operatorSignElement);
        PsiElement psiElement2 = operatorSignElement;
        this.operationText = psiElement2 != null ? psiElement2.getText() : null;
    }

    @Override
    protected boolean whetherToFlatten(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        if (this.operationType == null) {
            return false;
        }
        PsiElement element2 = node.getPsi();
        return element2 instanceof SqlBinaryExpression && Intrinsics.areEqual((Object)((SqlBinaryExpression)element2).getOpSign(), (Object)this.operationType);
    }

    @Override
    @NotNull
    public BlockRole determineRole$intellij_database_sql_impl(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        return node.getElementType() == this.operationType ? BlockRole.DELIMITER : (node instanceof SqlExpression ? BlockRole.ELEMENT : super.determineRole$intellij_database_sql_impl(node));
    }

    @Override
    protected void configureFormattingAttributes() {
        if (this.getContext().getSql().EXPR_BINARY_OP_ALIGN) {
            Wrap w = this.makeWrap$intellij_database_sql_impl(WrapType.NORMAL, false);
            Alignment a = SqlFormattingModelFunKt.makeLeftAlignment();
            Iterable $this$forEach$iv = (Iterable)SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SqlBlock it2 = (SqlBlock)element$iv;
                boolean bl = false;
                it2.setMyWrap(w);
                it2.setMyIndent(SqlFormattingFunKt.getNORMAL_INDENT());
                it2.setMyAlign(a);
            }
        } else {
            Wrap w = SqlFlowBlock.makeWrap$intellij_database_sql_impl$default((SqlFlowBlock)this, WrapType.NORMAL, false, 2, null);
            Indent i2 = Indent.getContinuationIndent();
            Iterable $this$forEach$iv = (Iterable)SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.DELIMITER);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SqlBlock it3 = (SqlBlock)element$iv;
                boolean bl = false;
                it3.setMyWrap(w);
                it3.setMyIndent(i2);
            }
        }
    }

    @Override
    @Nullable
    public Spacing decideSpacing$intellij_database_sql_impl(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Intrinsics.checkParameterIsNotNull((Object)block1, (String)"block1");
        Intrinsics.checkParameterIsNotNull((Object)block2, (String)"block2");
        int toSpace = this.getContext().getSql().EXPR_SPACE_AROUND_OPERATOR;
        BlockRole r1 = block1.getRole();
        BlockRole r2 = block2.getRole();
        return r1 == BlockRole.DELIMITER && r2 == BlockRole.ELEMENT ? (toSpace == 1 ? SqlFormattingContext.makeSpace$default(this.getContext(), false, 1, null) : (toSpace == 0 || !this.whetherBlockIsSymbol(block1) ? SqlFormattingContext.makeSafeSpacing$default(this.getContext(), false, 1, null) : SqlFormattingContext.makeNoSpace$default(this.getContext(), false, 1, null))) : (r1 == BlockRole.ELEMENT && r2 == BlockRole.DELIMITER ? (toSpace == 1 ? SqlFormattingContext.makeSpace$default(this.getContext(), false, 1, null) : (toSpace == 0 || !this.whetherBlockIsSymbol(block2) ? SqlFormattingContext.makeSafeSpacing$default(this.getContext(), false, 1, null) : SqlFormattingContext.makeNoSpace$default(this.getContext(), false, 1, null))) : super.decideSpacing$intellij_database_sql_impl(block1, block2));
    }

    private final boolean whetherBlockIsSymbol(SqlBlock block) {
        return block instanceof SqlLeafBlock && SqlUtilFun.isSymbol(((SqlLeafBlock)block).getNode());
    }

    @Override
    @Nullable
    protected String getDebugNameSuffix() {
        return this.operationText;
    }

    @Override
    @Nullable
    public String getNewLineIndent(@NotNull AdjacentBlocks blocks) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)blocks, (String)"blocks");
        boolean align = this.getContext().getSql().EXPR_BINARY_OP_ALIGN;
        BlockRole r1 = blocks.getRole1();
        BlockRole r2 = blocks.getRole2();
        if (r1 == BlockRole.DELIMITER && (r2 == BlockRole.ELEMENT || r2 == BlockRole.NOTHING)) {
            string = SqlFormattingContext.currIndentOf$default(this.getContext(), (Block)this, align, false, 4, null);
        } else if (r1 == BlockRole.ELEMENT && (r2 == BlockRole.DELIMITER || r2 == BlockRole.NOTHING)) {
            string = this.getContext().currIndentOf((Block)this, align, true);
        } else {
            return null;
        }
        return string;
    }
}

