/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.database.Dbms;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.SqlMergeInsertStatementsIntention;
import com.intellij.sql.intentions.SqlMergeInsertStatementsIntention$getStatements$;
import com.intellij.sql.intentions.UtilsKt;
import com.intellij.sql.psi.SqlInsertDmlInstruction;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\b\u0010\b\u001a\u00020\tH\u0016J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\tH\u0016J#\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0002J\u0018\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\tH\u0002J\"\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u001a"}, d2={"Lcom/intellij/sql/intentions/SqlMergeInsertStatementsIntention;", "Lcom/intellij/codeInsight/intention/impl/BaseIntentionAction;", "()V", "areEquivalent", "", "e1", "Lcom/intellij/psi/PsiElement;", "e2", "getFamilyName", "", "getStatements", "Lkotlin/sequences/Sequence;", "Lcom/intellij/sql/psi/SqlInsertStatement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "isAcceptable", "it", "delimiter", "isAvailable", "intellij.database.sql.impl"})
public final class SqlMergeInsertStatementsIntention
extends BaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        return "Merge INSERT statements";
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    private final boolean areEquivalent(PsiElement e1, PsiElement e2) {
        boolean bl;
        block8: {
            if (e1 == e2) {
                return true;
            }
            if (Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)e1), (Object)PsiUtilCore.getElementType((PsiElement)e2)) ^ true) {
                return false;
            }
            if (e1 instanceof LeafPsiElement) {
                return e2 instanceof LeafPsiElement && Intrinsics.areEqual((Object)((LeafPsiElement)e1).getText(), (Object)((LeafPsiElement)e2).getText());
            }
            if (e1 instanceof SqlValuesExpression && e2 instanceof SqlValuesExpression) {
                return true;
            }
            List list = SqlImplUtil.sqlChildren(e1).toList();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"SqlImplUtil.sqlChildren(e1).toList()");
            List children1 = list;
            List list2 = SqlImplUtil.sqlChildren(e2).toList();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"SqlImplUtil.sqlChildren(e2).toList()");
            List children2 = list2;
            if (children1.size() != children2.size()) {
                return false;
            }
            Iterable $this$all$iv = (Iterable)CollectionsKt.getIndices((Collection)children1);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator = $this$all$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int i2 = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl2 = false;
                    Object e = children1.get(i2);
                    Intrinsics.checkExpressionValueIsNotNull(e, (String)"children1[i]");
                    PsiElement psiElement = (PsiElement)e;
                    Object e3 = children2.get(i2);
                    Intrinsics.checkExpressionValueIsNotNull(e3, (String)"children2[i]");
                    if (this.areEquivalent(psiElement, (PsiElement)e3)) continue;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean isAcceptable(PsiElement it2, String delimiter) {
        return it2 instanceof SqlInsertStatement || it2 instanceof PsiWhiteSpace || it2 instanceof PsiComment || it2 instanceof LeafPsiElement && Intrinsics.areEqual((Object)((LeafPsiElement)it2).getText(), (Object)delimiter);
    }

    private final Sequence<SqlInsertStatement> getStatements(Editor editor, PsiFile file) {
        boolean bl;
        Sequence statements2;
        block9: {
            SqlInsertStatement it2;
            SelectionModel selectionModel = editor.getSelectionModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)selectionModel, (String)"editor.selectionModel");
            int startOffset = selectionModel.getSelectionStart();
            SelectionModel selectionModel2 = editor.getSelectionModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)selectionModel2, (String)"editor.selectionModel");
            int endOffset = selectionModel2.getSelectionEnd();
            SqlInsertStatement sqlInsertStatement = (SqlInsertStatement)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(startOffset), SqlInsertStatement.class, (boolean)false);
            if (sqlInsertStatement == null) {
                return SequencesKt.emptySequence();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlInsertStatement, (String)"PsiTreeUtil.getParentOfT\u2026?: return emptySequence()");
            SqlInsertStatement fromStatement = sqlInsertStatement;
            if (UtilsKt.getValuesKeyword(fromStatement) == null) {
                return SequencesKt.emptySequence();
            }
            TextRange textRange = fromStatement.getTextRange();
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"fromStatement.textRange");
            if (textRange.getStartOffset() != startOffset) {
                return SequencesKt.emptySequence();
            }
            String string = DbSqlUtil.getDelimiterAt(file, startOffset);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DbSqlUtil.getDelimiterAt(file, startOffset)");
            String delimiter = string;
            Sequence $this$filterIsInstance$iv = SequencesKt.takeWhile((Sequence)SequencesKt.generateSequence((Object)fromStatement, (Function1)getStatements.toStatement.1.INSTANCE), (Function1)((Function1)new Function1<PsiElement, Boolean>(this, delimiter){
                final /* synthetic */ SqlMergeInsertStatementsIntention this$0;
                final /* synthetic */ String $delimiter;

                public final boolean invoke(@NotNull PsiElement it2) {
                    Intrinsics.checkParameterIsNotNull((Object)it2, (String)"it");
                    return SqlMergeInsertStatementsIntention.access$isAcceptable(this.this$0, it2, this.$delimiter);
                }
                {
                    this.this$0 = sqlMergeInsertStatementsIntention;
                    this.$delimiter = string;
                    super(1);
                }
            }));
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)getStatements$$inlined$filterIsInstance$1.INSTANCE);
            if (sequence == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
            }
            Sequence $this$lastOrNull$iv = sequence;
            boolean $i$f$lastOrNull = false;
            Object last$iv = null;
            for (Object element$iv : $this$lastOrNull$iv) {
                it2 = (SqlInsertStatement)element$iv;
                boolean bl2 = false;
                TextRange textRange2 = it2.getTextRange();
                Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"it.textRange");
                if (!(textRange2.getEndOffset() <= endOffset)) continue;
                last$iv = element$iv;
            }
            SqlInsertStatement sqlInsertStatement2 = last$iv;
            if (sqlInsertStatement2 == null) {
                return SequencesKt.emptySequence();
            }
            SqlInsertStatement toStatement2 = sqlInsertStatement2;
            if (fromStatement == toStatement2) {
                return SequencesKt.emptySequence();
            }
            Sequence $this$all$iv = statements2 = SequencesKt.generateSequence((Object)fromStatement, (Function1)((Function1)new Function1<SqlInsertStatement, SqlInsertStatement>(toStatement2){
                final /* synthetic */ SqlInsertStatement $toStatement;

                @Nullable
                public final SqlInsertStatement invoke(@NotNull SqlInsertStatement it2) {
                    Intrinsics.checkParameterIsNotNull((Object)it2, (String)"it");
                    return it2 != this.$toStatement ? (SqlInsertStatement)SqlImplUtil.getSiblingToTheRightOfType((PsiElement)it2, false, SqlInsertStatement.class) : null;
                }
                {
                    this.$toStatement = sqlInsertStatement;
                    super(1);
                }
            }));
            boolean $i$f$all = false;
            for (Object element$iv : $this$all$iv) {
                it2 = (SqlInsertStatement)element$iv;
                boolean bl3 = false;
                SqlInsertDmlInstruction sqlInsertDmlInstruction = it2.getDmlInstruction();
                if ((sqlInsertDmlInstruction != null ? sqlInsertDmlInstruction.getValuesExpression() : null) != null && this.areEquivalent((PsiElement)it2, (PsiElement)fromStatement)) continue;
                bl = false;
                break block9;
            }
            bl = true;
        }
        if (!bl) {
            return SequencesKt.emptySequence();
        }
        return statements2;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (editor == null) {
            return false;
        }
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sqlLanguageDialectEx), (String)"SqlImplUtil.getSqlDialectSafe(file)");
        Dbms dbms = sqlLanguageDialectEx.getDbms();
        Intrinsics.checkExpressionValueIsNotNull((Object)dbms, (String)"SqlImplUtil.getSqlDialectSafe(file).dbms");
        Dbms dbms2 = dbms;
        if (dbms2.isOracle() || dbms2.isSybase()) {
            return false;
        }
        return SequencesKt.any(this.getStatements(editor, file));
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file) {
        SqlInsertStatement sqlInsertStatement;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Editor editor2 = editor;
        if (editor2 == null) {
            return;
        }
        List statements2 = SequencesKt.toList(this.getStatements(editor2, file));
        SqlInsertStatement sqlInsertStatement2 = (SqlInsertStatement)CollectionsKt.firstOrNull((List)statements2);
        if (sqlInsertStatement2 == null) {
            return;
        }
        SqlInsertStatement anchor = sqlInsertStatement2;
        String string = UtilsKt.getValuesKeyword(anchor);
        if (string == null) {
            return;
        }
        String valuesKeyword2 = string;
        DdlBuilder ddlBuilder = new DdlBuilder();
        boolean bl = false;
        boolean bl2 = false;
        DdlBuilder $this$apply = ddlBuilder;
        boolean bl3 = false;
        $this$apply.plain("INSERT INTO foo " + valuesKeyword2 + ' ');
        $this$apply.plain(CollectionsKt.joinToString$default((Iterable)statements2, null, null, null, (int)0, null, (Function1)invoke.insertText.1.1.INSTANCE, (int)31, null));
        String string2 = ddlBuilder.getStatement();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"DdlBuilder().apply {\n   \u2026\n      })\n    }.statement");
        String insertText2 = string2;
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sqlLanguageDialectEx), (String)"SqlImplUtil.getSqlDialectSafe(file)");
        SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
        SqlStatement newInsert = SqlPsiElementFactory.createStatementFromText(insertText2, dialect, project, null);
        SqlStatement sqlStatement = newInsert;
        if (!(sqlStatement instanceof SqlInsertStatement)) {
            sqlStatement = null;
        }
        if ((sqlInsertStatement = (SqlInsertStatement)sqlStatement) == null || (sqlInsertStatement = sqlInsertStatement.getDmlInstruction()) == null || (sqlInsertStatement = sqlInsertStatement.getValuesExpression()) == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlInsertStatement, (String)"(newInsert as? SqlInsert\u2026aluesExpression ?: return");
        SqlInsertStatement newValues = sqlInsertStatement;
        SqlInsertDmlInstruction sqlInsertDmlInstruction = anchor.getDmlInstruction();
        if (sqlInsertDmlInstruction == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlInsertDmlInstruction, (String)"anchor.dmlInstruction!!");
        SqlValuesExpression sqlValuesExpression = sqlInsertDmlInstruction.getValuesExpression();
        if (sqlValuesExpression == null) {
            Intrinsics.throwNpe();
        }
        sqlValuesExpression.replace((PsiElement)newValues);
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)anchor);
        PsiElement psiElement = anchor.getNextSibling();
        if (psiElement == null) {
            return;
        }
        PsiElement deleteFrom = psiElement;
        SqlInsertStatement sqlInsertStatement3 = (SqlInsertStatement)CollectionsKt.lastOrNull((List)statements2);
        if (sqlInsertStatement3 == null) {
            return;
        }
        SqlInsertStatement deleteTo = sqlInsertStatement3;
        anchor.getParent().deleteChildRange(deleteFrom, (PsiElement)deleteTo);
    }

    public static final /* synthetic */ boolean access$isAcceptable(SqlMergeInsertStatementsIntention $this, PsiElement it2, String delimiter) {
        return $this.isAcceptable(it2, delimiter);
    }
}

