/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.database.Dbms;
import com.intellij.database.util.DdlBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlStringLiteralManipulator;
import com.intellij.sql.psi.impl.SqlStringTokenElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class SqlSplitStringLiteralIntention
implements IntentionAction {
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            SqlSplitStringLiteralIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = SqlMessages.message("quickfix.name.split.string.literal", new Object[0]);
        if (string == null) {
            SqlSplitStringLiteralIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        SqlStringTokenElement string;
        if (project == null) {
            SqlSplitStringLiteralIntention.$$$reportNull$$$0(2);
        }
        if ((string = SqlSplitStringLiteralIntention.currentStringToken(editor, file)) == null) {
            return false;
        }
        return SqlSplitStringLiteralIntention.getContentRange(string).contains(editor.getCaretModel().getOffset());
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        SqlStringTokenElement string;
        if (project == null) {
            SqlSplitStringLiteralIntention.$$$reportNull$$$0(3);
        }
        if ((string = SqlSplitStringLiteralIntention.currentStringToken(editor, file)) != null) {
            CommandProcessor.getInstance().executeCommand(project, () -> SqlSplitStringLiteralIntention.splitLiteral(string, project, editor, file), null, (Object)editor.getDocument());
        }
    }

    @NotNull
    private static TextRange getContentRange(SqlStringTokenElement string) {
        PsiElement element2 = (PsiElement)ObjectUtils.notNull((Object)SqlStringLiteralManipulator.getStringElement((PsiElement)string));
        TextRange textRange = SqlStringLiteralManipulator.getStringContentRange(element2).shiftRight(element2.getTextRange().getStartOffset());
        if (textRange == null) {
            SqlSplitStringLiteralIntention.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static SqlStringTokenElement currentStringToken(Editor editor, PsiFile file) {
        SqlStringTokenElement type = (SqlStringTokenElement)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), SqlStringTokenElement.class, (boolean)false);
        if (type != null && type.getNode() != null && type.getNode().getElementType() == SqlTokens.SQL_IDENT_DELIMITED) {
            return null;
        }
        return type;
    }

    private static int getConcatExpr(@NotNull DdlBuilder builder, @NotNull String a, @NotNull String b2) {
        int res2;
        Dbms id;
        if (builder == null) {
            SqlSplitStringLiteralIntention.$$$reportNull$$$0(5);
        }
        if (a == null) {
            SqlSplitStringLiteralIntention.$$$reportNull$$$0(6);
        }
        if (b2 == null) {
            SqlSplitStringLiteralIntention.$$$reportNull$$$0(7);
        }
        if ((id = builder.getDialect().getDbms()).isMysql()) {
            builder.keyword("CONCAT").symbol("(").literal(a).symbol(",").space();
            res2 = builder.length();
            builder.symbol(",").space().literal(b2).symbol(")");
        } else {
            String op = id.isTransactSql() ? "+" : "||";
            builder.literal(a).space().symbol(op).space();
            res2 = builder.length();
            builder.space().symbol(op).space().literal(b2);
        }
        return res2;
    }

    @NotNull
    private static TextRange findLiteralRange(@NotNull SqlStringTokenElement string) {
        if (string == null) {
            SqlSplitStringLiteralIntention.$$$reportNull$$$0(8);
        }
        if (string.getParent() instanceof SqlStringLiteralExpression) {
            TextRange textRange = string.getParent().getTextRange();
            if (textRange == null) {
                SqlSplitStringLiteralIntention.$$$reportNull$$$0(9);
            }
            return textRange;
        }
        if (string.getElementType() == SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN) {
            Object prev = PsiTreeUtil.prevLeaf((PsiElement)string);
            Object next = PsiTreeUtil.nextLeaf((PsiElement)string);
            if (PsiUtilCore.getElementType((PsiElement)prev) != SqlTokens.SQL_CUSTOM_LQUOTE) {
                prev = string;
            }
            if (PsiUtilCore.getElementType((PsiElement)next) != SqlTokens.SQL_CUSTOM_RQUOTE) {
                next = string;
            }
            TextRange textRange = TextRange.create((int)prev.getTextRange().getStartOffset(), (int)next.getTextRange().getEndOffset());
            if (textRange == null) {
                SqlSplitStringLiteralIntention.$$$reportNull$$$0(10);
            }
            return textRange;
        }
        TextRange textRange = string.getTextRange();
        if (textRange == null) {
            SqlSplitStringLiteralIntention.$$$reportNull$$$0(11);
        }
        return textRange;
    }

    private static void splitLiteral(SqlStringTokenElement string, Project project, Editor editor, PsiFile file) {
        TextRange outerRange = SqlSplitStringLiteralIntention.findLiteralRange(string);
        TextRange innerRange = SqlSplitStringLiteralIntention.getContentRange(string).shiftLeft(outerRange.getStartOffset());
        int splitPosition = SqlSplitStringLiteralIntention.findSplitPosition(string, outerRange, editor);
        if (splitPosition != -1) {
            WriteCommandAction.runWriteCommandAction((Project)project, (String)"Split string literal", (String)"Split string literal", () -> {
                String text2 = editor.getDocument().getText(outerRange);
                String bquote = text2.substring(0, innerRange.getStartOffset());
                String equote = text2.substring(innerRange.getEndOffset(), outerRange.getLength());
                SqlLanguageDialectEx sqlDialect = SqlImplUtil.getSqlDialectSafe((PsiElement)string);
                DdlBuilder builder = new DdlBuilder(new StringBuilder(string.getTextLength() + 20)).configureBuilder(project, sqlDialect).withDialect(sqlDialect.getDatabaseDialect());
                int cur = SqlSplitStringLiteralIntention.getConcatExpr(builder, text2.substring(0, splitPosition) + equote, bquote + text2.substring(splitPosition));
                editor.getDocument().replaceString(outerRange.getStartOffset(), outerRange.getEndOffset(), (CharSequence)builder.getStatement());
                editor.getCaretModel().moveToOffset(cur += outerRange.getStartOffset());
            }, (PsiFile[])new PsiFile[]{file});
            AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor, null);
        }
    }

    private static int findSplitPosition(SqlStringTokenElement string, TextRange literalRange, Editor editor) {
        PsiElement parent2 = string.getParent();
        int caret = editor.getCaretModel().getOffset();
        if (parent2 instanceof SqlStringLiteralExpression) {
            return SqlSplitStringLiteralIntention.findSplitPosition((SqlStringLiteralExpression)parent2, caret);
        }
        SqlPsiFacade facade = SqlPsiFacade.getInstance((Project)editor.getProject());
        SqlStringLiteralExpression literal = (SqlStringLiteralExpression)PsiTreeUtil.findChildOfType((PsiElement)facade.createExpressionFragment((Language)SqlImplUtil.getSqlDialectSafe((PsiElement)string), null, null, editor.getDocument().getText(literalRange)), SqlStringLiteralExpression.class);
        if (literal == null) {
            return -1;
        }
        return SqlSplitStringLiteralIntention.findSplitPosition(literal, caret - literalRange.getStartOffset());
    }

    private static int findSplitPosition(SqlStringLiteralExpression literal, int caret) {
        StringBuilder dummy;
        int innerCaretOffset;
        TextRange innerRange = SqlStringLiteralManipulator.getStringContentRange((PsiElement)literal);
        if (!innerRange.contains(innerCaretOffset = caret - literal.getTextRange().getStartOffset())) {
            return -1;
        }
        LiteralTextEscaper esc = literal.createLiteralTextEscaper();
        if (!esc.decode(innerRange, dummy = new StringBuilder(literal.getTextLength()))) {
            return -1;
        }
        int pos = SqlSplitStringLiteralIntention.findDecodedSplitPosition(esc, innerRange, innerCaretOffset, 0, dummy.length());
        return pos == -1 ? -1 : esc.getOffsetInHost(pos, innerRange);
    }

    private static int findDecodedSplitPosition(LiteralTextEscaper<?> esc, TextRange innerRange, int h, int s, int e) {
        if (esc.getOffsetInHost(s, innerRange) == h) {
            return s;
        }
        if (esc.getOffsetInHost(e, innerRange) == h) {
            return e;
        }
        int i2 = ObjectUtils.binarySearch((int)s, (int)e, m -> Integer.compare(esc.getOffsetInHost(m, innerRange), h));
        if (i2 < 0) {
            i2 = -i2 - 1;
        }
        return i2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/intentions/SqlSplitStringLiteralIntention";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/intentions/SqlSplitStringLiteralIntention";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRange";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findLiteralRange";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getConcatExpr";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findLiteralRange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

