/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions;

import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramProvider;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.uml.statistics.DiagramUsagesTriggerCollector;
import com.intellij.uml.utils.UmlBundle;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ShowDiagramBase
extends DumbAwareAction {
    private boolean myIsCalledFromList = false;

    protected ShowDiagramBase() {
        this.setInjectedContext(true);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDiagramBase.$$$reportNull$$$0(0);
        }
        Presentation presentation = e.getPresentation();
        if (e.getProject() == null) {
            presentation.setEnabled(false);
            return;
        }
        DiagramProvider provider = (DiagramProvider)this.getProviders(e).first();
        boolean enabled = provider != null;
        String place = e.getPlace();
        presentation.setVisible(enabled || DiagramProvider.isEverybodyInThePlaceLetsGo((String)place));
        presentation.setEnabled(enabled);
        if (enabled) {
            presentation.setIcon(provider.getActionIcon(this.isPopup()));
            presentation.setText("Show " + provider.getActionName(this.isPopup()) + (this.isPopup() ? " Popup" : "") + "...");
        }
    }

    @NotNull
    private JBIterable<DiagramProvider> getProviders(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDiagramBase.$$$reportNull$$$0(1);
        }
        JBIterable<DiagramProvider> jBIterable = ShowDiagramBase.findProviders(e, this.getProvider(e));
        if (jBIterable == null) {
            ShowDiagramBase.$$$reportNull$$$0(2);
        }
        return jBIterable;
    }

    protected abstract boolean isPopup();

    @Nullable
    public DiagramProvider getProvider(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDiagramBase.$$$reportNull$$$0(3);
        }
        return null;
    }

    public String getFeatureId() {
        return "diagram.show";
    }

    public boolean isCalledFromJList() {
        return this.myIsCalledFromList;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ShowDiagramBase.$$$reportNull$$$0(4);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        DataContext context = e.getDataContext();
        List providers = this.getProviders(e).toList();
        DiagramUsagesTriggerCollector.triggerStatisticsProviders(project, providers, this.getFeatureId());
        if (providers.isEmpty()) {
            return;
        }
        Component comp = (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        AbstractPopup.MyContentPanel panel = comp == null ? null : (AbstractPopup.MyContentPanel)ComponentUtil.getParentOfType(AbstractPopup.MyContentPanel.class, (Component)comp);
        this.myIsCalledFromList = panel != null;
        RelativePoint point = this.getLocation(context, e);
        if (providers.size() > 1) {
            class ProviderEntry {
                final Object target;
                final Collection otherTargets;
                final DiagramProvider provider;

                ProviderEntry(DiagramProvider provider, Object target, Collection otherTargets) {
                    this.target = target;
                    this.otherTargets = otherTargets.size() > 0 ? new ArrayList(otherTargets) : otherTargets;
                    this.provider = provider;
                }
            }
            List entries = ContainerUtil.map((Collection)providers, provider -> new ProviderEntry((DiagramProvider)provider, this.findInDataContext((DiagramProvider)provider, context), provider.getElementManager().findElementsInDataContext(context)));
            IPopupChooserBuilder popupBuilder = JBPopupFactory.getInstance().createPopupChooserBuilder(entries);
            JBPopup popup = popupBuilder.setTitle(UmlBundle.message("select.uml.provider", new Object[0])).setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label, value, index) -> {
                label.setText(value.provider.getPresentableName());
                label.setIcon(value.provider.getActionIcon(this.isPopup()));
            })).setResizable(false).setMovable(false).setItemChosenCallback(entry -> this.showUnderProgress(entry.provider, project, entry.target, entry.otherTargets, point)).createPopup();
            popup.showInBestPositionFor(context);
        } else {
            DiagramProvider provider2 = (DiagramProvider)providers.get(0);
            ArrayList elements = provider2.getElementManager().findElementsInDataContext(context);
            if (elements.size() > 0) {
                elements = new ArrayList(elements);
            }
            this.showUnderProgress(provider2, project, this.findInDataContext(provider2, context), elements, point);
        }
    }

    protected Object findInDataContext(DiagramProvider provider, DataContext context) {
        return provider.getElementManager().findInDataContext(context);
    }

    @NotNull
    protected RelativePoint getLocation(DataContext context, AnActionEvent e) {
        RelativePoint relativePoint = JBPopupFactory.getInstance().guessBestPopupLocation(context);
        if (relativePoint == null) {
            ShowDiagramBase.$$$reportNull$$$0(5);
        }
        return relativePoint;
    }

    @Nullable
    protected abstract Runnable show(Object var1, DiagramProvider var2, Project var3, RelativePoint var4, Collection var5);

    protected void showUnderProgress(DiagramProvider provider, Project project, @Nullable Object element, Collection elements, RelativePoint point) {
        Ref postBackgroundAction = Ref.create(null);
        Object obj = element != null ? element : (!elements.isEmpty() ? elements.iterator().next() : null);
        elements.remove(obj);
        Runnable process = () -> ApplicationManager.getApplication().runReadAction(() -> {
            ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
            Runnable callback = this.show(obj, provider, project, point, elements);
            if (this.isPopup()) {
                postBackgroundAction.set((Object)callback);
            } else if (callback != null) {
                callback.run();
            }
        });
        if (this.isUnderProgress() && !this.isCalledFromJList()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(process, UmlBundle.message("building.diagram", provider.getPresentableName()), true, project);
        } else {
            postBackgroundAction.set((Object)this.show(obj, provider, project, point, elements));
        }
        if (!postBackgroundAction.isNull()) {
            ((Runnable)postBackgroundAction.get()).run();
        }
    }

    protected boolean isUnderProgress() {
        return true;
    }

    @NotNull
    public static JBIterable<DiagramProvider> findProviders(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDiagramBase.$$$reportNull$$$0(6);
        }
        JBIterable<DiagramProvider> jBIterable = ShowDiagramBase.findProviders(e, null);
        if (jBIterable == null) {
            ShowDiagramBase.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DiagramProvider> findProviders(@NotNull AnActionEvent e, @Nullable DiagramProvider forcedProvider) {
        Project project;
        if (e == null) {
            ShowDiagramBase.$$$reportNull$$$0(8);
        }
        if ((project = e.getProject()) == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                ShowDiagramBase.$$$reportNull$$$0(9);
            }
            return jBIterable;
        }
        String place = e.getPlace();
        boolean isDumb = DumbService.isDumb((Project)project);
        JBIterable jBIterable = (forcedProvider != null ? JBIterable.of((Object)forcedProvider) : JBIterable.from((Iterable)DiagramProvider.DIAGRAM_PROVIDER.getExtensionList())).filter(provider -> !isDumb || DumbService.isDumbAware((Object)provider)).filter(provider -> {
            DiagramElementManager mgr = provider.getElementManager();
            Object element = mgr.findInDataContext(e.getDataContext());
            Collection elements = mgr.findElementsInDataContext(e.getDataContext());
            List places = provider.getActionPlaces();
            element = element == null ? (!elements.isEmpty() ? elements.toArray()[0] : null) : element;
            return element != null && mgr.isAcceptableAsNode(element) && (places == null || places.contains(place) || places.isEmpty());
        });
        if (jBIterable == null) {
            ShowDiagramBase.$$$reportNull$$$0(10);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/core/actions/ShowDiagramBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/core/actions/ShowDiagramBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviders";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getProviders";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getProvider";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findProviders";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

