/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramCategory;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.uml.editors.DiagramNodeEditorManager;
import org.jetbrains.annotations.NotNull;

public class UmlCategorySwitcher
extends DiagramAction
implements Toggleable {
    private final DiagramCategory myCategory;
    private final DiagramBuilder myBuilder;

    public UmlCategorySwitcher(DiagramCategory category, DiagramBuilder builder) {
        super(category.getName(), "", category.getIcon());
        this.myCategory = category;
        this.myBuilder = builder;
    }

    public void perform(@NotNull AnActionEvent e) {
        if (e == null) {
            UmlCategorySwitcher.$$$reportNull$$$0(0);
        }
        DiagramNodeEditorManager.getInstance().stopEditing(this.myBuilder);
        boolean enabled = !this.isEnabled();
        this.myBuilder.getPresentation().setCategoryEnabled(this.myCategory, enabled);
        this.myBuilder.getProvider().getNodeContentManager().onCategoryEnabled(this.myCategory, enabled, this.myBuilder.getPresentation());
        if (this.myCategory.isRefreshDataModel()) {
            this.myBuilder.getDataModel().refreshDataModel();
        }
        this.myBuilder.update(true, this.myBuilder.isPopupMode() || this.myCategory.isRefreshLayout());
        this.myBuilder.getGraphBuilder().updateView();
        if (this.myCategory.isFitContent()) {
            this.myBuilder.getGraph().fitGraph2DView();
        }
    }

    public String getActionName() {
        return (this.isEnabled() ? "Disable " : "Enable ") + this.myCategory.getName();
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            UmlCategorySwitcher.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabled(UmlCategorySwitcher.getBuilder((AnActionEvent)e) != null);
        e.getPresentation().putClientProperty("selected", (Object)this.isEnabled());
    }

    private boolean isEnabled() {
        return this.myBuilder.getPresentation().isCategoryEnabled(this.myCategory);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/uml/core/actions/UmlCategorySwitcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "perform";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

