/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.CommonBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SafeFileOutputStream
extends OutputStream {
    private static final String DEFAULT_BACKUP_EXT = "~";
    private static final CopyOption[] BACKUP_COPY = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
    private static final OpenOption[] MAIN_WRITE = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.SYNC};
    private static final OpenOption[] BACKUP_READ = new OpenOption[]{StandardOpenOption.DELETE_ON_CLOSE};
    private final Path myTarget;
    private final String myBackupName;
    @Nullable
    private final Future<Path> myBackupFuture;
    private final BufferExposingByteArrayOutputStream myBuffer;
    private boolean myClosed;

    public SafeFileOutputStream(@NotNull File target) {
        if (target == null) {
            SafeFileOutputStream.$$$reportNull$$$0(0);
        }
        this(target.toPath(), DEFAULT_BACKUP_EXT);
    }

    public SafeFileOutputStream(@NotNull File target, @NotNull String backupExt) {
        if (target == null) {
            SafeFileOutputStream.$$$reportNull$$$0(1);
        }
        if (backupExt == null) {
            SafeFileOutputStream.$$$reportNull$$$0(2);
        }
        this(target.toPath(), backupExt);
    }

    public SafeFileOutputStream(@NotNull Path target) {
        if (target == null) {
            SafeFileOutputStream.$$$reportNull$$$0(3);
        }
        this(target, DEFAULT_BACKUP_EXT);
    }

    public SafeFileOutputStream(@NotNull Path target, @NotNull String backupExt) {
        if (target == null) {
            SafeFileOutputStream.$$$reportNull$$$0(4);
        }
        if (backupExt == null) {
            SafeFileOutputStream.$$$reportNull$$$0(5);
        }
        this.myClosed = false;
        this.myTarget = target;
        this.myBackupName = this.myTarget.getFileName() + backupExt;
        this.myBackupFuture = !Files.exists(target, new LinkOption[0]) ? null : AppExecutorUtil.getAppExecutorService().submit(() -> {
            Path backup = this.myTarget.getParent().resolve(this.myBackupName);
            Files.copy(this.myTarget, backup, BACKUP_COPY);
            return backup;
        });
        this.myBuffer = new BufferExposingByteArrayOutputStream();
    }

    @Override
    public void write(int b) throws IOException {
        this.myBuffer.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.myBuffer.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.myBuffer.write(b, off, len);
    }

    public void abort() throws IOException {
        this.myClosed = true;
        SafeFileOutputStream.deleteBackup(this.waitForBackup());
    }

    @Override
    public void close() throws IOException {
        if (this.myClosed) {
            return;
        }
        this.myClosed = true;
        Path backup = this.waitForBackup();
        OutputStream sink = this.openFile();
        try {
            this.writeData(sink);
            SafeFileOutputStream.deleteBackup(backup);
        }
        catch (IOException e) {
            this.restoreFromBackup(backup, e);
        }
    }

    @Nullable
    private Path waitForBackup() throws IOException {
        if (this.myBackupFuture == null) {
            return null;
        }
        try {
            return this.myBackupFuture.get();
        }
        catch (InterruptedException | CancellationException e) {
            throw new IllegalStateException(e);
        }
        catch (ExecutionException e) {
            throw new IOException(CommonBundle.message("safe.write.backup", this.myTarget, this.myBackupName), e.getCause());
        }
    }

    private OutputStream openFile() throws IOException {
        try {
            return Files.newOutputStream(this.myTarget, MAIN_WRITE);
        }
        catch (IOException e) {
            throw new IOException(CommonBundle.message("safe.write.open", this.myTarget), e);
        }
    }

    private void writeData(OutputStream sink) throws IOException {
        try (OutputStream out = sink;){
            out.write(this.myBuffer.getInternalBuffer(), 0, this.myBuffer.size());
        }
    }

    private static void deleteBackup(Path backup) {
        if (backup != null) {
            try {
                Files.delete(backup);
            }
            catch (IOException e) {
                Logger.getInstance(SafeFileOutputStream.class).warn("cannot delete a backup file " + backup, e);
            }
        }
    }

    private void restoreFromBackup(@Nullable Path backup, IOException e) throws IOException {
        if (backup == null) {
            throw new IOException(CommonBundle.message("safe.write.junk", this.myTarget), e);
        }
        boolean restored = true;
        try (InputStream in = Files.newInputStream(backup, BACKUP_READ);
             OutputStream out = Files.newOutputStream(this.myTarget, MAIN_WRITE);){
            FileUtil.copy(in, out);
        }
        catch (IOException ex) {
            restored = false;
            e.addSuppressed(ex);
        }
        if (restored) {
            throw new IOException(CommonBundle.message("safe.write.restored", this.myTarget), e);
        }
        throw new IOException(CommonBundle.message("safe.write.junk.backup", this.myTarget, backup.getFileName()), e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "target";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "backupExt";
                break;
            }
        }
        objectArray[1] = "com/intellij/util/io/SafeFileOutputStream";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

