/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ref;

import com.intellij.openapi.util.Ref;
import com.intellij.reference.SoftReference;
import com.intellij.util.MemoryDumpHelper;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ref.GCUtil;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class GCWatcher {
    private final ReferenceQueue<Object> myQueue;
    private final Set<Reference<?>> myReferences;

    private GCWatcher(@NotNull Collection<?> objects) {
        if (objects == null) {
            GCWatcher.$$$reportNull$$$0(0);
        }
        this.myQueue = new ReferenceQueue();
        this.myReferences = ContainerUtil.newConcurrentSet();
        for (Object o : objects) {
            if (o == null) continue;
            this.myReferences.add(new WeakReference<Object>(o, this.myQueue));
        }
    }

    @NotNull
    @Contract(pure=true)
    public static GCWatcher tracking(Object ... objects) {
        GCWatcher gCWatcher = GCWatcher.tracking(Arrays.asList(objects));
        if (gCWatcher == null) {
            GCWatcher.$$$reportNull$$$0(1);
        }
        return gCWatcher;
    }

    @NotNull
    @Contract(pure=true)
    public static GCWatcher tracking(@NotNull Collection<?> objects) {
        if (objects == null) {
            GCWatcher.$$$reportNull$$$0(2);
        }
        GCWatcher gCWatcher = new GCWatcher(objects);
        if (gCWatcher == null) {
            GCWatcher.$$$reportNull$$$0(3);
        }
        return gCWatcher;
    }

    @NotNull
    public static GCWatcher fromClearedRef(@NotNull Ref<?> ref) {
        if (ref == null) {
            GCWatcher.$$$reportNull$$$0(4);
        }
        GCWatcher result = GCWatcher.tracking(ref.get());
        ref.set(null);
        GCWatcher gCWatcher = result;
        if (gCWatcher == null) {
            GCWatcher.$$$reportNull$$$0(5);
        }
        return gCWatcher;
    }

    private boolean isEverythingCollected() {
        boolean removed;
        while (true) {
            Reference<Object> ref;
            if ((ref = this.myQueue.poll()) == null) {
                return this.myReferences.isEmpty();
            }
            removed = this.myReferences.remove(ref);
            assert (removed);
        }
    }

    public void tryGc() {
        StringBuilder log = new StringBuilder();
        if (!GCUtil.allocateTonsOfMemory(log, this::isEverythingCollected)) {
            String message = "Couldn't garbage-collect some objects, they might still be reachable from GC roots: " + ContainerUtil.mapNotNull(this.myReferences, SoftReference::dereference);
            try {
                File file = new File(System.getProperty("teamcity.build.tempDir", System.getProperty("java.io.tmpdir")), "GCWatcher.hprof.zip");
                MemoryDumpHelper.captureMemoryDumpZipped(file);
                System.out.println("##teamcity[publishArtifacts '" + file.getPath() + "']");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (this.isEverythingCollected()) {
                message = message + "\nEverything is collected after taking the heap dump.";
            }
            message = message + "Log:\n" + log;
            throw new IllegalStateException(message);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ref/GCWatcher";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ref/GCWatcher";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "tracking";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "fromClearedRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "tracking";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fromClearedRef";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

