/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsShortCommitDetails;
import git4idea.GitVcs;
import git4idea.branch.GitRebaseParams;
import git4idea.config.GitVersion;
import git4idea.rebase.GitCommitEditingAction;
import git4idea.rebase.GitRebaseUtils;
import git4idea.repo.GitRepository;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lgit4idea/rebase/GitInteractiveRebaseAction;", "Lgit4idea/rebase/GitCommitEditingAction;", "()V", "actionPerformedAfterChecks", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getFailureTitle", "", "update", "intellij.vcs.git"})
public final class GitInteractiveRebaseAction
extends GitCommitEditingAction {
    @Override
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        super.update(e);
        GitCommitEditingAction.prohibitRebaseDuringRebase$default(this, e, "rebase", false, 4, null);
    }

    @Override
    public void actionPerformedAfterChecks(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        VcsShortCommitDetails commit2 = this.getSelectedCommit(e);
        Project project = e.getProject();
        if (project == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"e.project!!");
        Project project2 = project;
        GitRepository repository = this.getRepository(e);
        new Task.Backgroundable(repository, commit2, project2, project2, "Rebasing"){
            final /* synthetic */ GitRepository $repository;
            final /* synthetic */ VcsShortCommitDetails $commit;
            final /* synthetic */ Project $project;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                GitVcs gitVcs = this.$repository.getVcs();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)gitVcs), (String)"repository.vcs");
                GitVersion gitVersion = gitVcs.getVersion();
                Intrinsics.checkExpressionValueIsNotNull((Object)gitVersion, (String)"repository.vcs.version");
                List list = this.$commit.getParents();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"commit.parents");
                String string = ((Hash)CollectionsKt.first((List)list)).asString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"commit.parents.first().asString()");
                GitRebaseParams params = GitRebaseParams.Companion.editCommits$default(GitRebaseParams.Companion, gitVersion, string, null, false, null, 16, null);
                GitRebaseUtils.rebase(this.$project, CollectionsKt.listOf((Object)this.$repository), params, indicator);
            }
            {
                this.$repository = $captured_local_variable$0;
                this.$commit = $captured_local_variable$1;
                this.$project = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4);
            }
        }.queue();
    }

    @Override
    @NotNull
    protected String getFailureTitle() {
        return "Couldn't Start Rebase";
    }
}

