/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.structure;

import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TextEditorBasedStructureViewModel;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.impl.structure.CssCustomPropertiesFilter;
import com.intellij.psi.css.impl.structure.CssImportsFilter;
import com.intellij.psi.css.impl.structure.CssMemberKindSorter;
import com.intellij.psi.css.impl.structure.CssStructureViewElement;
import com.intellij.psi.css.impl.structure.CssStructureViewElementsProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssTreeModel
extends TextEditorBasedStructureViewModel
implements StructureViewModel.ElementInfoProvider,
StructureViewModel.ExpandInfoProvider {
    private static final Filter[] CSS_FILTERS = new Filter[]{new CssImportsFilter(), new CssCustomPropertiesFilter()};
    private static final Class[] CSS_SUITABLE_CLASSES = new Class[]{CssDeclaration.class, CssImport.class, CssAtRule.class, CssRuleset.class};
    private final Sorter[] mySorters;
    @NotNull
    private final Filter[] myFilters;
    @NotNull
    private final Class[] myClasses;
    @NotNull
    private final CssStructureViewElementsProvider[] myElementProviders;

    protected boolean isSuitable(PsiElement element) {
        PsiElement ruleset;
        if (element instanceof CssSelectorSuffix && (ruleset = CssStructureViewElement.getNodeElement(element)) instanceof CssRuleset) {
            CssSelectorSuffix singleSuffix = CssStructureViewElement.retrieveSingleSelectorPrefixFromRuleset((CssRuleset)ruleset);
            return singleSuffix != null;
        }
        if (element instanceof CssDeclaration) {
            return ((CssDeclaration)element).isCustomProperty();
        }
        if (super.isSuitable(element)) {
            for (CssStructureViewElementsProvider provider : this.myElementProviders) {
                if (!provider.shouldSkipElement(element)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Object getCurrentEditorElement() {
        CssSelectorSuffix selectorSuffix;
        Object element = super.getCurrentEditorElement();
        if (element instanceof CssRuleset && (selectorSuffix = CssStructureViewElement.retrieveSingleSelectorPrefixFromRuleset((CssRuleset)element)) != null) {
            return selectorSuffix;
        }
        return element;
    }

    public CssTreeModel(@NotNull PsiFile file, @Nullable Editor editor) {
        if (file == null) {
            CssTreeModel.$$$reportNull$$$0(0);
        }
        super(editor, file);
        this.mySorters = new Sorter[]{CssMemberKindSorter.INSTANCE, Sorter.ALPHA_SORTER};
        this.myElementProviders = CssTreeModel.initProviders((PsiElement)file);
        this.myFilters = this.initFilters();
        this.myClasses = this.initSuitableClasses();
    }

    public CssTreeModel(@NotNull CssStylesheet stylesheet, Editor editor) {
        if (stylesheet == null) {
            CssTreeModel.$$$reportNull$$$0(1);
        }
        super(editor, stylesheet.getContainingFile());
        this.mySorters = new Sorter[]{CssMemberKindSorter.INSTANCE, Sorter.ALPHA_SORTER};
        this.myElementProviders = CssTreeModel.initProviders((PsiElement)stylesheet);
        this.myFilters = this.initFilters();
        this.myClasses = this.initSuitableClasses();
    }

    private static CssStructureViewElementsProvider[] initProviders(@NotNull PsiElement contextElement) {
        if (contextElement == null) {
            CssTreeModel.$$$reportNull$$$0(2);
        }
        ArrayList providers = new ArrayList();
        for (CssStructureViewElementsProvider provider : (CssStructureViewElementsProvider[])CssStructureViewElementsProvider.EXTENSION_POINT_NAME.getExtensions()) {
            if (!provider.isMyContext(contextElement)) continue;
            Collections.addAll(providers, provider);
        }
        return providers.toArray(new CssStructureViewElementsProvider[0]);
    }

    @NotNull
    private Filter[] initFilters() {
        if (this.myElementProviders.length == 0) {
            if (CSS_FILTERS == null) {
                CssTreeModel.$$$reportNull$$$0(3);
            }
            return CSS_FILTERS;
        }
        ArrayList filters = ContainerUtil.newArrayList((Object[])CSS_FILTERS);
        for (CssStructureViewElementsProvider provider : this.myElementProviders) {
            Collections.addAll(filters, provider.getFilters());
        }
        Filter[] filterArray = filters.toArray(Filter.EMPTY_ARRAY);
        if (filterArray == null) {
            CssTreeModel.$$$reportNull$$$0(4);
        }
        return filterArray;
    }

    @NotNull
    private Class[] initSuitableClasses() {
        if (this.myElementProviders.length == 0) {
            if (CSS_SUITABLE_CLASSES == null) {
                CssTreeModel.$$$reportNull$$$0(5);
            }
            return CSS_SUITABLE_CLASSES;
        }
        ArrayList suitableClasses = ContainerUtil.newArrayList((Object[])CSS_SUITABLE_CLASSES);
        for (CssStructureViewElementsProvider provider : this.myElementProviders) {
            Collections.addAll(suitableClasses, provider.getSuitableClasses());
        }
        Class[] classArray = suitableClasses.toArray(ArrayUtil.EMPTY_CLASS_ARRAY);
        if (classArray == null) {
            CssTreeModel.$$$reportNull$$$0(6);
        }
        return classArray;
    }

    @NotNull
    public StructureViewTreeElement getRoot() {
        PsiFile file = this.getPsiFile();
        if (file instanceof StylesheetFile) {
            CssStructureViewElement cssStructureViewElement = CssStructureViewElement.create((PsiElement)file, file.getFileType().getIcon(), file.getName());
            if (cssStructureViewElement == null) {
                CssTreeModel.$$$reportNull$$$0(7);
            }
            return cssStructureViewElement;
        }
        CssStructureViewElement cssStructureViewElement = CssStructureViewElement.create((PsiElement)file, CssFileType.INSTANCE.getIcon(), null);
        if (cssStructureViewElement == null) {
            CssTreeModel.$$$reportNull$$$0(8);
        }
        return cssStructureViewElement;
    }

    @NotNull
    public Sorter[] getSorters() {
        if (this.mySorters == null) {
            CssTreeModel.$$$reportNull$$$0(9);
        }
        return this.mySorters;
    }

    @NotNull
    protected Class[] getSuitableClasses() {
        if (this.myClasses == null) {
            CssTreeModel.$$$reportNull$$$0(10);
        }
        return this.myClasses;
    }

    public boolean isAlwaysShowsPlus(StructureViewTreeElement element) {
        return false;
    }

    public boolean isAlwaysLeaf(StructureViewTreeElement element) {
        return element instanceof CssStructureViewElement && ((CssStructureViewElement)element).isAlwaysLeaf();
    }

    @NotNull
    public Filter[] getFilters() {
        if (this.myFilters == null) {
            CssTreeModel.$$$reportNull$$$0(11);
        }
        return this.myFilters;
    }

    public boolean isAutoExpand(@NotNull StructureViewTreeElement element) {
        if (element == null) {
            CssTreeModel.$$$reportNull$$$0(12);
        }
        return element.getValue() instanceof CssStylesheet;
    }

    public boolean isSmartExpand() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stylesheet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/structure/CssTreeModel";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/structure/CssTreeModel";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "initFilters";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "initSuitableClasses";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSorters";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableClasses";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "initProviders";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAutoExpand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

