/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.codeInsight.attributes;

import com.intellij.html.impl.providers.HtmlAttributeValueProvider;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import org.angular2.lang.Angular2LangUtil;
import org.angular2.lang.expr.psi.Angular2Binding;
import org.angular2.lang.html.parser.Angular2AttributeNameParser;
import org.angular2.lang.html.psi.Angular2HtmlPropertyBinding;
import org.angular2.lang.html.psi.PropertyBindingType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Angular2AttributeValueProvider
extends HtmlAttributeValueProvider {
    @NonNls
    public static final String NG_CLASS_ATTR = "ngClass";

    public static boolean isNgClassAttribute(@Nullable XmlAttribute attribute) {
        return attribute != null && Angular2AttributeValueProvider.isNgClassAttribute(Angular2AttributeNameParser.parse(attribute.getName(), attribute.getParent()));
    }

    public static boolean isNgClassAttribute(@NotNull Angular2AttributeNameParser.AttributeInfo info) {
        if (info == null) {
            Angular2AttributeValueProvider.$$$reportNull$$$0(0);
        }
        return info instanceof Angular2AttributeNameParser.PropertyBindingInfo && ((Angular2AttributeNameParser.PropertyBindingInfo)info).bindingType == PropertyBindingType.PROPERTY && NG_CLASS_ATTR.equals(info.name);
    }

    @Nullable
    public String getCustomAttributeValues(XmlTag tag, String attributeName) {
        if (Angular2LangUtil.isAngular2Context((PsiElement)tag)) {
            if (attributeName.equalsIgnoreCase("class")) {
                SmartList result = new SmartList();
                String classAttr = null;
                for (XmlAttribute attribute : tag.getAttributes()) {
                    String attrName = attribute.getName();
                    if ("class".equalsIgnoreCase(attrName)) {
                        classAttr = attribute.getValue();
                        continue;
                    }
                    ObjectUtils.doIfNotNull((Object)this.getCustomAttributeValues(tag, attrName), ((List)result)::add);
                }
                if (!result.isEmpty()) {
                    ObjectUtils.doIfNotNull(classAttr, ((List)result)::add);
                    return StringUtil.join((Collection)result, (String)" ");
                }
                return null;
            }
            Angular2AttributeNameParser.AttributeInfo info = Angular2AttributeNameParser.parse(attributeName, tag);
            if (Angular2AttributeValueProvider.isNgClassAttribute(info)) {
                XmlAttribute attribute = tag.getAttribute(attributeName);
                if (attribute instanceof Angular2HtmlPropertyBinding) {
                    return Angular2AttributeValueProvider.getClassNames(((Angular2HtmlPropertyBinding)attribute).getBinding());
                }
            } else if (info instanceof Angular2AttributeNameParser.PropertyBindingInfo && ((Angular2AttributeNameParser.PropertyBindingInfo)info).bindingType == PropertyBindingType.CLASS) {
                return info.name;
            }
        }
        return null;
    }

    @NotNull
    private static String getClassNames(@Nullable Angular2Binding binding) {
        final StringBuilder result = new StringBuilder();
        if (binding != null && binding.getExpression() != null) {
            binding.getExpression().accept((PsiElementVisitor)new JSElementVisitor(){

                public void visitJSArrayLiteralExpression(JSArrayLiteralExpression node) {
                    for (JSExpression expression : node.getExpressions()) {
                        expression.accept((PsiElementVisitor)this);
                    }
                }

                public void visitJSLiteralExpression(JSLiteralExpression node) {
                    if (node.isQuotedLiteral()) {
                        result.append(node.getStringValue());
                        result.append(' ');
                    }
                }

                public void visitJSObjectLiteralExpression(JSObjectLiteralExpression node) {
                    for (JSProperty property : node.getProperties()) {
                        property.accept((PsiElementVisitor)this);
                    }
                }

                public void visitJSProperty(JSProperty node) {
                    result.append(node.getName());
                    result.append(' ');
                }
            });
        }
        String string = result.toString();
        if (string == null) {
            Angular2AttributeValueProvider.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/codeInsight/attributes/Angular2AttributeValueProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/codeInsight/attributes/Angular2AttributeValueProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isNgClassAttribute";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

