/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.css;

import com.intellij.lang.css.CssDialect;
import com.intellij.lang.css.CssDialectMappings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.descriptor.CssPseudoSelectorDescriptor;
import com.intellij.psi.css.descriptor.CssPseudoSelectorDescriptorStub;
import com.intellij.util.ArrayUtilRt;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.util.HtmlUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.angular2.codeInsight.refs.Angular2SelectorReferencesProvider;
import org.angular2.entities.Angular2EntitiesProvider;
import org.angular2.lang.Angular2LangUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Angular2CssElementDescriptionProvider
extends CssElementDescriptorProvider {
    @NonNls
    private static final String NG_DEEP = "ng-deep";
    private static final Set<CssPseudoSelectorDescriptorStub> PSEUDO_SELECTORS = Collections.singleton(new CssPseudoSelectorDescriptorStub("ng-deep", true));

    public boolean isMyContext(@Nullable PsiElement context) {
        if (context == null || !context.isValid()) {
            return false;
        }
        PsiFile file = context.getContainingFile();
        if (file == null) {
            return false;
        }
        Project project = context.getProject();
        if (HtmlUtil.hasHtml((PsiFile)file)) {
            return Angular2LangUtil.isAngular2Context(context);
        }
        VirtualFile virtualFile = file.getOriginalFile().getVirtualFile();
        CssDialect mapping = (CssDialect)CssDialectMappings.getInstance((Project)project).getMapping(virtualFile);
        return (mapping == null || mapping == CssDialect.CLASSIC) && Angular2LangUtil.isAngular2Context(context);
    }

    public boolean isPossibleSelector(@NotNull String selector, @NotNull PsiElement context) {
        if (selector == null) {
            Angular2CssElementDescriptionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            Angular2CssElementDescriptionProvider.$$$reportNull$$$0(1);
        }
        return !Angular2EntitiesProvider.findElementDirectivesCandidates(context.getProject(), selector).isEmpty();
    }

    @NotNull
    public Collection<? extends CssPseudoSelectorDescriptor> findPseudoSelectorDescriptors(@NotNull String name, @Nullable PsiElement context) {
        if (name == null) {
            Angular2CssElementDescriptionProvider.$$$reportNull$$$0(2);
        }
        if (context != null && NG_DEEP.equals(name) && Angular2LangUtil.isAngular2Context(context)) {
            Set<CssPseudoSelectorDescriptorStub> set = PSEUDO_SELECTORS;
            if (set == null) {
                Angular2CssElementDescriptionProvider.$$$reportNull$$$0(3);
            }
            return set;
        }
        Set set = Collections.emptySet();
        if (set == null) {
            Angular2CssElementDescriptionProvider.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public Collection<? extends CssPseudoSelectorDescriptor> getAllPseudoSelectorDescriptors(@Nullable PsiElement context) {
        Set<Object> set = context != null && Angular2LangUtil.isAngular2Context(context) ? PSEUDO_SELECTORS : Collections.emptySet();
        if (set == null) {
            Angular2CssElementDescriptionProvider.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    public String[] getSimpleSelectors(@NotNull PsiElement context) {
        if (context == null) {
            Angular2CssElementDescriptionProvider.$$$reportNull$$$0(6);
        }
        String[] stringArray = ArrayUtilRt.toStringArray(Angular2EntitiesProvider.getAllElementDirectives(context.getProject()).keySet());
        if (stringArray == null) {
            Angular2CssElementDescriptionProvider.$$$reportNull$$$0(7);
        }
        return stringArray;
    }

    @NotNull
    public PsiElement[] getDeclarationsForSimpleSelector(@NotNull CssSimpleSelector selector) {
        XmlElementDescriptor descriptor;
        if (selector == null) {
            Angular2CssElementDescriptionProvider.$$$reportNull$$$0(8);
        }
        if ((descriptor = Angular2SelectorReferencesProvider.getElementDescriptor(selector.getElementName(), selector.getContainingFile())) != null) {
            PsiElement[] psiElementArray = new PsiElement[]{descriptor.getDeclaration()};
            if (psiElementArray == null) {
                Angular2CssElementDescriptionProvider.$$$reportNull$$$0(9);
            }
            return psiElementArray;
        }
        String elementName = selector.getElementName();
        PsiElement[] psiElementArray = (PsiElement[])Angular2EntitiesProvider.findElementDirectivesCandidates(selector.getProject(), elementName).stream().map(dir -> dir.getSelector().getSimpleSelectorsWithPsi()).flatMap(Collection::stream).map(sel -> sel.getElement()).filter(Objects::nonNull).filter(el -> elementName.equals(el.getName())).toArray(PsiElement[]::new);
        if (psiElementArray == null) {
            Angular2CssElementDescriptionProvider.$$$reportNull$$$0(10);
        }
        return psiElementArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/css/Angular2CssElementDescriptionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/css/Angular2CssElementDescriptionProvider";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findPseudoSelectorDescriptors";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPseudoSelectorDescriptors";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleSelectors";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationsForSimpleSelector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isPossibleSelector";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findPseudoSelectorDescriptors";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleSelectors";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationsForSimpleSelector";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

