/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.psi.PsiElementVisitor;
import org.angular2.Angular2DecoratorUtil;
import org.angular2.entities.Angular2Component;
import org.angular2.inspections.Angular2SourceEntityListValidator;
import org.angular2.lang.Angular2Bundle;
import org.jetbrains.annotations.NotNull;

public class AngularInvalidEntryComponentInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            AngularInvalidEntryComponentInspection.$$$reportNull$$$0(0);
        }
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitES6Decorator(ES6Decorator decorator) {
                if (Angular2DecoratorUtil.isAngularDecorator(decorator, "NgModule", "Component")) {
                    Angular2SourceEntityListValidator.ValidationResults<ProblemType> results = new Angular2SourceEntityListValidator.ValidationResults<ProblemType>();
                    new EntryComponentsValidator().validate(decorator, results);
                    if ("NgModule".equals(decorator.getDecoratorName())) {
                        new BootstrapValidator().validate(decorator, results);
                    }
                    results.registerProblems(ProblemType.INVALID_ENTRY_COMPONENT, holder);
                }
            }
        };
        if (jSElementVisitor == null) {
            AngularInvalidEntryComponentInspection.$$$reportNull$$$0(1);
        }
        return jSElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/inspections/AngularInvalidEntryComponentInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/inspections/AngularInvalidEntryComponentInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class BootstrapValidator
    extends Angular2SourceEntityListValidator<Angular2Component, ProblemType> {
        protected BootstrapValidator() {
            super(Angular2Component.class, "bootstrap");
        }

        @Override
        protected void processNonEntityClass(@NotNull JSClass aClass) {
            if (aClass == null) {
                BootstrapValidator.$$$reportNull$$$0(0);
            }
            this.registerProblem(ProblemType.INVALID_ENTRY_COMPONENT, Angular2Bundle.message("angular.inspection.decorator.not-a-component", aClass.getName()), new LocalQuickFix[0]);
        }

        @Override
        protected void processAnyElement(JSElement node) {
            this.registerProblem(ProblemType.INVALID_ENTRY_COMPONENT, Angular2Bundle.message("angular.inspection.decorator.not-array-of-class-types", new Object[0]), new LocalQuickFix[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/angular2/inspections/AngularInvalidEntryComponentInspection$BootstrapValidator", "processNonEntityClass"));
        }
    }

    private static class EntryComponentsValidator
    extends Angular2SourceEntityListValidator<Angular2Component, ProblemType> {
        protected EntryComponentsValidator() {
            super(Angular2Component.class, "entryComponents");
        }

        @Override
        protected void processNonEntityClass(@NotNull JSClass aClass) {
            if (aClass == null) {
                EntryComponentsValidator.$$$reportNull$$$0(0);
            }
            this.registerProblem(ProblemType.INVALID_ENTRY_COMPONENT, Angular2Bundle.message("angular.inspection.decorator.not-a-component", aClass.getName()), new LocalQuickFix[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/angular2/inspections/AngularInvalidEntryComponentInspection$EntryComponentsValidator", "processNonEntityClass"));
        }
    }

    private static enum ProblemType {
        INVALID_ENTRY_COMPONENT;

    }
}

