/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.index;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSCallExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.lang.javascript.psi.literal.JSLiteralImplicitElementProvider;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElementStructure;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.BidirectionalMap;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.angular2.index.Angular2IndexingHandler;
import org.angular2.lang.Angular2LangUtil;
import org.angularjs.codeInsight.AngularJSReferenceExpressionResolver;
import org.angularjs.codeInsight.DirectiveUtil;
import org.angularjs.index.AngularControllerIndex;
import org.angularjs.index.AngularDirectivesDocIndex;
import org.angularjs.index.AngularDirectivesIndex;
import org.angularjs.index.AngularFilterIndex;
import org.angularjs.index.AngularGenericModulesIndex;
import org.angularjs.index.AngularIndexUtil;
import org.angularjs.index.AngularInjectionDelimiterIndex;
import org.angularjs.index.AngularModuleIndex;
import org.angularjs.index.AngularSymbolIndex;
import org.angularjs.index.AngularTemplateUrlIndex;
import org.angularjs.index.AngularUiRouterGenericStatesIndex;
import org.angularjs.index.AngularUiRouterStatesIndex;
import org.angularjs.lang.AngularJSLanguage;
import org.angularjs.lang.psi.AngularJSFilterExpression;
import org.angularjs.lang.psi.AngularJSRepeatExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngularJSIndexingHandler
extends FrameworkIndexingHandler {
    private static final Map<String, StubIndexKey<String, JSImplicitElementProvider>> INDEXERS = new HashMap<String, StubIndexKey<String, JSImplicitElementProvider>>();
    private static final Map<String, Function<String, String>> NAME_CONVERTERS = new HashMap<String, Function<String, String>>();
    private static final Map<String, Function<PsiElement, String>> DATA_CALCULATORS = new HashMap<String, Function<PsiElement, String>>();
    private static final Map<String, PairProcessor<JSProperty, JSElementIndexingData>> CUSTOM_PROPERTY_PROCESSORS = new HashMap<String, PairProcessor<JSProperty, JSElementIndexingData>>();
    private static final Map<String, PairProcessor<JSProperty, JSElementIndexingData>> CUSTOM_INDIRECT_PROPERTY_PROCESSORS = new HashMap<String, PairProcessor<JSProperty, JSElementIndexingData>>();
    private static final Map<String, Function<String, List<String>>> POLY_NAME_CONVERTERS = new HashMap<String, Function<String, List<String>>>();
    private static final Map<String, Processor<JSArgumentList>> ARGUMENT_LIST_CHECKERS = new HashMap<String, Processor<JSArgumentList>>();
    public static final Set<String> INTERESTING_METHODS = new HashSet<String>();
    public static final Set<String> INJECTABLE_METHODS = new HashSet<String>();
    public static final String CONTROLLER = "controller";
    public static final String DIRECTIVE = "directive";
    public static final String COMPONENT = "component";
    public static final String BINDINGS = "bindings";
    public static final String SCOPE = "scope";
    public static final String BIND_TO_CONTROLLER = "bindToController";
    public static final String TEMPLATE_URL = "templateUrl";
    public static final String TEMPLATE = "template";
    public static final String CONTROLLER_AS = "controllerAs";
    public static final String MODULE = "module";
    public static final String FILTER = "filter";
    public static final String STATE = "state";
    private static final String START_SYMBOL = "startSymbol";
    private static final String END_SYMBOL = "endSymbol";
    public static final String DEFAULT_RESTRICTIONS = "D";
    public static final String WHEN = "when";
    private static final String RESTRICT_PROP = "restrict";
    private static final String[] ALL_INTERESTING_METHODS;
    private static final BidirectionalMap<String, StubIndexKey<String, JSImplicitElementProvider>> INDEXES;
    public static final String AS_CONNECTOR_WITH_SPACES = " as ";
    public static final String ANGULAR_DIRECTIVES_DOC_INDEX_USER_STRING = "addi";
    public static final String ANGULAR_DIRECTIVES_INDEX_USER_STRING = "adi";
    public static final String ANGULAR_FILTER_INDEX_USER_STRING = "afi";
    public static final String ANGULAR_SYMBOL_INDEX_USER_STRING = "asi";
    public static final String ANGULAR_MODULE_INDEX_USER_STRING = "ami";
    static final String RESTRICT = "@restrict";
    static final String ELEMENT = "@element";
    private static final String PARAM = "@param";

    public static boolean isInjectable(PsiElement context) {
        JSCallExpression call = (JSCallExpression)PsiTreeUtil.getContextOfType((PsiElement)context, JSCallExpression.class, (boolean)false, (Class[])new Class[]{JSBlockStatement.class});
        if (call != null) {
            JSExpression methodExpression = (JSExpression)AstLoadingFilter.forceAllowTreeLoading((PsiFile)call.getContainingFile(), () -> ((JSCallExpression)call).getMethodExpression());
            JSReferenceExpression callee = (JSReferenceExpression)ObjectUtils.tryCast((Object)methodExpression, JSReferenceExpression.class);
            JSExpression qualifier = callee != null ? callee.getQualifier() : null;
            return qualifier != null && INJECTABLE_METHODS.contains(callee.getReferenceName());
        }
        return false;
    }

    @NotNull
    public String[] inheritanceMethodNames() {
        if (ALL_INTERESTING_METHODS == null) {
            AngularJSIndexingHandler.$$$reportNull$$$0(0);
        }
        return ALL_INTERESTING_METHODS;
    }

    @NotNull
    public String[] implicitProviderMethodNames() {
        if (ALL_INTERESTING_METHODS == null) {
            AngularJSIndexingHandler.$$$reportNull$$$0(1);
        }
        return ALL_INTERESTING_METHODS;
    }

    public JSLiteralImplicitElementProvider createLiteralImplicitElementProvider(final @NotNull String command) {
        if (command == null) {
            AngularJSIndexingHandler.$$$reportNull$$$0(2);
        }
        return new JSLiteralImplicitElementProvider(){

            public void fillIndexingData(@NotNull JSLiteralExpression argument, @NotNull JSCallExpression callExpression, @NotNull JSElementIndexingData outIndexingData) {
                JSExpression[] arguments;
                if (argument == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (callExpression == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (outIndexingData == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((arguments = callExpression.getArguments()).length == 0 || arguments[0] != argument) {
                    return;
                }
                JSExpression methodExpression = callExpression.getMethodExpression();
                if (!(methodExpression instanceof JSReferenceExpression)) {
                    return;
                }
                JSExpression qualifier = ((JSReferenceExpression)methodExpression).getQualifier();
                if (qualifier == null) {
                    return;
                }
                StubIndexKey index = (StubIndexKey)INDEXERS.get(command);
                if (index != null) {
                    if (argument.isQuotedLiteral()) {
                        Processor argumentListProcessor = (Processor)ARGUMENT_LIST_CHECKERS.get(command);
                        if (argumentListProcessor != null && !argumentListProcessor.process((Object)callExpression.getArgumentList())) {
                            return;
                        }
                        Function calculator = (Function)DATA_CALCULATORS.get(command);
                        String data = calculator != null ? (String)calculator.fun((Object)argument) : null;
                        String argumentText = AngularJSIndexingHandler.unquote((PsiElement)argument);
                        if (data != null && data.startsWith("D;")) {
                            AngularJSIndexingHandler.addImplicitElements((JSImplicitElementProvider)argument, command, (StubIndexKey<String, JSImplicitElementProvider>)index, argumentText, "A" + data.substring(1), outIndexingData);
                        }
                        AngularJSIndexingHandler.addImplicitElements((JSImplicitElementProvider)argument, command, (StubIndexKey<String, JSImplicitElementProvider>)index, argumentText, data, outIndexingData);
                    }
                } else if (INJECTABLE_METHODS.contains(command) && argument.isQuotedLiteral()) {
                    AngularJSIndexingHandler.generateNamespace(argument, outIndexingData);
                }
                if (AngularJSIndexingHandler.START_SYMBOL.equals(command) || AngularJSIndexingHandler.END_SYMBOL.equals(command)) {
                    while (qualifier != null) {
                        if (qualifier instanceof JSReferenceExpression) {
                            if ("$interpolateProvider".equals(((JSReferenceExpression)qualifier).getReferenceName()) && argument.isQuotedLiteral()) {
                                String interpolation = AngularJSIndexingHandler.unquote((PsiElement)argument);
                                if ("//".equals(interpolation)) {
                                    return;
                                }
                                FileViewProvider provider = qualifier.getContainingFile().getOriginalFile().getViewProvider();
                                VirtualFile virtualFile = provider.getVirtualFile();
                                VirtualFile virtualFile2 = virtualFile = virtualFile instanceof LightVirtualFile ? ((LightVirtualFile)virtualFile).getOriginalFile() : virtualFile;
                                if (virtualFile != null && JSLibraryUtil.isProbableLibraryFile((VirtualFile)virtualFile)) {
                                    return;
                                }
                                AngularJSIndexingHandler.addImplicitElements((JSImplicitElementProvider)argument, null, (StubIndexKey<String, JSImplicitElementProvider>)AngularInjectionDelimiterIndex.KEY, command, interpolation, outIndexingData);
                            }
                            qualifier = ((JSReferenceExpression)qualifier).getQualifier();
                            continue;
                        }
                        qualifier = qualifier instanceof JSCallExpression ? ((JSCallExpression)qualifier).getMethodExpression() : null;
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "argument";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outIndexingData";
                        break;
                    }
                }
                objectArray[1] = "org/angularjs/index/AngularJSIndexingHandler$1";
                objectArray[2] = "fillIndexingData";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public void processCallExpression(JSCallExpression callExpression, @NotNull JSElementIndexingData outData) {
        JSExpression[] arguments;
        JSReferenceExpression reference;
        if (outData == null) {
            AngularJSIndexingHandler.$$$reportNull$$$0(3);
        }
        if ((reference = (JSReferenceExpression)ObjectUtils.tryCast((Object)callExpression.getMethodExpression(), JSReferenceExpression.class)) == null) {
            return;
        }
        if (JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)reference, (String[])new String[]{"$stateProvider", STATE})) {
            JSExpression[] arguments2 = callExpression.getArguments();
            if (arguments2.length == 1 && arguments2[0] instanceof JSReferenceExpression) {
                AngularJSIndexingHandler.addImplicitElements((JSImplicitElementProvider)callExpression, null, AngularUiRouterGenericStatesIndex.KEY, STATE, null, outData);
            }
        } else if (JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)reference, (String[])new String[]{"angular", MODULE}) && (arguments = callExpression.getArguments()).length > 1 && arguments[0] instanceof JSReferenceExpression) {
            AngularJSIndexingHandler.addImplicitElements((JSImplicitElementProvider)callExpression, null, AngularGenericModulesIndex.KEY, MODULE, null, outData);
        }
    }

    public boolean shouldCreateStubForCallExpression(ASTNode node) {
        ASTNode methodExpression = JSCallExpressionImpl.getMethodExpression((ASTNode)node);
        if (methodExpression == null) {
            return false;
        }
        ASTNode referencedNameElement = methodExpression.getLastChildNode();
        ASTNode qualifierElement = JSReferenceExpressionImpl.getQualifierNode((ASTNode)methodExpression);
        if (qualifierElement == null) {
            return false;
        }
        String referencedName = referencedNameElement.getText();
        String qualifier = qualifierElement.getText();
        return STATE.equals(referencedName) && "$stateProvider".equalsIgnoreCase(qualifier) || MODULE.equals(referencedName) && "angular".equalsIgnoreCase(qualifier) || INJECTABLE_METHODS.contains(referencedName);
    }

    @Nullable
    public JSElementIndexingData processAnyProperty(@NotNull JSProperty property, @Nullable JSElementIndexingData outData) {
        PairProcessor<JSProperty, JSElementIndexingData> customProcessor;
        JSElementIndexingData localOutData;
        String name;
        if (property == null) {
            AngularJSIndexingHandler.$$$reportNull$$$0(4);
        }
        if ((name = property.getName()) == null) {
            return outData;
        }
        if (TEMPLATE_URL.equals(name) && AngularJSIndexingHandler.processTemplateUrlProperty(property, localOutData = outData == null ? new JSElementIndexingDataImpl() : outData)) {
            return localOutData;
        }
        if (TEMPLATE.equals(name) && AngularJSIndexingHandler.processTemplateProperty(property, localOutData = outData == null ? new JSElementIndexingDataImpl() : outData)) {
            return localOutData;
        }
        Trinity<JSCallExpression, Integer, Boolean> wrappingCall = AngularJSIndexingHandler.findWrappingCall(property);
        if (wrappingCall == null) {
            return outData;
        }
        JSCallExpression callExpression = (JSCallExpression)wrappingCall.first;
        int level = (Integer)wrappingCall.second;
        boolean immediate = (Boolean)wrappingCall.third;
        JSExpression methodExpression = callExpression.getMethodExpression();
        if (!(methodExpression instanceof JSReferenceExpression) || ((JSReferenceExpression)methodExpression).getQualifier() == null) {
            return outData;
        }
        String command = ((JSReferenceExpression)methodExpression).getReferenceName();
        PairProcessor<JSProperty, JSElementIndexingData> pairProcessor = customProcessor = immediate ? CUSTOM_PROPERTY_PROCESSORS.get(command) : CUSTOM_INDIRECT_PROPERTY_PROCESSORS.get(command);
        if (customProcessor != null && customProcessor.process((Object)property, (Object)(localOutData = outData == null ? new JSElementIndexingDataImpl() : outData))) {
            return localOutData;
        }
        if (level > 1 || !immediate) {
            return outData;
        }
        PsiElement parent = property.getParent();
        StubIndexKey<String, JSImplicitElementProvider> index = INDEXERS.get(command);
        if (index == null) {
            return outData;
        }
        if (callExpression.getArguments()[0] != parent) {
            return outData;
        }
        if (outData == null) {
            outData = new JSElementIndexingDataImpl();
        }
        AngularJSIndexingHandler.addImplicitElements((JSImplicitElementProvider)property, command, index, name, null, outData);
        return outData;
    }

    @Nullable
    private static Trinity<JSCallExpression, Integer, Boolean> findWrappingCall(@NotNull JSProperty property) {
        if (property == null) {
            AngularJSIndexingHandler.$$$reportNull$$$0(5);
        }
        PsiElement current = property.getParent();
        int level = 0;
        boolean immediate = true;
        while (current instanceof JSElement) {
            PsiElement callExpression;
            if (current instanceof JSProperty) {
                current = current.getParent();
                continue;
            }
            if (current instanceof JSObjectLiteralExpression) {
                ++level;
                current = current.getParent();
                continue;
            }
            if (current instanceof JSReturnStatement) {
                immediate = false;
                JSFunction function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)current, JSFunction.class);
                if (function instanceof JSFunctionExpression) {
                    current = function.getParent();
                } else {
                    return null;
                }
            }
            if (current instanceof JSArrayLiteralExpression) {
                current = current.getParent();
            }
            if (current instanceof JSArgumentList && (callExpression = current.getParent()) instanceof JSCallExpression) {
                return Trinity.create((Object)((JSCallExpression)callExpression), (Object)level, (Object)immediate);
            }
            return null;
        }
        return null;
    }

    public boolean indexImplicitElement(@NotNull JSImplicitElementStructure element, @Nullable IndexSink sink) {
        String userID;
        StubIndexKey index;
        if (element == null) {
            AngularJSIndexingHandler.$$$reportNull$$$0(6);
        }
        StubIndexKey stubIndexKey = index = (userID = element.getUserString()) != null ? (StubIndexKey)INDEXES.get((Object)userID) : null;
        if (index != null && sink != null) {
            sink.occurrence(index, (Object)element.getName());
            if (index != AngularSymbolIndex.KEY) {
                sink.occurrence(AngularSymbolIndex.KEY, (Object)element.getName());
            }
        }
        return false;
    }

    public JSElementIndexingData processJSDocComment(@NotNull JSDocComment comment, @Nullable JSElementIndexingData outData) {
        if (comment == null) {
            AngularJSIndexingHandler.$$$reportNull$$$0(7);
        }
        JSDocTag ngdocTag = null;
        JSDocTag nameTag = null;
        for (JSDocTag tag : comment.getTags()) {
            if ("ngdoc".equals(tag.getName())) {
                ngdocTag = tag;
                continue;
            }
            if (!"name".equals(tag.getName())) continue;
            nameTag = tag;
        }
        if (ngdocTag != null && nameTag != null) {
            String name;
            JSDocTagValue nameValue = nameTag.getValue();
            String string = name = nameValue != null ? nameValue.getText() : null;
            if (name != null) {
                name = name.substring(name.indexOf(58) + 1);
            }
            String ngdocValue = null;
            PsiElement nextSibling = ngdocTag.getNextSibling();
            if (nextSibling instanceof PsiWhiteSpace) {
                nextSibling = nextSibling.getNextSibling();
            }
            if (nextSibling != null && nextSibling.getNode().getElementType() == JSDocTokenTypes.DOC_COMMENT_DATA) {
                ngdocValue = nextSibling.getText();
            }
            if (ngdocValue != null && name != null) {
                String[] commentLines = StringUtil.splitByLines((String)comment.getText());
                boolean directive = ngdocValue.contains(DIRECTIVE);
                boolean component = ngdocValue.contains(COMPONENT);
                if (directive || component) {
                    List<Pair<String, String>> restrictions = AngularJSIndexingHandler.calculateRestrictions(commentLines, name, directive ? DEFAULT_RESTRICTIONS : "E");
                    if (outData == null) {
                        outData = new JSElementIndexingDataImpl();
                    }
                    for (Pair<String, String> p : restrictions) {
                        AngularJSIndexingHandler.addImplicitElements((JSImplicitElementProvider)comment, directive ? DIRECTIVE : COMPONENT, AngularDirectivesDocIndex.KEY, (String)p.first, (String)p.second, outData);
                    }
                } else if (ngdocValue.contains(FILTER)) {
                    if (outData == null) {
                        outData = new JSElementIndexingDataImpl();
                    }
                    AngularJSIndexingHandler.addImplicitElements((JSImplicitElementProvider)comment, FILTER, AngularFilterIndex.KEY, name, null, outData);
                }
            }
        }
        return outData;
    }

    private static List<Pair<String, String>> calculateRestrictions(String[] commentLines, String directiveName, String defaultRestrictions) {
        String restrict = defaultRestrictions;
        String tag = "";
        SmartList result = new SmartList();
        for (String line : commentLines) {
            JSDocumentationUtils.DocTag docTag;
            restrict = AngularJSIndexingHandler.getParamValue(restrict, line, RESTRICT);
            tag = AngularJSIndexingHandler.getParamValue(tag, line, ELEMENT);
            int start = line.indexOf(PARAM);
            if (start < 0 || (docTag = JSDocumentationUtils.getDocTag((String)line.substring(start))) == null || docTag.matchName == null) continue;
            for (String paramName : StringUtil.split((String)docTag.matchName, (String)"|")) {
                if (restrict.equals(DEFAULT_RESTRICTIONS) || restrict.contains("A")) {
                    result.add(Pair.pair((Object)paramName, (Object)("A;" + tag + (directiveName.equals(paramName) ? "" : "=" + directiveName) + ";" + (docTag.matchValue != null ? docTag.matchValue : "") + ";")));
                }
                if (!restrict.contains("E")) continue;
                result.add(Pair.pair((Object)paramName, (Object)("A;" + directiveName + ";" + (docTag.matchValue != null ? docTag.matchValue : "") + ";")));
            }
        }
        if (restrict.contains("E")) {
            result.add(Pair.pair((Object)directiveName, (Object)("E;" + tag + ";;")));
        } else if (result.isEmpty()) {
            if (restrict.equals(DEFAULT_RESTRICTIONS)) {
                result.add(Pair.pair((Object)directiveName, (Object)("A;" + tag + ";;")));
            }
            result.add(Pair.pair((Object)directiveName, (Object)(restrict + ";" + tag + ";;")));
        } else if (restrict.equals(DEFAULT_RESTRICTIONS)) {
            result.add(Pair.pair((Object)directiveName, (Object)("D;" + tag + ";;")));
        }
        return result;
    }

    public static boolean isAngularRestrictions(@Nullable String restrictions) {
        return restrictions == null || StringUtil.countChars((CharSequence)restrictions, (char)';') >= 3;
    }

    static String getParamValue(String previousValue, String line, String docTag) {
        int indexOfTag = line.indexOf(docTag);
        if (indexOfTag >= 0) {
            int commentAtEndIndex = line.indexOf("//", indexOfTag);
            String newValue = line.substring(indexOfTag + docTag.length(), commentAtEndIndex > 0 ? commentAtEndIndex : line.length());
            if (!StringUtil.isEmpty((String)(newValue = newValue.trim()))) {
                return newValue;
            }
        }
        return previousValue;
    }

    private static void generateNamespace(@NotNull JSLiteralExpression argument, @NotNull JSElementIndexingData outData) {
        String namespace;
        if (argument == null) {
            AngularJSIndexingHandler.$$$reportNull$$$0(8);
        }
        if (outData == null) {
            AngularJSIndexingHandler.$$$reportNull$$$0(9);
        }
        if ((namespace = AngularJSIndexingHandler.unquote((PsiElement)argument)) == null) {
            return;
        }
        JSQualifiedNameImpl qName = JSQualifiedNameImpl.fromQualifiedName((String)namespace);
        JSImplicitElementImpl.Builder elementBuilder = new JSImplicitElementImpl.Builder((JSQualifiedName)qName, (PsiElement)argument).setType(JSImplicitElement.Type.Class).setUserString(ANGULAR_SYMBOL_INDEX_USER_STRING);
        JSImplicitElementImpl implicitElement = elementBuilder.toImplicitElement();
        outData.addImplicitElement((JSImplicitElement)implicitElement);
    }

    private static void addImplicitElements(@NotNull JSImplicitElementProvider elementProvider, @Nullable String command, @NotNull StubIndexKey<String, JSImplicitElementProvider> index, @Nullable String defaultName, @Nullable String value, @NotNull JSElementIndexingData outData) {
        String name;
        if (elementProvider == null) {
            AngularJSIndexingHandler.$$$reportNull$$$0(10);
        }
        if (index == null) {
            AngularJSIndexingHandler.$$$reportNull$$$0(11);
        }
        if (outData == null) {
            AngularJSIndexingHandler.$$$reportNull$$$0(12);
        }
        if (defaultName == null) {
            return;
        }
        List keys = INDEXES.getKeysByValue(index);
        assert (keys != null && keys.size() == 1);
        Consumer adder = builder -> {
            builder.setType(elementProvider instanceof JSDocComment ? JSImplicitElement.Type.Tag : JSImplicitElement.Type.Class).setTypeString(value);
            builder.setUserString((String)keys.get(0));
            JSImplicitElementImpl implicitElement = builder.toImplicitElement();
            outData.addImplicitElement((JSImplicitElement)implicitElement);
        };
        Function<String, List<String>> variants = POLY_NAME_CONVERTERS.get(command);
        if (variants != null) {
            List strings = (List)variants.fun((Object)defaultName);
            for (String string : strings) {
                adder.consume((Object)new JSImplicitElementImpl.Builder(string, (PsiElement)elementProvider));
            }
        } else {
            adder.consume((Object)new JSImplicitElementImpl.Builder((JSQualifiedName)JSQualifiedNameImpl.fromQualifiedName((String)defaultName), (PsiElement)elementProvider));
        }
        Function<String, String> converter = command != null ? NAME_CONVERTERS.get(command) : null;
        String string = name = converter != null ? (String)converter.fun((Object)defaultName) : defaultName;
        if (!StringUtil.equals((CharSequence)defaultName, (CharSequence)name)) {
            JSImplicitElementImpl.Builder symbolElementBuilder = new JSImplicitElementImpl.Builder(name, (PsiElement)elementProvider).setType(elementProvider instanceof JSDocComment ? JSImplicitElement.Type.Tag : JSImplicitElement.Type.Class).setTypeString(value);
            List symbolKeys = INDEXES.getKeysByValue(AngularSymbolIndex.KEY);
            assert (symbolKeys != null && symbolKeys.size() == 1);
            symbolElementBuilder.setUserString((String)symbolKeys.get(0));
            JSImplicitElementImpl implicitElement2 = symbolElementBuilder.toImplicitElement();
            outData.addImplicitElement((JSImplicitElement)implicitElement2);
        }
    }

    private static String calculateRestrictions(PsiElement element, String defaultRestrictions) {
        final Ref restrict = Ref.create((Object)defaultRestrictions);
        PsiElement function = AngularJSIndexingHandler.findFunction(element);
        if (function != null) {
            function.accept((PsiElementVisitor)new JSRecursiveElementVisitor(){

                public void visitJSProperty(JSProperty node) {
                    String unquoted;
                    String name = node.getName();
                    JSExpression value = node.getValue();
                    if (AngularJSIndexingHandler.RESTRICT_PROP.equals(name) && value instanceof JSLiteralExpression && ((JSLiteralExpression)value).isQuotedLiteral() && (unquoted = AngularJSIndexingHandler.unquote((PsiElement)value)) != null) {
                        restrict.set((Object)unquoted);
                    }
                }
            });
        }
        return ((String)restrict.get()).trim() + ";;;";
    }

    private static PsiElement findFunction(PsiElement element) {
        JSArrayLiteralExpression array;
        PsiElement function = PsiTreeUtil.getNextSiblingOfType((PsiElement)element, JSFunction.class);
        if (function == null) {
            function = PsiTreeUtil.getNextSiblingOfType((PsiElement)element, JSObjectLiteralExpression.class);
        }
        if (function == null) {
            JSExpression expression = (JSExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)element, JSExpression.class);
            function = AngularJSIndexingHandler.findDeclaredFunction(expression);
        }
        if (function == null && (function = PsiTreeUtil.findChildOfType((PsiElement)(array = (JSArrayLiteralExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)element, JSArrayLiteralExpression.class)), JSFunction.class)) == null) {
            JSExpression candidate = array != null ? (JSExpression)PsiTreeUtil.getPrevSiblingOfType((PsiElement)array.getLastChild(), JSExpression.class) : null;
            function = AngularJSIndexingHandler.findDeclaredFunction(candidate);
        }
        return function;
    }

    private static PsiElement findDeclaredFunction(JSExpression expression) {
        String name;
        String string = name = expression instanceof JSReferenceExpression ? ((JSReferenceExpression)expression).getReferenceName() : null;
        if (name != null) {
            CompositeElement definition;
            ASTNode node = expression.getNode();
            JSTreeUtil.JSScopeDeclarationsAndAssignments declaration = JSTreeUtil.getDeclarationsAndAssignmentsInScopeAndUp((String)name, (ASTNode)node);
            CompositeElement compositeElement = definition = declaration != null ? declaration.findNearestDefinition(node) : null;
            if (definition != null) {
                return definition.getPsi();
            }
        }
        return null;
    }

    public String resolveContextFromProperty(JSObjectLiteralExpression objectLiteralExpression, boolean returnPropertiesNamespace) {
        if (!(objectLiteralExpression.getParent() instanceof JSReturnStatement)) {
            return null;
        }
        JSFunction function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)objectLiteralExpression, JSFunction.class);
        JSCallExpression call = (JSCallExpression)PsiTreeUtil.getParentOfType((PsiElement)function, JSCallExpression.class);
        if (call != null) {
            JSExpression argument;
            JSExpression[] arguments;
            JSExpression methodExpression = call.getMethodExpression();
            if (!(methodExpression instanceof JSReferenceExpression)) {
                return null;
            }
            JSReferenceExpression callee = (JSReferenceExpression)methodExpression;
            JSExpression qualifier = callee.getQualifier();
            if (qualifier == null) {
                return null;
            }
            String command = callee.getReferencedName();
            if (INJECTABLE_METHODS.contains(command) && (arguments = call.getArguments()).length > 0 && (argument = arguments[0]) instanceof JSLiteralExpression && ((JSLiteralExpression)argument).isQuotedLiteral()) {
                return AngularJSIndexingHandler.unquote((PsiElement)argument);
            }
        }
        return null;
    }

    public boolean addTypeFromResolveResult(@NotNull JSTypeEvaluator evaluator, @NotNull JSEvaluateContext context, @NotNull PsiElement resolveResult) {
        PsiElement resolveParent;
        if (evaluator == null) {
            AngularJSIndexingHandler.$$$reportNull$$$0(13);
        }
        if (context == null) {
            AngularJSIndexingHandler.$$$reportNull$$$0(14);
        }
        if (resolveResult == null) {
            AngularJSIndexingHandler.$$$reportNull$$$0(15);
        }
        if (!AngularIndexUtil.hasAngularJS(resolveResult.getProject()) && !Angular2LangUtil.isAngular2Context(resolveResult)) {
            return false;
        }
        if (resolveResult instanceof JSDefinitionExpression && resolveResult.getLanguage() instanceof AngularJSLanguage && AngularJSReferenceExpressionResolver.isAsExpression(resolveParent = resolveResult.getParent())) {
            String name = resolveParent.getFirstChild().getText();
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)resolveResult);
            JSType type = JSNamedType.createType((String)name, (JSTypeSource)source, (JSContext)JSContext.INSTANCE);
            evaluator.addType(type, resolveResult);
            return true;
        }
        if (resolveResult instanceof JSVariable && resolveResult.getLanguage() instanceof AngularJSLanguage && (resolveParent = resolveResult.getParent().getParent()) instanceof AngularJSRepeatExpression && AngularJSIndexingHandler.calculateRepeatParameterType(evaluator, (AngularJSRepeatExpression)resolveParent)) {
            return true;
        }
        if (resolveResult instanceof JSParameter && evaluator.isFromCurrentFile(resolveResult) && AngularJSIndexingHandler.isInjectable(resolveResult)) {
            String name = ((JSParameter)resolveResult).getName();
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)resolveResult);
            JSType type = JSNamedType.createType((String)name, (JSTypeSource)source, (JSContext)JSContext.UNKNOWN);
            evaluator.addType(type, resolveResult);
        }
        return false;
    }

    public int getVersion() {
        return 65;
    }

    private static boolean calculateRepeatParameterType(JSTypeEvaluator evaluator, AngularJSRepeatExpression resolveParent) {
        return JSPsiImplUtils.calculateTypeOfVariableForIteratedExpression((JSTypeEvaluator)evaluator, (PsiElement)AngularJSIndexingHandler.findReferenceExpression(resolveParent), (JSExpression)resolveParent);
    }

    private static PsiElement findReferenceExpression(AngularJSRepeatExpression parent) {
        JSExpression collection = parent.getCollection();
        while (collection instanceof JSBinaryExpression && ((JSBinaryExpression)collection).getROperand() instanceof AngularJSFilterExpression) {
            collection = ((JSBinaryExpression)collection).getLOperand();
        }
        return collection;
    }

    private static PairProcessor<JSProperty, JSElementIndexingData> createRouterParametersProcessor() {
        return new PairProcessor<JSProperty, JSElementIndexingData>(){

            public boolean process(JSProperty property, JSElementIndexingData outData) {
                if (!(property.getValue() instanceof JSLiteralExpression)) {
                    return true;
                }
                JSLiteralExpression value = (JSLiteralExpression)property.getValue();
                if (!value.isQuotedLiteral()) {
                    return true;
                }
                String unquotedValue = AngularJSIndexingHandler.unquote((PsiElement)value);
                if (AngularJSIndexingHandler.CONTROLLER_AS.equals(property.getName())) {
                    return this.recordControllerAs(property, outData, value, unquotedValue);
                }
                if (AngularJSIndexingHandler.CONTROLLER.equals(property.getName())) {
                    int idx;
                    int n = idx = unquotedValue != null ? unquotedValue.indexOf(AngularJSIndexingHandler.AS_CONNECTOR_WITH_SPACES) : 0;
                    if (idx > 0 && idx + AngularJSIndexingHandler.AS_CONNECTOR_WITH_SPACES.length() < unquotedValue.length() - 1) {
                        return this.recordControllerAs(property, outData, value, unquotedValue.substring(idx + AngularJSIndexingHandler.AS_CONNECTOR_WITH_SPACES.length()));
                    }
                } else if ("name".equals(property.getName())) {
                    AngularJSIndexingHandler.addImplicitElements((JSImplicitElementProvider)value, AngularJSIndexingHandler.STATE, (StubIndexKey<String, JSImplicitElementProvider>)((StubIndexKey)INDEXERS.get(AngularJSIndexingHandler.STATE)), unquotedValue, null, outData);
                    return true;
                }
                return true;
            }

            private boolean recordControllerAs(JSProperty property, JSElementIndexingData outData, JSLiteralExpression value, String unquotedValue) {
                StubIndexKey index = (StubIndexKey)INDEXERS.get(AngularJSIndexingHandler.CONTROLLER);
                assert (index != null);
                JSObjectLiteralExpression object = (JSObjectLiteralExpression)ObjectUtils.tryCast((Object)property.getParent(), JSObjectLiteralExpression.class);
                if (object == null) {
                    return false;
                }
                JSProperty controllerProperty = object.findProperty(AngularJSIndexingHandler.CONTROLLER);
                if (controllerProperty != null) {
                    AngularJSIndexingHandler.addImplicitElements((JSImplicitElementProvider)controllerProperty, null, (StubIndexKey<String, JSImplicitElementProvider>)index, unquotedValue, null, outData);
                    return true;
                }
                AngularJSIndexingHandler.addImplicitElements((JSImplicitElementProvider)value, null, (StubIndexKey<String, JSImplicitElementProvider>)index, unquotedValue, null, outData);
                return true;
            }
        };
    }

    @Nullable
    public static String unquote(PsiElement value) {
        return ((JSLiteralExpression)value).getStringValue();
    }

    private static boolean isControllerProperty(@NotNull JSProperty property) {
        PsiElement parent;
        if (property == null) {
            AngularJSIndexingHandler.$$$reportNull$$$0(16);
        }
        return (parent = property.getParent()) instanceof JSObjectLiteralExpression && (((JSObjectLiteralExpression)parent).findProperty(CONTROLLER) != null || ((JSObjectLiteralExpression)parent).findProperty(BINDINGS) != null || ((JSObjectLiteralExpression)parent).findProperty(SCOPE) != null);
    }

    private static boolean processTemplateProperty(@NotNull JSProperty property, @NotNull JSElementIndexingData data) {
        JSExpression expression;
        if (property == null) {
            AngularJSIndexingHandler.$$$reportNull$$$0(17);
        }
        if (data == null) {
            AngularJSIndexingHandler.$$$reportNull$$$0(18);
        }
        if (((expression = property.getValue()) instanceof JSReferenceExpression || expression instanceof JSCallExpression) && AngularJSIndexingHandler.isControllerProperty(property)) {
            return AngularJSIndexingHandler.indexComponentTemplateRef(property, Angular2IndexingHandler.getExprReferencedFileUrl(expression), data);
        }
        return false;
    }

    private static boolean processTemplateUrlProperty(@NotNull JSProperty property, @NotNull JSElementIndexingData data) {
        JSExpression value;
        if (property == null) {
            AngularJSIndexingHandler.$$$reportNull$$$0(19);
        }
        if (data == null) {
            AngularJSIndexingHandler.$$$reportNull$$$0(20);
        }
        if ((value = property.getValue()) instanceof JSLiteralExpression && AngularJSIndexingHandler.isControllerProperty(property)) {
            return AngularJSIndexingHandler.indexComponentTemplateRef(property, AngularJSIndexingHandler.unquote((PsiElement)value), data);
        }
        return false;
    }

    private static boolean indexComponentTemplateRef(@NotNull JSProperty property, @Nullable String url, @NotNull JSElementIndexingData data) {
        if (property == null) {
            AngularJSIndexingHandler.$$$reportNull$$$0(21);
        }
        if (data == null) {
            AngularJSIndexingHandler.$$$reportNull$$$0(22);
        }
        if (StringUtil.isEmptyOrSpaces((String)url)) {
            return false;
        }
        String fileName = new File(url).getName();
        data.addImplicitElement((JSImplicitElement)new JSImplicitElementImpl.Builder(fileName, (PsiElement)property).setTypeString("TU;;;").setUserString((String)Objects.requireNonNull(INDEXES.getKeysByValue(AngularTemplateUrlIndex.KEY)).get(0)).toImplicitElement());
        return true;
    }

    private static boolean processScopedProperty(JSProperty property, JSElementIndexingData data, String propertyName, boolean isComponent) {
        PsiElement parent = property.getParent();
        if (parent instanceof JSObjectLiteralExpression && parent.getParent() instanceof JSProperty && propertyName.equals(((JSProperty)parent.getParent()).getName()) && property.getName() != null) {
            Trinity<JSCallExpression, Integer, Boolean> call = AngularJSIndexingHandler.findWrappingCall(property);
            assert (call != null);
            JSExpression[] arguments = ((JSCallExpression)call.first).getArguments();
            if (arguments.length < 2 || !(arguments[0] instanceof JSLiteralExpression) || !((JSLiteralExpression)arguments[0]).isQuotedLiteral()) {
                return false;
            }
            String name = StringUtil.notNullize((String)AngularJSIndexingHandler.unquote((PsiElement)arguments[0]));
            String restrictions = AngularJSIndexingHandler.getRestrictions(parent, isComponent ? "E" : DEFAULT_RESTRICTIONS);
            String attributeName = DirectiveUtil.getPropertyAlias(property.getName(), property.getValue());
            if (restrictions.contains("E") || restrictions.equals(DEFAULT_RESTRICTIONS)) {
                AngularJSIndexingHandler.addImplicitElements((JSImplicitElementProvider)property, attributeName, AngularDirectivesDocIndex.KEY, attributeName, "A;" + name + ";" + AngularJSIndexingHandler.getBindingType(property.getValue()) + ";", data);
            }
            if (restrictions.contains("A") || restrictions.equals(DEFAULT_RESTRICTIONS)) {
                AngularJSIndexingHandler.addImplicitElements((JSImplicitElementProvider)property, attributeName, AngularDirectivesDocIndex.KEY, attributeName, "A;ANY" + (attributeName.equals(name) ? "" : "=" + name) + ";" + AngularJSIndexingHandler.getBindingType(property.getValue()) + ";", data);
            }
            return true;
        }
        return false;
    }

    private static String getRestrictions(PsiElement parent, String defaultRestrictions) {
        JSExpression restrict = (JSExpression)ObjectUtils.doIfNotNull((Object)((JSObjectLiteralExpression)parent).findProperty(RESTRICT_PROP), JSProperty::getValue);
        if (restrict instanceof JSLiteralExpression && ((JSLiteralExpression)restrict).isQuotedLiteral()) {
            return StringUtil.notNullize((String)AngularJSIndexingHandler.unquote((PsiElement)restrict), (String)defaultRestrictions);
        }
        return defaultRestrictions;
    }

    private static String getBindingType(@Nullable JSExpression valueExpr) {
        String typeStr;
        if (valueExpr instanceof JSLiteralExpression && (typeStr = ((JSLiteralExpression)valueExpr).getStringValue()) != null && typeStr.startsWith("@")) {
            return "constString";
        }
        return "expression";
    }

    static {
        Collections.addAll(INTERESTING_METHODS, "service", "factory", "value", "constant", "provider");
        INJECTABLE_METHODS.addAll(INTERESTING_METHODS);
        Collections.addAll(INJECTABLE_METHODS, CONTROLLER, DIRECTIVE, COMPONENT, MODULE, "config", "run");
        INDEXERS.put(DIRECTIVE, AngularDirectivesIndex.KEY);
        NAME_CONVERTERS.put(DIRECTIVE, (Function<String, String>)((Function)DirectiveUtil::getAttributeName));
        DATA_CALCULATORS.put(DIRECTIVE, (Function<PsiElement, String>)((Function)element -> AngularJSIndexingHandler.calculateRestrictions(element, DEFAULT_RESTRICTIONS)));
        INDEXERS.put(COMPONENT, AngularDirectivesIndex.KEY);
        DATA_CALCULATORS.put(COMPONENT, (Function<PsiElement, String>)((Function)element -> AngularJSIndexingHandler.calculateRestrictions(element, "E")));
        INDEXERS.put(CONTROLLER, AngularControllerIndex.KEY);
        INDEXERS.put(MODULE, AngularModuleIndex.KEY);
        INDEXERS.put(FILTER, AngularFilterIndex.KEY);
        INDEXERS.put(STATE, AngularUiRouterStatesIndex.KEY);
        THashSet allInterestingMethods = new THashSet(INTERESTING_METHODS);
        allInterestingMethods.addAll(INJECTABLE_METHODS);
        allInterestingMethods.addAll(INDEXERS.keySet());
        allInterestingMethods.add((Object)START_SYMBOL);
        allInterestingMethods.add((Object)END_SYMBOL);
        ALL_INTERESTING_METHODS = ArrayUtilRt.toStringArray((Collection)allInterestingMethods);
        INDEXES = new BidirectionalMap();
        INDEXES.put((Object)"aci", AngularControllerIndex.KEY);
        INDEXES.put((Object)ANGULAR_DIRECTIVES_DOC_INDEX_USER_STRING, AngularDirectivesDocIndex.KEY);
        INDEXES.put((Object)ANGULAR_DIRECTIVES_INDEX_USER_STRING, AngularDirectivesIndex.KEY);
        INDEXES.put((Object)ANGULAR_FILTER_INDEX_USER_STRING, AngularFilterIndex.KEY);
        INDEXES.put((Object)"aidi", AngularInjectionDelimiterIndex.KEY);
        INDEXES.put((Object)ANGULAR_MODULE_INDEX_USER_STRING, AngularModuleIndex.KEY);
        INDEXES.put((Object)ANGULAR_SYMBOL_INDEX_USER_STRING, AngularSymbolIndex.KEY);
        INDEXES.put((Object)"arsi", AngularUiRouterStatesIndex.KEY);
        INDEXES.put((Object)"arsgi", AngularUiRouterGenericStatesIndex.KEY);
        INDEXES.put((Object)"agmi", AngularGenericModulesIndex.KEY);
        INDEXES.put((Object)"ajtui", AngularTemplateUrlIndex.KEY);
        for (String key : INDEXES.keySet()) {
            JSImplicitElement.ourUserStringsRegistry.registerUserString(key);
        }
        CUSTOM_PROPERTY_PROCESSORS.put(COMPONENT, (PairProcessor<JSProperty, JSElementIndexingData>)((PairProcessor)(property, data) -> AngularJSIndexingHandler.processScopedProperty(property, data, BINDINGS, true)));
        CUSTOM_INDIRECT_PROPERTY_PROCESSORS.put(DIRECTIVE, (PairProcessor<JSProperty, JSElementIndexingData>)((PairProcessor)(property, data) -> {
            boolean result = AngularJSIndexingHandler.processScopedProperty(property, data, SCOPE, false);
            return AngularJSIndexingHandler.processScopedProperty(property, data, BIND_TO_CONTROLLER, false) || result;
        }));
        NAME_CONVERTERS.put(BINDINGS, NAME_CONVERTERS.get(DIRECTIVE));
        NAME_CONVERTERS.put(SCOPE, NAME_CONVERTERS.get(DIRECTIVE));
        NAME_CONVERTERS.put(BIND_TO_CONTROLLER, NAME_CONVERTERS.get(DIRECTIVE));
        PairProcessor<JSProperty, JSElementIndexingData> processor = AngularJSIndexingHandler.createRouterParametersProcessor();
        CUSTOM_PROPERTY_PROCESSORS.put(WHEN, processor);
        CUSTOM_PROPERTY_PROCESSORS.put("otherwise", processor);
        CUSTOM_PROPERTY_PROCESSORS.put(STATE, processor);
        POLY_NAME_CONVERTERS.put(STATE, (Function<String, List<String>>)((NotNullFunction)dom -> {
            String[] parts = dom.split("\\.");
            ArrayList<String> result = new ArrayList<String>();
            result.add((String)dom);
            String tail = "";
            for (int i = parts.length - 1; i > 0; --i) {
                String part = "." + parts[i] + tail;
                result.add(part);
                tail = part;
            }
            return result;
        }));
        POLY_NAME_CONVERTERS.put(MODULE, (Function<String, List<String>>)((Function)Collections::singletonList));
        ARGUMENT_LIST_CHECKERS.put(MODULE, (Processor<JSArgumentList>)((Processor)list -> list.getArguments().length > 1));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angularjs/index/AngularJSIndexingHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 3: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outData";
                break;
            }
            case 4: 
            case 5: 
            case 16: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementProvider";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluator";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "inheritanceMethodNames";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "implicitProviderMethodNames";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angularjs/index/AngularJSIndexingHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createLiteralImplicitElementProvider";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processCallExpression";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processAnyProperty";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findWrappingCall";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "indexImplicitElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processJSDocComment";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "generateNamespace";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addImplicitElements";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromResolveResult";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isControllerProperty";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processTemplateProperty";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processTemplateUrlProperty";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "indexComponentTemplateRef";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

