/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.extensions.compass;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.extensions.compass.CompassConfig;
import org.jetbrains.plugins.sass.extensions.compass.CompassConfigParser;
import org.jrubyparser.CompatVersion;
import org.jrubyparser.NodeVisitor;
import org.jrubyparser.Parser;
import org.jrubyparser.ast.ArrayNode;
import org.jrubyparser.ast.ClassNode;
import org.jrubyparser.ast.FCallNode;
import org.jrubyparser.ast.LocalAsgnNode;
import org.jrubyparser.ast.ModuleNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.StrNode;
import org.jrubyparser.lexer.SyntaxException;
import org.jrubyparser.parser.ParserConfiguration;
import org.jrubyparser.rewriter.ReWriteVisitor;

public class CompassConfigParserImpl
extends CompassConfigParser {
    private static final String DUMMY_CONFIG_PATH_RB = "dummy_config_path.rb";

    @Override
    @NotNull
    public CompassConfig parse(@NotNull VirtualFile file, final @NotNull String importPathsRoot, @Nullable PsiManager psiManager) {
        CompassConfig compassConfig;
        block11: {
            Node node;
            String fileContent;
            ArrayList additionalImportPaths;
            ArrayList<String> importPaths;
            block10: {
                if (file == null) {
                    CompassConfigParserImpl.$$$reportNull$$$0(0);
                }
                if (importPathsRoot == null) {
                    CompassConfigParserImpl.$$$reportNull$$$0(1);
                }
                Parser parser = new Parser();
                importPaths = new ArrayList<String>();
                additionalImportPaths = new ArrayList();
                fileContent = (String)ReadAction.compute(() -> {
                    PsiFile psiFile;
                    if (psiManager != null && (psiFile = psiManager.findFile(file)) != null) {
                        return psiFile.getText();
                    }
                    return null;
                });
                if (fileContent == null) {
                    fileContent = VfsUtilCore.loadText((VirtualFile)file);
                }
                if ((node = parser.parse(DUMMY_CONFIG_PATH_RB, (Reader)new StringReader(fileContent), new ParserConfiguration(0, CompatVersion.RUBY2_0))) != null) break block10;
                CompassConfig compassConfig2 = CompassConfig.EMPTY_COMPASS_CONFIG;
                if (compassConfig2 == null) {
                    CompassConfigParserImpl.$$$reportNull$$$0(2);
                }
                return compassConfig2;
            }
            try {
                node.accept((NodeVisitor)new ReWriteVisitor(new StringWriter(), fileContent){

                    public Object visitModuleNode(ModuleNode iVisited) {
                        return null;
                    }

                    public Object visitClassNode(ClassNode iVisited) {
                        return null;
                    }

                    public Object visitLocalAsgnNode(LocalAsgnNode iVisited) {
                        if ("additional_import_paths".equals(iVisited.getName())) {
                            additionalImportPaths.clear();
                            Node value = iVisited.getValue();
                            if (value instanceof ArrayNode) {
                                for (Node node : value.childNodes()) {
                                    if (!(node instanceof StrNode)) continue;
                                    additionalImportPaths.add(CompassConfigParser.normalizePath(((StrNode)node).getValue(), importPathsRoot));
                                }
                            }
                        }
                        return super.visitLocalAsgnNode(iVisited);
                    }

                    public Object visitFCallNode(FCallNode iVisited) {
                        if ("add_import_path".equals(iVisited.getName())) {
                            List nodes;
                            if (iVisited.getArgs() instanceof ArrayNode && (nodes = iVisited.getArgs().childNodes()).size() > 0) {
                                for (Node arg : nodes) {
                                    if (!(arg instanceof StrNode)) continue;
                                    importPaths.add(CompassConfigParser.normalizePath(((StrNode)arg).getValue(), importPathsRoot));
                                }
                            }
                        } else {
                            super.visitFCallNode(iVisited);
                        }
                        return null;
                    }

                    public void visitNode(Node iVisited) {
                        try {
                            super.visitNode(iVisited);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
                importPaths.addAll(additionalImportPaths);
                compassConfig = new CompassConfig(importPaths);
                if (compassConfig != null) break block11;
            }
            catch (SyntaxException ignore) {
                CompassConfig compassConfig3 = CompassConfig.EMPTY_COMPASS_CONFIG;
                if (compassConfig3 == null) {
                    CompassConfigParserImpl.$$$reportNull$$$0(4);
                }
                return compassConfig3;
            }
            catch (IOException e) {
                CompassConfig compassConfig4 = CompassConfig.EMPTY_COMPASS_CONFIG;
                if (compassConfig4 == null) {
                    CompassConfigParserImpl.$$$reportNull$$$0(5);
                }
                return compassConfig4;
            }
            CompassConfigParserImpl.$$$reportNull$$$0(3);
        }
        return compassConfig;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPathsRoot";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/sass/extensions/compass/CompassConfigParserImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/sass/extensions/compass/CompassConfigParserImpl";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

