/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.extensions.compass;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.SASSBundle;
import org.jetbrains.plugins.sass.extensions.SassExtension;
import org.jetbrains.plugins.sass.extensions.SassExtensionFunctionInfo;
import org.jetbrains.plugins.sass.extensions.SassExtensionFunctionInfoImpl;
import org.jetbrains.plugins.sass.extensions.SassRubyIntegrationHelper;
import org.jetbrains.plugins.sass.extensions.compass.CompassImportPathRegistrationWatcher;
import org.jetbrains.plugins.sass.extensions.compass.CompassImportPathRegistrationWatcherImpl;
import org.jetbrains.plugins.sass.extensions.compass.CompassSettings;
import org.jetbrains.plugins.sass.extensions.compass.CompassUtil;

public class CompassSassExtension
extends SassExtension
implements CompassImportPathRegistrationWatcher.ImportPathsListener {
    private static final Set<String> APPROPRIATE_MODULE_NAMES = ContainerUtil.newHashSet((Object[])new String[]{"Compass::SassExtensions::Functions", "Compass::Core::SassExtensions::Functions"});
    private static final Map<String, SassExtensionFunctionInfo> CUSTOM_FUNCTIONS = ContainerUtil.newHashMap((Pair)Pair.pair((Object)"_webkit", (Object)new SassExtensionFunctionInfoImpl("-webkit", "$arg, ...", "This is a shortcut for calling prefix(-webkit, $arg, ...).", "compass", null)), (Pair[])new Pair[]{Pair.pair((Object)"_o", (Object)new SassExtensionFunctionInfoImpl("-o", "$arg, ...", "This is a shortcut for calling prefix(-o, $arg, ...).", "compass", null)), Pair.pair((Object)"_ms", (Object)new SassExtensionFunctionInfoImpl("-ms", "$arg, ...", "This is a shortcut for calling prefix(-ms, $arg, ...).", "compass", null)), Pair.pair((Object)"_svg", (Object)new SassExtensionFunctionInfoImpl("-svg", "$arg, ...", "This is a shortcut for calling prefix(-svg, $arg, ...).", "compass", null)), Pair.pair((Object)"_pie", (Object)new SassExtensionFunctionInfoImpl("-pie", "$arg, ...", "This is a shortcut for calling prefix(-pie, $arg, ...).", "compass", null)), Pair.pair((Object)"_css2", (Object)new SassExtensionFunctionInfoImpl("-css2", "$arg, ...", "This is a shortcut for calling prefix(-css2, $arg, ...).", "compass", null)), Pair.pair((Object)"_owg", (Object)new SassExtensionFunctionInfoImpl("-owg", "$arg, ...", "This is a shortcut for calling prefix(-owg, $arg, ...).", "compass", null)), Pair.pair((Object)"_moz", (Object)new SassExtensionFunctionInfoImpl("-moz", "$arg, ...", "This is a shortcut for calling prefix(-moz, $arg, ...).", "compass", null))});

    @Override
    public String getName() {
        return SASSBundle.message("compass.gem.name");
    }

    @Override
    protected boolean isAvailableInModule(@NotNull Module module) {
        if (module == null) {
            CompassSassExtension.$$$reportNull$$$0(0);
        }
        if (module.isDisposed() || SassRubyIntegrationHelper.getInstance().hasRubyPlugin()) {
            return false;
        }
        CompassSettings compassSettings = CompassSettings.getInstance(module);
        return compassSettings != null && compassSettings.isCompassSupportEnabled();
    }

    public void startActivity(@NotNull Module module) {
        CompassImportPathRegistrationWatcherImpl compassImportPathsWatcher;
        CompassSettings settings;
        if (module == null) {
            CompassSassExtension.$$$reportNull$$$0(1);
        }
        if (!module.isDisposed() && (settings = CompassSettings.getInstance(module)) != null && settings.isCompassSupportEnabled() && (compassImportPathsWatcher = CompassImportPathRegistrationWatcherImpl.getInstance(module)) != null) {
            compassImportPathsWatcher.subscribe(this, !settings.getCompassConfigPath().isEmpty());
        }
    }

    public void stopActivity(@NotNull Module module) {
        CompassImportPathRegistrationWatcherImpl watcher;
        if (module == null) {
            CompassSassExtension.$$$reportNull$$$0(2);
        }
        if ((watcher = CompassImportPathRegistrationWatcherImpl.getInstance(module)) != null) {
            boolean wasStarted = watcher.isStarted();
            watcher.stop();
            if (wasStarted) {
                ApplicationManager.getApplication().invokeLater(() -> CompassUtil.removeCompassLibraryIfNeeded(module), ModalityState.NON_MODAL);
            }
        }
    }

    @Override
    @NotNull
    public Collection<SassExtensionFunctionInfo> getCustomFunctions() {
        Collection<SassExtensionFunctionInfo> collection = CUSTOM_FUNCTIONS.values();
        if (collection == null) {
            CompassSassExtension.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @Override
    @Nullable
    public SassExtensionFunctionInfo findCustomFunctionByName(@NotNull String name) {
        if (name == null) {
            CompassSassExtension.$$$reportNull$$$0(4);
        }
        return CUSTOM_FUNCTIONS.get(name);
    }

    @NotNull
    public Set<String> getRubyModulesWithFunctionExtensions() {
        Set<String> set = APPROPRIATE_MODULE_NAMES;
        if (set == null) {
            CompassSassExtension.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Override
    public void pathsChanged(@NotNull Module module, @NotNull Set<String> newImportPaths) {
        CompassSettings compassSettings;
        if (module == null) {
            CompassSassExtension.$$$reportNull$$$0(6);
        }
        if (newImportPaths == null) {
            CompassSassExtension.$$$reportNull$$$0(7);
        }
        if (!module.isDisposed() && !newImportPaths.equals(new HashSet<String>((compassSettings = CompassSettings.getInstance(module)).getImportPaths()))) {
            compassSettings.setImportPaths(new ArrayList<String>(newImportPaths));
            ApplicationManager.getApplication().invokeLater(() -> CompassUtil.updateCompassLibraries(compassSettings));
        }
    }

    @Override
    @NotNull
    public Collection<? extends VirtualFile> getStylesheetsRoots(@NotNull Module module) {
        List<String> importPaths;
        CompassSettings compassSettings;
        if (module == null) {
            CompassSassExtension.$$$reportNull$$$0(8);
        }
        if (!module.isDisposed() && (compassSettings = CompassSettings.getInstance(module)) != null && compassSettings.isCompassSupportEnabled() && !(importPaths = compassSettings.getImportPaths()).isEmpty()) {
            LinkedList<VirtualFile> result = new LinkedList<VirtualFile>();
            VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
            for (String path : importPaths) {
                VirtualFile vfile = virtualFileManager.findFileByUrl(VfsUtilCore.pathToUrl((String)path));
                if (vfile == null) continue;
                result.add(vfile);
            }
            LinkedList<VirtualFile> linkedList = result;
            if (linkedList == null) {
                CompassSassExtension.$$$reportNull$$$0(9);
            }
            return linkedList;
        }
        List list = Collections.emptyList();
        if (list == null) {
            CompassSassExtension.$$$reportNull$$$0(10);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/sass/extensions/compass/CompassSassExtension";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newImportPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/sass/extensions/compass/CompassSassExtension";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomFunctions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRubyModulesWithFunctionExtensions";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getStylesheetsRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableInModule";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "startActivity";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "stopActivity";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findCustomFunctionByName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "pathsChanged";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getStylesheetsRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

