/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote;

import com.google.common.collect.Lists;
import com.google.common.net.HostAndPort;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.remote.RemoteProcess;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.Tunnelable;
import com.intellij.util.PathMapper;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyPositionConverter;
import com.jetbrains.python.debugger.remote.vfs.PyRemotePositionConverter;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteProcessHandlerBase;
import com.jetbrains.python.remote.PyRemoteSocketToLocalHostProvider;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.remote.RemoteDebuggableProcessHandler;
import java.nio.charset.Charset;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRemoteProcessHandler
extends PyRemoteProcessHandlerBase
implements RemoteDebuggableProcessHandler,
KillableProcess {
    private static final Logger LOG = Logger.getInstance((String)PyRemoteProcessHandler.class.getName());
    public static final String LOG_PY_CHARM_FILE_MAPPING = "LOG: PyCharm: File mapping:";
    @NotNull
    private final PyRemotePathMapper myPathMapper;
    private final List<PathMappingSettings.PathMapping> myFileMappings;
    @NotNull
    private final PyRemoteSocketToLocalHostProvider myRemoteSocketProvider;

    private PyRemoteProcessHandler(@NotNull RemoteProcess process, @NotNull String commandLine, @Nullable Charset charset, PyRemotePathMapper pathMapper, @NotNull PyRemoteSocketToLocalHostProvider remoteSocketProvider) {
        if (process == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(0);
        }
        if (commandLine == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(1);
        }
        if (remoteSocketProvider == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(2);
        }
        super(process, commandLine, charset);
        this.myFileMappings = Lists.newArrayList();
        this.myRemoteSocketProvider = remoteSocketProvider;
        this.myPathMapper = pathMapper != null ? pathMapper : new PyRemotePathMapper();
        this.putUserData(PythonRemoteInterpreterManager.PATH_MAPPING_SETTINGS_KEY, pathMapper);
    }

    @NotNull
    public PathMapper getMappingSettings() {
        PyRemotePathMapper pyRemotePathMapper = this.myPathMapper;
        if (pyRemotePathMapper == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(3);
        }
        return pyRemotePathMapper;
    }

    @Deprecated
    public void addRemoteForwarding(int remotePort, int localPort) {
        try {
            if (this.myProcess instanceof Tunnelable) {
                ((Tunnelable)this.myProcess).addRemoteTunnel(remotePort, "localhost", localPort);
            }
        }
        catch (RemoteSdkException e) {
            throw new RuntimeException(e);
        }
    }

    public Pair<String, Integer> getRemoteSocket(int localPort) throws RemoteSdkException {
        try {
            return this.myRemoteSocketProvider.getRemoteSocket(localPort);
        }
        catch (RemoteSdkException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public HostAndPort getLocalTunnel(int remotePort) {
        return ((RemoteProcess)this.myProcess).getLocalTunnel(remotePort);
    }

    public boolean canKillProcess() {
        return true;
    }

    public void killProcess() {
        this.destroyProcessImpl();
    }

    public static PyRemoteProcessHandler createProcessHandler(@NotNull RemoteProcess remoteProcess, RemoteSdkCredentials data, GeneralCommandLine commandLine, PyRemotePathMapper pathMapper, @NotNull PyRemoteSocketToLocalHostProvider remoteSocketProvider) throws RemoteSdkException {
        if (remoteProcess == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(4);
        }
        if (remoteSocketProvider == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(5);
        }
        return PyRemoteProcessHandler.createProcessHandler(remoteProcess, data.getFullInterpreterPath(), commandLine, pathMapper, remoteSocketProvider);
    }

    @NotNull
    public static PyRemoteProcessHandler createProcessHandler(@NotNull RemoteProcess remoteProcess, String fullInterpreterPath, GeneralCommandLine commandLine, PyRemotePathMapper pathMapper, @NotNull PyRemoteSocketToLocalHostProvider remoteSocketProvider) throws RemoteSdkException {
        if (remoteProcess == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(6);
        }
        if (remoteSocketProvider == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(7);
        }
        PyRemoteProcessHandler pyRemoteProcessHandler = new PyRemoteProcessHandler(remoteProcess, commandLine.getCommandLineString(fullInterpreterPath), commandLine.getCharset(), pathMapper, remoteSocketProvider);
        if (pyRemoteProcessHandler == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(8);
        }
        return pyRemoteProcessHandler;
    }

    public void coloredTextAvailable(@NotNull String text, @NotNull Key outputType) {
        if (text == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(9);
        }
        if (outputType == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(10);
        }
        if (text.startsWith(LOG_PY_CHARM_FILE_MAPPING)) {
            String[] paths = (text = text.substring(LOG_PY_CHARM_FILE_MAPPING.length())).split("\t");
            if (paths.length == 2) {
                this.myFileMappings.add(new PathMappingSettings.PathMapping(paths[0].trim(), paths[1].trim()));
            } else {
                LOG.warn("Can't parse remote file mapping " + text);
            }
        } else {
            super.coloredTextAvailable(text, outputType);
        }
    }

    public List<PathMappingSettings.PathMapping> getFileMappings() {
        return this.myFileMappings;
    }

    public PyPositionConverter createPositionConverter(@NotNull PyDebugProcess debugProcess) {
        if (debugProcess == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(11);
        }
        return new PyRemotePositionConverter(debugProcess, this.myPathMapper);
    }

    public PyRemoteSocketToLocalHostProvider getRemoteSocketToLocalHostProvider() {
        return this.myRemoteSocketProvider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteSocketProvider";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/remote/PyRemoteProcessHandler";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteProcess";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/remote/PyRemoteProcessHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingSettings";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 8: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createProcessHandler";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "coloredTextAvailable";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createPositionConverter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

