/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote;

import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteProcess;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkException;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.DialogSshSudoPasswordStringProvider;
import com.intellij.ssh.PasswordStringProvider;
import com.intellij.ssh.ProcessBuilder;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.process.SshExecProcess;
import com.jetbrains.plugins.remotesdk.RemoteSdkSessionUtil;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteProcessHandler;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSdkCredentials;
import com.jetbrains.python.remote.PyRemoteSocketToLocalHostProvider;
import com.jetbrains.python.remote.PyRemoteSocketToLocalHostProviderFactory;
import com.jetbrains.python.remote.PySshCommandLineStateUtil;
import com.jetbrains.python.remote.PySshRemoteConnectionData;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRemoteProcessHandlerUtil {
    @NotNull
    public static SshExecProcessWithHandler startRemoteProcess(@Nullable Project project, @NotNull GeneralCommandLine commandLine, @NotNull PythonRemoteInterpreterManager manager, @NotNull PyRemoteSdkAdditionalDataBase sdkAdditionalData, @NotNull PyRemotePathMapper pathMapper) throws InterruptedException, ExecutionException {
        if (commandLine == null) {
            PyRemoteProcessHandlerUtil.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            PyRemoteProcessHandlerUtil.$$$reportNull$$$0(1);
        }
        if (sdkAdditionalData == null) {
            PyRemoteProcessHandlerUtil.$$$reportNull$$$0(2);
        }
        if (pathMapper == null) {
            PyRemoteProcessHandlerUtil.$$$reportNull$$$0(3);
        }
        pathMapper = manager.setupMappings(project, sdkAdditionalData, pathMapper);
        PyRemoteSdkCredentials remoteSdkCredentials = (PyRemoteSdkCredentials)sdkAdditionalData.getRemoteSdkCredentials(true);
        final ListenableFuture future = manager.uploadHelpersAsync(null, null, null, (RemoteSdkCredentials)remoteSdkCredentials, false);
        final Ref ref = Ref.create(null);
        try {
            new Task.Modal(project, "Checking Remote Helpers", false){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        future.get(15L, TimeUnit.SECONDS);
                    }
                    catch (TimeoutException e) {
                        throw new PythonRemoteInterpreterManager.PyHelpersNotReadyException((Throwable)e);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public void onThrowable(@NotNull Throwable e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (e instanceof PythonRemoteInterpreterManager.PyHelpersNotReadyException) {
                        ref.set((Object)((PythonRemoteInterpreterManager.PyHelpersNotReadyException)e));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "indicator";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "e";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/python/remote/PyRemoteProcessHandlerUtil$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "run";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onThrowable";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }.queue();
        }
        catch (RuntimeException e) {
            throw new ExecutionException((Throwable)e);
        }
        if (!ref.isNull()) {
            throw (PythonRemoteInterpreterManager.PyHelpersNotReadyException)ref.get();
        }
        SshExecProcessWithHandler sshExecProcessWithHandler = PyRemoteProcessHandlerUtil.startRemoteProcess(project, new PySshRemoteConnectionData(remoteSdkCredentials), commandLine, pathMapper, sdkAdditionalData.isRunAsRootViaSudo());
        if (sshExecProcessWithHandler == null) {
            PyRemoteProcessHandlerUtil.$$$reportNull$$$0(4);
        }
        return sshExecProcessWithHandler;
    }

    @NotNull
    private static SshExecProcessWithHandler startRemoteProcess(@Nullable Project project, @NotNull PySshRemoteConnectionData connectionData, @NotNull GeneralCommandLine commandLine, @NotNull PyRemotePathMapper pathMapper, boolean runAsRootViaSudo) throws RemoteSdkException {
        if (connectionData == null) {
            PyRemoteProcessHandlerUtil.$$$reportNull$$$0(5);
        }
        if (commandLine == null) {
            PyRemoteProcessHandlerUtil.$$$reportNull$$$0(6);
        }
        if (pathMapper == null) {
            PyRemoteProcessHandlerUtil.$$$reportNull$$$0(7);
        }
        PyRemoteSdkCredentials data = connectionData.getPyRemoteSdkCredentials();
        ConnectionBuilder connectionBuilder = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)data, (Project)project);
        RemoteSdkSessionUtil.checkConnection((ConnectionBuilder)connectionBuilder, (Project)project);
        PyRemoteSocketToLocalHostProvider sshRemoteSocketProvider = PyRemoteSocketToLocalHostProviderFactory.ssh(connectionBuilder, data);
        PySshCommandLineStateUtil.patchCommandLineForSshSession(commandLine, data, pathMapper, sshRemoteSocketProvider);
        commandLine.setExePath(data.getInterpreterPath());
        ProcessBuilder builder = RemoteCredentialsUtil.processBuilder((ConnectionBuilder)connectionBuilder, (GeneralCommandLine)commandLine).withAllocatePty(true).withSudo(runAsRootViaSudo, (PasswordStringProvider)new DialogSshSudoPasswordStringProvider((RemoteSdkCredentials)data));
        SshExecProcess process = builder.start();
        PyRemoteProcessHandler processHandler = PyRemoteProcessHandler.createProcessHandler((RemoteProcess)process, (RemoteSdkCredentials)data, commandLine, pathMapper, sshRemoteSocketProvider);
        SshExecProcessWithHandler sshExecProcessWithHandler = new SshExecProcessWithHandler(process, processHandler);
        if (sshExecProcessWithHandler == null) {
            PyRemoteProcessHandlerUtil.$$$reportNull$$$0(8);
        }
        return sshExecProcessWithHandler;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkAdditionalData";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/remote/PyRemoteProcessHandlerUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/remote/PyRemoteProcessHandlerUtil";
                break;
            }
            case 4: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "startRemoteProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "startRemoteProcess";
                break;
            }
            case 4: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SshExecProcessWithHandler {
        @NotNull
        private final SshExecProcess process;
        @NotNull
        private final PyRemoteProcessHandler handler;

        public SshExecProcessWithHandler(@NotNull SshExecProcess process, @NotNull PyRemoteProcessHandler handler) {
            if (process == null) {
                SshExecProcessWithHandler.$$$reportNull$$$0(0);
            }
            if (handler == null) {
                SshExecProcessWithHandler.$$$reportNull$$$0(1);
            }
            this.process = process;
            this.handler = handler;
        }

        @NotNull
        public SshExecProcess getProcess() {
            SshExecProcess sshExecProcess = this.process;
            if (sshExecProcess == null) {
                SshExecProcessWithHandler.$$$reportNull$$$0(2);
            }
            return sshExecProcess;
        }

        @NotNull
        public PyRemoteProcessHandler getHandler() {
            PyRemoteProcessHandler pyRemoteProcessHandler = this.handler;
            if (pyRemoteProcessHandler == null) {
                SshExecProcessWithHandler.$$$reportNull$$$0(3);
            }
            return pyRemoteProcessHandler;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/remote/PyRemoteProcessHandlerUtil$SshExecProcessWithHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/remote/PyRemoteProcessHandlerUtil$SshExecProcessWithHandler";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProcess";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

