/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.agent.DockerUtil;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import icons.DockerIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerDeploymentStatus {
    private static final DeploymentStatus STOPPED_EXITED = new DeploymentStatus(DockerIcons.SingleStoppedContainer, "Stopped", false);
    private static final DeploymentStatus STOPPED_CREATED = new DeploymentStatus(DockerIcons.SingleStoppedContainer, "Created", false);
    public static final DockerDeploymentStatus IMAGE = DockerDeploymentStatus.wrapStatus(new DeploymentStatus(DockerIcons.SingleImage, "Image", false));
    public static final DockerDeploymentStatus STARTING = new DockerDeploymentStatus(DeploymentStatus.DEPLOYING, "Starting");
    public static final DockerDeploymentStatus STARTED = new DockerDeploymentStatus(DeploymentStatus.DEPLOYED, "Started");
    public static final DockerDeploymentStatus STOPPING = new DockerDeploymentStatus(DeploymentStatus.UNDEPLOYING, "Stopping");
    public static final DockerDeploymentStatus STOPPED = DockerDeploymentStatus.wrapStatus(STOPPED_EXITED);
    public static final DockerDeploymentStatus CREATED = DockerDeploymentStatus.wrapStatus(STOPPED_CREATED);
    public static final DockerDeploymentStatus DELETING = new DockerDeploymentStatus(DeploymentStatus.UNDEPLOYING, "Deleting");
    public static final DockerDeploymentStatus DELETED = new DockerDeploymentStatus(DeploymentStatus.NOT_DEPLOYED, "Deleted");
    private final DeploymentStatus myMainStatus;
    private final String myCustomText;

    public static DockerDeploymentStatus newContainerStatus(@Nullable String statusText) {
        if (statusText == null || DockerUtil.isStartedStatus((String)statusText)) {
            return statusText == null ? DockerDeploymentStatus.wrapStatus(DeploymentStatus.DEPLOYED) : new DockerDeploymentStatus(DeploymentStatus.DEPLOYED, statusText);
        }
        if (DockerUtil.isExitedStatus((String)statusText)) {
            return new DockerDeploymentStatus(STOPPED_EXITED, statusText);
        }
        if (DockerUtil.isCreatedStatus((String)statusText)) {
            return new DockerDeploymentStatus(STOPPED_CREATED, statusText);
        }
        return new DockerDeploymentStatus(DeploymentStatus.DEPLOYING, statusText);
    }

    private static DockerDeploymentStatus wrapStatus(@NotNull DeploymentStatus mainStatus) {
        if (mainStatus == null) {
            DockerDeploymentStatus.$$$reportNull$$$0(0);
        }
        return new DockerDeploymentStatus(mainStatus, mainStatus.getPresentableText());
    }

    public static DockerDeploymentStatus newImageStatus() {
        return IMAGE;
    }

    public DockerDeploymentStatus(@NotNull DeploymentStatus mainStatus, @NotNull String customText) {
        if (mainStatus == null) {
            DockerDeploymentStatus.$$$reportNull$$$0(1);
        }
        if (customText == null) {
            DockerDeploymentStatus.$$$reportNull$$$0(2);
        }
        this.myMainStatus = mainStatus;
        this.myCustomText = customText;
    }

    public DeploymentStatus getStatus() {
        return this.myMainStatus;
    }

    public String getCustomText() {
        return this.myCustomText;
    }

    public boolean matches(@NotNull Deployment deploymentModel) {
        if (deploymentModel == null) {
            DockerDeploymentStatus.$$$reportNull$$$0(3);
        }
        return this.myMainStatus.equals(deploymentModel.getStatus()) && this.myCustomText.equals(deploymentModel.getStatusText());
    }

    public void apply(Deployment deploymentModel) {
        deploymentModel.setStatus(this.myMainStatus, this.myCustomText);
    }

    public static boolean canBeStarted(@NotNull DeploymentStatus status) {
        if (status == null) {
            DockerDeploymentStatus.$$$reportNull$$$0(4);
        }
        return status == STOPPED.getStatus() || status == CREATED.getStatus();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)) + ":" + this.myCustomText + ", main status: " + this.myMainStatus;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainStatus";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/DockerDeploymentStatus";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "wrapStatus";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "matches";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "canBeStarted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

