/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.machine;

import com.intellij.docker.DockerConfigurablesUtil;
import com.intellij.docker.DockerSettings;
import com.intellij.docker.machine.DockerMachine;
import com.intellij.docker.machine.DockerMachineUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerMachineConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    @NonNls
    public static final String ID = "reference.settingsDialog.application.dockerMachine";
    @NonNls
    public static final String HELP_TOPIC = "reference.settingsdialog.project.docker";
    private JPanel myMainPanel;
    private JBLabel myDockerMachineExecutableLabel;
    private TextFieldWithBrowseButton myDockerMachineExecutableField;
    private JBLabel myCheckResultLabel;
    private TextFieldWithBrowseButton myDockerComposeExecutableField;
    private TextFieldWithBrowseButton myDockerExecutableField;
    private final ReentrantLock myLock;
    private String myScheduledDockerMachineExecutable;
    private final ScheduledExecutorService myScheduledExecutorService;
    private JBTextFieldWithHint myDockerMachineExecutableTextField;
    private ScheduledFuture<?> myScheduledFuture;

    public DockerMachineConfigurable() {
        this.$$$setupUI$$$();
        this.myLock = new ReentrantLock();
        this.myScheduledExecutorService = ConcurrencyUtil.newSingleScheduledThreadExecutor((String)"Docker Machine Version");
    }

    @NotNull
    public String getId() {
        if (ID == null) {
            DockerMachineConfigurable.$$$reportNull$$$0(0);
        }
        return ID;
    }

    @Nls
    public String getDisplayName() {
        return "Docker";
    }

    @NotNull
    public String getHelpTopic() {
        if (HELP_TOPIC == null) {
            DockerMachineConfigurable.$$$reportNull$$$0(1);
        }
        return HELP_TOPIC;
    }

    @Nullable
    public JComponent createComponent() {
        FileChooserDescriptor singleExecutableDescriptor = FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor();
        this.myDockerMachineExecutableField.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener("Select Docker Machine Executable", "", (ComponentWithBrowseButton)this.myDockerMachineExecutableField, null, singleExecutableDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT));
        this.myDockerMachineExecutableField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                DockerMachineConfigurable.this.updateDockerMachineExecutable();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/docker/machine/DockerMachineConfigurable$1", "textChanged"));
            }
        });
        FileChooserDescriptor composeChooserDescriptor = new FileChooserDescriptor(true, false, false, false, false, false);
        composeChooserDescriptor.withFileFilter(file2 -> StringUtil.startsWith((CharSequence)file2.getName(), (CharSequence)"docker-compose"));
        this.myDockerComposeExecutableField.addBrowseFolderListener("Choose Docker Compose Executable Location", null, null, composeChooserDescriptor);
        FileChooserDescriptor dockerChooserDescriptor = new FileChooserDescriptor(true, false, false, false, false, false);
        dockerChooserDescriptor.withFileFilter(file2 -> StringUtil.startsWith((CharSequence)file2.getName(), (CharSequence)"docker"));
        this.myDockerExecutableField.addBrowseFolderListener("Choose Docker Executable Location", null, null, dockerChooserDescriptor);
        this.myCheckResultLabel.setVisible(false);
        return this.myMainPanel;
    }

    private void updateDockerMachineExecutable() {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        this.myDockerMachineExecutableTextField.setHint(null);
        this.myDockerMachineExecutableTextField.setHintIcon(null);
        this.myCheckResultLabel.setVisible(false);
        ModalityState modalityState = ModalityState.current();
        this.myLock.lock();
        try {
            String currentDockerMachineExecutable;
            this.myScheduledDockerMachineExecutable = currentDockerMachineExecutable = this.myDockerMachineExecutableField.getText();
            if (this.myScheduledFuture != null) {
                this.myScheduledFuture.cancel(false);
            }
            this.myScheduledFuture = this.myScheduledExecutorService.schedule(() -> {
                String dockerMachineExecutable;
                this.myLock.lock();
                try {
                    dockerMachineExecutable = this.myScheduledDockerMachineExecutable;
                }
                finally {
                    this.myLock.unlock();
                }
                if (!currentDockerMachineExecutable.equals(dockerMachineExecutable)) {
                    return;
                }
                DockerMachine dockerMachine = DockerMachine.getDockerMachine(dockerMachineExecutable);
                try {
                    String version = dockerMachine.version();
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (currentDockerMachineExecutable.equals(this.myDockerMachineExecutableField.getText())) {
                            this.onSuccess(version);
                        }
                    }, modalityState);
                }
                catch (RuntimeException e) {
                    String errorMessage = e.getMessage();
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (currentDockerMachineExecutable.equals(this.myDockerMachineExecutableField.getText())) {
                            this.onError(errorMessage);
                        }
                    }, modalityState);
                }
            }, 1500L, TimeUnit.MILLISECONDS);
        }
        finally {
            this.myLock.unlock();
        }
    }

    protected void onError(String errorMessage) {
        this.myDockerMachineExecutableTextField.setVisible(true);
        this.myDockerMachineExecutableTextField.setHint(null);
        this.myDockerMachineExecutableTextField.setHintIcon(UIUtil.getBalloonErrorIcon());
        this.myCheckResultLabel.setVisible(true);
        this.myCheckResultLabel.setText(UIUtil.toHtml((String)errorMessage));
        this.myCheckResultLabel.setForeground((Color)JBColor.RED);
        this.myCheckResultLabel.setIcon(UIUtil.getBalloonErrorIcon());
    }

    protected void onSuccess(String stdout) {
        this.myDockerMachineExecutableTextField.setVisible(true);
        this.myDockerMachineExecutableTextField.setHint(DockerMachineUtil.getVersion(stdout));
        this.myDockerMachineExecutableTextField.setHintIcon(null);
        this.myCheckResultLabel.setVisible(false);
    }

    public boolean isModified() {
        DockerSettings instance = DockerSettings.getInstance();
        return !StringUtil.equals((CharSequence)this.getDockerMachineExecutable(), (CharSequence)instance.getDockerMachinePath()) || !StringUtil.equals((CharSequence)this.myDockerComposeExecutableField.getText(), (CharSequence)instance.getDockerComposePath());
    }

    public void apply() {
        DockerSettings.getInstance().setDockerPath(this.myDockerExecutableField.getText());
        DockerSettings.getInstance().setDockerMachinePath(this.getDockerMachineExecutable());
        DockerSettings.getInstance().setDockerComposePath(this.myDockerComposeExecutableField.getText());
    }

    public String getDockerMachineExecutable() {
        return this.myDockerMachineExecutableField.getText();
    }

    public void reset() {
        this.myDockerExecutableField.setText(DockerSettings.getInstance().getDockerPath());
        String dockerMachinePath = DockerSettings.getInstance().getDockerMachinePath();
        this.myDockerMachineExecutableField.setText(dockerMachinePath);
        this.myDockerComposeExecutableField.setText(DockerSettings.getInstance().getDockerComposePath());
    }

    public void disposeUIResources() {
    }

    @NotNull
    public JComponent getAnchor() {
        JBLabel jBLabel = this.myDockerMachineExecutableLabel;
        if (jBLabel == null) {
            DockerMachineConfigurable.$$$reportNull$$$0(2);
        }
        return jBLabel;
    }

    private void createUIComponents() {
        this.myDockerMachineExecutableTextField = new JBTextFieldWithHint();
        this.myDockerMachineExecutableField = new TextFieldWithBrowseButton((JTextField)((Object)this.myDockerMachineExecutableTextField));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/docker/machine/DockerMachineConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpTopic";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnchor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBLabel jBLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JBLabel jBLabel2;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myDockerMachineExecutableLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Docker Machine executable:");
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton3 = this.myDockerMachineExecutableField;
        jPanel.add((Component)textFieldWithBrowseButton3, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Docker Compose executable:");
        jPanel.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myDockerComposeExecutableField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton2, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myCheckResultLabel = jBLabel = new JBLabel();
        jBLabel.setForeground(new Color(-65536));
        jPanel.add((Component)jBLabel, new GridConstraints(4, 0, 1, 2, 0, 1, 6, 0, new Dimension(10, -1), new Dimension(10, -1), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Docker executable:");
        jPanel.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDockerExecutableField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        jBLabel2.setLabelFor((Component)textFieldWithBrowseButton3);
        jBLabel4.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static class JBTextFieldWithHint
    extends JBTextField {
        private char[] myHint;
        private Icon myHintIcon;

        private JBTextFieldWithHint() {
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.myHint != null) {
                DockerConfigurablesUtil.paintHint(g, (Component)((Object)this), this.myHint);
            }
            if (this.myHintIcon != null) {
                DockerConfigurablesUtil.paintHintIcon(g, (Component)((Object)this), this.myHintIcon);
            }
        }

        public void setHint(@Nullable String hint) {
            this.myHint = hint == null ? null : hint.toCharArray();
            this.repaint();
        }

        public void setHintIcon(@Nullable Icon icon) {
            this.myHintIcon = icon;
            this.repaint();
        }
    }
}

