/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.action;

import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.plugins.watcher.BackgroundTaskBundle;
import com.intellij.plugins.watcher.config.BackgroundTaskConsumer;
import com.intellij.plugins.watcher.config.BackgroundTaskSuppressor;
import com.intellij.plugins.watcher.config.ui.NewWatcherDialog;
import com.intellij.plugins.watcher.model.ApplicationTasksOptions;
import com.intellij.plugins.watcher.model.ProjectTasksOptions;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.HoverHyperlinkLabel;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FwEditorNotificationProvider
extends EditorNotifications.Provider {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"FwEditorNotificationProvider");

    @NotNull
    public Key getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            FwEditorNotificationProvider.$$$reportNull$$$0(0);
        }
        return key;
    }

    @Nullable
    public JComponent createNotificationPanel(@NotNull VirtualFile vFile, @NotNull FileEditor fileEditor, @NotNull Project project) {
        if (vFile == null) {
            FwEditorNotificationProvider.$$$reportNull$$$0(1);
        }
        if (fileEditor == null) {
            FwEditorNotificationProvider.$$$reportNull$$$0(2);
        }
        if (project == null) {
            FwEditorNotificationProvider.$$$reportNull$$$0(3);
        }
        if (!vFile.isInLocalFileSystem()) {
            return null;
        }
        PsiFile file = PsiManager.getInstance((Project)project).findFile(vFile);
        if (file == null) {
            return null;
        }
        List taskConsumers = BackgroundTaskConsumer.EP_NAME.getExtensionList();
        if (taskConsumers.isEmpty()) {
            return null;
        }
        ArrayList<BackgroundTaskConsumer> toSuggest = new ArrayList<BackgroundTaskConsumer>();
        for (BackgroundTaskConsumer taskConsumer : taskConsumers) {
            if (!taskConsumer.isAvailable(file)) continue;
            TaskOptions taskOptions = taskConsumer.getOptionsTemplate();
            if (ProjectTasksOptions.getInstance(file.getProject()).isSuppressedTaskName(taskOptions.getName()) || ProjectTasksOptions.getInstance(file.getProject()).containWatcherWithFileType(taskOptions.getFileType()) || ProjectTasksOptions.getInstance(file.getProject()).hasWatcherWithName(taskOptions.getName()) || BackgroundTaskSuppressor.checkSuppress(file, taskOptions)) continue;
            toSuggest.add(taskConsumer);
        }
        if (toSuggest.size() == 0) {
            return null;
        }
        if (toSuggest.size() == 1) {
            return new FwPanel(project, file, (BackgroundTaskConsumer)toSuggest.get(0));
        }
        JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
        for (BackgroundTaskConsumer backgroundTaskConsumer : toSuggest) {
            panel.add((Component)((Object)new FwPanel(project, file, backgroundTaskConsumer)));
        }
        return panel;
    }

    private static void addFileWatcher(@NotNull Project project, @NotNull PsiFile file, @NotNull BackgroundTaskConsumer taskConsumer) {
        if (project == null) {
            FwEditorNotificationProvider.$$$reportNull$$$0(4);
        }
        if (file == null) {
            FwEditorNotificationProvider.$$$reportNull$$$0(5);
        }
        if (taskConsumer == null) {
            FwEditorNotificationProvider.$$$reportNull$$$0(6);
        }
        TaskOptions options = taskConsumer.getOptionsTemplate();
        TaskOptions lastOptions = ApplicationTasksOptions.getInstance().getLastEditedWatcherWithName(options.getName());
        taskConsumer.additionalConfiguration(project, file, options);
        taskConsumer.configureWithLastOptions(options, lastOptions);
        NewWatcherDialog dialog = new NewWatcherDialog(project, options, BackgroundTaskBundle.message("new.task", new Object[0]));
        if (!dialog.showAndGet()) {
            return;
        }
        TaskOptions newOptions = dialog.getTaskOptions();
        ApplicationTasksOptions.getInstance().addOrUpdate(Collections.singletonList(Pair.create((Object)newOptions, (Object)true)));
        ProjectTasksOptions.getInstance(project).addTask(newOptions, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/plugins/watcher/action/FwEditorNotificationProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/plugins/watcher/action/FwEditorNotificationProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addFileWatcher";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FwPanel
    extends EditorNotificationPanel {
        FwPanel(final @NotNull Project project, @NotNull PsiFile file, @NotNull BackgroundTaskConsumer taskConsumer) {
            if (project == null) {
                FwPanel.$$$reportNull$$$0(0);
            }
            if (file == null) {
                FwPanel.$$$reportNull$$$0(1);
            }
            if (taskConsumer == null) {
                FwPanel.$$$reportNull$$$0(2);
            }
            super(EditorColors.GUTTER_BACKGROUND);
            String fileWatcherLinkText = "File Watcher";
            HoverHyperlinkLabel fileWatcherLink = new HoverHyperlinkLabel(fileWatcherLinkText);
            fileWatcherLink.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

                protected void hyperlinkActivated(HyperlinkEvent e) {
                    ShowSettingsUtil.getInstance().showSettingsDialog(project, BackgroundTaskBundle.message("settings.name", new Object[0]));
                    EditorNotifications.getInstance((Project)project).updateAllNotifications();
                }
            });
            NonOpaquePanel questionPanel = new NonOpaquePanel((LayoutManager)new HorizontalLayout(JBUIScale.scale((int)0)));
            String message = taskConsumer.getConsumeMessage();
            int linkIndex = message.indexOf(fileWatcherLinkText);
            if (linkIndex < 0) {
                questionPanel.add((Component)new JBLabel(message));
            } else {
                questionPanel.add((Component)new JBLabel(message.substring(0, linkIndex)));
                questionPanel.add((Component)fileWatcherLink);
                questionPanel.add((Component)new JBLabel(message.substring(linkIndex + fileWatcherLinkText.length())));
            }
            this.add((Component)questionPanel, "West");
            this.createActionLabel("Yes", () -> {
                FwEditorNotificationProvider.addFileWatcher(project, file, taskConsumer);
                EditorNotifications.getInstance((Project)project).updateAllNotifications();
            });
            this.createActionLabel("No", () -> {
                ProjectTasksOptions.getInstance(project).suppressTaskName(taskConsumer.getOptionsTemplate().getName());
                EditorNotifications.getInstance((Project)project).updateAllNotifications();
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "taskConsumer";
                    break;
                }
            }
            objectArray[1] = "com/intellij/plugins/watcher/action/FwEditorNotificationProvider$FwPanel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

