/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.action;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.plugins.watcher.FwTaskRunner;
import com.intellij.plugins.watcher.model.ProjectTasksOptions;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class RunWatchersForFileAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RunWatchersForFileAction.$$$reportNull$$$0(0);
        }
        DataContext dataContext = e.getDataContext();
        Presentation presentation = e.getPresentation();
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        boolean enabled = files != null && project != null && RunWatchersForFileAction.hasDirOrTasks(project, files);
        presentation.setEnabledAndVisible(enabled);
    }

    private static boolean hasDirOrTasks(Project project, VirtualFile[] files) {
        for (VirtualFile file : files) {
            if (!file.isDirectory() && ProjectTasksOptions.getInstance(project).findTasksForFile(file).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            RunWatchersForFileAction.$$$reportNull$$$0(1);
        }
        DataContext dataContext = e.getDataContext();
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (files == null || project == null) {
            return;
        }
        ArrayList<VirtualFile> filesList = new ArrayList<VirtualFile>();
        for (VirtualFile file : files) {
            if (file.isDirectory()) {
                ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)project);
                index.iterateContentUnderDirectory(file, descendant -> {
                    if (!descendant.isDirectory()) {
                        filesList.add(descendant);
                    }
                    return true;
                });
                continue;
            }
            filesList.add(file);
        }
        for (VirtualFile virtualFile : filesList) {
            FwTaskRunner.tryFindTasksAndRun(project, virtualFile);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/plugins/watcher/action/RunWatchersForFileAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

