/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.autoupload;

import com.intellij.application.Topics;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.actions.SaveAllAction;
import com.intellij.ide.actions.SaveDocumentAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.util.messages.Topic;
import com.jetbrains.plugins.webDeployment.AutoUploadComponent;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.UploadPostponer;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.autoupload.AutoUploader;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.DeploymentNotifier;
import com.jetbrains.plugins.webDeployment.ui.FileTransferToolWindow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileListenerImpl
implements AnActionListener,
VirtualFileListener {
    private static final int CHECK_RELATED_CHANGES_TIMEOUT = 5000;
    @NotNull
    private final Project myProject;
    private PublishConfig myPublishConfig;
    private volatile boolean myUploadExternalChanges;
    private final List<AutoUploader> myUploaders;
    private volatile boolean myUploadOnSaveAll;
    private final List<ChangeData> myChanges;
    private volatile Disposable myActionListenerDisposable;
    private final Map<AnActionEvent, Editor> myActionsToHandle;
    private final AtomicBoolean myChecksRelatedChanges;

    public FileListenerImpl(@NotNull Project project, PublishConfig publishConfig, List<WebServerConfig> servers) {
        if (project == null) {
            FileListenerImpl.$$$reportNull$$$0(0);
        }
        this.myUploaders = new ArrayList<AutoUploader>();
        this.myChanges = new ArrayList<ChangeData>();
        this.myActionsToHandle = new HashMap<AnActionEvent, Editor>();
        this.myChecksRelatedChanges = new AtomicBoolean(false);
        this.myPublishConfig = publishConfig;
        this.myUploadExternalChanges = this.myPublishConfig.isAutoUploadExternalChanges();
        for (WebServerConfig server : servers) {
            this.myUploaders.add(new AutoUploader(project, publishConfig, server));
        }
        this.myProject = project;
        this.myUploadOnSaveAll = this.myPublishConfig.getAutoUploadState() == PublishConfig.AutoUploadState.ON_EXPLICIT_SAVE;
    }

    public synchronized void stopUpload() {
        for (AutoUploader uploader : this.myUploaders) {
            uploader.stopUpload();
        }
    }

    public synchronized void setConfigs(PublishConfig publishConfig, List<WebServerConfig> defaultServers) {
        this.myPublishConfig = publishConfig.clone();
        this.myUploadExternalChanges = this.myPublishConfig.isAutoUploadExternalChanges();
        boolean oldUploadOnSaveAll = this.myUploadOnSaveAll;
        this.myUploadOnSaveAll = this.myPublishConfig.getAutoUploadState() == PublishConfig.AutoUploadState.ON_EXPLICIT_SAVE;
        this.stopUpload();
        ArrayList<WebServerConfig> newServers = new ArrayList<WebServerConfig>(defaultServers);
        Iterator<AutoUploader> iterator = this.myUploaders.iterator();
        while (iterator.hasNext()) {
            AutoUploader next = iterator.next();
            if (!newServers.remove(next.getServer())) {
                iterator.remove();
                continue;
            }
            next.setConfig(publishConfig);
        }
        for (WebServerConfig server : newServers) {
            this.myUploaders.add(new AutoUploader(this.myProject, publishConfig, server));
        }
        if (publishConfig.getAutoUploadState() == PublishConfig.AutoUploadState.ALWAYS && oldUploadOnSaveAll) {
            this.uploadCollectedChanges(null);
        }
    }

    public void contentsChanged(@NotNull VirtualFileEvent event) {
        if (event == null) {
            FileListenerImpl.$$$reportNull$$$0(1);
        }
        if (!this.myUploadExternalChanges && !event.isFromSave()) {
            return;
        }
        if (this.isMuted(event.getFile())) {
            return;
        }
        if (this.myUploadOnSaveAll) {
            this.myChanges.add(new ContentChangeData(event));
            return;
        }
        this.handleContentChangedEvent(event);
    }

    private void handleContentChangedEvent(VirtualFileEvent event) {
        AutoUploadComponent.LOG.assertTrue(!event.getFile().isDirectory(), (Object)("Contents changed fired for a directory " + event.getFile().getPresentableUrl()));
        for (AutoUploader uploader : this.myUploaders) {
            uploader.onFileModified(event.getFile().getPath());
        }
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        if (event == null) {
            FileListenerImpl.$$$reportNull$$$0(2);
        }
        if (!this.myUploadExternalChanges && event.isFromRefresh()) {
            return;
        }
        if (!"name".equals(event.getPropertyName())) {
            return;
        }
        if (event.getParent() == null) {
            return;
        }
        boolean sourceMuted = this.isMuted(event.getParent(), (String)event.getOldValue());
        boolean targetMuted = this.isMuted(event.getParent(), (String)event.getNewValue());
        if (sourceMuted && targetMuted) {
            return;
        }
        if (this.myUploadOnSaveAll) {
            this.myChanges.add(new PropertyChangedData(event, sourceMuted, targetMuted));
            return;
        }
        this.handlePropertyChangeEvent(event, sourceMuted, targetMuted);
    }

    private void handlePropertyChangeEvent(VirtualFilePropertyEvent event, boolean sourceMuted, boolean targetMuted) {
        if (event.getPropertyName() != "name" || event.getNewValue() != null && event.getNewValue().equals(event.getOldValue())) {
            return;
        }
        String oldPath = DeploymentPathUtils.join(event.getFile().getParent().getPath(), (String)event.getOldValue());
        String newPath = DeploymentPathUtils.join(event.getFile().getParent().getPath(), (String)event.getNewValue());
        for (AutoUploader uploader : this.myUploaders) {
            uploader.handlePropertyChangeEvent(event, sourceMuted, targetMuted, oldPath, newPath);
        }
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        if (event == null) {
            FileListenerImpl.$$$reportNull$$$0(3);
        }
        if (!this.myUploadExternalChanges && event.isFromRefresh()) {
            return;
        }
        if (this.isMuted(event.getFile())) {
            return;
        }
        if (this.myUploadOnSaveAll) {
            this.myChanges.add(new FileCreatedData(event));
            return;
        }
        this.handleFileCreatedEvent(event);
    }

    private void handleFileCreatedEvent(VirtualFileEvent event) {
        for (AutoUploader uploader : this.myUploaders) {
            uploader.onCreate(event.getFile().getPath(), event.getFile().isDirectory(), event.isFromRefresh(), null);
        }
    }

    public void fileDeleted(@NotNull VirtualFileEvent event) {
        if (event == null) {
            FileListenerImpl.$$$reportNull$$$0(4);
        }
        if (!this.myUploadExternalChanges && event.isFromRefresh()) {
            return;
        }
        if (this.isMuted(event.getFile())) {
            return;
        }
        if (this.myUploadOnSaveAll) {
            this.myChanges.add(new FileDeletedData(event));
            return;
        }
        this.handleFileDeletedEvent(event);
    }

    private void handleFileDeletedEvent(VirtualFileEvent event) {
        for (AutoUploader uploader : this.myUploaders) {
            uploader.onDelete(event.getFile().getPath(), event.getFile().isDirectory(), null);
        }
    }

    public void fileMoved(@NotNull VirtualFileMoveEvent event) {
        if (event == null) {
            FileListenerImpl.$$$reportNull$$$0(5);
        }
        if (!this.myUploadExternalChanges && event.isFromRefresh()) {
            return;
        }
        boolean sourceMuted = this.isMuted(event.getOldParent(), event.getFileName());
        boolean targetMuted = this.isMuted(event.getNewParent(), event.getFileName());
        if (sourceMuted && targetMuted) {
            return;
        }
        if (this.myUploadOnSaveAll) {
            this.myChanges.add(new FileMovedData(event, sourceMuted, targetMuted));
            return;
        }
        this.handleFileMovedEvent(event, sourceMuted, targetMuted);
    }

    private void handleFileMovedEvent(VirtualFileMoveEvent event, boolean sourceMuted, boolean targetMuted) {
        String oldPath = DeploymentPathUtils.join(event.getOldParent().getPath(), event.getFileName());
        String newPath = DeploymentPathUtils.join(event.getNewParent().getPath(), event.getFileName());
        for (AutoUploader uploader : this.myUploaders) {
            uploader.handleFileMovedEvent(event, sourceMuted, targetMuted, oldPath, newPath);
        }
    }

    public void beforeActionPerformed(@NotNull AnAction action, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
        if (action == null) {
            FileListenerImpl.$$$reportNull$$$0(6);
        }
        if (dataContext == null) {
            FileListenerImpl.$$$reportNull$$$0(7);
        }
        if (event == null) {
            FileListenerImpl.$$$reportNull$$$0(8);
        }
        if (!this.myUploadOnSaveAll || !(action instanceof SaveAllAction) && !(action instanceof SaveDocumentAction)) {
            return;
        }
        if (!this.myProject.equals(event.getProject())) {
            return;
        }
        this.myActionsToHandle.put(event, action instanceof SaveDocumentAction ? (Editor)CommonDataKeys.EDITOR.getData(dataContext) : null);
    }

    public void afterActionPerformed(@NotNull AnAction action, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
        if (action == null) {
            FileListenerImpl.$$$reportNull$$$0(9);
        }
        if (dataContext == null) {
            FileListenerImpl.$$$reportNull$$$0(10);
        }
        if (event == null) {
            FileListenerImpl.$$$reportNull$$$0(11);
        }
        if (!(action instanceof SaveAllAction) && !(action instanceof SaveDocumentAction)) {
            return;
        }
        if (!this.myUploadOnSaveAll) {
            this.myActionsToHandle.remove(event);
            return;
        }
        if (!this.myActionsToHandle.containsKey(event)) {
            return;
        }
        Editor editor = this.myActionsToHandle.remove(event);
        VirtualFile target = null;
        if (action instanceof SaveDocumentAction) {
            if (editor == null) {
                return;
            }
            Document document = editor.getDocument();
            target = FileDocumentManager.getInstance().getFile(document);
            if (target == null) {
                return;
            }
        }
        this.waitForRelatedChangesAndUpload(target);
    }

    private void waitForRelatedChangesAndUpload(final @Nullable VirtualFile target) {
        if (this.myChecksRelatedChanges.get()) {
            return;
        }
        Task.Backgroundable task = new Task.Backgroundable(this.myProject, WDBundle.message("auto.upload.wait.for.related.changes.to.apply.before.upload", new Object[0]), true, PerformInBackgroundOption.ALWAYS_BACKGROUND){

            public void run(@NotNull ProgressIndicator pi) {
                if (pi == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (FileListenerImpl.this.myChecksRelatedChanges.get()) {
                    return;
                }
                Future checkFuture = ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    boolean wasNotChecking = FileListenerImpl.this.myChecksRelatedChanges.compareAndSet(false, true);
                    if (!wasNotChecking) {
                        return;
                    }
                    try {
                        for (UploadPostponer extension : UploadPostponer.EP_NAME.getExtensionList()) {
                            AutoUploadComponent.LOG.debug("Checking for related changes " + extension.getPresentableName());
                            pi.setText(WDBundle.message("auto.upload.checking.0", extension.getPresentableName()));
                            extension.waitForRelatedChanges(pi, this.myProject);
                            pi.checkCanceled();
                        }
                    }
                    finally {
                        FileListenerImpl.this.myChecksRelatedChanges.set(false);
                    }
                });
                boolean checkFailedByTimeout = false;
                try {
                    checkFuture.get(5000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    AutoUploadComponent.LOG.warn((Throwable)e);
                }
                catch (ExecutionException e) {
                    AutoUploadComponent.LOG.error((Throwable)e);
                }
                catch (TimeoutException e) {
                    AutoUploadComponent.LOG.debug((Throwable)e);
                    checkFailedByTimeout = true;
                    checkFuture.cancel(true);
                }
                pi.checkCanceled();
                boolean finalCheckFailedByTimeout = checkFailedByTimeout;
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (this.myProject.isDisposed()) {
                        return;
                    }
                    if (finalCheckFailedByTimeout) {
                        String text = WDBundle.message("auto.upload.check.for.related.changes.took.too.much.time.and.was.cancelled", new Object[0]);
                        for (AutoUploader uploader : FileListenerImpl.this.myUploaders) {
                            FileTransferToolWindow.printWithTimestamp(this.myProject, uploader.getServer(), text, ConsoleViewContentType.NORMAL_OUTPUT, PublishConfig.TraceLevel.ERRORS);
                        }
                        DeploymentNotifier.notifyWithBalloon(null, text, NotificationType.WARNING, null, this.myProject, FileTransferToolWindow.ID_PROVIDER);
                    }
                    FileListenerImpl.this.uploadCollectedChanges(target);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "com/jetbrains/plugins/webDeployment/autoupload/FileListenerImpl$1", "run"));
            }
        };
        task.queue();
    }

    private void uploadCollectedChanges(@Nullable VirtualFile filteringFile) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        FileListenerImpl listener = this;
        HashSet<VirtualFile> justUploadedFiles = new HashSet<VirtualFile>();
        Iterator<ChangeData> it = this.myChanges.iterator();
        while (it.hasNext()) {
            ChangeData next = it.next();
            if (filteringFile != null && !next.affects(filteringFile)) continue;
            next.apply(listener, justUploadedFiles);
            it.remove();
        }
    }

    public void registerActionListener() {
        Disposable disposable = this.myActionListenerDisposable;
        if (disposable == null) {
            this.myActionListenerDisposable = disposable = Disposer.newDisposable();
            Topics.subscribe((Topic)AnActionListener.TOPIC, (Disposable)disposable, (Object)this);
        }
    }

    public void unregisterActionListener() {
        Disposable disposable = this.myActionListenerDisposable;
        if (disposable != null) {
            this.myActionListenerDisposable = null;
            Disposer.dispose((Disposable)disposable);
        }
    }

    protected boolean isMuted(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            FileListenerImpl.$$$reportNull$$$0(12);
        }
        return false;
    }

    protected boolean isMuted(@NotNull VirtualFile parent, @NotNull String fileName) {
        if (parent == null) {
            FileListenerImpl.$$$reportNull$$$0(13);
        }
        if (fileName == null) {
            FileListenerImpl.$$$reportNull$$$0(14);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/autoupload/FileListenerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "contentsChanged";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "propertyChanged";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fileCreated";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "fileDeleted";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "fileMoved";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeActionPerformed";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "afterActionPerformed";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "isMuted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class FileMovedData
    implements ChangeData {
        private final VirtualFileMoveEvent myEvent;
        private final boolean mySourceMuted;
        private final boolean myTargetMuted;

        FileMovedData(VirtualFileMoveEvent event, boolean sourceMuted, boolean targetMuted) {
            this.myEvent = event;
            this.mySourceMuted = sourceMuted;
            this.myTargetMuted = targetMuted;
        }

        @Override
        public void apply(FileListenerImpl listener, Set<VirtualFile> justUploadedFiles) {
            listener.handleFileMovedEvent(this.myEvent, this.mySourceMuted, this.myTargetMuted);
            VirtualFile deletedFile = null;
            for (VirtualFile file : justUploadedFiles) {
                if (!file.getName().equals(this.myEvent.getFileName()) || !file.getParent().equals(this.myEvent.getOldParent())) continue;
                deletedFile = file;
                break;
            }
            if (deletedFile != null) {
                justUploadedFiles.remove(deletedFile);
            }
        }

        @Override
        public boolean affects(@NotNull VirtualFile file) {
            if (file == null) {
                FileMovedData.$$$reportNull$$$0(0);
            }
            return this.myEvent.getFile().equals(file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/autoupload/FileListenerImpl$FileMovedData", "affects"));
        }
    }

    static class FileDeletedData
    implements ChangeData {
        private final VirtualFileEvent myEvent;

        FileDeletedData(VirtualFileEvent event) {
            this.myEvent = event;
        }

        @Override
        public void apply(FileListenerImpl listener, Set<VirtualFile> justUploadedFiles) {
            justUploadedFiles.remove(this.myEvent.getFile());
            listener.handleFileDeletedEvent(this.myEvent);
        }

        @Override
        public boolean affects(@NotNull VirtualFile file) {
            if (file == null) {
                FileDeletedData.$$$reportNull$$$0(0);
            }
            return this.myEvent.getFile().equals(file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/autoupload/FileListenerImpl$FileDeletedData", "affects"));
        }
    }

    static class FileCreatedData
    implements ChangeData {
        private final VirtualFileEvent myEvent;

        FileCreatedData(VirtualFileEvent event) {
            this.myEvent = event;
        }

        @Override
        public void apply(FileListenerImpl listener, Set<VirtualFile> justUploadedFiles) {
            if (justUploadedFiles.contains(this.myEvent.getFile())) {
                return;
            }
            listener.handleFileCreatedEvent(this.myEvent);
            justUploadedFiles.add(this.myEvent.getFile());
        }

        @Override
        public boolean affects(@NotNull VirtualFile file) {
            if (file == null) {
                FileCreatedData.$$$reportNull$$$0(0);
            }
            return this.myEvent.getFile().equals(file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/autoupload/FileListenerImpl$FileCreatedData", "affects"));
        }
    }

    static class PropertyChangedData
    implements ChangeData {
        private final VirtualFilePropertyEvent myEvent;
        private final boolean mySourceMuted;
        private final boolean myTargetMuted;

        PropertyChangedData(VirtualFilePropertyEvent event, boolean sourceMuted, boolean targetMuted) {
            this.myEvent = event;
            this.mySourceMuted = sourceMuted;
            this.myTargetMuted = targetMuted;
        }

        @Override
        public void apply(FileListenerImpl listener, Set<VirtualFile> justUploadedFiles) {
            listener.handlePropertyChangeEvent(this.myEvent, this.mySourceMuted, this.myTargetMuted);
            VirtualFile deletedFile = null;
            for (VirtualFile file : justUploadedFiles) {
                if (!file.getName().equals(this.myEvent.getOldValue()) && !file.getName().equals(this.myEvent.getNewValue()) || !file.getParent().equals(this.myEvent.getParent())) continue;
                deletedFile = file;
                break;
            }
            if (deletedFile != null) {
                justUploadedFiles.remove(deletedFile);
            }
        }

        @Override
        public boolean affects(@NotNull VirtualFile file) {
            if (file == null) {
                PropertyChangedData.$$$reportNull$$$0(0);
            }
            return this.myEvent.getFile().equals(file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/autoupload/FileListenerImpl$PropertyChangedData", "affects"));
        }
    }

    static class ContentChangeData
    implements ChangeData {
        private final VirtualFileEvent myEvent;

        ContentChangeData(VirtualFileEvent event) {
            this.myEvent = event;
        }

        @Override
        public void apply(FileListenerImpl listener, Set<VirtualFile> justUploadedFiles) {
            if (justUploadedFiles.contains(this.myEvent.getFile())) {
                return;
            }
            listener.handleContentChangedEvent(this.myEvent);
            justUploadedFiles.add(this.myEvent.getFile());
        }

        @Override
        public boolean affects(@NotNull VirtualFile file) {
            if (file == null) {
                ContentChangeData.$$$reportNull$$$0(0);
            }
            return this.myEvent.getFile().equals(file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/autoupload/FileListenerImpl$ContentChangeData", "affects"));
        }
    }

    private static interface ChangeData {
        public void apply(FileListenerImpl var1, Set<VirtualFile> var2);

        public boolean affects(@NotNull VirtualFile var1);
    }
}

