/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.credentialStore.Credentials;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ssh.SshConnectionUtil;
import com.intellij.ssh.SshPasswordProvider;
import com.intellij.ssh.common.ServerDescription;
import com.intellij.ssh.interaction.ConnectionOwner;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SftpUserInfo
implements SshPasswordProvider,
UserInfo,
UIKeyboardInteractive {
    @NotNull
    private final Deployable myDeployable;
    @NotNull
    private final FileTransferConfig myConfig;
    @NotNull
    private final ConnectionOwner myConnectionOwner;
    @NotNull
    private final String myTitle;
    @Nullable
    private final ProgressIndicator myProgressIndicator;

    public SftpUserInfo(@NotNull FileTransferConfig config, @NotNull ConnectionOwner connectionOwner, @NotNull String title, @NotNull Deployable deployable, @Nullable ProgressIndicator pi) {
        if (config == null) {
            SftpUserInfo.$$$reportNull$$$0(0);
        }
        if (connectionOwner == null) {
            SftpUserInfo.$$$reportNull$$$0(1);
        }
        if (title == null) {
            SftpUserInfo.$$$reportNull$$$0(2);
        }
        if (deployable == null) {
            SftpUserInfo.$$$reportNull$$$0(3);
        }
        this.myConfig = config;
        this.myConnectionOwner = connectionOwner;
        this.myTitle = title;
        this.myDeployable = deployable;
        this.myProgressIndicator = pi;
    }

    @Nullable
    public String getPassphrase() {
        Credentials credentials = this.myDeployable.getCredentials();
        return credentials == null ? null : credentials.getPasswordAsString();
    }

    public String getPassword() {
        Credentials credentials = this.myDeployable.getCredentials();
        return StringUtil.notNullize((String)(credentials == null ? null : credentials.getPasswordAsString()));
    }

    public boolean promptPassword(String message) {
        return true;
    }

    public boolean promptPassphrase(String message) {
        return true;
    }

    public boolean promptYesNo(@NotNull String message) {
        if (message == null) {
            SftpUserInfo.$$$reportNull$$$0(4);
        }
        return this.myConnectionOwner.promptYesNo(message, this.myTitle, this.myProgressIndicator);
    }

    public void showMessage(@NotNull String message) {
        if (message == null) {
            SftpUserInfo.$$$reportNull$$$0(5);
        }
        if (this.myConfig.getAdvancedOptions().isMuteSftpMessages()) {
            return;
        }
        DialogWrapper.DoNotAskOption option = new DialogWrapper.DoNotAskOption(){

            public boolean isToBeShown() {
                return true;
            }

            public void setToBeShown(boolean value, int exitCode) {
                SftpUserInfo.this.myConfig.getAdvancedOptions().setMuteSftpMessages(!value);
            }

            public boolean canBeHidden() {
                return true;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return false;
            }

            @NotNull
            public String getDoNotShowMessage() {
                String string = WDBundle.message("do.not.show.messages.from.this.server.can.be.changed.in.server.s.advanced.settings", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/SftpUserInfo$1", "getDoNotShowMessage"));
            }
        };
        this.myConnectionOwner.showMessage(message, this.myTitle, (ServerDescription)this.myDeployable, this.myProgressIndicator, option);
    }

    @Nullable
    public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
        return SshConnectionUtil.promptKeyboardInteractive((String[])prompt, (boolean[])echo, (String)destination, (String)name, (String)instruction, (SshPasswordProvider)this);
    }

    @Nullable
    public String[] askUserForPassword(@NotNull String message) {
        String[] stringArray;
        String password;
        if (message == null) {
            SftpUserInfo.$$$reportNull$$$0(6);
        }
        if ((password = this.myConnectionOwner.promptPassword(message, this.myTitle, this.myProgressIndicator)) != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = password;
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SftpUserInfo that = (SftpUserInfo)o;
        if (!this.myConfig.equals(that.myConfig)) {
            return false;
        }
        return this.myDeployable.equals(that.myDeployable);
    }

    public int hashCode() {
        int result = this.myDeployable.hashCode();
        result = 31 * result + this.myConfig.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionOwner";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deployable";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/config/SftpUserInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "promptYesNo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "showMessage";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "askUserForPassword";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

